/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxString;

public class StructImpl
implements Struct,
DataSerializableFixedID,
Serializable {
    private static final long serialVersionUID = -8474955084549542156L;
    private StructTypeImpl type;
    private Object[] values;
    private transient boolean hasPdx = false;

    public StructImpl() {
    }

    public StructImpl(StructTypeImpl type, Object[] values) {
        if (type == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructImpl_TYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.type = type;
        this.values = values;
        if (this.values != null) {
            for (Object o : values) {
                if (!(o instanceof PdxInstance) && !(o instanceof PdxString)) continue;
                this.hasPdx = true;
                break;
            }
        }
    }

    @Override
    public Object get(String fieldName) {
        return this.values[this.type.getFieldIndex(fieldName)];
    }

    public ObjectType[] getFieldTypes() {
        return this.type.getFieldTypes();
    }

    public String[] getFieldNames() {
        return this.type.getFieldNames();
    }

    @Override
    public Object[] getFieldValues() {
        if (this.values == null) {
            return new Object[0];
        }
        return this.values;
    }

    public Object[] getPdxFieldValues() {
        if (this.values == null) {
            return new Object[0];
        }
        Object[] fValues = new Object[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            fValues[i] = this.values[i] instanceof PdxInstance ? ((PdxInstance)this.values[i]).getObject() : (this.values[i] instanceof PdxString ? ((PdxString)this.values[i]).toString() : this.values[i]);
        }
        return fValues;
    }

    @Override
    public StructType getStructType() {
        return this.type;
    }

    public boolean isHasPdx() {
        return this.hasPdx;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        if (!Arrays.equals(this.getFieldTypes(), s.getStructType().getFieldTypes())) {
            return false;
        }
        if (!Arrays.equals(this.getFieldNames(), s.getStructType().getFieldNames())) {
            return false;
        }
        return Arrays.equals(this.getFieldValues(), s.getFieldValues());
    }

    public int hashCode() {
        int hashCode = this.type.hashCode();
        for (Object o : this.values) {
            if (o == null) continue;
            hashCode ^= o.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        Object[] locValues = this.getFieldValues();
        String[] names = this.getFieldNames();
        StringBuffer buf = new StringBuffer();
        buf.append("struct(");
        for (int i = 0; i < locValues.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(names[i]);
            buf.append(":");
            buf.append(locValues[i]);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return 32;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.type = (StructTypeImpl)DataSerializer.readObject(in);
        this.values = DataSerializer.readObjectArray(in);
        if (this.values != null) {
            for (Object o : this.values) {
                if (!(o instanceof PdxInstance)) continue;
                this.hasPdx = true;
                break;
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.type, out);
        DataSerializer.writeObjectArray(this.values, out);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

