/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.internal.MethodInvocationAuthorizer;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;

public class RestrictedMethodInvocationAuthorizer
implements MethodInvocationAuthorizer {
    public static final String UNAUTHORIZED_STRING = "Unauthorized access to method: ";
    protected static final HashMap<String, Set> DEFAULT_WHITELIST = RestrictedMethodInvocationAuthorizer.createWhiteList();
    private SecurityService securityService;
    private final HashMap<String, Set> whiteListedMethodsToClass;

    public RestrictedMethodInvocationAuthorizer(SecurityService securityService) {
        this.securityService = securityService;
        this.whiteListedMethodsToClass = DEFAULT_WHITELIST;
    }

    private static HashMap<String, Set> createWhiteList() {
        HashMap<String, Set> whiteListMap = new HashMap<String, Set>();
        HashSet<Class<Object>> objectCallers = new HashSet<Class<Object>>();
        objectCallers.add(Object.class);
        whiteListMap.put("toString", objectCallers);
        whiteListMap.put("equals", objectCallers);
        whiteListMap.put("compareTo", objectCallers);
        HashSet<Class<Boolean>> booleanCallers = new HashSet<Class<Boolean>>();
        booleanCallers.add(Boolean.class);
        whiteListMap.put("booleanValue", booleanCallers);
        HashSet<Class<Number>> numericCallers = new HashSet<Class<Number>>();
        numericCallers.add(Number.class);
        whiteListMap.put("byteValue", numericCallers);
        whiteListMap.put("intValue", numericCallers);
        whiteListMap.put("doubleValue", numericCallers);
        whiteListMap.put("floatValue", numericCallers);
        whiteListMap.put("longValue", numericCallers);
        whiteListMap.put("shortValue", numericCallers);
        HashSet<Class> mapCallers = new HashSet<Class>();
        mapCallers.add(Collection.class);
        mapCallers.add(Map.class);
        whiteListMap.put("get", mapCallers);
        whiteListMap.put("entrySet", mapCallers);
        whiteListMap.put("keySet", mapCallers);
        whiteListMap.put("values", mapCallers);
        whiteListMap.put("getEntries", mapCallers);
        whiteListMap.put("getValues", mapCallers);
        whiteListMap.put("containsKey", mapCallers);
        HashSet<Class<Map.Entry>> mapEntryCallers = new HashSet<Class<Map.Entry>>();
        mapEntryCallers.add(Map.Entry.class);
        whiteListMap.put("getKey", mapEntryCallers);
        whiteListMap.put("getValue", mapEntryCallers);
        HashSet<Class<Date>> dateCallers = new HashSet<Class<Date>>();
        dateCallers.add(Date.class);
        whiteListMap.put("after", dateCallers);
        whiteListMap.put("before", dateCallers);
        whiteListMap.put("getNanos", dateCallers);
        whiteListMap.put("getTime", dateCallers);
        HashSet<Class<String>> stringCallers = new HashSet<Class<String>>();
        stringCallers.add(String.class);
        whiteListMap.put("charAt", stringCallers);
        whiteListMap.put("codePointAt", stringCallers);
        whiteListMap.put("codePointBefore", stringCallers);
        whiteListMap.put("codePointCount", stringCallers);
        whiteListMap.put("compareToIgnoreCase", stringCallers);
        whiteListMap.put("concat", stringCallers);
        whiteListMap.put("contains", stringCallers);
        whiteListMap.put("contentEquals", stringCallers);
        whiteListMap.put("endsWith", stringCallers);
        whiteListMap.put("equalsIgnoreCase", stringCallers);
        whiteListMap.put("getBytes", stringCallers);
        whiteListMap.put("hashCode", stringCallers);
        whiteListMap.put("indexOf", stringCallers);
        whiteListMap.put("intern", stringCallers);
        whiteListMap.put("isEmpty", stringCallers);
        whiteListMap.put("lastIndexOf", stringCallers);
        whiteListMap.put("length", stringCallers);
        whiteListMap.put("matches", stringCallers);
        whiteListMap.put("offsetByCodePoints", stringCallers);
        whiteListMap.put("regionMatches", stringCallers);
        whiteListMap.put("replace", stringCallers);
        whiteListMap.put("replaceAll", stringCallers);
        whiteListMap.put("replaceFirst", stringCallers);
        whiteListMap.put("split", stringCallers);
        whiteListMap.put("startsWith", stringCallers);
        whiteListMap.put("substring", stringCallers);
        whiteListMap.put("toCharArray", stringCallers);
        whiteListMap.put("toLowerCase", stringCallers);
        whiteListMap.put("toUpperCase", stringCallers);
        whiteListMap.put("trim", stringCallers);
        return whiteListMap;
    }

    protected HashMap<String, Set> getWhiteList() {
        return this.whiteListedMethodsToClass;
    }

    boolean isWhitelisted(Method method) {
        String methodName = method.getName();
        Set allowedClasses = this.whiteListedMethodsToClass.get(methodName);
        if (allowedClasses == null) {
            return false;
        }
        for (Class clazz : allowedClasses) {
            if (!clazz.isAssignableFrom(method.getDeclaringClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void authorizeMethodInvocation(Method method, Object target) {
        if (!this.isWhitelisted(method)) {
            throw new NotAuthorizedException(UNAUTHORIZED_STRING + method.getName());
        }
        this.authorizeRegionAccess(this.securityService, target);
    }

    private void authorizeRegionAccess(SecurityService securityService, Object target) {
        if (target instanceof Region) {
            String regionName = ((Region)target).getName();
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        }
    }
}

