/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryExecutionTimeoutException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.QueryExecutionCanceledException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class QueryMonitor
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private final InternalCache cache;
    private static final ThreadLocal<AtomicBoolean> queryCancelled = ThreadLocal.withInitial(() -> new AtomicBoolean(Boolean.FALSE));
    private final long maxQueryExecutionTime;
    private static final ConcurrentLinkedQueue queryThreads = new ConcurrentLinkedQueue();
    private Thread monitoringThread;
    private final AtomicBoolean stopped = new AtomicBoolean(Boolean.FALSE);
    private static volatile Boolean LOW_MEMORY = Boolean.FALSE;
    private static volatile long LOW_MEMORY_USED_BYTES = 0L;

    public QueryMonitor(InternalCache cache, long maxQueryExecutionTime) {
        this.cache = cache;
        this.maxQueryExecutionTime = maxQueryExecutionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorQueryThread(Thread queryThread, DefaultQuery query) {
        if (query.isCqQuery()) {
            return;
        }
        if (LOW_MEMORY.booleanValue()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(LOW_MEMORY_USED_BYTES);
            query.setCanceled(new QueryExecutionLowMemoryException(reason));
            throw new QueryExecutionLowMemoryException(reason);
        }
        QueryThreadTask queryTask = new QueryThreadTask(queryThread, query, queryCancelled.get());
        ConcurrentLinkedQueue concurrentLinkedQueue = queryThreads;
        synchronized (concurrentLinkedQueue) {
            queryThreads.add(queryTask);
            queryThreads.notifyAll();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding thread to QueryMonitor. QueryMonitor size is:{}, Thread (id): {} query: {} thread is : {}", (Object)queryThreads.size(), (Object)queryThread.getId(), (Object)query.getQueryString(), (Object)queryThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringQueryThread(Thread queryThread, DefaultQuery query) {
        boolean[] queryCompleted;
        Object testException = null;
        boolean[] blArray = queryCompleted = query.getQueryCompletedForMonitoring();
        synchronized (queryCompleted) {
            queryCancelled.get().getAndSet(Boolean.FALSE);
            query.setQueryCompletedForMonitoring(true);
            queryThreads.remove(new QueryThreadTask(queryThread, null, null));
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (logger.isDebugEnabled()) {
                logger.debug("Removed thread from QueryMonitor. QueryMonitor size is:{}, Thread ID is: {}  thread is : {}", (Object)queryThreads.size(), (Object)queryThread.getId(), (Object)queryThread);
            }
            if (testException != null) {
                throw testException;
            }
            return;
        }
    }

    public static void isQueryExecutionCanceled() {
        if (queryCancelled.get() != null && queryCancelled.get().get()) {
            throw new QueryExecutionCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            if (this.monitoringThread != null) {
                this.monitoringThread.interrupt();
            }
            this.stopped.set(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        AtomicBoolean atomicBoolean = this.stopped;
        // MONITORENTER : atomicBoolean
        if (this.stopped.get()) {
            queryThreads.clear();
            // MONITOREXIT : atomicBoolean
            return;
        }
        this.monitoringThread = Thread.currentThread();
        // MONITOREXIT : atomicBoolean
        try {
            try {}
            catch (InterruptedException ignore) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Monitoring thread got interrupted.");
                }
                queryThreads.clear();
                return;
            }
        }
        catch (Throwable throwable) {
            queryThreads.clear();
            throw throwable;
        }
        while (true) {
            boolean[] queryCompleted;
            QueryThreadTask queryTask;
            if ((queryTask = (QueryThreadTask)queryThreads.peek()) == null) {
                ConcurrentLinkedQueue concurrentLinkedQueue = queryThreads;
                // MONITORENTER : concurrentLinkedQueue
                queryThreads.wait();
                // MONITOREXIT : concurrentLinkedQueue
                continue;
            }
            long executionTime = System.currentTimeMillis() - queryTask.StartTime;
            if (executionTime < this.maxQueryExecutionTime) {
                long sleepTime = this.maxQueryExecutionTime - executionTime;
                Thread.sleep(sleepTime);
                continue;
            }
            boolean[] blArray = queryCompleted = queryTask.query.getQueryCompletedForMonitoring();
            // MONITORENTER : queryCompleted
            if (!queryCompleted[0]) {
                queryTask.query.setCanceled(new QueryExecutionTimeoutException(String.format("Query execution cancelled after exceeding max execution time %sms.", this.maxQueryExecutionTime)));
                queryTask.queryCancelled.set(Boolean.TRUE);
                queryThreads.poll();
                logger.info(String.format("%s is set as canceled after %s milliseconds", queryTask.toString(), executionTime));
            }
            // MONITOREXIT : blArray
        }
    }

    public static boolean isLowMemory() {
        return LOW_MEMORY;
    }

    public static long getMemoryUsedDuringLowMemory() {
        return LOW_MEMORY_USED_BYTES;
    }

    public void setLowMemory(boolean lowMemory, long usedBytes) {
        if (this.cache != null && !this.cache.isQueryMonitorDisabledForLowMemory()) {
            LOW_MEMORY_USED_BYTES = usedBytes;
            LOW_MEMORY = lowMemory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllQueriesDueToMemory() {
        ConcurrentLinkedQueue concurrentLinkedQueue = queryThreads;
        synchronized (concurrentLinkedQueue) {
            QueryThreadTask queryTask = (QueryThreadTask)queryThreads.poll();
            while (queryTask != null) {
                this.cancelQueryDueToLowMemory(queryTask, LOW_MEMORY_USED_BYTES);
                queryTask = (QueryThreadTask)queryThreads.poll();
            }
            queryThreads.clear();
            queryThreads.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueryDueToLowMemory(QueryThreadTask queryTask, long memoryThreshold) {
        boolean[] queryCompleted;
        boolean[] blArray = queryCompleted = queryTask.query.getQueryCompletedForMonitoring();
        synchronized (queryCompleted) {
            if (!queryCompleted[0]) {
                String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(memoryThreshold);
                queryTask.query.setCanceled(new QueryExecutionLowMemoryException(reason));
                queryTask.queryCancelled.set(Boolean.TRUE);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    public static int getQueryMonitorThreadCount() {
        return queryThreads.size();
    }

    private static class QueryThreadTask {
        final long StartTime = System.currentTimeMillis();
        final Thread queryThread;
        final DefaultQuery query;
        final AtomicBoolean queryCancelled;

        QueryThreadTask(Thread queryThread, DefaultQuery query, AtomicBoolean queryCancelled) {
            this.queryThread = queryThread;
            this.query = query;
            this.queryCancelled = queryCancelled;
        }

        public int hashCode() {
            assert (this.queryThread != null);
            return this.queryThread.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof QueryThreadTask)) {
                return false;
            }
            QueryThreadTask o = (QueryThreadTask)other;
            return this.queryThread.equals(o.queryThread);
        }

        public String toString() {
            return "QueryThreadTask[StartTime:" + this.StartTime + ", queryThread:" + this.queryThread + ", threadId:" + this.queryThread.getId() + ", query:" + this.query.getQueryString() + ", queryCancelled:" + this.queryCancelled + ']';
        }
    }
}

