/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.execute;

import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.internal.FunctionServiceManager;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class FunctionService {
    private static final FunctionServiceManager functionSvcMgr = new FunctionServiceManager();

    FunctionService() {
    }

    public static Execution onRegion(Region region) {
        return functionSvcMgr.onRegion(region);
    }

    public static Execution onServer(Pool pool) {
        return functionSvcMgr.onServer(pool, new String[0]);
    }

    public static Execution onServers(Pool pool) {
        return functionSvcMgr.onServers(pool, new String[0]);
    }

    public static Execution onServer(RegionService regionService) {
        return functionSvcMgr.onServer(regionService, new String[0]);
    }

    public static Execution onServers(RegionService regionService) {
        return functionSvcMgr.onServers(regionService, new String[0]);
    }

    public static Execution onMember(DistributedMember distributedMember) {
        return functionSvcMgr.onMember(FunctionService.getDistributedSystem(), distributedMember);
    }

    public static Execution onMembers(String ... groups) {
        return functionSvcMgr.onMembers(FunctionService.getDistributedSystem(), groups);
    }

    public static Execution onMembers(Set<DistributedMember> distributedMembers) {
        return functionSvcMgr.onMembers(FunctionService.getDistributedSystem(), distributedMembers);
    }

    public static Execution onMember(String ... groups) {
        return functionSvcMgr.onMember(FunctionService.getDistributedSystem(), groups);
    }

    public static Function getFunction(String functionId) {
        return functionSvcMgr.getFunction(functionId);
    }

    public static void registerFunction(Function function) {
        functionSvcMgr.registerFunction(function);
    }

    public static void unregisterFunction(String functionId) {
        functionSvcMgr.unregisterFunction(functionId);
    }

    public static boolean isRegistered(String functionId) {
        return functionSvcMgr.isRegistered(functionId);
    }

    public static Map<String, Function> getRegisteredFunctions() {
        return functionSvcMgr.getRegisteredFunctions();
    }

    private static DistributedSystem getDistributedSystem() {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system == null) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.InternalDistributedSystem_THIS_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_HAS_BEEN_DISCONNECTED.toLocalizedString());
        }
        return system;
    }
}

