/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.cache.configuration.CacheTransactionManagerType;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.DiskStoreType;
import org.apache.geode.cache.configuration.DynamicRegionFactoryType;
import org.apache.geode.cache.configuration.FunctionServiceType;
import org.apache.geode.cache.configuration.JndiBindingsType;
import org.apache.geode.cache.configuration.PdxType;
import org.apache.geode.cache.configuration.PoolType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.configuration.ResourceManagerType;
import org.apache.geode.cache.configuration.SerializationRegistrationType;
import org.apache.geode.cache.configuration.ServerType;
import org.apache.geode.cache.configuration.XSDRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"cacheTransactionManager", "dynamicRegionFactory", "gatewayHubs", "gatewaySenders", "gatewayReceiver", "gatewayConflictResolver", "asyncEventQueues", "cacheServers", "pools", "diskStores", "pdx", "regionAttributes", "jndiBindings", "regions", "functionService", "resourceManager", "serializationRegistration", "backups", "initializer", "cacheElements"})
@XmlRootElement(name="cache", namespace="http://geode.apache.org/schema/cache")
@XSDRootElement(namespace="http://geode.apache.org/schema/cache", schemaLocation="http://geode.apache.org/schema/cache/cache-1.0.xsd")
@Experimental
public class CacheConfig {
    @XmlElement(name="cache-transaction-manager", namespace="http://geode.apache.org/schema/cache")
    protected CacheTransactionManagerType cacheTransactionManager;
    @XmlElement(name="dynamic-region-factory", namespace="http://geode.apache.org/schema/cache")
    protected DynamicRegionFactoryType dynamicRegionFactory;
    @XmlElement(name="gateway-hub", namespace="http://geode.apache.org/schema/cache")
    protected List<GatewayHub> gatewayHubs;
    @XmlElement(name="gateway-sender", namespace="http://geode.apache.org/schema/cache")
    protected List<GatewaySender> gatewaySenders;
    @XmlElement(name="gateway-receiver", namespace="http://geode.apache.org/schema/cache")
    protected GatewayReceiver gatewayReceiver;
    @XmlElement(name="gateway-conflict-resolver", namespace="http://geode.apache.org/schema/cache")
    protected DeclarableType gatewayConflictResolver;
    @XmlElement(name="async-event-queue", namespace="http://geode.apache.org/schema/cache")
    protected List<AsyncEventQueue> asyncEventQueues;
    @XmlElement(name="cache-server", namespace="http://geode.apache.org/schema/cache")
    protected List<CacheServer> cacheServers;
    @XmlElement(name="pool", namespace="http://geode.apache.org/schema/cache")
    protected List<PoolType> pools;
    @XmlElement(name="disk-store", namespace="http://geode.apache.org/schema/cache")
    protected List<DiskStoreType> diskStores;
    @XmlElement(namespace="http://geode.apache.org/schema/cache")
    protected PdxType pdx;
    @XmlElement(name="region-attributes", namespace="http://geode.apache.org/schema/cache")
    protected List<RegionAttributesType> regionAttributes;
    @XmlElement(name="jndi-bindings", namespace="http://geode.apache.org/schema/cache")
    protected JndiBindingsType jndiBindings;
    @XmlElement(name="region", namespace="http://geode.apache.org/schema/cache")
    protected List<RegionConfig> regions;
    @XmlElement(name="function-service", namespace="http://geode.apache.org/schema/cache")
    protected FunctionServiceType functionService;
    @XmlElement(name="resource-manager", namespace="http://geode.apache.org/schema/cache")
    protected ResourceManagerType resourceManager;
    @XmlElement(name="serialization-registration", namespace="http://geode.apache.org/schema/cache")
    protected SerializationRegistrationType serializationRegistration;
    @XmlElement(name="backup", namespace="http://geode.apache.org/schema/cache")
    protected List<String> backups;
    @XmlElement(namespace="http://geode.apache.org/schema/cache")
    protected DeclarableType initializer;
    @XmlAnyElement(lax=true)
    protected List<CacheElement> cacheElements;
    @XmlAttribute(name="copy-on-read")
    protected Boolean copyOnRead;
    @XmlAttribute(name="is-server")
    protected Boolean isServer;
    @XmlAttribute(name="lock-timeout")
    protected String lockTimeout;
    @XmlAttribute(name="lock-lease")
    protected String lockLease;
    @XmlAttribute(name="message-sync-interval")
    protected String messageSyncInterval;
    @XmlAttribute(name="search-timeout")
    protected String searchTimeout;
    @XmlAttribute(name="version", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String version;

    public CacheConfig() {
    }

    public CacheConfig(String version) {
        this.version = version;
    }

    public CacheTransactionManagerType getCacheTransactionManager() {
        return this.cacheTransactionManager;
    }

    public void setCacheTransactionManager(CacheTransactionManagerType value) {
        this.cacheTransactionManager = value;
    }

    public DynamicRegionFactoryType getDynamicRegionFactory() {
        return this.dynamicRegionFactory;
    }

    public void setDynamicRegionFactory(DynamicRegionFactoryType value) {
        this.dynamicRegionFactory = value;
    }

    public List<GatewayHub> getGatewayHubs() {
        if (this.gatewayHubs == null) {
            this.gatewayHubs = new ArrayList<GatewayHub>();
        }
        return this.gatewayHubs;
    }

    public List<GatewaySender> getGatewaySenders() {
        if (this.gatewaySenders == null) {
            this.gatewaySenders = new ArrayList<GatewaySender>();
        }
        return this.gatewaySenders;
    }

    public GatewayReceiver getGatewayReceiver() {
        return this.gatewayReceiver;
    }

    public void setGatewayReceiver(GatewayReceiver value) {
        this.gatewayReceiver = value;
    }

    public DeclarableType getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    public void setGatewayConflictResolver(DeclarableType value) {
        this.gatewayConflictResolver = value;
    }

    public List<AsyncEventQueue> getAsyncEventQueues() {
        if (this.asyncEventQueues == null) {
            this.asyncEventQueues = new ArrayList<AsyncEventQueue>();
        }
        return this.asyncEventQueues;
    }

    public List<CacheServer> getCacheServers() {
        if (this.cacheServers == null) {
            this.cacheServers = new ArrayList<CacheServer>();
        }
        return this.cacheServers;
    }

    public List<PoolType> getPools() {
        if (this.pools == null) {
            this.pools = new ArrayList<PoolType>();
        }
        return this.pools;
    }

    public List<DiskStoreType> getDiskStores() {
        if (this.diskStores == null) {
            this.diskStores = new ArrayList<DiskStoreType>();
        }
        return this.diskStores;
    }

    public PdxType getPdx() {
        return this.pdx;
    }

    public void setPdx(PdxType value) {
        this.pdx = value;
    }

    public List<RegionAttributesType> getRegionAttributes() {
        if (this.regionAttributes == null) {
            this.regionAttributes = new ArrayList<RegionAttributesType>();
        }
        return this.regionAttributes;
    }

    public List<JndiBindingsType.JndiBinding> getJndiBindings() {
        if (this.jndiBindings == null) {
            this.jndiBindings = new JndiBindingsType();
        }
        return this.jndiBindings.getJndiBindings();
    }

    public List<RegionConfig> getRegions() {
        if (this.regions == null) {
            this.regions = new ArrayList<RegionConfig>();
        }
        return this.regions;
    }

    public FunctionServiceType getFunctionService() {
        return this.functionService;
    }

    public void setFunctionService(FunctionServiceType value) {
        this.functionService = value;
    }

    public ResourceManagerType getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManagerType value) {
        this.resourceManager = value;
    }

    public SerializationRegistrationType getSerializationRegistration() {
        return this.serializationRegistration;
    }

    public void setSerializationRegistration(SerializationRegistrationType value) {
        this.serializationRegistration = value;
    }

    public List<String> getBackups() {
        if (this.backups == null) {
            this.backups = new ArrayList<String>();
        }
        return this.backups;
    }

    public DeclarableType getInitializer() {
        return this.initializer;
    }

    public void setInitializer(DeclarableType value) {
        this.initializer = value;
    }

    public List<CacheElement> getCustomCacheElements() {
        if (this.cacheElements == null) {
            this.cacheElements = new ArrayList<CacheElement>();
        }
        return this.cacheElements;
    }

    public Boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    public void setCopyOnRead(Boolean value) {
        this.copyOnRead = value;
    }

    public Boolean isIsServer() {
        return this.isServer;
    }

    public void setIsServer(Boolean value) {
        this.isServer = value;
    }

    public String getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(String value) {
        this.lockTimeout = value;
    }

    public String getLockLease() {
        return this.lockLease;
    }

    public void setLockLease(String value) {
        this.lockLease = value;
    }

    public String getMessageSyncInterval() {
        return this.messageSyncInterval;
    }

    public void setMessageSyncInterval(String value) {
        this.messageSyncInterval = value;
    }

    public String getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(String value) {
        this.searchTimeout = value;
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.0";
        }
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public RegionConfig findRegionConfiguration(String regionPath) {
        if (regionPath.startsWith("/")) {
            regionPath = regionPath.substring(1);
        }
        return CacheElement.findElement(this.getRegions(), regionPath);
    }

    public <T extends CacheElement> List<T> findCustomCacheElements(Class<T> classT) {
        ArrayList<T> newList = new ArrayList<T>();
        for (CacheElement element : this.getCustomCacheElements()) {
            if (!classT.isInstance(element)) continue;
            newList.add(classT.cast(element));
        }
        return newList;
    }

    public <T extends CacheElement> T findCustomCacheElement(String elementId, Class<T> classT) {
        return CacheElement.findElement(this.findCustomCacheElements(classT), elementId);
    }

    public <T extends CacheElement> List<T> findCustomRegionElements(String regionPath, Class<T> classT) {
        ArrayList<T> newList = new ArrayList<T>();
        RegionConfig regionConfig = this.findRegionConfiguration(regionPath);
        if (regionConfig == null) {
            return newList;
        }
        for (CacheElement element : regionConfig.getCustomRegionElements()) {
            if (!classT.isInstance(element)) continue;
            newList.add(classT.cast(element));
        }
        return newList;
    }

    public <T extends CacheElement> T findCustomRegionElement(String regionPath, String elementId, Class<T> classT) {
        return CacheElement.findElement(this.findCustomRegionElements(regionPath, classT), elementId);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"gatewayEventFilters", "gatewayEventSubstitutionFilter", "gatewayTransportFilters"})
    public static class GatewaySender {
        @XmlElement(name="gateway-event-filter", namespace="http://geode.apache.org/schema/cache")
        protected List<DeclarableType> gatewayEventFilters;
        @XmlElement(name="gateway-event-substitution-filter", namespace="http://geode.apache.org/schema/cache")
        protected DeclarableType gatewayEventSubstitutionFilter;
        @XmlElement(name="gateway-transport-filter", namespace="http://geode.apache.org/schema/cache")
        protected List<DeclarableType> gatewayTransportFilters;
        @XmlAttribute(name="id", required=true)
        protected String id;
        @XmlAttribute(name="remote-distributed-system-id", required=true)
        protected String remoteDistributedSystemId;
        @XmlAttribute(name="parallel")
        protected Boolean parallel;
        @XmlAttribute(name="manual-start")
        protected Boolean manualStart;
        @XmlAttribute(name="socket-buffer-size")
        protected String socketBufferSize;
        @XmlAttribute(name="socket-read-timeout")
        protected String socketReadTimeout;
        @XmlAttribute(name="enable-batch-conflation")
        protected Boolean enableBatchConflation;
        @XmlAttribute(name="batch-size")
        protected String batchSize;
        @XmlAttribute(name="batch-time-interval")
        protected String batchTimeInterval;
        @XmlAttribute(name="enable-persistence")
        protected Boolean enablePersistence;
        @XmlAttribute(name="disk-store-name")
        protected String diskStoreName;
        @XmlAttribute(name="disk-synchronous")
        protected Boolean diskSynchronous;
        @XmlAttribute(name="maximum-queue-memory")
        protected String maximumQueueMemory;
        @XmlAttribute(name="alert-threshold")
        protected String alertThreshold;
        @XmlAttribute(name="dispatcher-threads")
        protected String dispatcherThreads;
        @XmlAttribute(name="order-policy")
        protected String orderPolicy;

        public List<DeclarableType> getGatewayEventFilters() {
            if (this.gatewayEventFilters == null) {
                this.gatewayEventFilters = new ArrayList<DeclarableType>();
            }
            return this.gatewayEventFilters;
        }

        public DeclarableType getGatewayEventSubstitutionFilter() {
            return this.gatewayEventSubstitutionFilter;
        }

        public void setGatewayEventSubstitutionFilter(DeclarableType value) {
            this.gatewayEventSubstitutionFilter = value;
        }

        public List<DeclarableType> getGatewayTransportFilters() {
            if (this.gatewayTransportFilters == null) {
                this.gatewayTransportFilters = new ArrayList<DeclarableType>();
            }
            return this.gatewayTransportFilters;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String value) {
            this.id = value;
        }

        public String getRemoteDistributedSystemId() {
            return this.remoteDistributedSystemId;
        }

        public void setRemoteDistributedSystemId(String value) {
            this.remoteDistributedSystemId = value;
        }

        public Boolean isParallel() {
            return this.parallel;
        }

        public void setParallel(Boolean value) {
            this.parallel = value;
        }

        public Boolean isManualStart() {
            return this.manualStart;
        }

        public void setManualStart(Boolean value) {
            this.manualStart = value;
        }

        public String getSocketBufferSize() {
            return this.socketBufferSize;
        }

        public void setSocketBufferSize(String value) {
            this.socketBufferSize = value;
        }

        public String getSocketReadTimeout() {
            return this.socketReadTimeout;
        }

        public void setSocketReadTimeout(String value) {
            this.socketReadTimeout = value;
        }

        public Boolean isEnableBatchConflation() {
            return this.enableBatchConflation;
        }

        public void setEnableBatchConflation(Boolean value) {
            this.enableBatchConflation = value;
        }

        public String getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(String value) {
            this.batchSize = value;
        }

        public String getBatchTimeInterval() {
            return this.batchTimeInterval;
        }

        public void setBatchTimeInterval(String value) {
            this.batchTimeInterval = value;
        }

        public Boolean isEnablePersistence() {
            return this.enablePersistence;
        }

        public void setEnablePersistence(Boolean value) {
            this.enablePersistence = value;
        }

        public String getDiskStoreName() {
            return this.diskStoreName;
        }

        public void setDiskStoreName(String value) {
            this.diskStoreName = value;
        }

        public Boolean isDiskSynchronous() {
            return this.diskSynchronous;
        }

        public void setDiskSynchronous(Boolean value) {
            this.diskSynchronous = value;
        }

        public String getMaximumQueueMemory() {
            return this.maximumQueueMemory;
        }

        public void setMaximumQueueMemory(String value) {
            this.maximumQueueMemory = value;
        }

        public String getAlertThreshold() {
            return this.alertThreshold;
        }

        public void setAlertThreshold(String value) {
            this.alertThreshold = value;
        }

        public String getDispatcherThreads() {
            return this.dispatcherThreads;
        }

        public void setDispatcherThreads(String value) {
            this.dispatcherThreads = value;
        }

        public String getOrderPolicy() {
            return this.orderPolicy;
        }

        public void setOrderPolicy(String value) {
            this.orderPolicy = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"gatewayTransportFilters"})
    public static class GatewayReceiver {
        @XmlElement(name="gateway-transport-filter", namespace="http://geode.apache.org/schema/cache")
        protected List<DeclarableType> gatewayTransportFilters;
        @XmlAttribute(name="start-port")
        protected String startPort;
        @XmlAttribute(name="end-port")
        protected String endPort;
        @XmlAttribute(name="bind-address")
        protected String bindAddress;
        @XmlAttribute(name="maximum-time-between-pings")
        protected String maximumTimeBetweenPings;
        @XmlAttribute(name="socket-buffer-size")
        protected String socketBufferSize;
        @XmlAttribute(name="hostname-for-senders")
        protected String hostnameForSenders;
        @XmlAttribute(name="manual-start")
        protected Boolean manualStart;

        public List<DeclarableType> getGatewayTransportFilters() {
            if (this.gatewayTransportFilters == null) {
                this.gatewayTransportFilters = new ArrayList<DeclarableType>();
            }
            return this.gatewayTransportFilters;
        }

        public String getStartPort() {
            return this.startPort;
        }

        public void setStartPort(String value) {
            this.startPort = value;
        }

        public String getEndPort() {
            return this.endPort;
        }

        public void setEndPort(String value) {
            this.endPort = value;
        }

        public String getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(String value) {
            this.bindAddress = value;
        }

        public String getMaximumTimeBetweenPings() {
            return this.maximumTimeBetweenPings;
        }

        public void setMaximumTimeBetweenPings(String value) {
            this.maximumTimeBetweenPings = value;
        }

        public String getSocketBufferSize() {
            return this.socketBufferSize;
        }

        public void setSocketBufferSize(String value) {
            this.socketBufferSize = value;
        }

        public String getHostnameForSenders() {
            return this.hostnameForSenders;
        }

        public void setHostnameForSenders(String value) {
            this.hostnameForSenders = value;
        }

        public Boolean isManualStart() {
            return this.manualStart;
        }

        public void setManualStart(Boolean value) {
            this.manualStart = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"gateways"})
    public static class GatewayHub {
        @XmlElement(name="gateway", namespace="http://geode.apache.org/schema/cache")
        protected List<Gateway> gateways;
        @XmlAttribute(name="id", required=true)
        protected String id;
        @XmlAttribute(name="bind-address")
        protected String bindAddress;
        @XmlAttribute(name="maximum-time-between-pings")
        protected String maximumTimeBetweenPings;
        @XmlAttribute(name="port")
        protected String port;
        @XmlAttribute(name="socket-buffer-size")
        protected String socketBufferSize;
        @XmlAttribute(name="startup-policy")
        protected String startupPolicy;
        @XmlAttribute(name="manual-start")
        protected Boolean manualStart;
        @XmlAttribute(name="max-connections")
        protected BigInteger maxConnections;

        public List<Gateway> getGateway() {
            if (this.gateways == null) {
                this.gateways = new ArrayList<Gateway>();
            }
            return this.gateways;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String value) {
            this.id = value;
        }

        public String getBindAddress() {
            return this.bindAddress;
        }

        public void setBindAddress(String value) {
            this.bindAddress = value;
        }

        public String getMaximumTimeBetweenPings() {
            return this.maximumTimeBetweenPings;
        }

        public void setMaximumTimeBetweenPings(String value) {
            this.maximumTimeBetweenPings = value;
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String value) {
            this.port = value;
        }

        public String getSocketBufferSize() {
            return this.socketBufferSize;
        }

        public void setSocketBufferSize(String value) {
            this.socketBufferSize = value;
        }

        public String getStartupPolicy() {
            return this.startupPolicy;
        }

        public void setStartupPolicy(String value) {
            this.startupPolicy = value;
        }

        public Boolean isManualStart() {
            return this.manualStart;
        }

        public void setManualStart(Boolean value) {
            this.manualStart = value;
        }

        public BigInteger getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(BigInteger value) {
            this.maxConnections = value;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"gatewayEndpoints", "gatewayListeners", "gatewayQueue"})
        public static class Gateway {
            @XmlElement(name="gateway-endpoint", namespace="http://geode.apache.org/schema/cache")
            protected List<GatewayEndpoint> gatewayEndpoints;
            @XmlElement(name="gateway-listener", namespace="http://geode.apache.org/schema/cache")
            protected List<DeclarableType> gatewayListeners;
            @XmlElement(name="gateway-queue", namespace="http://geode.apache.org/schema/cache")
            protected GatewayQueue gatewayQueue;
            @XmlAttribute(name="early-ack")
            protected Boolean earlyAck;
            @XmlAttribute(name="id", required=true)
            protected String id;
            @XmlAttribute(name="socket-buffer-size")
            protected String socketBufferSize;
            @XmlAttribute(name="socket-read-timeout")
            protected String socketReadTimeout;
            @XmlAttribute(name="concurrency-level")
            protected String concurrencyLevel;
            @XmlAttribute(name="order-policy")
            protected String orderPolicy;

            public List<GatewayEndpoint> getGatewayEndpoints() {
                if (this.gatewayEndpoints == null) {
                    this.gatewayEndpoints = new ArrayList<GatewayEndpoint>();
                }
                return this.gatewayEndpoints;
            }

            public List<DeclarableType> getGatewayListeners() {
                if (this.gatewayListeners == null) {
                    this.gatewayListeners = new ArrayList<DeclarableType>();
                }
                return this.gatewayListeners;
            }

            public GatewayQueue getGatewayQueue() {
                return this.gatewayQueue;
            }

            public void setGatewayQueue(GatewayQueue value) {
                this.gatewayQueue = value;
            }

            public Boolean isEarlyAck() {
                return this.earlyAck;
            }

            public void setEarlyAck(Boolean value) {
                this.earlyAck = value;
            }

            public String getId() {
                return this.id;
            }

            public void setId(String value) {
                this.id = value;
            }

            public String getSocketBufferSize() {
                return this.socketBufferSize;
            }

            public void setSocketBufferSize(String value) {
                this.socketBufferSize = value;
            }

            public String getSocketReadTimeout() {
                return this.socketReadTimeout;
            }

            public void setSocketReadTimeout(String value) {
                this.socketReadTimeout = value;
            }

            public String getConcurrencyLevel() {
                return this.concurrencyLevel;
            }

            public void setConcurrencyLevel(String value) {
                this.concurrencyLevel = value;
            }

            public String getOrderPolicy() {
                return this.orderPolicy;
            }

            public void setOrderPolicy(String value) {
                this.orderPolicy = value;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="")
            public static class GatewayQueue {
                @XmlAttribute(name="alert-threshold")
                protected String alertThreshold;
                @XmlAttribute(name="batch-conflation")
                protected Boolean batchConflation;
                @XmlAttribute(name="batch-size")
                protected String batchSize;
                @XmlAttribute(name="batch-time-interval")
                protected String batchTimeInterval;
                @XmlAttribute(name="enable-persistence")
                protected Boolean enablePersistence;
                @XmlAttribute(name="disk-store-name")
                protected String diskStoreName;
                @XmlAttribute(name="roll-oplogs")
                protected Boolean rollOplogs;
                @XmlAttribute(name="maximum-queue-memory")
                protected String maximumQueueMemory;
                @XmlAttribute(name="overflow-directory")
                protected String overflowDirectory;

                public String getAlertThreshold() {
                    return this.alertThreshold;
                }

                public void setAlertThreshold(String value) {
                    this.alertThreshold = value;
                }

                public Boolean isBatchConflation() {
                    return this.batchConflation;
                }

                public void setBatchConflation(Boolean value) {
                    this.batchConflation = value;
                }

                public String getBatchSize() {
                    return this.batchSize;
                }

                public void setBatchSize(String value) {
                    this.batchSize = value;
                }

                public String getBatchTimeInterval() {
                    return this.batchTimeInterval;
                }

                public void setBatchTimeInterval(String value) {
                    this.batchTimeInterval = value;
                }

                public Boolean isEnablePersistence() {
                    return this.enablePersistence;
                }

                public void setEnablePersistence(Boolean value) {
                    this.enablePersistence = value;
                }

                public String getDiskStoreName() {
                    return this.diskStoreName;
                }

                public void setDiskStoreName(String value) {
                    this.diskStoreName = value;
                }

                public Boolean isRollOplogs() {
                    return this.rollOplogs;
                }

                public void setRollOplogs(Boolean value) {
                    this.rollOplogs = value;
                }

                public String getMaximumQueueMemory() {
                    return this.maximumQueueMemory;
                }

                public void setMaximumQueueMemory(String value) {
                    this.maximumQueueMemory = value;
                }

                public String getOverflowDirectory() {
                    return this.overflowDirectory;
                }

                public void setOverflowDirectory(String value) {
                    this.overflowDirectory = value;
                }
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="")
            public static class GatewayEndpoint {
                @XmlAttribute(name="host", required=true)
                protected String host;
                @XmlAttribute(name="id", required=true)
                protected String id;
                @XmlAttribute(name="port", required=true)
                protected String port;

                public String getHost() {
                    return this.host;
                }

                public void setHost(String value) {
                    this.host = value;
                }

                public String getId() {
                    return this.id;
                }

                public void setId(String value) {
                    this.id = value;
                }

                public String getPort() {
                    return this.port;
                }

                public void setPort(String value) {
                    this.port = value;
                }
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class CacheServer
    extends ServerType {
        @XmlAttribute(name="tcp-no-delay")
        protected Boolean tcpNoDelay;

        public Boolean isTcpNoDelay() {
            return this.tcpNoDelay;
        }

        public void setTcpNoDelay(Boolean value) {
            this.tcpNoDelay = value;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"gatewayEventFilters", "gatewayEventSubstitutionFilter", "asyncEventListener"})
    public static class AsyncEventQueue
    implements Serializable {
        @XmlElement(name="gateway-event-filter", namespace="http://geode.apache.org/schema/cache")
        protected List<DeclarableType> gatewayEventFilters;
        @XmlElement(name="gateway-event-substitution-filter", namespace="http://geode.apache.org/schema/cache")
        protected DeclarableType gatewayEventSubstitutionFilter;
        @XmlElement(name="async-event-listener", namespace="http://geode.apache.org/schema/cache", required=true)
        protected DeclarableType asyncEventListener;
        @XmlAttribute(name="id", required=true)
        protected String id;
        @XmlAttribute(name="parallel")
        protected Boolean parallel;
        @XmlAttribute(name="batch-size")
        protected String batchSize;
        @XmlAttribute(name="batch-time-interval")
        protected String batchTimeInterval;
        @XmlAttribute(name="enable-batch-conflation")
        protected Boolean enableBatchConflation;
        @XmlAttribute(name="maximum-queue-memory")
        protected String maximumQueueMemory;
        @XmlAttribute(name="persistent")
        protected Boolean persistent;
        @XmlAttribute(name="disk-store-name")
        protected String diskStoreName;
        @XmlAttribute(name="disk-synchronous")
        protected Boolean diskSynchronous;
        @XmlAttribute(name="dispatcher-threads")
        protected String dispatcherThreads;
        @XmlAttribute(name="order-policy")
        protected String orderPolicy;
        @XmlAttribute(name="forward-expiration-destroy")
        protected Boolean forwardExpirationDestroy;

        public List<DeclarableType> getGatewayEventFilters() {
            if (this.gatewayEventFilters == null) {
                this.gatewayEventFilters = new ArrayList<DeclarableType>();
            }
            return this.gatewayEventFilters;
        }

        public DeclarableType getGatewayEventSubstitutionFilter() {
            return this.gatewayEventSubstitutionFilter;
        }

        public void setGatewayEventSubstitutionFilter(DeclarableType value) {
            this.gatewayEventSubstitutionFilter = value;
        }

        public DeclarableType getAsyncEventListener() {
            return this.asyncEventListener;
        }

        public void setAsyncEventListener(DeclarableType value) {
            this.asyncEventListener = value;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String value) {
            this.id = value;
        }

        public Boolean isParallel() {
            return this.parallel;
        }

        public void setParallel(Boolean value) {
            this.parallel = value;
        }

        public String getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(String value) {
            this.batchSize = value;
        }

        public String getBatchTimeInterval() {
            return this.batchTimeInterval;
        }

        public void setBatchTimeInterval(String value) {
            this.batchTimeInterval = value;
        }

        public Boolean isEnableBatchConflation() {
            return this.enableBatchConflation;
        }

        public void setEnableBatchConflation(Boolean value) {
            this.enableBatchConflation = value;
        }

        public String getMaximumQueueMemory() {
            return this.maximumQueueMemory;
        }

        public void setMaximumQueueMemory(String value) {
            this.maximumQueueMemory = value;
        }

        public Boolean isPersistent() {
            return this.persistent;
        }

        public void setPersistent(Boolean value) {
            this.persistent = value;
        }

        public String getDiskStoreName() {
            return this.diskStoreName;
        }

        public void setDiskStoreName(String value) {
            this.diskStoreName = value;
        }

        public Boolean isDiskSynchronous() {
            return this.diskSynchronous;
        }

        public void setDiskSynchronous(Boolean value) {
            this.diskSynchronous = value;
        }

        public String getDispatcherThreads() {
            return this.dispatcherThreads;
        }

        public void setDispatcherThreads(String value) {
            this.dispatcherThreads = value;
        }

        public String getOrderPolicy() {
            return this.orderPolicy;
        }

        public void setOrderPolicy(String value) {
            this.orderPolicy = value;
        }

        public boolean isForwardExpirationDestroy() {
            if (this.forwardExpirationDestroy == null) {
                return false;
            }
            return this.forwardExpirationDestroy;
        }

        public void setForwardExpirationDestroy(Boolean value) {
            this.forwardExpirationDestroy = value;
        }
    }
}

