/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import org.apache.geode.CancelCriterion;
import org.apache.geode.cache.client.internal.ClientSideHandshakeImpl;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.ClientSideHandshake;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheClientUpdater;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.logging.log4j.Logger;

public class ConnectionConnector {
    private static final Logger logger = LogService.getLogger();
    private final ClientSideHandshakeImpl handshake;
    private final int socketBufferSize;
    private final int handshakeTimeout;
    private final boolean usedByGateway;
    private final CancelCriterion cancelCriterion;
    private final SocketCreator socketCreator;
    private int readTimeout;
    private InternalDistributedSystem ds;
    private EndpointManager endpointManager;
    private GatewaySender gatewaySender;

    public ConnectionConnector(EndpointManager endpointManager, InternalDistributedSystem sys, int socketBufferSize, int handshakeTimeout, int readTimeout, CancelCriterion cancelCriterion, boolean usedByGateway, GatewaySender sender, SocketCreator socketCreator, ClientSideHandshakeImpl handshake) {
        this.handshake = handshake;
        this.handshake.setClientReadTimeout(readTimeout);
        this.endpointManager = endpointManager;
        this.ds = sys;
        this.socketBufferSize = socketBufferSize;
        this.handshakeTimeout = handshakeTimeout;
        this.readTimeout = readTimeout;
        this.usedByGateway = usedByGateway;
        this.gatewaySender = sender;
        this.cancelCriterion = cancelCriterion;
        this.socketCreator = socketCreator;
        if (this.socketCreator != null && (this.usedByGateway || this.gatewaySender != null) && sender != null && !sender.getGatewayTransportFilters().isEmpty()) {
            this.socketCreator.initializeTransportFilterClientSocketFactory(sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionImpl connectClientToServer(ServerLocation location, boolean forQueue) throws IOException {
        ConnectionImpl connection = null;
        boolean initialized = false;
        try {
            connection = this.getConnection(this.ds, this.cancelCriterion);
            ClientSideHandshake connHandShake = this.getClientSideHandshake(this.handshake);
            connection.connect(this.endpointManager, location, connHandShake, this.socketBufferSize, this.handshakeTimeout, this.readTimeout, this.getCommMode(forQueue), this.gatewaySender, this.socketCreator);
            connection.setHandshake(connHandShake);
            initialized = true;
            ConnectionImpl connectionImpl = connection;
            return connectionImpl;
        }
        finally {
            if (!initialized && connection != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Destroy failed connection to {}", (Object)location);
                }
                this.destroyConnection(connection);
            }
        }
    }

    void destroyConnection(ConnectionImpl connection) {
        connection.destroy();
    }

    ConnectionImpl getConnection(InternalDistributedSystem ds, CancelCriterion cancelCriterion) {
        return new ConnectionImpl(ds, cancelCriterion);
    }

    ClientSideHandshake getClientSideHandshake(ClientSideHandshakeImpl handshake) {
        return new ClientSideHandshakeImpl(handshake);
    }

    public CacheClientUpdater connectServerToClient(Endpoint endpoint, QueueManager qManager, boolean isPrimary, ClientUpdater failedUpdater, String clientUpdateName) {
        CacheClientUpdater updater = new CacheClientUpdater(clientUpdateName, endpoint.getLocation(), isPrimary, this.ds, new ClientSideHandshakeImpl(this.handshake), qManager, this.endpointManager, endpoint, this.handshakeTimeout, this.socketCreator);
        if (!updater.isConnected()) {
            return null;
        }
        updater.setFailedUpdater(failedUpdater);
        updater.start();
        return updater;
    }

    private CommunicationMode getCommMode(boolean forQueue) {
        if (this.usedByGateway || this.gatewaySender != null) {
            return CommunicationMode.GatewayToGateway;
        }
        if (forQueue) {
            return CommunicationMode.ClientToServerForQueue;
        }
        return CommunicationMode.ClientToServer;
    }
}

