/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueStats;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ParallelAsyncEventQueueImpl
extends AbstractGatewaySender {
    private static final Logger logger = LogService.getLogger();

    public ParallelAsyncEventQueueImpl(InternalCache cache, GatewaySenderAttributes attrs) {
        super(cache, attrs);
        if (!(this.cache instanceof CacheCreation)) {
            this.statistics = new AsyncEventQueueStats(cache.getDistributedSystem(), AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.id));
        }
        this.isForInternalUse = true;
    }

    @Override
    public void start() {
        this.getLifeCycleLock().writeLock().lock();
        try {
            String locators;
            if (this.isRunning()) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GatewaySender_SENDER_0_IS_ALREADY_RUNNING, this.getId()));
                return;
            }
            if (this.remoteDSId != -1 && (locators = this.cache.getInternalDistributedSystem().getConfig().getLocators()).length() == 0) {
                throw new IllegalStateException(LocalizedStrings.AbstractGatewaySender_LOCATOR_SHOULD_BE_CONFIGURED_BEFORE_STARTING_GATEWAY_SENDER.toLocalizedString());
            }
            this.eventProcessor = new ConcurrentParallelGatewaySenderEventProcessor(this, this.getThreadMonitorObj());
            this.eventProcessor.start();
            this.waitForRunningStatus();
            if (!this.isAsyncEventQueue()) {
                this.getCache().getPdxRegistry().gatewaySenderStarted(this);
            }
            new UpdateAttributesProcessor(this).distribute(false);
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_START, this);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.ParallelGatewaySenderImpl_STARTED__0, this));
            this.enqueueTempEvents();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    @Override
    public void stop() {
        this.getLifeCycleLock().writeLock().lock();
        try {
            if (!this.isRunning()) {
                return;
            }
            this.stopProcessing();
            this.stompProxyDead();
            for (AsyncEventListener listener : this.listeners) {
                listener.close();
            }
            ((ConcurrentParallelGatewaySenderQueue)this.eventProcessor.getQueue()).cleanUp();
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GatewayImpl_STOPPED__0, this));
            InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
            system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_STOP, this);
            this.clearTempEventsAfterSenderStopped();
        }
        finally {
            this.getLifeCycleLock().writeLock().unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ParallelGatewaySender{");
        sb.append("id=" + this.getId());
        sb.append(",remoteDsId=" + this.getRemoteDSId());
        sb.append(",isRunning =" + this.isRunning());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof GatewaySenderAdvisor.GatewaySenderProfile);
        GatewaySenderAdvisor.GatewaySenderProfile pf = (GatewaySenderAdvisor.GatewaySenderProfile)profile;
        pf.Id = this.getId();
        pf.remoteDSId = this.getRemoteDSId();
        pf.isRunning = this.isRunning();
        pf.isPrimary = this.isPrimary();
        pf.isParallel = true;
        pf.isBatchConflationEnabled = this.isBatchConflationEnabled();
        pf.isPersistenceEnabled = this.isPersistenceEnabled();
        pf.alertThreshold = this.getAlertThreshold();
        pf.manualStart = this.isManualStart();
        pf.dispatcherThreads = this.getDispatcherThreads();
        pf.orderPolicy = this.getOrderPolicy();
        for (GatewayEventFilter gatewayEventFilter : this.getGatewayEventFilters()) {
            pf.eventFiltersClassNames.add(gatewayEventFilter.getClass().getName());
        }
        for (GatewayTransportFilter gatewayTransportFilter : this.getGatewayTransportFilters()) {
            pf.transFiltersClassNames.add(gatewayTransportFilter.getClass().getName());
        }
        for (AsyncEventListener asyncEventListener : this.getAsyncEventListeners()) {
            pf.senderEventListenerClassNames.add(asyncEventListener.getClass().getName());
        }
        pf.isDiskSynchronous = this.isDiskSynchronous();
    }

    @Override
    public void setModifiedEventId(EntryEventImpl clonedEvent) {
        int bucketId = -1;
        bucketId = clonedEvent.getRegion() instanceof DistributedRegion ? PartitionedRegionHelper.getHashKey(clonedEvent.getKey(), this.getMaxParallelismForReplicatedRegion()) : PartitionedRegionHelper.getHashKey(clonedEvent);
        EventID originalEventId = clonedEvent.getEventId();
        long originatingThreadId = ThreadIdentifier.getRealThreadID(originalEventId.getThreadID());
        long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGSPrimaryBucket(bucketId, originatingThreadId, this.getEventIdIndex());
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID(), bucketId);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, bucketId={}, original event id={}, threadId={}, new event id={}, newThreadId={}", (Object)this, clonedEvent.getKey(), (Object)bucketId, (Object)originalEventId, (Object)originatingThreadId, (Object)newEventId, (Object)newThreadId);
        }
        clonedEvent.setEventId(newEventId);
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.cache.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }
}

