/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.ParallelAsyncEventQueueImpl;
import org.apache.geode.cache.asyncqueue.internal.SerialAsyncEventQueueImpl;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AsyncEventQueueConfigurationException;
import org.apache.geode.internal.cache.wan.GatewaySenderAttributes;
import org.apache.geode.internal.cache.wan.InternalGatewaySender;
import org.apache.geode.internal.cache.xmlcache.AsyncEventQueueCreation;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.ParallelAsyncEventQueueCreation;
import org.apache.geode.internal.cache.xmlcache.SerialAsyncEventQueueCreation;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class AsyncEventQueueFactoryImpl
implements AsyncEventQueueFactory {
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_BATCH_TIME_INTERVAL = 5;
    private final InternalCache cache;
    private final GatewaySenderAttributes gatewaySenderAttributes;

    public AsyncEventQueueFactoryImpl(InternalCache cache) {
        this(cache, new GatewaySenderAttributes(), 5);
    }

    AsyncEventQueueFactoryImpl(InternalCache cache, GatewaySenderAttributes gatewaySenderAttributes, int batchTimeInterval) {
        this.cache = cache;
        this.gatewaySenderAttributes = gatewaySenderAttributes;
        this.gatewaySenderAttributes.batchTimeInterval = batchTimeInterval;
    }

    @Override
    public AsyncEventQueueFactory setBatchSize(int size) {
        this.gatewaySenderAttributes.batchSize = size;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setPersistent(boolean isPersistent) {
        this.gatewaySenderAttributes.isPersistenceEnabled = isPersistent;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskStoreName(String name) {
        this.gatewaySenderAttributes.diskStoreName = name;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setMaximumQueueMemory(int memory) {
        this.gatewaySenderAttributes.maximumQueueMemory = memory;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDiskSynchronous(boolean isSynchronous) {
        this.gatewaySenderAttributes.isDiskSynchronous = isSynchronous;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchTimeInterval(int batchTimeInterval) {
        this.gatewaySenderAttributes.batchTimeInterval = batchTimeInterval;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setBatchConflationEnabled(boolean isConflation) {
        this.gatewaySenderAttributes.isBatchConflationEnabled = isConflation;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setDispatcherThreads(int numThreads) {
        this.gatewaySenderAttributes.dispatcherThreads = numThreads;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setOrderPolicy(GatewaySender.OrderPolicy policy) {
        this.gatewaySenderAttributes.policy = policy;
        return this;
    }

    @Override
    public AsyncEventQueueFactory addGatewayEventFilter(GatewayEventFilter filter) {
        this.gatewaySenderAttributes.addGatewayEventFilter(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory removeGatewayEventFilter(GatewayEventFilter filter) {
        this.gatewaySenderAttributes.eventFilters.remove(filter);
        return this;
    }

    @Override
    public AsyncEventQueueFactory setGatewayEventSubstitutionListener(GatewayEventSubstitutionFilter filter) {
        this.gatewaySenderAttributes.eventSubstitutionFilter = filter;
        return this;
    }

    public AsyncEventQueueFactory removeGatewayEventAlternateValueProvider(GatewayEventSubstitutionFilter provider) {
        return this;
    }

    public AsyncEventQueueFactory addAsyncEventListener(AsyncEventListener listener) {
        this.gatewaySenderAttributes.addAsyncEventListener(listener);
        return this;
    }

    @Override
    public AsyncEventQueue create(String asyncQueueId, AsyncEventListener listener) {
        AsyncEventQueue asyncEventQueue;
        if (listener == null) {
            throw new IllegalArgumentException(LocalizedStrings.AsyncEventQueue_ASYNC_EVENT_LISTENER_CANNOT_BE_NULL.toLocalizedString());
        }
        if (this.cache instanceof CacheCreation) {
            asyncEventQueue = new AsyncEventQueueCreation(asyncQueueId, this.gatewaySenderAttributes, listener);
            ((CacheCreation)this.cache).addAsyncEventQueue(asyncEventQueue);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating GatewaySender that underlies the AsyncEventQueue");
            }
            this.addAsyncEventListener(listener);
            InternalGatewaySender sender = (InternalGatewaySender)this.create(AsyncEventQueueImpl.getSenderIdFromAsyncEventQueueId(asyncQueueId));
            AsyncEventQueueImpl asyncEventQueueImpl = new AsyncEventQueueImpl(sender, listener);
            asyncEventQueue = asyncEventQueueImpl;
            this.cache.addAsyncEventQueue(asyncEventQueueImpl);
            if (!this.gatewaySenderAttributes.isManualStart()) {
                sender.start();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning AsyncEventQueue" + asyncEventQueue);
        }
        return asyncEventQueue;
    }

    private GatewaySender create(String id) {
        AbstractGatewaySender sender;
        this.gatewaySenderAttributes.id = id;
        if (this.gatewaySenderAttributes.getDispatcherThreads() <= 0) {
            throw new AsyncEventQueueConfigurationException(LocalizedStrings.AsyncEventQueue_0_CANNOT_HAVE_DISPATCHER_THREADS_LESS_THAN_1.toLocalizedString(id));
        }
        if (this.gatewaySenderAttributes.isParallel()) {
            if (this.gatewaySenderAttributes.getOrderPolicy() != null && this.gatewaySenderAttributes.getOrderPolicy().equals((Object)GatewaySender.OrderPolicy.THREAD)) {
                throw new AsyncEventQueueConfigurationException(LocalizedStrings.AsyncEventQueue_0_CANNOT_BE_CREATED_WITH_ORDER_POLICY_1.toLocalizedString(new Object[]{id, this.gatewaySenderAttributes.getOrderPolicy()}));
            }
            sender = this.cache instanceof CacheCreation ? new ParallelAsyncEventQueueCreation(this.cache, this.gatewaySenderAttributes) : new ParallelAsyncEventQueueImpl(this.cache, this.gatewaySenderAttributes);
            this.cache.addGatewaySender(sender);
        } else {
            if (this.gatewaySenderAttributes.getOrderPolicy() == null && this.gatewaySenderAttributes.getDispatcherThreads() > 1) {
                this.gatewaySenderAttributes.policy = GatewaySender.DEFAULT_ORDER_POLICY;
            }
            sender = this.cache instanceof CacheCreation ? new SerialAsyncEventQueueCreation(this.cache, this.gatewaySenderAttributes) : new SerialAsyncEventQueueImpl(this.cache, this.gatewaySenderAttributes);
            this.cache.addGatewaySender(sender);
        }
        return sender;
    }

    public void configureAsyncEventQueue(AsyncEventQueue asyncQueueCreation) {
        this.gatewaySenderAttributes.batchSize = asyncQueueCreation.getBatchSize();
        this.gatewaySenderAttributes.batchTimeInterval = asyncQueueCreation.getBatchTimeInterval();
        this.gatewaySenderAttributes.isBatchConflationEnabled = asyncQueueCreation.isBatchConflationEnabled();
        this.gatewaySenderAttributes.isPersistenceEnabled = asyncQueueCreation.isPersistent();
        this.gatewaySenderAttributes.diskStoreName = asyncQueueCreation.getDiskStoreName();
        this.gatewaySenderAttributes.isDiskSynchronous = asyncQueueCreation.isDiskSynchronous();
        this.gatewaySenderAttributes.maximumQueueMemory = asyncQueueCreation.getMaximumQueueMemory();
        this.gatewaySenderAttributes.isParallel = asyncQueueCreation.isParallel();
        this.gatewaySenderAttributes.isBucketSorted = ((AsyncEventQueueCreation)asyncQueueCreation).isBucketSorted();
        this.gatewaySenderAttributes.dispatcherThreads = asyncQueueCreation.getDispatcherThreads();
        this.gatewaySenderAttributes.policy = asyncQueueCreation.getOrderPolicy();
        this.gatewaySenderAttributes.eventFilters = asyncQueueCreation.getGatewayEventFilters();
        this.gatewaySenderAttributes.eventSubstitutionFilter = asyncQueueCreation.getGatewayEventSubstitutionFilter();
        this.gatewaySenderAttributes.isForInternalUse = true;
        this.gatewaySenderAttributes.forwardExpirationDestroy = asyncQueueCreation.isForwardExpirationDestroy();
    }

    @Override
    public AsyncEventQueueFactory setParallel(boolean isParallel) {
        this.gatewaySenderAttributes.isParallel = isParallel;
        return this;
    }

    public AsyncEventQueueFactory setBucketSorted(boolean isbucketSorted) {
        this.gatewaySenderAttributes.isBucketSorted = isbucketSorted;
        return this;
    }

    public AsyncEventQueueFactory setIsMetaQueue(boolean isMetaQueue) {
        this.gatewaySenderAttributes.isMetaQueue = isMetaQueue;
        return this;
    }

    @Override
    public AsyncEventQueueFactory setForwardExpirationDestroy(boolean forward) {
        this.gatewaySenderAttributes.forwardExpirationDestroy = forward;
        return this;
    }
}

