/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.util.Properties;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PartitionAttributesFactory<K, V> {
    private final PartitionAttributesImpl partitionAttributes = new PartitionAttributesImpl();
    public static final String LOCAL_MAX_MEMORY_PROPERTY = "LOCAL_MAX_MEMORY";
    @Deprecated
    public static final int LOCAL_MAX_MEMORY_DEFAULT = PartitionAttributesFactory.computeMaxMem();
    public static final String GLOBAL_MAX_MEMORY_PROPERTY = "GLOBAL_MAX_MEMORY";
    public static final long GLOBAL_MAX_MEMORY_DEFAULT = Integer.MAX_VALUE;
    public static final String GLOBAL_MAX_BUCKETS_PROPERTY = "GLOBAL_MAX_BUCKETS";
    public static final int GLOBAL_MAX_BUCKETS_DEFAULT = 113;
    public static final long RECOVERY_DELAY_DEFAULT = -1L;
    public static final long STARTUP_RECOVERY_DELAY_DEFAULT = 0L;

    static int computeMaxMem() {
        int ret;
        long maxMemInMegabytes = Runtime.getRuntime().maxMemory() / 0x100000L;
        long maxMemoryToUse = (long)((double)maxMemInMegabytes * 0.9);
        if (maxMemoryToUse < Integer.MAX_VALUE) {
            ret = (int)maxMemoryToUse;
            if (ret < 1) {
                ret = 1;
            }
        } else {
            ret = Integer.MAX_VALUE;
        }
        return ret;
    }

    public PartitionAttributesFactory() {
    }

    public PartitionAttributesFactory(PartitionAttributes pa) {
        this.partitionAttributes.setAll(pa);
    }

    public PartitionAttributesFactory<K, V> setRedundantCopies(int redundantCopies) {
        this.partitionAttributes.setRedundantCopies(redundantCopies);
        return this;
    }

    public PartitionAttributesFactory<K, V> setLocalMaxMemory(int mb) {
        this.partitionAttributes.setLocalMaxMemory(mb);
        return this;
    }

    @Deprecated
    public PartitionAttributesFactory<K, V> setTotalMaxMemory(long mb) {
        this.partitionAttributes.setTotalMaxMemory(mb);
        return this;
    }

    public PartitionAttributesFactory<K, V> setTotalNumBuckets(int numBuckets) {
        this.partitionAttributes.setTotalNumBuckets(numBuckets);
        return this;
    }

    public PartitionAttributesFactory<K, V> setPartitionResolver(PartitionResolver<K, V> resolver) {
        this.partitionAttributes.setPartitionResolver(resolver);
        return this;
    }

    public PartitionAttributesFactory<K, V> setColocatedWith(String colocatedRegionFullPath) {
        this.partitionAttributes.setColocatedWith(colocatedRegionFullPath);
        return this;
    }

    public PartitionAttributesFactory<K, V> setRecoveryDelay(long recoveryDelay) {
        this.partitionAttributes.setRecoveryDelay(recoveryDelay);
        return this;
    }

    public PartitionAttributesFactory<K, V> setStartupRecoveryDelay(long startupRecoveryDelay) {
        this.partitionAttributes.setStartupRecoveryDelay(startupRecoveryDelay);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionAttributesFactory<K, V> addPartitionListener(PartitionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionAttributesFactory_PARTITION_LISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        PartitionAttributesImpl partitionAttributesImpl = this.partitionAttributes;
        synchronized (partitionAttributesImpl) {
            this.partitionAttributes.addPartitionListener(listener);
        }
        return this;
    }

    @Deprecated
    public PartitionAttributesFactory<K, V> setLocalProperties(Properties localProps) {
        if (localProps == null) {
            return this;
        }
        this.partitionAttributes.setLocalProperties(localProps);
        return this;
    }

    @Deprecated
    public PartitionAttributesFactory<K, V> setGlobalProperties(Properties globalProps) {
        this.partitionAttributes.setGlobalProperties(globalProps);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionAttributesFactory<K, V> addFixedPartitionAttributes(FixedPartitionAttributes fpa) {
        PartitionAttributesImpl partitionAttributesImpl = this.partitionAttributes;
        synchronized (partitionAttributesImpl) {
            this.partitionAttributes.addFixedPartitionAttributes(fpa);
            return this;
        }
    }

    public PartitionAttributes<K, V> create() {
        this.partitionAttributes.validateAttributes();
        return (PartitionAttributes)this.partitionAttributes.clone();
    }
}

