/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.GemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.jmx.Agent;
import org.apache.geode.admin.jmx.AgentFactory;
import org.apache.geode.admin.jmx.internal.AgentConfigImpl;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.internal.util.JavaCommandBuilder;
import org.apache.logging.log4j.Logger;

public class AgentLauncher {
    private static final Logger logger = LogService.getLogger();
    public static final boolean PRINT_LAUNCH_COMMAND = Boolean.getBoolean(AgentLauncher.class.getSimpleName() + ".PRINT_LAUNCH_COMMAND");
    static final int SHUTDOWN = 0;
    static final int STARTING = 1;
    static final int RUNNING = 2;
    static final int SHUTDOWN_PENDING = 3;
    static final int SHUTDOWN_PENDING_AFTER_FAILED_STARTUP = 4;
    static final int UNKNOWN = 6;
    static final String AGENT_PROPS = "agent-props";
    static final String APPENDTO_LOG_FILE = "appendto-log-file";
    static final String CLASSPATH = "classpath";
    static final String DIR = "dir";
    static final String VMARGS = "vmargs";
    private File workingDirectory = null;
    private Status status = null;
    private final String basename;
    private final String startLogFileName;
    private final String statusFileName;

    AgentLauncher(String basename) {
        assert (basename != null) : "The base name used by the AgentLauncher to create files cannot be null!";
        this.basename = basename;
        String formattedBasename = this.basename.toLowerCase().replace(" ", "");
        this.startLogFileName = "start_" + formattedBasename + ".log";
        this.statusFileName = "." + formattedBasename + ".ser";
    }

    public void configHelp() {
        PrintStream out = System.out;
        Properties props = AgentConfigImpl.getDefaultValuesForAllProperties();
        out.println("\n");
        out.println(LocalizedStrings.AgentLauncher_AGENT_CONFIGURATION_PROPERTIES.toString());
        TreeMap<String, String> map = new TreeMap<String, String>();
        int maxLength = 0;
        for (String string : props.keySet()) {
            int length = string.length();
            if (length > maxLength) {
                maxLength = length;
            }
            map.put(string, AgentConfigImpl.getPropertyDescription(string) + " (" + LocalizedStrings.AgentLauncher_DEFAULT.toLocalizedString() + "  \"" + props.getProperty(string) + "\")");
        }
        for (Map.Entry entry : map.entrySet()) {
            String prop = (String)entry.getKey();
            out.print("  ");
            out.println(prop);
            String description = (String)entry.getValue();
            StringTokenizer st = new StringTokenizer(description, " ");
            out.print("    ");
            int printed = 6;
            while (st.hasMoreTokens()) {
                String word = st.nextToken();
                if (printed + word.length() > 72) {
                    out.print("\n    ");
                    printed = 6;
                }
                out.print(word);
                out.print(" ");
                printed += word.length() + 1;
            }
            out.println("");
        }
        out.println("");
        ExitCode.FATAL.doSystemExit();
    }

    protected Map<String, Object> getStartOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(APPENDTO_LOG_FILE, "false");
        options.put(DIR, IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(new File(".")));
        ArrayList<String> vmArgs = new ArrayList<String>();
        options.put(VMARGS, vmArgs);
        Properties agentProps = new Properties();
        options.put(AGENT_PROPS, agentProps);
        for (String arg : args) {
            if (arg.startsWith("-classpath=")) {
                options.put(CLASSPATH, arg.substring("-classpath=".length()));
                continue;
            }
            if (arg.startsWith("-dir=")) {
                File workingDirectory = AgentLauncher.processDirOption(options, arg.substring("-dir=".length()));
                System.setProperty("gfAgentPropertyFile", new File(workingDirectory, "agent.properties").getPath());
                continue;
            }
            if (arg.startsWith("-J")) {
                vmArgs.add(arg.substring(2));
                continue;
            }
            if (!arg.contains("=")) continue;
            int index = arg.indexOf("=");
            String prop = arg.substring(0, index);
            String value = arg.substring(index + 1);
            if (prop.equals(APPENDTO_LOG_FILE)) {
                options.put(APPENDTO_LOG_FILE, value);
                continue;
            }
            AgentConfigImpl.getPropertyDescription(prop);
            if ("property-file".equals(prop)) {
                System.setProperty("gfAgentPropertyFile", value);
            }
            agentProps.setProperty(prop, value);
        }
        return options;
    }

    public void start(String[] args) throws Exception {
        Map<String, Object> options = this.getStartOptions(args);
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)options.get(DIR));
        this.verifyAndClearStatus();
        this.runCommandLine(options, this.buildCommandLine(options));
        this.pollAgentUntilRunning();
        ExitCode.NORMAL.doSystemExit();
    }

    private void verifyAndClearStatus() throws Exception {
        Status status = this.getStatus();
        if (status != null && status.state != 0) {
            throw new IllegalStateException(LocalizedStrings.AgentLauncher_JMX_AGENT_EXISTS_BUT_WAS_NOT_SHUTDOWN.toLocalizedString());
        }
        this.deleteStatus();
    }

    private String[] buildCommandLine(Map<String, Object> options) {
        List<String> commands = JavaCommandBuilder.buildCommand(AgentLauncher.class.getName(), (String)options.get(CLASSPATH), null, (List)options.get(VMARGS));
        commands.add("server");
        commands.add("-dir=" + this.workingDirectory);
        Properties agentProps = (Properties)options.get(AGENT_PROPS);
        for (Object key : agentProps.keySet()) {
            commands.add(key + "=" + agentProps.get(key.toString()));
        }
        return commands.toArray(new String[commands.size()]);
    }

    private void printCommandLine(String[] commandLine) {
        if (PRINT_LAUNCH_COMMAND) {
            System.out.print("Starting " + this.basename + " with command:\n");
            for (String command : commandLine) {
                System.out.print(command);
                System.out.print(' ');
            }
            System.out.println();
        }
    }

    private int runCommandLine(Map<String, Object> options, String[] commandLine) throws IOException {
        File startLogFile = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(new File(this.workingDirectory, this.startLogFileName));
        if (startLogFile.exists() && !startLogFile.delete()) {
            throw new IOException(LocalizedStrings.AgentLauncher_UNABLE_TO_DELETE_FILE_0.toLocalizedString(startLogFile.getAbsolutePath()));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        SocketCreator.readSSLProperties(env, true);
        this.printCommandLine(commandLine);
        int pid = OSProcess.bgexec(commandLine, this.workingDirectory, startLogFile, false, env);
        System.out.println(LocalizedStrings.AgentLauncher_STARTING_JMX_AGENT_WITH_PID_0.toLocalizedString(pid));
        return pid;
    }

    private void pollAgentUntilRunning() throws Exception {
        Status status = this.spinReadStatus();
        while (status != null && status.state == 1) {
            Thread.sleep(500L);
            status = this.spinReadStatus();
        }
        if (status == null) {
            throw new Exception(LocalizedStrings.AgentLauncher_NO_AVAILABLE_STATUS.toLocalizedString());
        }
        System.out.println(status);
    }

    public void server(String[] args) throws Exception {
        Map<String, Object> options = this.getStartOptions(args);
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)options.get(DIR));
        this.writeStatus(AgentLauncher.createStatus(this.basename, 1, OSProcess.getId()));
        Agent agent = this.createAgent((Properties)options.get(AGENT_PROPS));
        Thread thread = this.createAgentProcessThread(this.createAgentProcessThreadGroup(), agent);
        thread.setDaemon(true);
        thread.start();
        this.pollAgentForPendingShutdown(agent);
    }

    private Agent createAgent(Properties props) throws IOException, AdminException {
        ClusterDistributionManager.setIsDedicatedAdminVM(true);
        SystemFailure.setExitOK(true);
        AgentConfigImpl config = new AgentConfigImpl(props);
        if (config.getLogFile() == null || "".equals(config.getLogFile().trim())) {
            config.setLogFile("agent.log");
        }
        OSProcess.redirectOutput(new File(config.getLogFile()));
        return AgentFactory.getAgent(config);
    }

    private ThreadGroup createAgentProcessThreadGroup() {
        return new ThreadGroup(LocalizedStrings.AgentLauncher_STARTING_AGENT.toLocalizedString()){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof VirtualMachineError) {
                    SystemFailure.setFailure((VirtualMachineError)e);
                }
                AgentLauncher.this.setServerError(LocalizedStrings.AgentLauncher_UNCAUGHT_EXCEPTION_IN_THREAD_0.toLocalizedString(t.getName()), e);
            }
        };
    }

    private Thread createAgentProcessThread(ThreadGroup group, Agent agent) {
        return new Thread(group, this.createAgentProcessRunnable(agent), "Start agent");
    }

    private Runnable createAgentProcessRunnable(final Agent agent) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    agent.start();
                    AgentLauncher.this.writeStatus(AgentLauncher.createStatus(AgentLauncher.this.basename, 2, OSProcess.getId()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (GemFireException e) {
                    e.printStackTrace();
                    this.handleGemFireException(e);
                }
            }

            private void handleGemFireException(GemFireException e) {
                String message = LocalizedStrings.AgentLauncher_SERVER_FAILED_TO_START_0.toLocalizedString(e.getMessage());
                if (e.getCause() != null && e.getCause().getCause() != null) {
                    message = message + ", " + e.getCause().getCause().getMessage();
                }
                AgentLauncher.this.setServerError(null, new Exception(message));
            }
        };
    }

    private void setServerError(String message, Throwable cause) {
        try {
            this.writeStatus(AgentLauncher.createStatus(this.basename, 4, OSProcess.getId(), message, cause));
        }
        catch (Exception e) {
            logger.fatal(e.getMessage(), (Throwable)e);
            ExitCode.FATAL.doSystemExit();
        }
    }

    private void pollAgentForPendingShutdown(Agent agent) throws Exception {
        while (true) {
            AgentLauncher.pause(500);
            this.spinReadStatus();
            if (!this.isStatus(3, 4)) continue;
            agent.stop();
            ExitCode exitCode = this.isStatus(4) ? ExitCode.FATAL : ExitCode.NORMAL;
            this.writeStatus(AgentLauncher.createStatus(this.status, 0));
            exitCode.doSystemExit();
        }
    }

    protected Map<String, Object> getStopOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(DIR, IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(new File(".")));
        for (String arg : args) {
            if (arg.equals("stop") || arg.equals("status")) continue;
            if (arg.startsWith("-dir=")) {
                AgentLauncher.processDirOption(options, arg.substring("-dir=".length()));
                continue;
            }
            throw new Exception(LocalizedStrings.AgentLauncher_UNKNOWN_ARGUMENT_0.toLocalizedString(arg));
        }
        return options;
    }

    public void stop(String[] args) throws Exception {
        Map<String, Object> options = this.getStopOptions(args);
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)options.get(DIR));
        ExitCode exitCode = ExitCode.FATAL;
        if (new File(this.workingDirectory, this.statusFileName).exists()) {
            this.spinReadStatus();
            if (!this.isStatus(0)) {
                this.writeStatus(AgentLauncher.createStatus(this.basename, 3, this.status.pid));
            }
            this.pollAgentForShutdown();
            if (this.isStatus(0)) {
                System.out.println(LocalizedStrings.AgentLauncher_0_HAS_STOPPED.toLocalizedString(this.basename));
                this.deleteStatus();
                exitCode = ExitCode.NORMAL;
            } else {
                System.out.println(LocalizedStrings.AgentLauncher_TIMEOUT_WAITING_FOR_0_TO_SHUTDOWN_STATUS_IS_1.toLocalizedString(this.basename, this.status));
            }
        } else {
            System.out.println(LocalizedStrings.AgentLauncher_THE_SPECIFIED_WORKING_DIRECTORY_0_CONTAINS_NO_STATUS_FILE.toLocalizedString(this.workingDirectory));
        }
        exitCode.doSystemExit();
    }

    private void pollAgentForShutdown() throws InterruptedException {
        long endTime = System.currentTimeMillis() + 20000L;
        long clock = 0L;
        while (clock < endTime && !this.isStatus(0)) {
            AgentLauncher.pause(500);
            this.spinReadStatus();
            clock = System.currentTimeMillis();
        }
    }

    public void status(String[] args) throws Exception {
        this.workingDirectory = IOUtils.tryGetCanonicalFileElseGetAbsoluteFile((File)this.getStopOptions(args).get(DIR));
        System.out.println(this.getStatus());
        ExitCode.NORMAL.doSystemExit();
    }

    protected Status getStatus() throws Exception {
        Status status = new File(this.workingDirectory, this.statusFileName).exists() ? this.spinReadStatus() : AgentLauncher.createStatus(this.basename, 0, 0, LocalizedStrings.AgentLauncher_0_IS_NOT_RUNNING_IN_SPECIFIED_WORKING_DIRECTORY_1.toLocalizedString(this.basename, this.workingDirectory), null);
        return status;
    }

    private boolean isStatus(Integer ... states2) {
        return this.status != null && Arrays.asList(AgentLauncher.defaultToUnknownStateIfNull(states2)).contains(this.status.state);
    }

    protected void deleteStatus() throws IOException {
        this.deleteStatus(this.workingDirectory);
    }

    void deleteStatus(File workingDirectory) throws IOException {
        File statusFile = new File(workingDirectory, this.statusFileName);
        if (statusFile.exists() && !statusFile.delete()) {
            throw new IOException("Could not delete status file (" + statusFile.getAbsolutePath() + ")");
        }
    }

    protected Status readStatus() throws IOException {
        return this.readStatus(this.workingDirectory);
    }

    Status readStatus(File workingDirectory) throws IOException {
        Status status;
        FileInputStream fileIn = null;
        ObjectInputStream objectIn = null;
        try {
            fileIn = new FileInputStream(new File(workingDirectory, this.statusFileName));
            objectIn = new ObjectInputStream(fileIn);
            status = this.status = (Status)objectIn.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close(objectIn);
                IOUtils.close(fileIn);
                throw throwable;
            }
        }
        IOUtils.close(objectIn);
        IOUtils.close(fileIn);
        return status;
    }

    protected Status nativeReadStatus() throws IOException {
        Status status = this.readStatus();
        if (status != null && !PureJavaMode.isPure() && !OSProcess.exists(status.pid)) {
            status = AgentLauncher.createStatus(status, 0);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status spinReadStatus() {
        Status status = null;
        long endTime = System.currentTimeMillis() + 20000L;
        long clock = 0L;
        while (status == null && clock < endTime) {
            try {
                status = this.nativeReadStatus();
            }
            catch (Exception ignore) {
                AgentLauncher.pause(500);
            }
            finally {
                clock = System.currentTimeMillis();
            }
        }
        return status;
    }

    public Status writeStatus(Status status) throws IOException {
        return this.writeStatus(status, this.workingDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Status writeStatus(Status status, File workingDirectory) throws IOException {
        Status status2;
        FileOutputStream fileOut = null;
        ObjectOutputStream objectOut = null;
        try {
            fileOut = new FileOutputStream(new File(workingDirectory, this.statusFileName));
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(status);
            objectOut.flush();
            status2 = this.status = status;
        }
        catch (Throwable throwable) {
            IOUtils.close(objectOut);
            IOUtils.close(fileOut);
            throw throwable;
        }
        IOUtils.close(objectOut);
        IOUtils.close(fileOut);
        return status2;
    }

    protected static Status createStatus(String basename, int state, int pid) {
        return AgentLauncher.createStatus(basename, state, pid, null, null);
    }

    protected static Status createStatus(String basename, int state, int pid, String msg, Throwable t) {
        Status status = new Status(basename);
        status.state = state;
        status.pid = pid;
        status.msg = msg;
        status.exception = t;
        return status;
    }

    protected static Status createStatus(Status status, int state) {
        assert (status != null) : "The status to clone cannot be null!";
        return AgentLauncher.createStatus(status.baseName, state, status.pid, status.msg, status.exception);
    }

    protected static Integer[] defaultToUnknownStateIfNull(Integer ... states2) {
        Integer[] integerArray;
        if (states2 != null) {
            integerArray = states2;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = 6;
        }
        return integerArray;
    }

    protected static boolean pause(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected static File processDirOption(Map<String, Object> options, String dirValue) throws FileNotFoundException {
        File workingDirectory = new File(dirValue);
        if (!workingDirectory.exists()) {
            throw new FileNotFoundException(LocalizedStrings.AgentLauncher_THE_INPUT_WORKING_DIRECTORY_DOES_NOT_EXIST_0.toLocalizedString(dirValue));
        }
        options.put(DIR, workingDirectory);
        return workingDirectory;
    }

    private static void usage(String message) {
        PrintStream out = System.out;
        out.println("\n** " + message + "\n");
        out.println("agent start [-J<vmarg>]* [-dir=<dir>] [prop=value]*");
        out.println(LocalizedStrings.AgentLauncher_STARTS_THE_GEMFIRE_JMX_AGENT.toLocalizedString());
        out.println("\t" + LocalizedStrings.AgentLauncher_VMARG.toLocalizedString());
        out.println("\t" + LocalizedStrings.AgentLauncher_DIR.toLocalizedString());
        out.println("\t" + LocalizedStrings.AgentLauncher_PROP.toLocalizedString());
        out.println("\t" + LocalizedStrings.AgentLauncher_SEE_HELP_CONFIG.toLocalizedString());
        out.println();
        out.println("agent stop [-dir=<dir>]");
        out.println(LocalizedStrings.AgentLauncher_STOPS_A_GEMFIRE_JMX_AGENT.toLocalizedString());
        out.println("\t" + LocalizedStrings.AgentLauncher_DIR.toLocalizedString());
        out.println("");
        out.println("agent status [-dir=<dir>]");
        out.println(LocalizedStrings.AgentLauncher_REPORTS_THE_STATUS_AND_THE_PROCESS_ID_OF_A_GEMFIRE_JMX_AGENT.toLocalizedString());
        out.println("\t" + LocalizedStrings.AgentLauncher_DIR.toLocalizedString());
        out.println();
        ExitCode.FATAL.doSystemExit();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            AgentLauncher.usage(LocalizedStrings.AgentLauncher_MISSING_COMMAND.toLocalizedString());
        }
        SystemFailure.loadEmergencyClasses();
        AgentLauncher launcher = new AgentLauncher("Agent");
        try {
            String command = args[0];
            if (command.equalsIgnoreCase("start")) {
                launcher.start(args);
            } else if (command.equalsIgnoreCase("server")) {
                launcher.server(args);
            } else if (command.equalsIgnoreCase("stop")) {
                launcher.stop(args);
            } else if (command.equalsIgnoreCase("status")) {
                launcher.status(args);
            } else if (command.toLowerCase().matches("-{0,2}help")) {
                if (args.length > 1) {
                    String topic = args[1];
                    if (topic.equals("config")) {
                        launcher.configHelp();
                    } else {
                        AgentLauncher.usage(LocalizedStrings.AgentLauncher_NO_HELP_AVAILABLE_FOR_0.toLocalizedString(topic));
                    }
                }
                AgentLauncher.usage(LocalizedStrings.AgentLauncher_AGENT_HELP.toLocalizedString());
            } else {
                AgentLauncher.usage(LocalizedStrings.AgentLauncher_UNKNOWN_COMMAND_0.toLocalizedString(command));
            }
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            System.err.println(LocalizedStrings.AgentLauncher_ERROR_0.toLocalizedString(t.getLocalizedMessage()));
            ExitCode.FATAL.doSystemExit();
        }
    }

    static class Status
    implements Serializable {
        private static final long serialVersionUID = -7758402454664266174L;
        int pid = 0;
        int state = 0;
        final String baseName;
        String msg;
        Throwable exception;

        public Status(String baseName) {
            this.baseName = baseName;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.pid == Integer.MIN_VALUE && this.state == 0 && this.msg != null) {
                buffer.append(this.msg);
            } else {
                buffer.append(LocalizedStrings.AgentLauncher_0_PID_1_STATUS.toLocalizedString(this.baseName, this.pid));
                switch (this.state) {
                    case 0: {
                        buffer.append(LocalizedStrings.AgentLauncher_SHUTDOWN.toLocalizedString());
                        break;
                    }
                    case 1: {
                        buffer.append(LocalizedStrings.AgentLauncher_STARTING.toLocalizedString());
                        break;
                    }
                    case 2: {
                        buffer.append(LocalizedStrings.AgentLauncher_RUNNING.toLocalizedString());
                        break;
                    }
                    case 3: {
                        buffer.append(LocalizedStrings.AgentLauncher_SHUTDOWN_PENDING.toLocalizedString());
                        break;
                    }
                    case 4: {
                        buffer.append(LocalizedStrings.AgentLauncher_SHUTDOWN_PENDING_AFTER_FAILED_STARTUP.toLocalizedString());
                        break;
                    }
                    default: {
                        buffer.append(LocalizedStrings.AgentLauncher_UNKNOWN.toLocalizedString());
                    }
                }
                if (this.exception != null) {
                    if (this.msg != null) {
                        buffer.append("\n").append(this.msg).append(" - ");
                    } else {
                        buffer.append("\n " + LocalizedStrings.AgentLauncher_EXCEPTION_IN_0_1.toLocalizedString(this.baseName, this.exception.getMessage()) + " - ");
                    }
                    buffer.append(LocalizedStrings.AgentLauncher_SEE_LOG_FILE_FOR_DETAILS.toLocalizedString());
                }
            }
            return buffer.toString();
        }
    }
}

