/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.admin.ConfigurationParameter;
import org.apache.geode.admin.UnmodifiableConfigurationException;
import org.apache.geode.admin.internal.ConfigurationParameterListener;
import org.apache.geode.admin.internal.InetAddressUtil;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ConfigurationParameterImpl
implements ConfigurationParameter {
    protected String name;
    protected String description;
    protected Object value;
    protected Class type;
    protected boolean userModifiable;
    private final List listeners = new ArrayList();

    protected ConfigurationParameterImpl(String name, String description, Object value, Class type, boolean userModifiable) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.ConfigurationParameterImpl_CONFIGURATIONPARAMETER_NAME_MUST_BE_SPECIFIED.toLocalizedString());
        }
        this.name = name;
        this.setInternalState(description, value, type, userModifiable);
    }

    protected ConfigurationParameterImpl(String name, Object value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.ConfigurationParameterImpl_CONFIGURATIONPARAMETER_NAME_MUST_BE_SPECIFIED.toLocalizedString());
        }
        this.name = name;
        this.setInternalState(name, value, value.getClass(), true);
    }

    protected ConfigurationParameterImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getValueAsString() {
        if (this.isString()) {
            return (String)this.value;
        }
        if (this.isInetAddress()) {
            return InetAddressUtil.toString(this.value);
        }
        if (this.isFile()) {
            return this.value.toString();
        }
        if (this.isOctal()) {
            String strVal = Integer.toOctalString((Integer)this.value);
            if (!strVal.startsWith("0")) {
                strVal = "0" + strVal;
            }
            return strVal;
        }
        if (this.isArray()) {
            List<Object> list = Arrays.asList((Object[])this.value);
            return list.toString();
        }
        return this.value.toString();
    }

    @Override
    public Class getValueType() {
        return this.type;
    }

    @Override
    public boolean isModifiable() {
        return this.userModifiable;
    }

    @Override
    public boolean isArray() {
        return "manager-parameters".equals(this.name) || "manager-classpaths".equals(this.name);
    }

    @Override
    public boolean isInetAddress() {
        return InetAddress.class.isAssignableFrom(this.type);
    }

    @Override
    public boolean isFile() {
        return File.class.equals((Object)this.type);
    }

    @Override
    public boolean isOctal() {
        return "shared-memory-permissions".equals(this.name);
    }

    @Override
    public boolean isString() {
        return String.class.equals((Object)this.type);
    }

    @Override
    public void setValue(Object value) throws UnmodifiableConfigurationException {
        if (!this.isModifiable()) {
            throw new UnmodifiableConfigurationException(LocalizedStrings.ConfigurationParameterImpl_0_IS_NOT_A_MODIFIABLE_CONFIGURATION_PARAMETER.toLocalizedString(this.getName()));
        }
        if (value == null) {
            throw new IllegalArgumentException(LocalizedStrings.ConfigurationParameterImpl_UNABLE_TO_SET_0_TO_NULL_VALUE.toLocalizedString(this.getName()));
        }
        if (!this.getValueType().equals(value.getClass())) {
            throw new IllegalArgumentException(LocalizedStrings.ConfigurationParameterImpl_UNABLE_TO_SET_TYPE_0_WITH_TYPE_1.toLocalizedString(this.getValueType().getName(), value.getClass().getName()));
        }
        if (value instanceof String && !this.isString()) {
            this.setValueFromString((String)value);
        } else {
            this.value = value;
        }
        this.fireConfigurationParameterValueChanged(this);
    }

    public void addConfigurationParameterListener(ConfigurationParameterListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConfigurationParameterListener(ConfigurationParameterListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    protected void setValueFromString(String newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(LocalizedStrings.ConfigurationParameterImpl_UNABLE_TO_SET_0_TO_NULL_VALUE.toLocalizedString(this.getName()));
        }
        if (this.isInetAddress()) {
            this.value = InetAddressUtil.toInetAddress(newValue);
        } else if (this.isFile()) {
            this.value = new File(newValue);
        } else if (this.isOctal()) {
            if (!newValue.startsWith("0")) {
                newValue = "0" + newValue;
            }
            this.value = Integer.parseInt(newValue, 8);
        } else {
            if (this.isArray()) {
                throw new IllegalArgumentException(LocalizedStrings.ConfigurationParameterImpl_SETTING_ARRAY_VALUE_FROM_DELIMITED_STRING_IS_NOT_SUPPORTED.toLocalizedString());
            }
            this.value = newValue;
        }
    }

    protected void fireConfigurationParameterValueChanged(ConfigurationParameter parm) {
        ConfigurationParameterListener[] listeners = this.listeners.toArray(new ConfigurationParameterListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].configurationParameterValueChanged(parm);
        }
    }

    protected void setInternalState(String description, Object value, Class type, boolean userModifiable) {
        this.description = description;
        this.type = type;
        this.userModifiable = userModifiable;
        this.value = value;
    }

    public String toString() {
        return this.name;
    }
}

