/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.List;
import org.apache.geode.CancelException;
import org.apache.geode.admin.CacheHealthConfig;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.internal.AbstractHealthEvaluator;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.cache.CacheLifecycleListener;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class CacheHealthEvaluator
extends AbstractHealthEvaluator
implements CacheLifecycleListener {
    private static final Logger logger = LogService.getLogger();
    private final CacheHealthConfig config;
    private String description;
    private CachePerfStats cacheStats;
    private long prevNetsearchTime;
    private long prevNetsearchesCompleted;
    private long prevLoadTime;
    private long prevLoadsCompleted;
    private long prevGets;

    CacheHealthEvaluator(GemFireHealthConfig config, DistributionManager dm) {
        super(config, dm);
        InternalCache cache;
        this.config = config;
        InternalDistributedSystem system = dm.getSystem();
        try {
            cache = (InternalCache)CacheFactory.getInstance(system);
        }
        catch (CancelException ignore) {
            cache = null;
        }
        this.initialize(cache, dm);
        GemFireCacheImpl.addCacheLifecycleListener(this);
    }

    @Override
    protected String getDescription() {
        return this.description;
    }

    private void initialize(InternalCache cache, DistributionManager dm) {
        StringBuilder sb = new StringBuilder();
        if (cache != null) {
            this.cacheStats = cache.getCachePerfStats();
            sb.append("Cache \"");
            sb.append(cache.getName());
            sb.append('\"');
        } else {
            sb.append("No Cache");
        }
        sb.append(" in member ");
        sb.append(dm.getId());
        int pid = OSProcess.getId();
        if (pid != 0) {
            sb.append(" with pid ");
            sb.append(pid);
        }
        this.description = sb.toString();
    }

    @Override
    public void cacheCreated(InternalCache cache) {
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DistributionManager dm = system.getDistributionManager();
        this.initialize(cache, dm);
    }

    private void checkNetSearchTime(List status) {
        if (this.cacheStats == null || this.isFirstEvaluation() || this.cacheStats.isClosed()) {
            return;
        }
        long deltaNetsearchTime = this.cacheStats.getNetsearchTime() - this.prevNetsearchTime;
        long deltaNetsearchesCompleted = (long)this.cacheStats.getNetsearchesCompleted() - this.prevNetsearchesCompleted;
        if (deltaNetsearchesCompleted != 0L) {
            long ratio = deltaNetsearchTime / deltaNetsearchesCompleted;
            long threshold = this.config.getMaxNetSearchTime();
            if ((ratio /= 1000000L) > threshold) {
                String s = LocalizedStrings.CacheHealthEvaluator_THE_AVERAGE_DURATION_OF_A_CACHE_NETSEARCH_0_MS_EXCEEDS_THE_THRESHOLD_1_MS.toLocalizedString(ratio, threshold);
                status.add(this.okayHealth(s));
            }
        }
    }

    private void checkLoadTime(List<AbstractHealthEvaluator.HealthStatus> status) {
        if (this.cacheStats == null || this.isFirstEvaluation() || this.cacheStats.isClosed()) {
            return;
        }
        if (!this.isFirstEvaluation()) {
            long deltaLoadTime = this.cacheStats.getLoadTime() - this.prevLoadTime;
            long deltaLoadsCompleted = (long)this.cacheStats.getLoadsCompleted() - this.prevLoadsCompleted;
            if (logger.isDebugEnabled()) {
                logger.debug("Completed {} loads in {} ms", (Object)deltaLoadsCompleted, (Object)(deltaLoadTime / 1000000L));
            }
            if (deltaLoadsCompleted != 0L) {
                long ratio = deltaLoadTime / deltaLoadsCompleted;
                long threshold = this.config.getMaxLoadTime();
                if ((ratio /= 1000000L) > threshold) {
                    String s = LocalizedStrings.CacheHealthEvaluator_THE_AVERAGE_DURATION_OF_A_CACHE_LOAD_0_MS_EXCEEDS_THE_THRESHOLD_1_MS.toLocalizedString(ratio, threshold);
                    if (logger.isDebugEnabled()) {
                        logger.debug(s);
                    }
                    status.add(this.okayHealth(s));
                }
            }
        }
    }

    private void checkHitRatio(List<AbstractHealthEvaluator.HealthStatus> status) {
        double threshold;
        long deltaNetsearchesCompleted;
        long deltaLoadsCompleted;
        double hits;
        double hitRatio;
        if (this.cacheStats == null || this.isFirstEvaluation() || this.cacheStats.isClosed()) {
            return;
        }
        long deltaGets = (long)this.cacheStats.getGets() - this.prevGets;
        if (deltaGets != 0L && (hitRatio = (hits = (double)(deltaGets - ((deltaLoadsCompleted = (long)this.cacheStats.getLoadsCompleted() - this.prevLoadsCompleted) + (deltaNetsearchesCompleted = (long)this.cacheStats.getNetsearchesCompleted() - this.prevNetsearchesCompleted)))) / (double)deltaGets) < (threshold = this.config.getMinHitRatio())) {
            String s = "The hit ratio of this Cache (" + hitRatio + ") is below the threshold (" + threshold + ')';
            status.add(this.okayHealth(s));
        }
    }

    private void checkEventQueueSize(List<AbstractHealthEvaluator.HealthStatus> status) {
        long threshold;
        if (this.cacheStats == null || this.isFirstEvaluation() || this.cacheStats.isClosed()) {
            return;
        }
        long eventQueueSize = this.cacheStats.getEventQueueSize();
        if (eventQueueSize > (threshold = this.config.getMaxEventQueueSize())) {
            String s = LocalizedStrings.CacheHealthEvaluator_THE_SIZE_OF_THE_CACHE_EVENT_QUEUE_0_MS_EXCEEDS_THE_THRESHOLD_1_MS.toLocalizedString(eventQueueSize, threshold);
            status.add(this.okayHealth(s));
        }
    }

    private void updatePrevious() {
        if (this.cacheStats != null && !this.cacheStats.isClosed()) {
            this.prevLoadTime = this.cacheStats.getLoadTime();
            this.prevLoadsCompleted = this.cacheStats.getLoadsCompleted();
            this.prevNetsearchTime = this.cacheStats.getNetsearchTime();
            this.prevNetsearchesCompleted = this.cacheStats.getNetsearchesCompleted();
            this.prevGets = this.cacheStats.getGets();
        } else {
            this.prevLoadTime = 0L;
            this.prevLoadsCompleted = 0L;
            this.prevNetsearchTime = 0L;
            this.prevNetsearchesCompleted = 0L;
            this.prevGets = 0L;
        }
    }

    @Override
    protected void check(List status) {
        this.checkNetSearchTime(status);
        this.checkLoadTime(status);
        this.checkHitRatio(status);
        this.checkEventQueueSize(status);
        this.updatePrevious();
    }

    @Override
    public void close() {
        GemFireCacheImpl.removeCacheLifecycleListener(this);
    }

    @Override
    public void cacheClosed(InternalCache cache) {
    }
}

