/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.internal.cache;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.junit.Before;
import org.junit.Test;

import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.cache.CacheDistributionAdvisor.CacheProfile;

public class CacheProfileTest {

  private ClusterDistributionManager dm;
  private InternalCache cache;
  private String adviseePath;
  private LocalRegion region;

  @Before
  public void setUp() {
    adviseePath = "adviseePath";

    dm = mock(ClusterDistributionManager.class);
    cache = mock(InternalCache.class);
    region = mock(LocalRegion.class);

    when(dm.getCache()).thenReturn(cache);
    when(cache.getRegionByPath(adviseePath)).thenReturn(region);
  }

  @Test
  public void getsRegionFromCacheFromDM() {
    CacheProfile profile = new CacheProfile();
    profile.processIncoming(dm, adviseePath, false, false, null);
    verify(dm, times(1)).getCache();
    verify(cache, times(1)).getRegionByPath(adviseePath);
  }
}
