/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.test.junit.rules;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.junit.rules.ExternalResource;

public class InMemoryDerbyConnectionRule extends ExternalResource
    implements DatabaseConnectionRule {
  private static final String CONNECTION_URL = "jdbc:derby:memory:%s;create=true";

  private final String dbName;

  public InMemoryDerbyConnectionRule(String dbName) {
    this.dbName = dbName;
  }

  @Override
  public Connection getConnection() throws SQLException {
    return DriverManager.getConnection(getConnectionUrl());
  }

  @Override
  public String getConnectionUrl() {
    return String.format(CONNECTION_URL, dbName);
  }
}
