/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.geode.javac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

import sun.tools.java.CompilerError;

public class TestCompiler {
  public byte[] compile(String qualifiedClassName, String testSource) {

    JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    SimpleFileManager fileManager =
        new SimpleFileManager(compiler.getStandardFileManager(null, null, null));

    List<SimpleSourceFile> compilationUnits =
        Collections.singletonList(new SimpleSourceFile(qualifiedClassName, testSource));

    List<String> arguments = new ArrayList<>();
    arguments.addAll(Arrays.asList("-classpath", System.getProperty("java.class.path"),
        "-processor", EnsureCorrectRunsWithProcessor.class.getName()));

    JavaCompiler.CompilationTask task =
        compiler.getTask(null, fileManager, null, arguments, null, compilationUnits);

    if (!task.call()) {
      throw new CompilerError("Compilation errors");
    }

    return fileManager.getCompiled().iterator().next().getCompiledBinaries();
  }
}
