/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Experimental
public class RemoveRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<RegionAPI.RemoveResponse> process(ProtobufSerializationService serializationService, RegionAPI.RemoveRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException {
        String regionName = request.getRegionName();
        Object decodedKey = serializationService.decode(request.getKey());
        if (decodedKey == null) {
            return Failure.of(BasicTypes.ErrorCode.INVALID_REQUEST, "NULL is not a valid key for removal.");
        }
        messageExecutionContext.getAuthorizingCache().remove(regionName, decodedKey);
        return Success.of(RegionAPI.RemoveResponse.newBuilder().build());
    }
}

