/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.HashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingCache;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Experimental
public class PutAllRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse> {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public Result<RegionAPI.PutAllResponse> process(ProtobufSerializationService serializationService, RegionAPI.PutAllRequest putAllRequest, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException {
        String regionName = putAllRequest.getRegionName();
        RegionAPI.PutAllResponse.Builder builder = RegionAPI.PutAllResponse.newBuilder();
        AuthorizingCache cache = messageExecutionContext.getAuthorizingCache();
        HashMap entries = new HashMap(putAllRequest.getEntryList().size());
        putAllRequest.getEntryList().forEach(entry -> entries.put(serializationService.decode(entry.getKey()), serializationService.decode(entry.getValue())));
        cache.putAll(regionName, entries, (key, exception) -> this.addError(builder, serializationService.encode(key), (Exception)exception));
        return Success.of(builder.build());
    }

    private void addError(RegionAPI.PutAllResponse.Builder builder, BasicTypes.EncodedValue key, Exception exception) {
        BasicTypes.ErrorCode errorCode = exception instanceof NotAuthorizedException ? BasicTypes.ErrorCode.AUTHORIZATION_FAILED : (exception instanceof DecodingException ? BasicTypes.ErrorCode.INVALID_REQUEST : BasicTypes.ErrorCode.SERVER_ERROR);
        builder.addFailedKeys(BasicTypes.KeyedError.newBuilder().setKey(key).setError(BasicTypes.Error.newBuilder().setErrorCode(errorCode).setMessage(exception.toString())));
    }
}

