/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.authentication;

import java.util.Set;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.cache.client.internal.locator.ClientConnectionResponse;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.Authorizer;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingLocator;
import org.apache.geode.security.ResourcePermission;

public class AuthorizingLocatorImpl
implements AuthorizingLocator {
    private final Locator locator;
    private final Authorizer authorizer;

    public AuthorizingLocatorImpl(Locator locator, Authorizer authorizer) {
        this.locator = locator;
        this.authorizer = authorizer;
    }

    @Override
    public ServerLocation findServer(Set<ServerLocation> excludedServers, String serverGroup) {
        this.authorizer.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, ResourcePermission.ALL, ResourcePermission.ALL);
        InternalLocator internalLocator = (InternalLocator)this.locator;
        ClientConnectionRequest clientConnectionRequest = new ClientConnectionRequest(excludedServers, serverGroup);
        ClientConnectionResponse connectionResponse = (ClientConnectionResponse)internalLocator.getServerLocatorAdvisee().processRequest((Object)clientConnectionRequest);
        ServerLocation serverLocation = null;
        if (connectionResponse != null && connectionResponse.hasResult()) {
            serverLocation = connectionResponse.getServer();
        }
        return serverLocation;
    }
}

