/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.Properties;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingCache;
import org.apache.geode.internal.protocol.protobuf.v1.authentication.AuthorizingLocator;
import org.apache.geode.internal.protocol.protobuf.v1.state.ConnectionState;
import org.apache.geode.internal.protocol.protobuf.v1.state.RequireVersion;
import org.apache.geode.internal.protocol.serialization.NoOpCustomValueSerializer;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.protocol.serialization.ValueSerializer;

@Experimental
public abstract class MessageExecutionContext {
    protected final ClientStatistics statistics;
    protected final SecurityService securityService;
    protected ConnectionState connectionState;
    public ProtobufSerializationService serializationService = new ProtobufSerializationService(new NoOpCustomValueSerializer());

    public MessageExecutionContext(ClientStatistics statistics, SecurityService securityService) {
        this.securityService = securityService;
        this.statistics = statistics;
        this.connectionState = new RequireVersion(securityService);
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public ProtobufSerializationService getSerializationService() {
        return this.serializationService;
    }

    public abstract AuthorizingCache getAuthorizingCache() throws InvalidExecutionContextException;

    public abstract AuthorizingLocator getAuthorizingLocator() throws InvalidExecutionContextException;

    public ClientStatistics getStatistics() {
        return this.statistics;
    }

    public void setState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    public abstract void authenticate(Properties var1);

    public abstract void setValueSerializer(ValueSerializer var1);
}

