/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.List;
import java.util.Random;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SPopExecutor
extends SetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SPOP command is \"SPOP key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<?, ?> keyRegion = context.getRegionProvider().getRegion(key);
        if (keyRegion == null || keyRegion.isEmpty()) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        Random rand = new Random();
        ByteArrayWrapper[] entries = keyRegion.keySet().toArray(new ByteArrayWrapper[keyRegion.size()]);
        ByteArrayWrapper pop = entries[rand.nextInt(entries.length)];
        keyRegion.remove(pop);
        if (keyRegion.isEmpty()) {
            context.getRegionProvider().removeKey(key);
        }
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), pop.toBytes()));
    }
}

