/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.util.Map;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CommandService;
import org.apache.geode.management.cli.CommandServiceException;
import org.apache.geode.management.cli.CommandStatement;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.remote.CommandStatementImpl;
import org.apache.geode.management.internal.cli.remote.OnlineCommandProcessor;

public class MemberCommandService
extends CommandService {
    private final Object modLock = new Object();
    private InternalCache cache;
    private OnlineCommandProcessor onlineCommandProcessor;

    public MemberCommandService(InternalCache cache) throws CommandServiceException {
        this.cache = cache;
        try {
            this.onlineCommandProcessor = new OnlineCommandProcessor(cache.getDistributedSystem().getProperties(), cache.getSecurityService(), cache);
        }
        catch (Exception e) {
            throw new CommandServiceException("Could not load commands.", e);
        }
    }

    @Override
    public Result processCommand(String commandString) {
        return this.processCommand(commandString, EMPTY_ENV);
    }

    @Override
    public Result processCommand(String commandString, Map<String, String> env) {
        return this.onlineCommandProcessor.executeCommand(commandString, env, null);
    }

    @Override
    @Deprecated
    public CommandStatement createCommandStatement(String commandString) {
        return this.createCommandStatement(commandString, EMPTY_ENV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public CommandStatement createCommandStatement(String commandString, Map<String, String> env) {
        if (!this.isUsable()) {
            throw new IllegalStateException("Cache instance is not available.");
        }
        Object object = this.modLock;
        synchronized (object) {
            return new CommandStatementImpl(commandString, env, this.onlineCommandProcessor);
        }
    }

    @Override
    public boolean isUsable() {
        return this.cache != null && !this.cache.isClosed();
    }
}

