/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.domain.ClassName;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.util.RegionPath;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class RegionAlterFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4846425364943216425L;

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        RegionFunctionArgs regionAlterArgs = (RegionFunctionArgs)context.getArguments();
        try {
            Region<?, ?> alteredRegion = this.alterRegion(cache, regionAlterArgs);
            XmlEntity xmlEntity = new XmlEntity("region", "name", alteredRegion.getName());
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("Region \"{0}\" altered on \"{1}\"", alteredRegion.getFullPath(), memberNameOrId)));
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, e.getMessage()));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error(th.getMessage(), th);
            String exceptionMsg = th.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = ExceptionUtils.getStackTrace((Throwable)th);
            }
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, exceptionMsg));
        }
    }

    private <K, V> Region<?, ?> alterRegion(Cache cache, RegionFunctionArgs regionAlterArgs) {
        ClassName<CacheWriter> className;
        ClassName<CacheLoader> cacheLoader;
        Set<ClassName<CacheListener>> newCacheListeners;
        RegionFunctionArgs.ExpirationAttrs newRegionExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs newRegionExpirationIdleTime;
        ClassName<CustomExpiry> entryTTLCustomExpiry;
        ClassName<CustomExpiry> entryIdleCustomExpiry;
        RegionFunctionArgs.ExpirationAttrs newEntryExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs newEntryExpirationIdleTime;
        String regionPathString = regionAlterArgs.getRegionPath();
        RegionPath regionPath = new RegionPath(regionPathString);
        AbstractRegion region = (AbstractRegion)cache.getRegion(regionPathString);
        if (region == null) {
            throw new IllegalArgumentException(CliStrings.format("Region doesn't exist: {0}", new Object[]{regionPath}));
        }
        AttributesMutator mutator = region.getAttributesMutator();
        if (regionAlterArgs.isCloningEnabled() != null) {
            mutator.setCloningEnabled(regionAlterArgs.isCloningEnabled());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cloning");
            }
        }
        if (regionAlterArgs.getEvictionMax() != null) {
            mutator.getEvictionAttributesMutator().setMaximum(regionAlterArgs.getEvictionMax());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - eviction attributes max");
            }
        }
        if ((newEntryExpirationIdleTime = regionAlterArgs.getEntryExpirationIdleTime()).isTimeOrActionSet()) {
            mutator.setEntryIdleTimeout(newEntryExpirationIdleTime.getExpirationAttributes(region.getEntryIdleTimeout()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - entry idle timeout");
            }
        }
        if ((newEntryExpirationTTL = regionAlterArgs.getEntryExpirationTTL()).isTimeOrActionSet()) {
            mutator.setEntryTimeToLive(newEntryExpirationTTL.getExpirationAttributes(region.getEntryTimeToLive()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - entry TTL");
            }
        }
        if ((entryIdleCustomExpiry = regionAlterArgs.getEntryIdleTimeCustomExpiry()) != null) {
            if (entryIdleCustomExpiry.equals(ClassName.EMPTY)) {
                mutator.setCustomEntryIdleTimeout(null);
            } else {
                mutator.setCustomEntryIdleTimeout(entryIdleCustomExpiry.newInstance(cache));
            }
        }
        if ((entryTTLCustomExpiry = regionAlterArgs.getEntryTTLCustomExpiry()) != null) {
            if (entryTTLCustomExpiry.equals(ClassName.EMPTY)) {
                mutator.setCustomEntryTimeToLive(null);
            } else {
                mutator.setCustomEntryTimeToLive(entryTTLCustomExpiry.newInstance(cache));
            }
        }
        if ((newRegionExpirationIdleTime = regionAlterArgs.getRegionExpirationIdleTime()).isTimeOrActionSet()) {
            mutator.setRegionIdleTimeout(newRegionExpirationIdleTime.getExpirationAttributes(region.getRegionIdleTimeout()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - region idle timeout");
            }
        }
        if ((newRegionExpirationTTL = regionAlterArgs.getRegionExpirationTTL()).isTimeOrActionSet()) {
            mutator.setRegionTimeToLive(newRegionExpirationTTL.getExpirationAttributes(region.getRegionTimeToLive()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - region TTL");
            }
        }
        Set<String> newGatewaySenderIds = regionAlterArgs.getGatewaySenderIds();
        Set<String> newAsyncEventQueueIds = regionAlterArgs.getAsyncEventQueueIds();
        if (region instanceof PartitionedRegion) {
            HashSet<String> senderIds = new HashSet<String>();
            if (newGatewaySenderIds != null) {
                this.validateParallelGatewaySenderIDs((PartitionedRegion)region, newGatewaySenderIds);
                senderIds.addAll(newGatewaySenderIds);
            } else if (region.getGatewaySenderIds() != null) {
                senderIds.addAll(region.getAllGatewaySenderIds());
            }
            if (newAsyncEventQueueIds != null) {
                this.validateParallelGatewaySenderIDs((PartitionedRegion)region, newAsyncEventQueueIds);
                senderIds.addAll(newAsyncEventQueueIds);
            } else if (region.getAsyncEventQueueIds() != null) {
                senderIds.addAll(region.getAsyncEventQueueIds());
            }
            ((PartitionedRegion)region).updatePRConfigWithNewSetOfGatewaySenders(senderIds);
        }
        if (newGatewaySenderIds != null) {
            Set<String> oldGatewaySenderIds = region.getGatewaySenderIds();
            if (!oldGatewaySenderIds.isEmpty()) {
                for (String string : oldGatewaySenderIds) {
                    if (newGatewaySenderIds.contains(string)) continue;
                    mutator.removeGatewaySenderId(string);
                }
            }
            for (String string : newGatewaySenderIds) {
                if (oldGatewaySenderIds.contains(string)) continue;
                mutator.addGatewaySenderId(string);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - gateway sender IDs");
            }
        }
        if (newAsyncEventQueueIds != null) {
            Set<String> oldAsyncEventQueueIds = region.getAsyncEventQueueIds();
            if (!oldAsyncEventQueueIds.isEmpty()) {
                for (String string : oldAsyncEventQueueIds) {
                    if (newAsyncEventQueueIds.contains(string)) continue;
                    mutator.removeAsyncEventQueueId(string);
                }
            }
            for (String string : newAsyncEventQueueIds) {
                if (oldAsyncEventQueueIds.contains(string)) continue;
                mutator.addAsyncEventQueueId(string);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - async event queue IDs");
            }
        }
        if ((newCacheListeners = regionAlterArgs.getCacheListeners()) != null) {
            CacheListener[] oldCacheListeners;
            for (CacheListener oldCacheListener : oldCacheListeners = region.getCacheListeners()) {
                mutator.removeCacheListener(oldCacheListener);
            }
            for (ClassName<CacheListener> className2 : newCacheListeners) {
                if (className2.equals(ClassName.EMPTY)) continue;
                mutator.addCacheListener(className2.newInstance(cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache listeners");
            }
        }
        if ((cacheLoader = regionAlterArgs.getCacheLoader()) != null) {
            if (cacheLoader.equals(ClassName.EMPTY)) {
                mutator.setCacheLoader(null);
            } else {
                mutator.setCacheLoader(cacheLoader.newInstance(cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache loader");
            }
        }
        if ((className = regionAlterArgs.getCacheWriter()) != null) {
            if (className.equals(ClassName.EMPTY)) {
                mutator.setCacheWriter(null);
            } else {
                mutator.setCacheWriter(className.newInstance(cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache writer");
            }
        }
        return region;
    }

    private void validateParallelGatewaySenderIDs(PartitionedRegion region, Set<String> newGatewaySenderIds) {
        try {
            Set<String> parallelSenders = region.filterOutNonParallelGatewaySenders(newGatewaySenderIds);
            region.validateParallelGatewaySenderIds(parallelSenders);
        }
        catch (PRLocallyDestroyedException e) {
            throw new IllegalStateException("Partitioned Region not found registered", e);
        }
    }

    private static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    private static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    @Override
    public String getId() {
        return RegionAlterFunction.class.getName();
    }
}

