/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.Context;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;

public class ListJndiBindingFunction
implements InternalFunction {
    private static final long serialVersionUID = 5254506785395069200L;

    @Override
    public void execute(FunctionContext context) {
        CliFunctionResult result;
        try {
            Context ctx = JNDIInvoker.getJNDIContext();
            Map<String, String> bindings = JNDIInvoker.getBindingNamesRecursively(ctx);
            List<Serializable> resultValues = bindings.entrySet().stream().flatMap(e -> Arrays.stream(new String[]{(String)e.getKey(), (String)e.getValue()})).collect(Collectors.toList());
            result = new CliFunctionResult(context.getMemberName(), resultValues.toArray(new Serializable[0]));
        }
        catch (Exception e2) {
            result = new CliFunctionResult(context.getMemberName(), e2, "Unable to retrieve JNDI bindings");
        }
        ResultSender sender = context.getResultSender();
        sender.lastResult(result);
    }
}

