/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class GatewaySenderDestroyFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;
    private static final String ID = GatewaySenderDestroyFunction.class.getName();
    public static GatewaySenderDestroyFunction INSTANCE = new GatewaySenderDestroyFunction();

    @Override
    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = (GatewaySenderDestroyFunctionArgs)context.getArguments();
        String senderId = gatewaySenderDestroyFunctionArgs.getId();
        boolean ifExists = gatewaySenderDestroyFunctionArgs.isIfExists();
        GatewaySender gatewaySender = cache.getGatewaySender(senderId);
        if (gatewaySender == null) {
            String message = "Gateway sender " + senderId + " not found.";
            if (ifExists) {
                resultSender.lastResult(new CliFunctionResult(memberNameOrId, true, "Skipping: " + message));
            } else {
                resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, message));
            }
            return;
        }
        try {
            gatewaySender.stop();
            gatewaySender.destroy();
            XmlEntity xmlEntity = new XmlEntity("gateway-sender", "id", senderId);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, String.format("GatewaySender \"%s\" destroyed on \"%s\"", senderId, memberNameOrId)));
        }
        catch (Exception e) {
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, e, ""));
        }
    }

    @Override
    public String getId() {
        return ID;
    }
}

