/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class AlterRuntimeConfigFunction
implements InternalFunction {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LogService.getLogger();

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object arg = context.getArguments();
            InternalCache cache = (InternalCache)context.getCache();
            DistributionConfig config = cache.getInternalDistributedSystem().getConfig();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            Map runtimeAttributes = (Map)arg;
            Set entries = runtimeAttributes.entrySet();
            for (Map.Entry entry : entries) {
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                if (attributeName.equals("copy-on-read")) {
                    cache.setCopyOnRead(Boolean.parseBoolean(attributeValue));
                    continue;
                }
                if (attributeName.equals("lock-lease")) {
                    cache.setLockLease(Integer.parseInt(attributeValue));
                    continue;
                }
                if (attributeName.equals("lock-timeout")) {
                    int lockTimeout = Integer.parseInt(attributeValue);
                    cache.setLockTimeout(lockTimeout);
                    continue;
                }
                if (attributeName.equals("search-timeout")) {
                    cache.setSearchTimeout(Integer.parseInt(attributeValue));
                    continue;
                }
                if (attributeName.equals("message-sync-interval")) {
                    cache.setMessageSyncInterval(Integer.parseInt(attributeValue));
                    continue;
                }
                config.setAttribute(attributeName, attributeValue, ConfigSource.runtime());
            }
            CliFunctionResult cliFuncResult = new CliFunctionResult(memberId, true, null);
            context.getResultSender().lastResult(cliFuncResult);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (Exception e) {
            logger.error("Exception happened on : " + memberId, (Throwable)e);
            CliFunctionResult cliFuncResult = new CliFunctionResult(memberId, e, ExceptionUtils.getStackTrace((Throwable)e));
            context.getResultSender().lastResult(cliFuncResult);
        }
    }

    @Override
    public String getId() {
        return AlterRuntimeConfigFunction.class.getName();
    }
}

