/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.util.JsonUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class DataCommandResult
implements Serializable {
    private static Logger logger = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private String command;
    private Object putResult;
    private Object getResult;
    private List<SelectResultRow> selectResult;
    private String queryTraceString;
    public static final String RESULT_FLAG = "Result";
    public static final String NUM_ROWS = "Rows";
    public static final String MISSING_VALUE = "<NULL>";
    private List<KeyInfo> locateEntryLocations;
    private KeyInfo locateEntryResult;
    private boolean hasResultForAggregation;
    private Object removeResult;
    private Object inputKey;
    private Object inputValue;
    private Object inputQuery;
    private Throwable error;
    private String errorString;
    private String infoString;
    private String keyClass;
    private String valueClass;
    private int limit;
    private boolean operationCompletedSuccessfully;
    public static final String NEW_LINE = GfshParser.LINE_SEPARATOR;
    public static final int ROW_TYPE_STRUCT_RESULT = 100;
    public static final int ROW_TYPE_BEAN = 200;
    public static final int ROW_TYPE_PRIMITIVE = 300;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isGet()) {
            sb.append(" Type  : Get").append(NEW_LINE);
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.getResult != null) {
                sb.append(" ReturnValue Class : ").append(this.getResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue : ").append(this.getResult).append(NEW_LINE);
        } else if (this.isPut()) {
            sb.append(" Type  : Put");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.putResult != null) {
                sb.append(" ReturnValue Class : ").append(this.putResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue  : ").append(this.putResult).append(NEW_LINE);
            sb.append(" Value  : ").append(this.inputValue).append(NEW_LINE);
        } else if (this.isRemove()) {
            sb.append(" Type  : Remove");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.removeResult != null) {
                sb.append(" ReturnValue Class : ").append(this.removeResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue  : ").append(this.removeResult).append(NEW_LINE);
        } else if (this.isLocateEntry()) {
            sb.append(" Type  : Locate Entry");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            sb.append(" Results  : ").append(this.locateEntryResult).append(NEW_LINE);
            sb.append(" Locations  : ").append(this.locateEntryLocations).append(NEW_LINE);
        }
        if (this.errorString != null) {
            sb.append(" ERROR ").append(this.errorString);
        }
        return sb.toString();
    }

    public boolean isGet() {
        return "get".equals(this.command);
    }

    public boolean isPut() {
        return "put".equals(this.command);
    }

    public boolean isRemove() {
        return "remove".equals(this.command);
    }

    public boolean isLocateEntry() {
        return "locate entry".equals(this.command);
    }

    public boolean isSelect() {
        return "query".equals(this.command);
    }

    public List<SelectResultRow> getSelectResult() {
        return this.selectResult;
    }

    public static DataCommandResult createGetResult(Object inputKey, Object value, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "get";
        result.inputKey = inputKey;
        result.getResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createGetInfoResult(Object inputKey, Object value, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "get";
        result.inputKey = inputKey;
        result.getResult = value;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createLocateEntryResult(Object inputKey, KeyInfo locationResult, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "locate entry";
        result.inputKey = inputKey;
        if (flag) {
            result.hasResultForAggregation = true;
        }
        result.locateEntryResult = locationResult;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createLocateEntryInfoResult(Object inputKey, KeyInfo locationResult, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "locate entry";
        result.inputKey = inputKey;
        if (flag) {
            result.hasResultForAggregation = true;
        }
        result.locateEntryResult = locationResult;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createPutResult(Object inputKey, Object value, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "put";
        result.inputKey = inputKey;
        result.putResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createPutInfoResult(Object inputKey, Object value, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "put";
        result.inputKey = inputKey;
        result.putResult = value;
        result.error = error;
        result.infoString = infoString;
        return result;
    }

    public static DataCommandResult createRemoveResult(Object inputKey, Object value, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "remove";
        result.inputKey = inputKey;
        result.removeResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createRemoveInfoResult(Object inputKey, Object value, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "remove";
        result.inputKey = inputKey;
        result.removeResult = value;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createSelectResult(Object inputQuery, List<SelectResultRow> value, String queryTraceString, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "query";
        result.inputQuery = inputQuery;
        result.queryTraceString = queryTraceString;
        result.selectResult = value;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createSelectInfoResult(Object inputQuery, List<SelectResultRow> value, int limit, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "query";
        result.inputQuery = inputQuery;
        result.limit = limit;
        result.selectResult = value;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Object getPutResult() {
        return this.putResult;
    }

    public void setPutResult(Object putResult) {
        this.putResult = putResult;
    }

    public Object getGetResult() {
        return this.getResult;
    }

    public void setGetResult(Object getResult) {
        this.getResult = getResult;
    }

    public Object getRemoveResult() {
        return this.removeResult;
    }

    public void setRemoveResult(Object removeResult) {
        this.removeResult = removeResult;
    }

    public Object getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(Object inputKey) {
        this.inputKey = inputKey;
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(Object inputValue) {
        this.inputValue = inputValue;
    }

    public Throwable getErorr() {
        return this.error;
    }

    public void setErorr(Throwable erorr) {
        this.error = erorr;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public String getInfoString() {
        return this.infoString;
    }

    public void setInfoString(String infoString) {
        this.infoString = infoString;
    }

    public String getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(String keyClass) {
        this.keyClass = keyClass;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
    }

    public List<KeyInfo> getLocateEntryLocations() {
        return this.locateEntryLocations;
    }

    public void setLocateEntryLocations(List<KeyInfo> locateEntryLocations) {
        this.locateEntryLocations = locateEntryLocations;
    }

    public Result toCommandResult() {
        if (StringUtils.isEmpty((String)this.keyClass)) {
            this.keyClass = "java.lang.String";
        }
        if (StringUtils.isEmpty((String)this.valueClass)) {
            this.valueClass = "java.lang.String";
        }
        if (this.errorString != null) {
            CompositeResultData data = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = data.addSection();
            section.addData("Message", this.errorString);
            section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
            return ResultBuilder.buildResult(data);
        }
        CompositeResultData data = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = data.addSection();
        TabularResultData table = section.addTable();
        section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
        if (this.infoString != null) {
            section.addData("Message", this.infoString);
        }
        if (this.isGet()) {
            this.toCommandResult_isGet(section, table);
        } else if (this.isLocateEntry()) {
            this.toCommandResult_isLocate(section, table);
        } else if (this.isPut()) {
            this.toCommandResult_isPut(section, table);
        } else if (this.isRemove()) {
            this.toCommandResult_isRemove(section, table);
        }
        return ResultBuilder.buildResult(data);
    }

    private void toCommandResult_isGet(CompositeResultData.SectionResultData section, TabularResultData table) {
        section.addData("Key Class", this.getKeyClass());
        if (!this.isDeclaredPrimitive(this.keyClass)) {
            this.addJSONStringToTable(table, this.inputKey);
        } else {
            section.addData("Key", this.inputKey);
        }
        section.addData("Value Class", this.getValueClass());
        if (!this.isDeclaredPrimitive(this.valueClass)) {
            this.addJSONStringToTable(table, this.getResult);
        } else {
            section.addData("Value", this.getResult);
        }
    }

    private void toCommandResult_isLocate(CompositeResultData.SectionResultData section, TabularResultData table) {
        section.addData("Key Class", this.getKeyClass());
        if (!this.isDeclaredPrimitive(this.keyClass)) {
            this.addJSONStringToTable(table, this.inputKey);
        } else {
            section.addData("Key", this.inputKey);
        }
        if (this.locateEntryLocations != null) {
            TabularResultData locationTable = section.addTable();
            int totalLocations = 0;
            for (KeyInfo info : this.locateEntryLocations) {
                List<Object[]> locations = info.getLocations();
                if (locations == null) continue;
                if (locations.size() == 1) {
                    Object[] array = locations.get(0);
                    boolean found = (Boolean)array[1];
                    if (!found) continue;
                    ++totalLocations;
                    boolean primary = (Boolean)array[3];
                    String bucketId = (String)array[4];
                    locationTable.accumulate("MemberName", info.getMemberName());
                    locationTable.accumulate("MemberId", info.getMemberId());
                    if (bucketId == null) continue;
                    if (primary) {
                        locationTable.accumulate("Primary", "*Primary PR*");
                    } else {
                        locationTable.accumulate("Primary", "No");
                    }
                    locationTable.accumulate("BucketId", bucketId);
                    continue;
                }
                for (Object[] array : locations) {
                    String regionPath = (String)array[0];
                    boolean found = (Boolean)array[1];
                    if (!found) continue;
                    ++totalLocations;
                    boolean primary = (Boolean)array[3];
                    String bucketId = (String)array[4];
                    locationTable.accumulate("MemberName", info.getMemberName());
                    locationTable.accumulate("MemberId", info.getMemberId());
                    locationTable.accumulate("RegionPath", regionPath);
                    if (bucketId == null) continue;
                    if (primary) {
                        locationTable.accumulate("Primary", "*Primary PR*");
                    } else {
                        locationTable.accumulate("Primary", "No");
                    }
                    locationTable.accumulate("BucketId", bucketId);
                }
            }
            section.addData("Locations Found", totalLocations);
        } else {
            section.addData("Location Info ", "Could not find location information");
        }
    }

    private void toCommandResult_isPut(CompositeResultData.SectionResultData section, TabularResultData table) {
        section.addData("Key Class", this.getKeyClass());
        if (!this.isDeclaredPrimitive(this.keyClass)) {
            this.addJSONStringToTable(table, this.inputKey);
        } else {
            section.addData("Key", this.inputKey);
        }
        section.addData("Value Class", this.getValueClass());
        if (!this.isDeclaredPrimitive(this.valueClass)) {
            this.addJSONStringToTable(table, this.putResult);
        } else {
            section.addData("Old Value", this.putResult);
        }
    }

    private void toCommandResult_isRemove(CompositeResultData.SectionResultData section, TabularResultData table) {
        if (this.inputKey != null) {
            section.addData("Key Class", this.getKeyClass());
            if (!this.isDeclaredPrimitive(this.keyClass)) {
                this.addJSONStringToTable(table, this.inputKey);
            } else {
                section.addData("Key", this.inputKey);
            }
        }
    }

    public CompositeResultData toSelectCommandResult() {
        if (this.errorString != null) {
            CompositeResultData data = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = data.addSection();
            section.addData("Message", this.errorString);
            section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
            return data;
        }
        CompositeResultData data = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = data.addSection();
        TabularResultData table = section.addTable();
        section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
        if (this.infoString != null) {
            section.addData("Message", this.infoString);
        }
        if (this.inputQuery != null) {
            if (this.limit > 0) {
                section.addData("Limit", this.limit);
            }
            if (this.selectResult != null) {
                section.addData(NUM_ROWS, this.selectResult.size());
                if (this.queryTraceString != null) {
                    section.addData("Query Trace", this.queryTraceString);
                }
                this.buildTable(table, 0, this.selectResult.size());
            }
        }
        return data;
    }

    private int buildTable(TabularResultData table, int startCount, int endCount) {
        int lastRowExclusive = Math.min(this.selectResult.size(), endCount + 1);
        List<SelectResultRow> paginatedRows = this.selectResult.subList(startCount, lastRowExclusive);
        ArrayList<GfJsonObject> tableRows = new ArrayList<GfJsonObject>();
        ArrayList<GfJsonObject> rowsWithRealJsonObjects = new ArrayList<GfJsonObject>();
        HashSet columns = new HashSet();
        for (SelectResultRow row : paginatedRows) {
            GfJsonObject object = new GfJsonObject();
            try {
                if (row.value == null || MISSING_VALUE.equals(row.value)) {
                    object.put("Value", MISSING_VALUE);
                } else if (row.type == 300) {
                    object.put(RESULT_FLAG, row.value);
                } else {
                    object = this.buildGfJsonFromRawObject(row.value);
                    rowsWithRealJsonObjects.add(object);
                    object.keys().forEachRemaining(columns::add);
                }
                tableRows.add(object);
            }
            catch (GfJsonException e) {
                JSONObject errJson = new JSONObject().put("Value", (Object)("Error getting bean properties " + e.getMessage()));
                tableRows.add(new GfJsonObject(errJson, false));
            }
        }
        for (GfJsonObject tableRow : rowsWithRealJsonObjects) {
            for (String key : columns) {
                if (tableRow.has(key)) continue;
                try {
                    tableRow.put(key, MISSING_VALUE);
                }
                catch (GfJsonException e) {
                    logger.warn("Ignored GfJsonException:", (Throwable)e);
                }
            }
        }
        for (GfJsonObject jsonObject : tableRows) {
            this.addJSONObjectToTable(table, jsonObject);
        }
        return paginatedRows.size();
    }

    private boolean isDeclaredPrimitive(String keyClass2) {
        try {
            Class<?> klass = ClassPathLoader.getLatest().forName(keyClass2);
            return JsonUtil.isPrimitiveOrWrapper(klass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Object getDomainValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (str.contains("{") && str.contains("}")) {
                try {
                    JSONObject json = new JSONObject(str);
                    return json.get("type-class");
                }
                catch (Exception e) {
                    return str;
                }
            }
            return str;
        }
        return value;
    }

    public Object getInputQuery() {
        return this.inputQuery;
    }

    public void setInputQuery(Object inputQuery) {
        this.inputQuery = inputQuery;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void aggregate(DataCommandResult result) {
        if (!this.isLocateEntry()) {
            return;
        }
        if (this.locateEntryLocations == null) {
            this.locateEntryLocations = new ArrayList<KeyInfo>();
        }
        if (result == null) {
            if (this.locateEntryResult != null) {
                this.locateEntryLocations.add(this.locateEntryResult);
            }
            return;
        }
        if (result.errorString != null && !result.errorString.equals(this.errorString)) {
            this.errorString = result.errorString + " " + this.errorString;
        }
        if (!this.operationCompletedSuccessfully && result.infoString != null && !result.infoString.equals(this.infoString)) {
            this.infoString = result.infoString;
        }
        if (result.hasResultForAggregation) {
            this.operationCompletedSuccessfully = true;
            this.infoString = result.infoString;
            if (result.locateEntryResult != null) {
                this.locateEntryLocations.add(result.locateEntryResult);
            }
        }
    }

    private void addJSONObjectToTable(TabularResultData table, GfJsonObject object) {
        Iterator<String> keys = object.keys();
        while (keys.hasNext()) {
            Object value;
            String k = keys.next();
            if ("type-class".equals(k) || (value = object.get(k)) == null) continue;
            table.accumulate(k, this.getDomainValue(value));
        }
    }

    private GfJsonObject buildGfJsonFromRawObject(Object object) throws GfJsonException {
        GfJsonObject jsonObject = String.class.equals(object.getClass()) ? new GfJsonObject(this.sanitizeJsonString((String)object)) : new GfJsonObject(object, true);
        return jsonObject;
    }

    private String sanitizeJsonString(String s) {
        String newString = s.replaceAll("'", "\"");
        if (newString.charAt(0) == '(') {
            int len = newString.length();
            newString = "{" + newString.substring(1, len - 1) + "}";
        }
        return newString;
    }

    private void addJSONStringToTable(TabularResultData table, Object object) {
        if (object == null || MISSING_VALUE.equals(object)) {
            table.accumulate("Value", MISSING_VALUE);
        } else {
            try {
                GfJsonObject jsonObject = this.buildGfJsonFromRawObject(object);
                this.addJSONObjectToTable(table, jsonObject);
            }
            catch (Exception e) {
                table.accumulate("Value", "Error getting bean properties " + e.getMessage());
            }
        }
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.command, out);
        out.writeUTF(this.command);
        DataSerializer.writeObject(this.putResult, out);
        DataSerializer.writeObject(this.getResult, out);
        DataSerializer.writeObject(this.locateEntryResult, out);
        DataSerializer.writeArrayList((ArrayList)this.locateEntryLocations, out);
        DataSerializer.writeBoolean(this.hasResultForAggregation, out);
        DataSerializer.writeObject(this.removeResult, out);
        DataSerializer.writeObject(this.inputKey, out);
        DataSerializer.writeObject(this.inputValue, out);
        DataSerializer.writeObject(this.error, out);
        DataSerializer.writeString(this.errorString, out);
        DataSerializer.writeString(this.infoString, out);
        DataSerializer.writeString(this.keyClass, out);
        DataSerializer.writeString(this.valueClass, out);
        DataSerializer.writeBoolean(this.operationCompletedSuccessfully, out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.command = DataSerializer.readString(in);
        this.putResult = DataSerializer.readObject(in);
        this.getResult = DataSerializer.readObject(in);
        this.locateEntryLocations = DataSerializer.readArrayList(in);
        this.locateEntryResult = (KeyInfo)DataSerializer.readObject(in);
        this.hasResultForAggregation = DataSerializer.readBoolean(in);
        this.removeResult = DataSerializer.readObject(in);
        this.inputKey = DataSerializer.readObject(in);
        this.inputValue = DataSerializer.readObject(in);
        this.error = (Throwable)DataSerializer.readObject(in);
        this.errorString = DataSerializer.readString(in);
        this.infoString = DataSerializer.readString(in);
        this.keyClass = DataSerializer.readString(in);
        this.valueClass = DataSerializer.readString(in);
        this.operationCompletedSuccessfully = DataSerializer.readBoolean(in);
    }

    public static class SelectResultRow
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int type;
        private Object value;

        public SelectResultRow(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class KeyInfo
    implements Serializable {
        private String memberId;
        private String memberName;
        private String host;
        private int pid;
        private ArrayList<Object[]> locations = null;

        public void addLocation(Object[] locationArray) {
            if (this.locations == null) {
                this.locations = new ArrayList();
            }
            this.locations.add(locationArray);
        }

        public List<Object[]> getLocations() {
            return this.locations;
        }

        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPid() {
            return this.pid;
        }

        public void setPid(int pid) {
            this.pid = pid;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ Member : ").append(this.host).append("(").append(this.memberId).append(") , ");
            for (Object[] array : this.locations) {
                boolean primary = (Boolean)array[3];
                String bucketId = (String)array[4];
                sb.append(" [ Primary : ").append(primary).append(" , BucketId : ").append(bucketId).append(" ]");
            }
            sb.append(" }");
            return sb.toString();
        }

        public boolean hasLocation() {
            if (this.locations == null) {
                return false;
            }
            for (Object[] array : this.locations) {
                boolean found = (Boolean)array[1];
                if (!found) continue;
                return true;
            }
            return false;
        }

        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeString(this.memberId, out);
            DataSerializer.writeString(this.memberName, out);
            DataSerializer.writeString(this.host, out);
            DataSerializer.writePrimitiveInt(this.pid, out);
            DataSerializer.writeArrayList(this.locations, out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.memberId = DataSerializer.readString(in);
            this.memberName = DataSerializer.readString(in);
            this.host = DataSerializer.readString(in);
            this.pid = DataSerializer.readPrimitiveInt(in);
            this.locations = DataSerializer.readArrayList(in);
        }
    }
}

