/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.apache.geode.internal.ClassPathLoader;

public class ClassName<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String className = "";
    private Properties initProperties = new Properties();
    private static ObjectMapper mapper = new ObjectMapper();
    public static ClassName EMPTY;

    public ClassName(String className) {
        this(className, "{}");
    }

    public ClassName(String className, String jsonInitProperties) {
        if (StringUtils.isBlank((String)className)) {
            return;
        }
        if (!ClassName.isClassNameValid(className)) {
            throw new IllegalArgumentException("Invalid className");
        }
        this.className = className;
        try {
            this.initProperties = (Properties)mapper.readValue(jsonInitProperties, Properties.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON: " + jsonInitProperties, e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getInitProperties() {
        return this.initProperties;
    }

    public static boolean isClassNameValid(String fqcn) {
        if (StringUtils.isBlank((String)fqcn)) {
            return false;
        }
        String regex = "([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*";
        return Pattern.matches(regex, fqcn);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClassName)) {
            return false;
        }
        ClassName that = (ClassName)o;
        return this.className.equals(that.getClassName()) && this.getInitProperties().equals(that.getInitProperties());
    }

    public T newInstance(Cache cache) {
        try {
            Class<?> loadedClass = ClassPathLoader.getLatest().forName(this.className);
            Object object = loadedClass.newInstance();
            if (object instanceof Declarable) {
                Declarable declarable = (Declarable)object;
                declarable.initialize(cache, this.initProperties);
                declarable.init(this.initProperties);
            }
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating class: <" + this.className + ">", e);
        }
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        EMPTY = new ClassName("");
    }
}

