/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.DiskStoreValidater;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ValidateDiskStoreCommand
extends InternalGfshCommand {
    @CliCommand(value={"validate offline-disk-store"}, help="Scan the contents of a disk store to verify that it has no errors.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result validateDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the disk store to be validated.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories where data for the disk store was previously written.") String[] diskDirs, @CliOption(key={"J"}, help="Arguments passed to the Java Virtual Machine performing the compact operation on the disk store.") String[] jvmProps) {
        try {
            String line;
            String opts;
            StringBuilder dirList = new StringBuilder();
            for (String diskDir : diskDirs) {
                dirList.append(diskDir);
                dirList.append(";");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            DiskStoreCommandsUtils.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                commandList.addAll(Arrays.asList(jvmProps));
            }
            if ((opts = System.getenv("JAVA_OPTS")) != null) {
                commandList.add(opts);
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreValidater.class.getName());
            commandList.add(diskStoreName);
            commandList.add(dirList.toString());
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            StringBuilder output = new StringBuilder();
            String errorString = "";
            Process validateDiskStoreProcess = procBuilder.redirectErrorStream(true).start();
            InputStream inputStream = validateDiskStoreProcess.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = br.readLine()) != null) {
                output.append(line).append(GfshParser.LINE_SEPARATOR);
            }
            validateDiskStoreProcess.destroy();
            output.append(errorString).append(GfshParser.LINE_SEPARATOR);
            String resultString = "Validating " + diskStoreName + GfshParser.LINE_SEPARATOR + output.toString();
            return ResultBuilder.createInfoResult(resultString);
        }
        catch (IOException ex) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Input/Output error in validating disk store {0} is : {1}", diskStoreName, ex.getMessage()));
        }
        catch (Exception ex) {
            return ResultBuilder.createGemFireErrorResult(CliStrings.format("Error in validating disk store {0} is : {1}", diskStoreName, ex.getMessage()));
        }
    }
}

