/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.commands.GatewayCommandsUtils;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ResumeGatewaySenderCommand
extends InternalGfshCommand {
    @CliCommand(value={"resume gateway-sender"}, help="Resume the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result resumeGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to resume the Gateway Sender.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to resume the Gateway Sender.") String[] onMember) {
        if (senderId != null) {
            senderId = senderId.trim();
        }
        Cache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)this.getManagementService();
        TabularResultData resultData = ResultBuilder.createTabularResultData();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        for (DistributedMember member : dsMembers) {
            GatewaySenderMXBean bean;
            if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                bean = service.getLocalGatewaySenderMXBean(senderId);
            } else {
                ObjectName objectName = service.getGatewaySenderMBeanName(member, senderId);
                bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
            }
            if (bean != null) {
                if (bean.isRunning()) {
                    if (bean.isPaused()) {
                        bean.resume();
                        GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "OK", CliStrings.format("GatewaySender {0} is resumed on member {1}", senderId, member.getId()));
                        continue;
                    }
                    GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not paused on member {1}", senderId, member.getId()));
                    continue;
                }
                GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not running on member {1}.", senderId, member.getId()));
                continue;
            }
            GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("GatewaySender {0} is not available on member {1}", senderId, member.getId()));
        }
        CommandResult result = ResultBuilder.buildResult(resultData);
        return result;
    }
}

