/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexDetails;
import org.apache.geode.management.internal.cli.functions.ListIndexFunction;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListIndexCommand
extends InternalGfshCommand {
    @CliCommand(value={"list indexes"}, help="Display the list of indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ, target=ResourcePermission.Target.QUERY)
    public Result listIndex(@CliOption(key={"with-stats"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether statistics should also be displayed.") boolean showStats) {
        return this.toTabularResult(this.getIndexListing(), showStats);
    }

    private Result toTabularResult(List<IndexDetails> indexDetailsList, boolean showStats) {
        if (!indexDetailsList.isEmpty()) {
            TabularResultData indexData = ResultBuilder.createTabularResultData();
            for (IndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Member Name", StringUtils.defaultString((String)indexDetails.getMemberName()));
                indexData.accumulate("Member ID", indexDetails.getMemberId());
                indexData.accumulate("Region Path", indexDetails.getRegionPath());
                indexData.accumulate("Name", indexDetails.getIndexName());
                if (indexDetails.getIndexType() == null) {
                    indexData.accumulate("Type", "");
                } else {
                    indexData.accumulate("Type", indexDetails.getIndexType().getName());
                }
                indexData.accumulate("Indexed Expression", indexDetails.getIndexedExpression());
                indexData.accumulate("From Clause", indexDetails.getFromClause());
                indexData.accumulate("Valid Index", indexDetails.getIsValid());
                if (!showStats) continue;
                IndexStatisticsDetailsAdapter adapter = new IndexStatisticsDetailsAdapter(indexDetails.getIndexStatisticsDetails());
                indexData.accumulate("Uses", adapter.getTotalUses());
                indexData.accumulate("Updates", adapter.getNumberOfUpdates());
                indexData.accumulate("Update Time", adapter.getTotalUpdateTime());
                indexData.accumulate("Keys", adapter.getNumberOfKeys());
                indexData.accumulate("Values", adapter.getNumberOfValues());
            }
            return ResultBuilder.buildResult(indexData);
        }
        return ResultBuilder.createInfoResult("No Indexes Found");
    }

    List<IndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getAllMembers());
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute(new ListIndexFunction());
        List results = (List)resultsCollector.getResult();
        ArrayList<IndexDetails> indexDetailsList = new ArrayList<IndexDetails>(results.size());
        for (Object result : results) {
            if (!(result instanceof Set)) continue;
            indexDetailsList.addAll((Set)result);
        }
        Collections.sort(indexDetailsList);
        return indexDetailsList;
    }

    protected static class IndexStatisticsDetailsAdapter {
        private final IndexDetails.IndexStatisticsDetails indexStatisticsDetails;

        protected IndexStatisticsDetailsAdapter(IndexDetails.IndexStatisticsDetails indexStatisticsDetails) {
            this.indexStatisticsDetails = indexStatisticsDetails;
        }

        public IndexDetails.IndexStatisticsDetails getIndexStatisticsDetails() {
            return this.indexStatisticsDetails;
        }

        public String getNumberOfKeys() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getNumberOfKeys()) : "";
        }

        public String getNumberOfUpdates() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getNumberOfUpdates()) : "";
        }

        public String getNumberOfValues() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getNumberOfValues()) : "";
        }

        public String getTotalUpdateTime() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getTotalUpdateTime()) : "";
        }

        public String getTotalUses() {
            return this.getIndexStatisticsDetails() != null ? StringUtils.defaultString(this.getIndexStatisticsDetails().getTotalUses()) : "";
        }
    }
}

