/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.DurableClientCommandsResultBuilder;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.domain.DurableCqNamesResult;
import org.apache.geode.management.internal.cli.functions.ListDurableCqNamesFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListDurableClientCQsCommand
extends InternalGfshCommand {
    DurableClientCommandsResultBuilder builder = new DurableClientCommandsResultBuilder();

    @CliCommand(value={"list durable-cqs"}, help="List durable client cqs associated with the specified durable client id.")
    @CliMetaData
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listDurableClientCQs(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client") String durableClientId, @CliOption(key={"member", "members"}, help="Name/Id of the member for which the durable client is registered and durable cqs will be displayed.", optionContext="geode.converter.member.idOrName:disable-string-converter") String[] memberNameOrId, @CliOption(key={"group", "groups"}, help="Group of members for which the durable client is registered and durable cqs will be displayed.", optionContext="geode.converter.member.groups:disable-string-converter") String[] group) {
        CommandResult result;
        try {
            boolean noResults = true;
            Set<DistributedMember> targetMembers = this.findMembers(group, memberNameOrId);
            if (targetMembers.isEmpty()) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction(new ListDurableCqNamesFunction(), durableClientId, targetMembers);
            List results = (List)rc.getResult();
            TreeMap<String, List<String>> memberCqNamesMap = new TreeMap<String, List<String>>();
            HashMap<String, List<String>> errorMessageNodes = new HashMap<String, List<String>>();
            HashMap<String, List<String>> exceptionMessageNodes = new HashMap<String, List<String>>();
            for (DurableCqNamesResult memberResult : results) {
                if (memberResult == null) continue;
                if (memberResult.isSuccessful()) {
                    memberCqNamesMap.put(memberResult.getMemberNameOrId(), memberResult.getCqNamesList());
                    continue;
                }
                if (memberResult.isOpPossible()) {
                    this.builder.groupByMessage(memberResult.getExceptionMessage(), memberResult.getMemberNameOrId(), exceptionMessageNodes);
                    continue;
                }
                this.builder.groupByMessage(memberResult.getErrorMessage(), memberResult.getMemberNameOrId(), errorMessageNodes);
            }
            if (!memberCqNamesMap.isEmpty()) {
                TabularResultData table = ResultBuilder.createTabularResultData();
                Set members = memberCqNamesMap.keySet();
                for (String member : members) {
                    boolean isFirst = true;
                    List cqNames = (List)memberCqNamesMap.get(member);
                    for (String cqName : cqNames) {
                        if (isFirst) {
                            isFirst = false;
                            table.accumulate("member", member);
                        } else {
                            table.accumulate("member", "");
                        }
                        table.accumulate("durable-cq-name", cqName);
                    }
                }
                result = ResultBuilder.buildResult(table);
            } else {
                String errorHeader = CliStrings.format("Unable to list durable-cqs for durable-client-id : \"{0}\" due to following reasons.", (Object)durableClientId);
                result = ResultBuilder.buildResult(this.builder.buildFailureData(null, exceptionMessageNodes, errorMessageNodes, errorHeader));
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }
}

