/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.messages.CompactRequest;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CompactDiskStoreCommand
extends InternalGfshCommand {
    @CliCommand(value={"compact disk-store"}, help="Compact a disk store on all members with that disk store. This command uses the compaction threshold that each member has configured for its disk stores. The disk store must have \"allow-force-compaction\" set to true.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public Result compactDiskStore(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.cluster.diskstore:disable-string-converter", help="Name of the disk store to be compacted.") String diskStoreName, @CliOption(key={"group", "groups"}, help="Group(s) of members that will perform disk compaction. If no group is specified the disk store will be compacted by all members.") String[] groups) {
        Result result;
        try {
            if (!this.diskStoreExists(diskStoreName)) {
                result = ResultBuilder.createUserErrorResult(CliStrings.format("Disk store \"{0}\" does not exist.", new Object[]{diskStoreName}));
            } else {
                InternalDistributedSystem ds = ((InternalCache)this.getCache()).getInternalDistributedSystem();
                HashMap<DistributedMember, PersistentID> overallCompactInfo = new HashMap<DistributedMember, PersistentID>();
                Set otherMembers = ds.getDistributionManager().getOtherNormalDistributionManagerIds();
                HashSet<InternalDistributedMember> allMembers = new HashSet<InternalDistributedMember>();
                for (Object member : otherMembers) {
                    allMembers.add((InternalDistributedMember)member);
                }
                allMembers.add(ds.getDistributedMember());
                String groupInfo = "";
                if (groups != null && groups.length > 0) {
                    groupInfo = CliStrings.format(" for group(s) \"{0}\"", new Object[]{Arrays.toString(groups) + "."});
                    HashSet<InternalDistributedMember> selectedMembers = new HashSet<InternalDistributedMember>();
                    List<String> targetedGroups = Arrays.asList(groups);
                    for (InternalDistributedMember member : allMembers) {
                        List<String> memberGroups = member.getGroups();
                        if (Collections.disjoint(targetedGroups, memberGroups)) continue;
                        selectedMembers.add(member);
                    }
                    allMembers = selectedMembers;
                }
                if (allMembers.isEmpty()) {
                    result = ResultBuilder.createUserErrorResult(CliStrings.format("No members found in the specified group(s) \"{0}\".", new Object[]{Arrays.toString(groups)}));
                } else {
                    PersistentID compactedDiskStoreId;
                    if (allMembers.remove(ds.getDistributedMember()) && (compactedDiskStoreId = CompactRequest.compactDiskStore(diskStoreName)) != null) {
                        overallCompactInfo.put(ds.getDistributedMember(), compactedDiskStoreId);
                    }
                    if (!allMembers.isEmpty()) {
                        String notExecutedMembers;
                        Map<DistributedMember, PersistentID> memberCompactInfo = CompactRequest.send(ds.getDistributionManager(), diskStoreName, allMembers);
                        if (memberCompactInfo != null && !memberCompactInfo.isEmpty()) {
                            overallCompactInfo.putAll(memberCompactInfo);
                            memberCompactInfo.clear();
                        }
                        if ((notExecutedMembers = CompactRequest.getNotExecutedMembers()) != null && !notExecutedMembers.isEmpty()) {
                            LogWrapper.getInstance(this.getCache()).info("compact disk-store \"" + diskStoreName + "\" message was scheduled to be sent to but was not send to " + notExecutedMembers);
                        }
                    }
                    if (overallCompactInfo != null && !overallCompactInfo.isEmpty()) {
                        CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
                        Set entries = overallCompactInfo.entrySet();
                        for (Map.Entry entry : entries) {
                            String memberId = ((DistributedMember)entry.getKey()).getId();
                            CompositeResultData.SectionResultData section = compositeResultData.addSection(memberId);
                            section.addData("On Member", memberId);
                            PersistentID persistentID = (PersistentID)entry.getValue();
                            if (persistentID == null) continue;
                            CompositeResultData.SectionResultData subSection = section.addSection("DiskStore" + memberId);
                            subSection.addData("UUID", persistentID.getUUID());
                            subSection.addData("Host", persistentID.getHost().getHostName());
                            subSection.addData("Directory", persistentID.getDirectory());
                        }
                        compositeResultData.setHeader("Compacted " + diskStoreName + groupInfo);
                        result = ResultBuilder.buildResult(compositeResultData);
                    } else {
                        result = ResultBuilder.createInfoResult("Attempted to compact disk store, but there was nothing to do.");
                    }
                }
            }
        }
        catch (RuntimeException e) {
            LogWrapper.getInstance(this.getCache()).info(e.getMessage(), e);
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("An error occurred while doing compaction: \"{0}\"", new Object[]{e.getMessage()}));
        }
        return result;
    }

    private boolean diskStoreExists(String diskStoreName) {
        ManagementService managementService = this.getManagementService();
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        Map<String, String[]> diskstore = dsMXBean.listMemberDiskstore();
        Set<Map.Entry<String, String[]>> entrySet = diskstore.entrySet();
        for (Map.Entry<String, String[]> entry : entrySet) {
            Object[] value = entry.getValue();
            if (diskStoreName == null || !ArrayUtils.contains((Object[])value, (Object)diskStoreName)) continue;
            return true;
        }
        return false;
    }
}

