/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.util.List;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.AlreadyRunningException;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.JmxManagerLocatorRequest;
import org.apache.geode.management.internal.JmxManagerLocatorResponse;
import org.apache.logging.log4j.Logger;

public class JmxManagerLocator
implements TcpHandler {
    private static final Logger logger = LogService.getLogger();
    private InternalCache cache;

    public JmxManagerLocator(InternalCache internalCache) {
        this.cache = internalCache;
    }

    @Override
    public Object processRequest(Object request) throws IOException {
        assert (request instanceof JmxManagerLocatorRequest);
        return this.findJmxManager((JmxManagerLocatorRequest)request);
    }

    @Override
    public void endRequest(Object request, long startTime) {
    }

    @Override
    public void endResponse(Object request, long startTime) {
    }

    @Override
    public void shutDown() {
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, InternalClusterConfigurationService sharedConfig) {
        this.cache = (InternalCache)cache;
    }

    @Override
    public void init(TcpServer tcpServer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmxManagerLocatorResponse findJmxManager(JmxManagerLocatorRequest request) {
        List<JmxManagerAdvisor.JmxManagerProfile> willingToManage;
        List<JmxManagerAdvisor.JmxManagerProfile> alreadyManaging;
        if (logger.isDebugEnabled()) {
            logger.debug("Locator requested to find or start jmx manager");
        }
        if ((alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging()).isEmpty() && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
            JmxManagerLocator jmxManagerLocator = this;
            synchronized (jmxManagerLocator) {
                alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                if (alreadyManaging.isEmpty() && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
                    JmxManagerAdvisor.JmxManagerProfile p = willingToManage.get(0);
                    if (p.getDistributedMember().equals(this.cache.getMyId())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Locator starting jmx manager in its JVM");
                        }
                        try {
                            ManagementService.getManagementService(this.cache).startManager();
                        }
                        catch (CancelException cancelException) {
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            return new JmxManagerLocatorResponse(null, 0, false, t);
                        }
                    } else {
                        p = this.startJmxManager(willingToManage);
                        if (p != null && logger.isDebugEnabled()) {
                            logger.debug("Locator started jmx manager in {}", (Object)p.getDistributedMember());
                        }
                        alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                        int sleepCount = 0;
                        while (sleepCount < 20 && alreadyManaging.isEmpty() && this.cache.getDistributionManager().getDistributionManagerIds().contains(p.getDistributedMember())) {
                            ++sleepCount;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ignored) {
                                Thread.currentThread().interrupt();
                            }
                            alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                        }
                    }
                    if (alreadyManaging.isEmpty()) {
                        alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                    }
                }
            }
        }
        JmxManagerLocatorResponse result = null;
        if (!alreadyManaging.isEmpty()) {
            JmxManagerAdvisor.JmxManagerProfile p = alreadyManaging.get(0);
            result = new JmxManagerLocatorResponse(p.getHost(), p.getPort(), p.getSsl(), null);
            if (logger.isDebugEnabled()) {
                logger.debug("Found jmx manager: " + p);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Did not find a jmx manager");
            }
            result = new JmxManagerLocatorResponse();
        }
        return result;
    }

    private JmxManagerAdvisor.JmxManagerProfile startJmxManager(List<JmxManagerAdvisor.JmxManagerProfile> willingToManage) {
        for (JmxManagerAdvisor.JmxManagerProfile p : willingToManage) {
            if (!this.sendStartJmxManager(p.getDistributedMember())) continue;
            return p;
        }
        return null;
    }

    private boolean sendStartJmxManager(InternalDistributedMember distributedMember) {
        try {
            List resultContainer = (List)FunctionService.onMember(distributedMember).execute(new StartJmxManagerFunction()).getResult();
            Object result = resultContainer.get(0);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            logger.info("Could not start jmx manager on {} because {}", (Object)distributedMember, result);
            return false;
        }
        catch (RuntimeException ex) {
            if (!this.cache.getDistributionManager().getDistributionManagerIdsIncludingAdmin().contains(distributedMember)) {
                logger.info("Could not start jmx manager on {} because of {}", (Object)distributedMember, (Object)ex.getMessage(), (Object)ex);
                return false;
            }
            throw ex;
        }
    }

    public static class StartJmxManagerFunction
    implements InternalFunction {
        private static final long serialVersionUID = -2860286061903069789L;
        public static final String ID = StartJmxManagerFunction.class.getName();

        @Override
        public void execute(FunctionContext context) {
            try {
                ManagementService ms;
                Cache cache = CacheFactory.getAnyInstance();
                if (cache != null && (ms = ManagementService.getExistingManagementService(cache)) != null) {
                    if (!ms.isManager()) {
                        ms.startManager();
                    }
                    context.getResultSender().lastResult(Boolean.TRUE);
                }
                context.getResultSender().lastResult(Boolean.FALSE);
            }
            catch (AlreadyRunningException ignored) {
                context.getResultSender().lastResult(Boolean.TRUE);
            }
            catch (Exception e) {
                context.getResultSender().lastResult("Exception in StartJmxManager =" + e.getMessage());
            }
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }
}

