/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.ManagementStrings;
import org.apache.geode.management.internal.SSLUtil;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyHelper {
    private static final Logger logger = LogService.getLogger();
    private static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String HTTPS = "https";
    private static String bindAddress = "0.0.0.0";
    private static int port = 0;
    public static final String SECURITY_SERVICE_SERVLET_CONTEXT_PARAM = "org.apache.geode.securityService";
    private static final CountDownLatch latch = new CountDownLatch(1);

    public static Server initJetty(String bindAddress, int port, SSLConfig sslConfig) {
        Server jettyServer = new Server();
        jettyServer.setHandler((Handler)new HandlerCollection());
        ServerConnector connector = null;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HTTPS);
        httpConfig.setSecurePort(port);
        if (sslConfig.isEnabled()) {
            String protocol;
            SslContextFactory sslContextFactory = new SslContextFactory();
            if (StringUtils.isNotBlank((String)sslConfig.getAlias())) {
                sslContextFactory.setCertAlias(sslConfig.getAlias());
            }
            sslContextFactory.setNeedClientAuth(sslConfig.isRequireAuth());
            if (StringUtils.isNotBlank((String)sslConfig.getCiphers()) && !"any".equalsIgnoreCase(sslConfig.getCiphers())) {
                sslContextFactory.setExcludeCipherSuites(new String[0]);
                sslContextFactory.setIncludeCipherSuites(SSLUtil.readArray(sslConfig.getCiphers()));
            }
            if ((protocol = SSLUtil.getSSLAlgo(SSLUtil.readArray(sslConfig.getProtocols()))) != null) {
                sslContextFactory.setProtocol(protocol);
            } else {
                logger.warn((Object)ManagementStrings.SSL_PROTOCOAL_COULD_NOT_BE_DETERMINED);
            }
            if (StringUtils.isBlank((String)sslConfig.getKeystore())) {
                throw new GemFireConfigException("Key store can't be empty if SSL is enabled for HttpService");
            }
            sslContextFactory.setKeyStorePath(sslConfig.getKeystore());
            if (StringUtils.isNotBlank((String)sslConfig.getKeystoreType())) {
                sslContextFactory.setKeyStoreType(sslConfig.getKeystoreType());
            }
            if (StringUtils.isNotBlank((String)sslConfig.getKeystorePassword())) {
                sslContextFactory.setKeyStorePassword(sslConfig.getKeystorePassword());
            }
            if (StringUtils.isNotBlank((String)sslConfig.getTruststore())) {
                sslContextFactory.setTrustStorePath(sslConfig.getTruststore());
            }
            if (StringUtils.isNotBlank((String)sslConfig.getTruststorePassword())) {
                sslContextFactory.setTrustStorePassword(sslConfig.getTruststorePassword());
            }
            if (logger.isDebugEnabled()) {
                logger.debug(sslContextFactory.dump());
            }
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(jettyServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        } else {
            connector = new ServerConnector(jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        }
        jettyServer.setConnectors(new Connector[]{connector});
        if (StringUtils.isNotBlank((String)bindAddress)) {
            connector.setHost(bindAddress);
        }
        if (bindAddress != null && !bindAddress.isEmpty()) {
            JettyHelper.bindAddress = bindAddress;
        }
        JettyHelper.port = port;
        return jettyServer;
    }

    public static Server startJetty(Server jetty) throws Exception {
        jetty.start();
        return jetty;
    }

    public static Server addWebApplication(Server jetty, String webAppContext, String warFilePath, SecurityService securityService) {
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(webAppContext);
        webapp.setWar(warFilePath);
        webapp.setParentLoaderPriority(false);
        webapp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        webapp.setAttribute(SECURITY_SERVICE_SERVLET_CONTEXT_PARAM, (Object)securityService);
        File tmpPath = new File(JettyHelper.getWebAppBaseDirectory(webAppContext));
        tmpPath.mkdirs();
        webapp.setTempDirectory(tmpPath);
        ((HandlerCollection)jetty.getHandler()).addHandler((Handler)webapp);
        return jetty;
    }

    private static String getWebAppBaseDirectory(String context) {
        String underscoredContext = context.replace("/", "_");
        String workingDirectory = USER_DIR.concat(FILE_PATH_SEPARATOR).concat("GemFire_" + USER_NAME).concat(FILE_PATH_SEPARATOR).concat("services").concat(FILE_PATH_SEPARATOR).concat("http").concat(FILE_PATH_SEPARATOR).concat(StringUtils.isBlank((String)bindAddress) ? "0.0.0.0" : bindAddress).concat("_").concat(String.valueOf(port).concat(underscoredContext));
        return workingDirectory;
    }

    private static String normalizeWebAppArchivePath(String webAppArchivePath) {
        return (webAppArchivePath.startsWith(File.separator) ? new File(webAppArchivePath) : new File(".", webAppArchivePath)).getAbsolutePath();
    }

    private static String normalizeWebAppContext(String webAppContext) {
        return webAppContext.startsWith("/") ? webAppContext : "/" + webAppContext;
    }
}

