/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public abstract class BaseManagementService
extends ManagementService {
    private static final Logger logger = LogService.getLogger();
    protected static final Map<Object, BaseManagementService> instances = new HashMap<Object, BaseManagementService>();
    private static final List<InternalDistributedSystem> systems = new ArrayList<InternalDistributedSystem>(1);

    protected BaseManagementService() {
    }

    protected abstract void close();

    protected abstract boolean isClosed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagementService getManagementService(InternalCache cache) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            BaseManagementService service = instances.get(cache);
            if (service == null) {
                service = SystemManagementService.newSystemManagementService(cache);
                instances.put(cache, service);
            }
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagementService getExistingManagementService(InternalCache cache) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            BaseManagementService service = instances.get(cache);
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initInternalDistributedSystem() {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            List existingSystems = InternalDistributedSystem.addConnectListener(new InternalDistributedSystem.ConnectListener(){

                @Override
                public void onConnect(InternalDistributedSystem sys) {
                    BaseManagementService.addInternalDistributedSystem(sys);
                }
            });
            for (InternalDistributedSystem sys : existingSystems) {
                try {
                    if (!sys.isConnected()) continue;
                    BaseManagementService.addInternalDistributedSystem(sys);
                }
                catch (DistributedSystemDisconnectedException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("DistributedSystemDisconnectedException {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInternalDistributedSystem(InternalDistributedSystem sys) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            sys.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                public String toString() {
                    return "Disconnect listener for BaseManagementService";
                }

                @Override
                public void onDisconnect(InternalDistributedSystem ss) {
                    BaseManagementService.removeInternalDistributedSystem(ss);
                }
            });
            systems.add(sys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInternalDistributedSystem(InternalDistributedSystem sys) {
        Map<Object, BaseManagementService> map = instances;
        synchronized (map) {
            systems.remove(sys);
            if (systems.isEmpty()) {
                for (Object key : instances.keySet()) {
                    BaseManagementService service = instances.get(key);
                    try {
                        if (service.isClosed()) continue;
                        service.close();
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("ManagementException while removing InternalDistributedSystem {}", (Object)e.getMessage(), (Object)e);
                    }
                }
                instances.clear();
            }
        }
    }

    static {
        BaseManagementService.initInternalDistributedSystem();
    }
}

