/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class StatisticsTypeXml
implements EntityResolver,
ErrorHandler {
    static final String DTD = "statisticsType.dtd";
    static final String systemId = "http://www.gemstone.com/dtd/statisticsType.dtd";
    static final String publicId = "-//GemStone Systems, Inc.//GemFire StatisticsType//EN";
    private static final int INT_STORAGE = 0;
    private static final int LONG_STORAGE = 1;
    private static final int DOUBLE_STORAGE = 2;

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId.equals(publicId) || systemId.equals(systemId) || systemId.endsWith(DTD)) {
            String location = "/org/apache/geode/statisticsType.dtd";
            InputStream stream = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), location);
            if (stream != null) {
                return new InputSource(stream);
            }
            throw new SAXNotRecognizedException(LocalizedStrings.StatisticsTypeXml_DTD_NOT_FOUND_0.toLocalizedString(location));
        }
        throw new SAXNotRecognizedException(LocalizedStrings.StatisticsTypeXml_INVALID_PUBLIC_ID_0.toLocalizedString(publicId));
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_SAX_ERROR_WHILE_WORKING_WITH_XML.toLocalizedString(), exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_SAX_FATAL_ERROR_WHILE_WORKING_WITH_XML.toLocalizedString(), exception);
    }

    public StatisticsType[] read(Reader reader, StatisticsTypeFactory statFactory) {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_FAILED_PARSING_XML.toLocalizedString(), ex);
        }
        parser.setErrorHandler(this);
        parser.setEntityResolver(this);
        try {
            doc = parser.parse(new InputSource(reader));
        }
        catch (SAXException se) {
            throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_FAILED_PARSING_XML.toLocalizedString(), se);
        }
        catch (IOException io) {
            throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_FAILED_READING_XML_DATA.toLocalizedString(), io);
        }
        if (doc == null) {
            throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_FAILED_READING_XML_DATA_NO_DOCUMENT.toLocalizedString());
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new GemFireConfigException(LocalizedStrings.StatisticsTypeXml_FAILED_READING_XML_DATA_NO_ROOT_ELEMENT.toLocalizedString());
        }
        return this.extractStatistics(root, statFactory);
    }

    private StatisticsType[] extractStatistics(Element root, StatisticsTypeFactory statFactory) {
        Assert.assertTrue(root.getTagName().equals("statistics"));
        ArrayList<StatisticsType> types = new ArrayList<StatisticsType>();
        NodeList typeNodes = root.getElementsByTagName("type");
        for (int i = 0; i < typeNodes.getLength(); ++i) {
            Element typeNode = (Element)typeNodes.item(i);
            types.add(this.extractType(typeNode, statFactory));
        }
        return types.toArray(new StatisticsType[types.size()]);
    }

    private StatisticsType extractType(Element typeNode, StatisticsTypeFactory statFactory) {
        Element descriptionNode;
        Assert.assertTrue(typeNode.getTagName().equals("type"));
        Assert.assertTrue(typeNode.hasAttribute("name"));
        String typeName = typeNode.getAttribute("name");
        ArrayList<StatisticDescriptor> stats = new ArrayList<StatisticDescriptor>();
        NodeList statNodes = typeNode.getElementsByTagName("stat");
        for (int i = 0; i < statNodes.getLength(); ++i) {
            Element statNode = (Element)statNodes.item(i);
            stats.add(this.extractStat(statNode, statFactory));
        }
        StatisticDescriptor[] descriptors = stats.toArray(new StatisticDescriptor[stats.size()]);
        String description = "";
        NodeList descriptionNodes = typeNode.getElementsByTagName("description");
        if (descriptionNodes.getLength() > 0 && (descriptionNode = (Element)descriptionNodes.item(0)).getParentNode().getNodeName().equals(typeNode.getNodeName())) {
            description = this.extractDescription(descriptionNode);
        }
        return statFactory.createType(typeName, description, descriptors);
    }

    private StatisticDescriptor extractStat(Element statNode, StatisticsTypeFactory statFactory) {
        NodeList unitNodes;
        NodeList descriptionNodes;
        String value;
        Assert.assertTrue(statNode.getTagName().equals("stat"));
        Assert.assertTrue(statNode.hasAttribute("name"));
        String statName = statNode.getAttribute("name");
        String description = "";
        String unit = "";
        boolean isCounter = true;
        int storage = 0;
        if (statNode.hasAttribute("counter")) {
            value = statNode.getAttribute("counter");
            Assert.assertTrue(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"));
            isCounter = Boolean.valueOf(value);
        }
        boolean largerBetter = isCounter;
        if (statNode.hasAttribute("largerBetter")) {
            value = statNode.getAttribute("largerBetter");
            Assert.assertTrue(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"));
            largerBetter = Boolean.valueOf(value);
        }
        if (statNode.hasAttribute("storage")) {
            value = statNode.getAttribute("storage");
            if (value.equalsIgnoreCase("int")) {
                storage = 0;
            } else if (value.equalsIgnoreCase("long")) {
                storage = 1;
            } else {
                Assert.assertTrue(value.equalsIgnoreCase("double"));
                storage = 2;
            }
        }
        Assert.assertTrue((descriptionNodes = statNode.getElementsByTagName("description")).getLength() <= 1);
        if (descriptionNodes.getLength() == 1) {
            Element descriptionNode = (Element)descriptionNodes.item(0);
            description = this.extractDescription(descriptionNode);
        }
        Assert.assertTrue((unitNodes = statNode.getElementsByTagName("unit")).getLength() <= 1);
        if (unitNodes.getLength() == 1) {
            Element unitNode = (Element)unitNodes.item(0);
            unit = this.extractUnit(unitNode);
        }
        if (isCounter) {
            switch (storage) {
                case 0: {
                    return statFactory.createIntCounter(statName, description, unit, largerBetter);
                }
                case 1: {
                    return statFactory.createLongCounter(statName, description, unit, largerBetter);
                }
                case 2: {
                    return statFactory.createDoubleCounter(statName, description, unit, largerBetter);
                }
            }
            throw new RuntimeException(LocalizedStrings.StatisticsTypeXml_UNEXPECTED_STORAGE_TYPE_0.toLocalizedString(storage));
        }
        switch (storage) {
            case 0: {
                return statFactory.createIntGauge(statName, description, unit, largerBetter);
            }
            case 1: {
                return statFactory.createLongGauge(statName, description, unit, largerBetter);
            }
            case 2: {
                return statFactory.createDoubleGauge(statName, description, unit, largerBetter);
            }
        }
        throw new RuntimeException(LocalizedStrings.StatisticsTypeXml_UNEXPECTED_STORAGE_TYPE_0.toLocalizedString(storage));
    }

    private String extractDescription(Element descriptionNode) {
        Assert.assertTrue(descriptionNode.getTagName().equals("description"));
        return this.extractText(descriptionNode);
    }

    private String extractUnit(Element unitNode) {
        Assert.assertTrue(unitNode.getTagName().equals("unit"));
        return this.extractText(unitNode);
    }

    private String extractText(Element element) {
        Text text = (Text)element.getFirstChild();
        return text == null ? "" : text.getData();
    }
}

