/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import org.apache.commons.lang.Validate;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.shared.NativeCalls;

class NativeProcessUtils
implements ProcessUtils.InternalProcessUtils {
    private static final NativeCalls nativeCalls = NativeCalls.getInstance();

    NativeProcessUtils() {
    }

    @Override
    public boolean isProcessAlive(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"));
        return nativeCalls.isProcessActive(pid);
    }

    @Override
    public boolean killProcess(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"));
        return nativeCalls.killProcess(pid);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isAttachApiAvailable() {
        return false;
    }
}

