/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.process.ControlFileWatchdog;
import org.apache.geode.internal.process.FileControllerParameters;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.UnableToControlProcessException;
import org.apache.geode.lang.AttachAPINotFoundException;

class FileProcessController
implements ProcessController {
    static final long DEFAULT_STATUS_TIMEOUT_MILLIS = 60000L;
    private final long statusTimeoutMillis;
    private final FileControllerParameters parameters;
    private final int pid;

    FileProcessController(FileControllerParameters parameters, int pid) {
        this(parameters, pid, 60000L, TimeUnit.MILLISECONDS);
    }

    FileProcessController(FileControllerParameters parameters, int pid, long timeout, TimeUnit units) {
        Validate.notNull((Object)parameters, (String)("Invalid parameters '" + parameters + "' specified"));
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"));
        Validate.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)("Invalid timeout '" + timeout + "' specified"));
        Validate.notNull((Object)((Object)units), (String)("Invalid units '" + (Object)((Object)units) + "' specified"));
        this.pid = pid;
        this.parameters = parameters;
        this.statusTimeoutMillis = units.toMillis(timeout);
    }

    @Override
    public int getProcessId() {
        return this.pid;
    }

    @Override
    public String status() throws UnableToControlProcessException, IOException, InterruptedException, TimeoutException {
        return this.status(this.parameters.getDirectory(), this.parameters.getProcessType().getStatusRequestFileName(), this.parameters.getProcessType().getStatusFileName());
    }

    @Override
    public void stop() throws UnableToControlProcessException, IOException {
        this.stop(this.parameters.getDirectory(), this.parameters.getProcessType().getStopRequestFileName());
    }

    @Override
    public void checkPidSupport() {
        throw new AttachAPINotFoundException(LocalizedStrings.Launcher_ATTACH_API_NOT_FOUND_ERROR_MESSAGE.toLocalizedString());
    }

    long getStatusTimeoutMillis() {
        return this.statusTimeoutMillis;
    }

    private void stop(File workingDir, String stopRequestFileName) throws IOException {
        File stopRequestFile = new File(workingDir, stopRequestFileName);
        if (!stopRequestFile.exists()) {
            stopRequestFile.createNewFile();
        }
    }

    private String status(File workingDir, String statusRequestFileName, String statusFileName) throws IOException, InterruptedException, TimeoutException {
        File statusFile = new File(workingDir, statusFileName);
        AtomicReference statusRef = new AtomicReference();
        ControlFileWatchdog.ControlRequestHandler statusHandler = () -> {
            StringBuilder lines = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new FileReader(statusFile));){
                reader.lines().forEach(lines::append);
            }
            finally {
                statusRef.set(lines.toString());
            }
        };
        ControlFileWatchdog statusFileWatchdog = new ControlFileWatchdog(workingDir, statusFileName, statusHandler, true);
        statusFileWatchdog.start();
        File statusRequestFile = new File(workingDir, statusRequestFileName);
        if (!statusRequestFile.exists()) {
            statusRequestFile.createNewFile();
        }
        long start = System.currentTimeMillis();
        while (statusFileWatchdog.isAlive()) {
            Thread.sleep(10L);
            if (System.currentTimeMillis() < start + this.statusTimeoutMillis) continue;
            statusFileWatchdog.stop();
            throw new TimeoutException("Timed out waiting for process to create " + statusFile);
        }
        String lines = (String)statusRef.get();
        if (StringUtils.isBlank((String)lines)) {
            throw new IllegalStateException("Status file '" + statusFile + "' is blank");
        }
        return lines;
    }
}

