/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.apache.geode.internal.logging.log4j.AppenderContext;
import org.apache.geode.internal.logging.log4j.ConfigLocator;
import org.apache.geode.internal.logging.log4j.Configurator;
import org.apache.geode.internal.logging.log4j.FastLogger;
import org.apache.geode.internal.logging.log4j.LogWriterLogger;
import org.apache.geode.internal.logging.log4j.message.GemFireParameterizedMessageFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class LogService
extends LogManager {
    public static final String ROOT_LOGGER_NAME = "";
    public static final String BASE_LOGGER_NAME = "org.apache.geode";
    public static final String MAIN_LOGGER_NAME = "org.apache.geode";
    public static final String SECURITY_LOGGER_NAME = "org.apache.geode.security";
    public static final String GEODE_VERBOSE_FILTER = "{GEODE_VERBOSE}";
    public static final String GEMFIRE_VERBOSE_FILTER = "{GEMFIRE_VERBOSE}";
    public static final String DEFAULT_CONFIG = "/log4j2.xml";
    public static final String CLI_CONFIG = "/log4j2-cli.xml";
    protected static final String STDOUT = "STDOUT";
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeListenerImpl();
    private static final String GEMFIRE_DEFAULT_PROPERTY = "geode-default";
    private static Appender stdoutAppender;

    private LogService() {
    }

    private static void init() {
        LoggerContext context = ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)"org.apache.geode", (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE)).getContext();
        context.removePropertyChangeListener(propertyChangeListener);
        context.addPropertyChangeListener(propertyChangeListener);
        context.reconfigure();
        LogService.configureLoggers(false, false);
    }

    public static void initialize() {
        new LogService();
    }

    public static void reconfigure() {
        LogService.init();
    }

    public static void configureLoggers(boolean hasLogFile, boolean hasSecurityLogFile) {
        Configurator.getOrCreateLoggerConfig("org.apache.geode", true, false);
        Configurator.getOrCreateLoggerConfig("org.apache.geode", true, hasLogFile);
        boolean useMainLoggerForSecurity = !hasSecurityLogFile;
        Configurator.getOrCreateLoggerConfig(SECURITY_LOGGER_NAME, useMainLoggerForSecurity, hasSecurityLogFile);
    }

    public static AppenderContext getAppenderContext() {
        return new AppenderContext();
    }

    public static AppenderContext getAppenderContext(String name) {
        return new AppenderContext(name);
    }

    public static boolean isUsingGemFireDefaultConfig() {
        Configuration config = ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)ROOT_LOGGER_NAME, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE)).getContext().getConfiguration();
        StrSubstitutor sub = config.getStrSubstitutor();
        StrLookup resolver = sub.getVariableResolver();
        String value = resolver.lookup(GEMFIRE_DEFAULT_PROPERTY);
        return "true".equals(value);
    }

    public static String getConfigInformation() {
        return LogService.getConfiguration().getConfigurationSource().toString();
    }

    public static File findLog4jConfigInCurrentDir() {
        return ConfigLocator.findConfigInWorkingDirectory();
    }

    public static Logger getLogger() {
        return new FastLogger(LogManager.getLogger((String)LogService.getClassName(2), (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE));
    }

    public static Logger getLogger(String name) {
        return new FastLogger(LogManager.getLogger((String)name, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE));
    }

    public static LogWriterLogger createLogWriterLogger(String name, String connectionName, boolean isSecure) {
        return LogWriterLogger.create(name, connectionName, isSecure);
    }

    public static Level toLevel(int intLevel) {
        for (Level level : Level.values()) {
            if (level.intLevel() != intLevel) continue;
            return level;
        }
        throw new IllegalArgumentException("Unknown int level [" + intLevel + "].");
    }

    public static String getClassName(int depth) {
        return new Throwable().getStackTrace()[depth].getClassName();
    }

    public static Configuration getConfiguration() {
        Configuration config = ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)ROOT_LOGGER_NAME, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE)).getContext().getConfiguration();
        return config;
    }

    public static void configureFastLoggerDelegating() {
        Configuration config = ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)ROOT_LOGGER_NAME, (MessageFactory)GemFireParameterizedMessageFactory.INSTANCE)).getContext().getConfiguration();
        if (Configurator.hasContextWideFilter(config) || Configurator.hasAppenderFilter(config) || Configurator.hasDebugOrLower(config) || Configurator.hasLoggerFilter(config) || Configurator.hasAppenderRefFilter(config)) {
            FastLogger.setDelegating(true);
        } else {
            FastLogger.setDelegating(false);
        }
    }

    public static void setSecurityLogLevel(Level level) {
        Configurator.setLevel(SECURITY_LOGGER_NAME, level);
    }

    public static Level getBaseLogLevel() {
        return Configurator.getLevel("org.apache.geode");
    }

    public static void setBaseLogLevel(Level level) {
        if (LogService.isUsingGemFireDefaultConfig()) {
            Configurator.setLevel(ROOT_LOGGER_NAME, level);
        }
        Configurator.setLevel("org.apache.geode", level);
        Configurator.setLevel("org.apache.geode", level);
    }

    public static LoggerConfig getRootLoggerConfig() {
        return Configurator.getLoggerConfig(LogManager.getRootLogger().getName());
    }

    public static synchronized void removeConsoleAppender() {
        AppenderContext appenderContext = LogService.getAppenderContext(ROOT_LOGGER_NAME);
        LoggerConfig config = appenderContext.getLoggerConfig();
        Appender stdout = (Appender)config.getAppenders().get(STDOUT);
        if (stdout != null) {
            config.removeAppender(STDOUT);
            stdoutAppender = stdout;
            appenderContext.getLoggerContext().updateLoggers();
        }
    }

    public static synchronized void restoreConsoleAppender() {
        if (stdoutAppender == null) {
            return;
        }
        AppenderContext appenderContext = LogService.getAppenderContext(ROOT_LOGGER_NAME);
        LoggerConfig config = appenderContext.getLoggerConfig();
        Appender stdout = (Appender)config.getAppenders().get(STDOUT);
        if (stdout == null) {
            config.addAppender(stdoutAppender, Level.ALL, null);
            appenderContext.getLoggerContext().updateLoggers();
        }
    }

    static {
        LogService.init();
    }

    private static class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            StatusLogger.getLogger().debug("LogService responding to a property change event. Property name is {}.", (Object)evt.getPropertyName());
            if (evt.getPropertyName().equals("config")) {
                LogService.configureFastLoggerDelegating();
            }
        }
    }
}

