/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.datasource.ClientConnectionFactoryWrapper;
import org.apache.geode.internal.datasource.ConfigProperty;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.DataSourceCreateException;
import org.apache.geode.internal.datasource.FacetsJCAConnectionManagerImpl;
import org.apache.geode.internal.datasource.GemFireBasicDataSource;
import org.apache.geode.internal.datasource.GemFireConnPooledDataSource;
import org.apache.geode.internal.datasource.GemFireTransactionDataSource;
import org.apache.geode.internal.datasource.JCAConnectionManagerImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.util.PasswordUtil;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DataSourceFactory {
    private static final Logger logger = LogService.getLogger();
    private static String TEST_CONNECTION_URL = null;
    private static String TEST_CONNECTION_HOST = null;
    private static String TEST_CONNECTION_PORT = null;

    public static DataSource getSimpleDataSource(Map configMap) throws DataSourceCreateException {
        ConfiguredDataSourceProperties configs = DataSourceFactory.createDataSourceProperties(configMap);
        if (configs.getJDBCDriver() == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETSIMPLEDATASOURCEJDBC_DRIVER_IS_NOT_AVAILABLE));
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETSIMPLEDATASOURCEJDBC_DRIVER_IS_NOT_AVAILABLE.toLocalizedString());
        }
        if (configs.getURL() == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETSIMPLEDATASOURCEURL_STRING_TO_DATABASE_IS_NULL));
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETSIMPLEDATASOURCEURL_STRING_TO_DATABASE_IS_NULL.toLocalizedString());
        }
        try {
            return new GemFireBasicDataSource(configs);
        }
        catch (Exception ex) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_GETSIMPLEDATASOURCE_EXCEPTION_WHILE_CREATING_GEMFIREBASICDATASOURCE_EXCEPTION_STRING_0, ex.getLocalizedMessage()), (Throwable)ex);
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_GETSIMPLEDATASOURCE_EXCEPTION_WHILE_CREATING_GEMFIREBASICDATASOURCE_EXCEPTION_STRING_0.toLocalizedString(ex.getLocalizedMessage()), ex);
        }
    }

    public static ClientConnectionFactoryWrapper getManagedDataSource(Map configMap, List<ConfigProperty> props) throws DataSourceCreateException {
        Object cf = null;
        ManagedConnectionFactory mcf = null;
        ConfiguredDataSourceProperties configs = DataSourceFactory.createDataSourceProperties(configMap);
        if (configs.getMCFClass() == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETMANAGEDDATASOURCEMANAGED_CONNECTION_FACTORY_CLASS_IS_NOT_AVAILABLE));
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETMANAGEDDATASOURCEMANAGED_CONNECTION_FACTORY_CLASS_IS_NOT_AVAILABLE.toLocalizedString());
        }
        try {
            Class<?> cl = ClassPathLoader.getLatest().forName(configs.getMCFClass());
            mcf = (ManagedConnectionFactory)cl.newInstance();
            DataSourceFactory.invokeAllMethods(cl, mcf, props);
        }
        catch (Exception ex) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETMANAGEDDATASOURCE_EXCEPTION_IN_CREATING_MANAGED_CONNECTION_FACTORY_EXCEPTION_STRING_0, ex), null);
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETMANAGEDDATASOURCE_EXCEPTION_IN_CREATING_MANAGED_CONNECTION_FACTORY_EXCEPTION_STRING_0.toLocalizedString(ex));
        }
        Object cm = null;
        cm = configs.getMCFClass().equals("org.apache.persistence.connection.internal.ConnFactory") ? new FacetsJCAConnectionManagerImpl(mcf, configs) : new JCAConnectionManagerImpl(mcf, configs);
        try {
            cf = mcf.createConnectionFactory((ConnectionManager)cm);
        }
        catch (Exception ex) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETMANAGEDDATASOURCE_EXCEPTION_IN_CREATING_MANAGED_CONNECTION_FACTORY_EXCEPTION_STRING_0, ex), null);
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETMANAGEDDATASOURCE_EXCEPTION_IN_CREATING_MANAGED_CONNECTION_FACTORY_EXCEPTION_STRING_0.toLocalizedString(ex));
        }
        return new ClientConnectionFactoryWrapper(cf, cm);
    }

    public static DataSource getPooledDataSource(Map configMap, List<ConfigProperty> props) throws DataSourceCreateException {
        ConfiguredDataSourceProperties configs = DataSourceFactory.createDataSourceProperties(configMap);
        String connpoolClassName = configs.getConnectionPoolDSClass();
        if (connpoolClassName == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETPOOLEDDATASOURCECONNECTIONPOOLDATASOURCE_CLASS_NAME_FOR_THE_RESOURCEMANAGER_IS_NOT_AVAILABLE));
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETPOOLEDDATASOURCECONNECTIONPOOLDATASOURCE_CLASS_NAME_FOR_THE_RESOURCEMANAGER_IS_NOT_AVAILABLE.toLocalizedString());
        }
        try {
            Class<?> cl = ClassPathLoader.getLatest().forName(connpoolClassName);
            Object Obj = cl.newInstance();
            DataSourceFactory.invokeAllMethods(cl, Obj, props);
            return new GemFireConnPooledDataSource((ConnectionPoolDataSource)Obj, configs);
        }
        catch (Exception ex) {
            String exception = LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_GETPOOLEDDATASOURCE_EXCEPTION_CREATING_CONNECTIONPOOLDATASOURCE_EXCEPTION_STRING_0.toLocalizedString(ex);
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_GETPOOLEDDATASOURCE_EXCEPTION_CREATING_CONNECTIONPOOLDATASOURCE_EXCEPTION_STRING_0, ex), (Throwable)ex);
            throw new DataSourceCreateException(exception, ex);
        }
    }

    public static DataSource getTranxDataSource(Map configMap, List<ConfigProperty> props) throws DataSourceCreateException {
        ConfiguredDataSourceProperties configs = DataSourceFactory.createDataSourceProperties(configMap);
        String xaClassName = configs.getXADSClass();
        if (xaClassName == null) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETTRANXDATASOURCEXADATASOURCE_CLASS_NAME_FOR_THE_RESOURCEMANAGER_IS_NOT_AVAILABLE));
            throw new DataSourceCreateException(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORYGETTRANXDATASOURCEXADATASOURCE_CLASS_NAME_FOR_THE_RESOURCEMANAGER_IS_NOT_AVAILABLE.toLocalizedString());
        }
        if (TEST_CONNECTION_HOST != null) {
            props.add(new ConfigProperty("serverName", TEST_CONNECTION_HOST, "java.lang.String"));
        }
        if (TEST_CONNECTION_PORT != null) {
            props.add(new ConfigProperty("portNumber", TEST_CONNECTION_PORT, "int"));
        }
        try {
            Class<?> cl = ClassPathLoader.getLatest().forName(xaClassName);
            Object Obj = cl.newInstance();
            DataSourceFactory.invokeAllMethods(cl, Obj, props);
            return new GemFireTransactionDataSource((XADataSource)Obj, configs);
        }
        catch (Exception ex) {
            String exception = LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_GETTRANXDATASOURCE_EXCEPTION_IN_CREATING_GEMFIRETRANSACTIONDATASOURCE__EXCEPTION_STRING_0.toLocalizedString(ex);
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_GETTRANXDATASOURCE_EXCEPTION_IN_CREATING_GEMFIRETRANSACTIONDATASOURCE__EXCEPTION_STRING_0, ex), (Throwable)ex);
            throw new DataSourceCreateException(exception, ex);
        }
    }

    private static ConfiguredDataSourceProperties createDataSourceProperties(Map configMap) {
        ConfiguredDataSourceProperties configs = new ConfiguredDataSourceProperties();
        for (Map.Entry entry : configMap.entrySet()) {
            String name = (String)entry.getKey();
            Object obj = entry.getValue();
            if (name.equals("connection-url")) {
                configs.setURL((String)obj);
                continue;
            }
            if (name.equals("user-name")) {
                configs.setUser((String)obj);
                continue;
            }
            if (name.equals("password")) {
                configs.setPassword(PasswordUtil.decrypt((String)obj));
                continue;
            }
            if (name.equals("jdbc-driver-class")) {
                configs.setJDBCDriver((String)obj);
                continue;
            }
            if (name.equals("init-pool-size")) {
                configs.setInitialPoolSize(Integer.parseInt(obj == null ? String.valueOf(10) : obj));
                continue;
            }
            if (name.equals("max-pool-size")) {
                configs.setMaxPoolSize(Integer.parseInt(obj == null ? String.valueOf(30) : obj));
                continue;
            }
            if (name.equals("idle-timeout-seconds")) {
                configs.setConnectionExpirationTime(Integer.parseInt(obj == null ? String.valueOf(600) : obj));
                continue;
            }
            if (name.equals("blocking-timeout-seconds")) {
                configs.setConnectionTimeOut(Integer.parseInt(obj == null ? String.valueOf(120) : obj));
                continue;
            }
            if (name.equals("login-timeout-seconds")) {
                configs.setLoginTimeOut(Integer.parseInt(obj == null ? String.valueOf(30) : obj));
                continue;
            }
            if (name.equals("conn-pooled-datasource-class")) {
                configs.setConnectionPoolDSClass((String)obj);
                continue;
            }
            if (name.equals("xa-datasource-class")) {
                configs.setXADSClass((String)obj);
                continue;
            }
            if (name.equals("managed-conn-factory-class")) {
                configs.setMCFClass((String)obj);
                continue;
            }
            if (!name.equals("transaction-type")) continue;
            configs.setTransactionType((String)obj);
        }
        if (TEST_CONNECTION_URL != null) {
            configs.setURL(TEST_CONNECTION_URL);
        }
        return configs;
    }

    public static void setTestConnectionUrl(String url) {
        TEST_CONNECTION_URL = url;
    }

    public static void setTestConnectionHost(String host) {
        TEST_CONNECTION_HOST = host;
    }

    public static void setTestConnectionPort(String port) {
        TEST_CONNECTION_PORT = port;
    }

    private static void invokeAllMethods(Class c, Object cpdsObj, List props) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String key = null;
        String value = null;
        String type = null;
        String methodName = null;
        Method m = null;
        for (ConfigProperty cp : props) {
            String exception;
            key = cp.getName();
            value = cp.getValue();
            type = cp.getType();
            if (key.indexOf("password") != -1) {
                value = PasswordUtil.decrypt(String.valueOf(value));
            }
            methodName = new StringBuffer("set").append(Character.toUpperCase(key.charAt(0))).append(key.length() > 1 ? key.substring(1) : "").toString();
            try {
                Class<Integer> cl = null;
                Class<Integer> realClass = null;
                if ("int".equals(type)) {
                    cl = Integer.TYPE;
                    realClass = Integer.class;
                } else {
                    cl = ClassPathLoader.getLatest().forName(type);
                    realClass = cl;
                }
                Constructor cr = realClass.getConstructor(String.class);
                Object ob = cr.newInstance(value);
                m = c.getMethod(methodName, cl);
                m.invoke(cpdsObj, ob);
            }
            catch (ClassNotFoundException ex) {
                exception = LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_INVOKEALLMETHODS_EXCEPTION_IN_CREATING_CLASS_WITH_THE_GIVEN_CONFIGPROPERTYTYPE_CLASSNAME_EXCEPTION_STRING_0.toLocalizedString(ex.toString());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(exception, (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                exception = LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_INVOKEALLMETHODS_EXCEPTION_IN_CREATING_METHOD_USING_CONFIGPROPERTYNAME_PROPERTY_EXCEPTION_STRING_0.toLocalizedString(ex.toString());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(exception, (Throwable)ex);
            }
            catch (InstantiationException ex) {
                exception = LocalizedStrings.DataSourceFactory_DATASOURCEFACTORY_INVOKEALLMETHODS_EXCEPTION_IN_CREATING_INSTANCE_OF_THE_CLASS_USING_THE_CONSTRUCTOR_WITH_A_STRING_PARAMETER_EXCEPTION_STRING_0.toLocalizedString(ex.toString());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(exception, (Throwable)ex);
            }
        }
    }
}

