/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.util.Set;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DumpAllPRConfigMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();

    public DumpAllPRConfigMessage() {
    }

    private DumpAllPRConfigMessage(Set recipients, int regionId, ReplyProcessor21 processor) {
        super(recipients, regionId, processor);
    }

    public static PartitionMessage.PartitionResponse send(Set recipients, PartitionedRegion r) {
        PartitionMessage.PartitionResponse p = new PartitionMessage.PartitionResponse(r.getSystem(), recipients);
        DumpAllPRConfigMessage m = new DumpAllPRConfigMessage(recipients, r.getPRId(), (ReplyProcessor21)p);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "DumpAllPRConfigMessage operateOnRegion: {}", (Object)pr.getFullPath());
        }
        pr.dumpSelfEntryFromAllPartitionedRegions();
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "{} dumped allPartitionedRegions", (Object)this.getClass().getName());
        }
        return true;
    }

    @Override
    public int getDSFID() {
        return 44;
    }
}

