/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DeposePrimaryBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile int bucketId;

    public DeposePrimaryBucketMessage() {
    }

    private DeposePrimaryBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
    }

    public static DeposePrimaryBucketResponse send(InternalDistributedMember recipient, PartitionedRegion region, int bucketId) {
        Assert.assertTrue(recipient != null, "DeposePrimaryBucketMessage NULL recipient");
        DeposePrimaryBucketResponse response = new DeposePrimaryBucketResponse(region.getSystem(), recipient, region);
        DeposePrimaryBucketMessage msg = new DeposePrimaryBucketMessage(recipient, region.getPRId(), response, bucketId);
        msg.setTransactionDistributed(region.getCache().getTxManager().isDistributed());
        Set failures = region.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        region.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public DeposePrimaryBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        BucketAdvisor bucketAdvisor = region.getRegionAdvisor().getBucketAdvisor(this.bucketId);
        bucketAdvisor.deposePrimary();
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        DeposePrimaryBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, (ReplyException)null);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 130;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    public static class DeposePrimaryBucketResponse
    extends PartitionMessage.PartitionResponse {
        public DeposePrimaryBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof DeposePrimaryBucketReplyMessage) {
                    DeposePrimaryBucketReplyMessage reply = (DeposePrimaryBucketReplyMessage)msg;
                    if (reply.isSuccess()) {
                        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "DeposePrimaryBucketResponse return OK");
                        }
                    } else if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "DeposePrimaryBucketResponse return NOT_PRIMARY");
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("DeposePrimaryBucketMessage ignoring exception {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public static class DeposePrimaryBucketReplyMessage
    extends ReplyMessage {
        public DeposePrimaryBucketReplyMessage() {
        }

        public DeposePrimaryBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private DeposePrimaryBucketReplyMessage(int processorId, ReplyException re) {
            this.setProcessorId(processorId);
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "DeposePrimaryBucketReplyMessage NULL recipient");
            DeposePrimaryBucketReplyMessage m = new DeposePrimaryBucketReplyMessage(processorId, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean isSuccess() {
            return true;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "DeposePrimaryBucketReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "DeposePrimaryBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public int getDSFID() {
            return 131;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DeposePrimaryBucketReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

