/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.locks.DLockRecoverGrantorProcessor;
import org.apache.geode.distributed.internal.locks.DLockRemoteToken;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.locks.TXLockServiceImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class TXRecoverGrantorMessageProcessor
implements DLockRecoverGrantorProcessor.MessageProcessor {
    private static final Logger logger = LogService.getLogger();

    @Override
    public void process(final DistributionManager dm, final DLockRecoverGrantorProcessor.DLockRecoverGrantorMessage msg) {
        try {
            dm.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    TXRecoverGrantorMessageProcessor.this.processDLockRecoverGrantorMessage(dm, msg);
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger.debug("Rejected processing of {}", (Object)msg, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDLockRecoverGrantorMessage(DistributionManager dm, DLockRecoverGrantorProcessor.DLockRecoverGrantorMessage msg) {
        ReplyException replyException = null;
        int replyCode = 0;
        DLockRemoteToken[] heldLocks = new DLockRemoteToken[]{};
        if (logger.isDebugEnabled()) {
            logger.debug("[TXRecoverGrantorMessageProcessor.process]");
        }
        boolean gotRecoveryLock = false;
        TXLockServiceImpl dtls = null;
        try {
            Assert.assertTrue(msg.getServiceName().startsWith("DTLS"), "TXRecoverGrantorMessageProcessor cannot handle service " + msg.getServiceName());
            DLockService svc = DLockService.getInternalServiceNamed(msg.getServiceName());
            if (svc != null && (dtls = (TXLockServiceImpl)TXLockService.getDTLS()) != null) {
                dtls.acquireRecoveryWriteLock();
                gotRecoveryLock = true;
                TXCommitMessage.getTracker().waitForAllToProcess();
            }
        }
        catch (InterruptedException t) {
            Thread.currentThread().interrupt();
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TXRecoverGrantorMessageProcessor_TXRECOVERGRANTORMESSAGEPROCESSORPROCESS_THROWABLE), (Throwable)t);
            replyException = new ReplyException(t);
        }
        catch (RuntimeException t) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TXRecoverGrantorMessageProcessor_TXRECOVERGRANTORMESSAGEPROCESSORPROCESS_THROWABLE), (Throwable)t);
            if (replyException == null) {
                replyException = new ReplyException(t);
            } else {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.TXRecoverGrantorMessageProcessor_MORE_THAN_ONE_EXCEPTION_THROWN_IN__0, this), (Throwable)t);
            }
        }
        finally {
            if (gotRecoveryLock && dtls != null) {
                dtls.releaseRecoveryWriteLock();
            }
            DLockRecoverGrantorProcessor.DLockRecoverGrantorReplyMessage replyMsg = new DLockRecoverGrantorProcessor.DLockRecoverGrantorReplyMessage();
            replyMsg.setReplyCode(replyCode);
            replyMsg.setHeldLocks(heldLocks);
            replyMsg.setProcessorId(msg.getProcessorId());
            replyMsg.setRecipient(msg.getSender());
            replyMsg.setException(replyException);
            if (msg.getSender().equals(dm.getId())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("[TXRecoverGrantorMessageProcessor.process] locally process reply");
                }
                replyMsg.setSender(dm.getId());
                replyMsg.dmProcess((ClusterDistributionManager)dm);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("[TXRecoverGrantorMessageProcessor.process] send reply");
                }
                dm.putOutgoing(replyMsg);
            }
        }
    }
}

