/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntry;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeap;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryOffHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryOffHeap;

public abstract class VMStatsLRURegionEntryOffHeap
extends VMStatsLRURegionEntry
implements OffHeapRegionEntry {
    private static final VMStatsLRURegionEntryOffHeapFactory factory = new VMStatsLRURegionEntryOffHeapFactory();

    public VMStatsLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VMStatsLRURegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsLRURegionEntryOffHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VMStatsLRURegionEntryHeap.getEntryFactory();
        }
    }
}

