/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.backup.BackupOperation;
import org.apache.geode.internal.cache.backup.PrepareBackupFactory;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

class PrepareBackupOperation
extends BackupOperation {
    private static final Logger logger = LogService.getLogger();
    private final InternalDistributedMember member;
    private final InternalCache cache;
    private final Set<InternalDistributedMember> recipients;
    private final PrepareBackupFactory prepareBackupFactory;
    private final Properties properties;

    PrepareBackupOperation(DistributionManager dm, InternalDistributedMember member, InternalCache cache, Set<InternalDistributedMember> recipients, PrepareBackupFactory prepareBackupFactory, Properties properties) {
        super(dm);
        this.member = member;
        this.cache = cache;
        this.recipients = recipients;
        this.prepareBackupFactory = prepareBackupFactory;
        this.properties = properties;
    }

    @Override
    ReplyProcessor21 createReplyProcessor() {
        return this.prepareBackupFactory.createReplyProcessor(this, this.getDistributionManager(), this.recipients);
    }

    @Override
    DistributionMessage createDistributionMessage(ReplyProcessor21 replyProcessor) {
        return this.prepareBackupFactory.createRequest(this.member, this.recipients, replyProcessor.getProcessorId(), this.properties);
    }

    @Override
    void processLocally() {
        try {
            this.addToResults(this.member, this.prepareBackupFactory.createPrepareBackup(this.member, this.cache, this.properties).run());
        }
        catch (IOException | InterruptedException e) {
            logger.fatal("Failed to PrepareBackup in " + this.member, (Throwable)e);
        }
    }
}

