/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminFailureResponse;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.cache.backup.FinishBackupFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class FinishBackupRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();
    private final transient FinishBackupFactory finishBackupFactory;

    public FinishBackupRequest() {
        this.finishBackupFactory = new FinishBackupFactory();
    }

    FinishBackupRequest(InternalDistributedMember sender, Set<InternalDistributedMember> recipients, int processorId, FinishBackupFactory finishBackupFactory) {
        this.setSender(sender);
        this.setRecipients(recipients);
        this.msgId = processorId;
        this.finishBackupFactory = finishBackupFactory;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        HashSet<PersistentID> persistentIds;
        try {
            persistentIds = this.finishBackupFactory.createFinishBackup(dm.getCache()).run();
        }
        catch (IOException e) {
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.CliLegacyMessage_ERROR, this.getClass()), (Throwable)e);
            return AdminFailureResponse.create(this.getSender(), e);
        }
        return this.finishBackupFactory.createBackupResponse(this.getSender(), persistentIds);
    }

    @Override
    public int getDSFID() {
        return 2114;
    }
}

