/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.internal.cache.backup.UnixBackupInspector;
import org.apache.geode.internal.cache.backup.WindowsBackupInspector;
import org.apache.geode.internal.lang.SystemUtils;

public abstract class BackupInspector {
    private final Map<String, String> oplogLineMap = new HashMap<String, String>();
    private final Set<String> oplogFileNames = new HashSet<String>();
    private final File backupDir;

    public static BackupInspector createInspector(File backupDir) throws IOException {
        if (SystemUtils.isWindows()) {
            return new WindowsBackupInspector(backupDir);
        }
        return new UnixBackupInspector(backupDir);
    }

    BackupInspector(File backupDir) throws IOException {
        if (!backupDir.exists()) {
            throw new IOException("Backup directory " + backupDir.getAbsolutePath() + " does not exist.");
        }
        this.backupDir = backupDir;
        File restoreFile = this.getRestoreFile(backupDir);
        if (!restoreFile.exists()) {
            throw new IOException("Restore file " + restoreFile.getName() + " does not exist.");
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(restoreFile));){
            this.parseRestoreFile(reader);
        }
    }

    void addOplogLine(String filename, String line) {
        this.oplogFileNames.add(filename);
        this.oplogLineMap.put(filename, line);
    }

    String getOplogLineFromFilename(String filename) {
        return this.oplogLineMap.get(filename);
    }

    private void parseRestoreFile(BufferedReader reader) throws IOException {
        boolean markerFound = false;
        String line = null;
        while (!markerFound && null != (line = reader.readLine())) {
            markerFound = line.contains("Incremental backup.  Restore baseline originals from previous backups.");
        }
        if (markerFound) {
            this.parseOplogLines(reader);
        }
    }

    public boolean isIncremental() {
        return !this.oplogFileNames.isEmpty();
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public String getScriptLineForOplogFile(String oplogFileName) {
        return this.oplogLineMap.get(oplogFileName);
    }

    public Set<String> getIncrementalOplogFileNames() {
        return Collections.unmodifiableSet(this.oplogFileNames);
    }

    protected abstract File getRestoreFile(File var1);

    public abstract String getCopyToForOplogFile(String var1);

    public abstract String getCopyFromForOplogFile(String var1);

    protected abstract void parseOplogLines(BufferedReader var1) throws IOException;
}

