/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.cache.tier.sockets.CommBufferPool;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class TXSynchronizationRunnable
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private final CancelCriterion cancelCriterion;
    private final CommBufferPool commBufferPool;
    private Runnable firstRunnable;
    private final Object firstRunnableSync = new Object();
    private boolean firstRunnableCompleted;
    private Runnable secondRunnable;
    private final Object secondRunnableSync = new Object();
    private boolean secondRunnableCompleted;
    private boolean abort;

    public TXSynchronizationRunnable(CancelCriterion cancelCriterion, CommBufferPool commBufferPool, Runnable beforeCompletion) {
        this.cancelCriterion = cancelCriterion;
        this.commBufferPool = commBufferPool;
        this.firstRunnable = beforeCompletion;
    }

    @Override
    public void run() {
        this.commBufferPool.setTLCommBuffer();
        try {
            this.doSynchronizationOps();
        }
        finally {
            this.commBufferPool.releaseTLCommBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSynchronizationOps() {
        Object object = this.firstRunnableSync;
        synchronized (object) {
            try {
                this.firstRunnable.run();
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace("beforeCompletion notification completed");
                }
                this.firstRunnableCompleted = true;
                this.firstRunnable = null;
                this.firstRunnableSync.notifyAll();
            }
        }
        object = this.secondRunnableSync;
        synchronized (object) {
            boolean isTraceEnabled = logger.isTraceEnabled();
            while (this.secondRunnable == null && !this.abort) {
                try {
                    if (isTraceEnabled) {
                        logger.trace("waiting for afterCompletion notification");
                    }
                    this.secondRunnableSync.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (isTraceEnabled) {
                logger.trace("executing afterCompletion notification");
            }
            try {
                if (!this.abort) {
                    this.secondRunnable.run();
                }
            }
            finally {
                if (isTraceEnabled) {
                    logger.trace("afterCompletion notification completed");
                }
                this.secondRunnableCompleted = true;
                this.secondRunnable = null;
                this.secondRunnableSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFirstExecution() {
        Object object = this.firstRunnableSync;
        synchronized (object) {
            while (!this.firstRunnableCompleted) {
                try {
                    this.firstRunnableSync.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cancelCriterion.checkCancelInProgress(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSecondRunnable(Runnable r) {
        Object object = this.secondRunnableSync;
        synchronized (object) {
            this.secondRunnable = r;
            this.secondRunnableSync.notifyAll();
            while (!this.secondRunnableCompleted && !this.abort) {
                try {
                    this.secondRunnableSync.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cancelCriterion.checkCancelInProgress(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.secondRunnableSync;
        synchronized (object) {
            this.abort = true;
        }
    }
}

