/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.CopyHelper;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.DeltaSerializationException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.LogWriter;
import org.apache.geode.Statistics;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.internal.SystemMemberCacheEventProcessor;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.DiskWriteAttributesFactory;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.FailedSynchronizationException;
import org.apache.geode.cache.InterestRegistrationEvent;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionReinitializedException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.SubscriptionNotEnabledException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ServerRegionProxy;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.persistence.ConflictingPersistentDataException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.CacheStatisticsImpl;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.ClientRegionEventImpl;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.CustomEntryExpiryTask;
import org.apache.geode.internal.cache.DiskInitFile;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DistTXState;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntriesSet;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntryExpiryTask;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ExpirationScheduler;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.ImageState;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InterestEvent;
import org.apache.geode.internal.cache.InterestFilter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalDataView;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LoaderHelperFactory;
import org.apache.geode.internal.cache.LoaderHelperImpl;
import org.apache.geode.internal.cache.LocalRegionDataView;
import org.apache.geode.internal.cache.NetSearchExpirationCalculator;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.RegionExpiryTask;
import org.apache.geode.internal.cache.RegionIdleExpiryTask;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.RegionMapFactory;
import org.apache.geode.internal.cache.RegionTTLExpiryTask;
import org.apache.geode.internal.cache.SearchLoadAndWriteProcessor;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXRegionState;
import org.apache.geode.internal.cache.TXRmtEvent;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TXStateProxyImpl;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.UnsharedImageState;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.apache.geode.internal.cache.VersionTagHolder;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.MemoryEvent;
import org.apache.geode.internal.cache.control.MemoryThresholds;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.event.EventTracker;
import org.apache.geode.internal.cache.event.NonDistributedEventTracker;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.RegionFunctionContextImpl;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.RedundancyAlreadyMetException;
import org.apache.geode.internal.cache.persistence.DefaultDiskDirs;
import org.apache.geode.internal.cache.persistence.DiskExceptionHandler;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.query.IndexMap;
import org.apache.geode.internal.cache.persistence.query.mock.IndexMapImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientTombstoneMessage;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.RegionVersionHolder;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.Releasable;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.geode.internal.util.concurrent.FutureResult;
import org.apache.geode.internal.util.concurrent.StoppableCountDownLatch;
import org.apache.geode.internal.util.concurrent.StoppableReadWriteLock;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class LocalRegion
extends AbstractRegion
implements LoaderHelperFactory,
ResourceListener<MemoryEvent>,
DiskExceptionHandler,
DiskRecoveryStore {
    static final Logger logger = LogService.getLogger();
    public static final int AFTER_INITIAL_IMAGE = 0;
    public static final int BEFORE_INITIAL_IMAGE = 1;
    public static final int ANY_INIT = 2;
    private static final ThreadLocal<Integer> initializationThread = new ThreadLocal();
    static final ThreadLocal isConversion = new ThreadLocal();
    private Object regionUserAttribute;
    Map entryUserAttributes;
    private final String regionName;
    protected final LocalRegion parentRegion;
    private volatile boolean reinitialized_old = false;
    protected volatile boolean isDestroyed = false;
    volatile boolean isDestroyedForParallelWAN = false;
    private volatile boolean reinitialized_new = false;
    private Semaphore destroyLock;
    private RegionTTLExpiryTask regionTTLExpiryTask = null;
    private RegionIdleExpiryTask regionIdleExpiryTask = null;
    private final Object regionExpiryLock = new Object();
    private int txRefCount;
    private final ConcurrentHashMap<RegionEntry, EntryExpiryTask> entryExpiryTasks = new ConcurrentHashMap();
    volatile boolean regionInvalid = false;
    public final RegionMap entries;
    private final boolean supportsTX;
    private final RegionVersionVector versionVector;
    private static final Pattern[] QUERY_PATTERNS = new Pattern[]{Pattern.compile("^\\(*select .*", 98), Pattern.compile("^import .*", 98)};
    public static final String EXPIRY_MS_PROPERTY = "gemfire.EXPIRY_UNITS_MS";
    final boolean EXPIRY_UNITS_MS;
    private final boolean entriesInitialized;
    protected volatile ConcurrentMap subregions;
    private final Object subregionsLock = new Object();
    final StoppableCountDownLatch initializationLatchBeforeGetInitialImage;
    final StoppableCountDownLatch initializationLatchAfterGetInitialImage;
    private final StoppableCountDownLatch afterRegionCreateEventLatch;
    private volatile boolean initialized = false;
    private final DiskRegion diskRegion;
    private volatile StoppableReadWriteLock txExpirationLock;
    private final ConcurrentMap getFutures = new ConcurrentHashMap();
    public static boolean ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
    private final boolean isUsedForPartitionedRegionAdmin;
    private final boolean isUsedForPartitionedRegionBucket;
    private final boolean isUsedForMetaRegion;
    private final boolean isMetaRegionWithTransactions;
    private final boolean isUsedForSerialGatewaySenderQueue;
    private final boolean isUsedForParallelGatewaySenderQueue;
    private final AbstractGatewaySender serialGatewaySender;
    final LoaderHelperFactory loaderHelperFactory;
    private final CachePerfStats cachePerfStats;
    private final boolean hasOwnStats;
    private final ImageState imageState;
    private final EventTracker eventTracker;
    private int riCnt = 0;
    private volatile HashMap destroyedSubregionSerialNumbers;
    public final AtomicBoolean memoryThresholdReached = new AtomicBoolean(false);
    private final Lock clientMetaDataLock = new ReentrantLock();
    protected final CancelCriterion stopper = this.createStopper();
    private final TestCallable testCallable;
    private static final ThreadLocal<LocalRegion> initializingRegion = new ThreadLocal();
    private final CopyOnWriteHashMap<String, CacheServiceProfile> cacheServiceProfiles = new CopyOnWriteHashMap();
    final ServerRegionProxy serverRegionProxy;
    private final InternalDataView sharedDataView;
    private final String fullPath;
    private final boolean doExpensiveValidations = Boolean.getBoolean("gemfire.DO_EXPENSIVE_VALIDATIONS");
    private final AtomicInteger tombstoneCount = new AtomicInteger();
    private boolean concurrencyMessageIssued;
    private static final byte SNAPSHOT_VERSION = 1;
    private static final byte SNAPSHOT_VALUE_OBJ = 23;
    private static final byte SNAPSHOT_VALUE_INVALID = 24;
    private static final byte SNAPSHOT_VALUE_LOCAL_INVALID = 25;
    public static final float DEFAULT_HEAPLRU_EVICTION_HEAP_PERCENTAGE = 80.0f;
    protected final boolean restoreSetOperationTransactionBehavior = SystemPropertyHelper.restoreSetOperationTransactionBehavior();
    private final DiskStoreImpl diskStoreImpl;
    FilterProfile filterProfile;
    private static final DistributionAdvisor.ProfileVisitor<Void> netLoaderVisitor = new DistributionAdvisor.ProfileVisitor<Void>(){

        @Override
        public boolean visit(DistributionAdvisor advisor, DistributionAdvisor.Profile profile, int profileIndex, int numProfiles, Void aggregate) {
            assert (profile instanceof CacheDistributionAdvisor.CacheProfile);
            CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
            if (prof.regionInitialized) {
                return !prof.hasCacheLoader;
            }
            return true;
        }
    };
    private static final DistributionAdvisor.ProfileVisitor<Void> netWriterVisitor = new DistributionAdvisor.ProfileVisitor<Void>(){

        @Override
        public boolean visit(DistributionAdvisor advisor, DistributionAdvisor.Profile profile, int profileIndex, int numProfiles, Void aggregate) {
            assert (profile instanceof CacheDistributionAdvisor.CacheProfile);
            CacheDistributionAdvisor.CacheProfile prof = (CacheDistributionAdvisor.CacheProfile)profile;
            if (!prof.inRecovery) {
                return !prof.hasCacheWriter;
            }
            return true;
        }
    };

    public CancelCriterion createStopper() {
        return new Stopper();
    }

    protected CancelCriterion getStopper() {
        return this.stopper;
    }

    static LocalRegion getInitializingRegion() {
        return initializingRegion.get();
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    private static String calcFullPath(String regionName, LocalRegion parentRegion) {
        StringBuilder buf = null;
        if (parentRegion == null) {
            buf = new StringBuilder(regionName.length() + 1);
        } else {
            String parentFull = parentRegion.getFullPath();
            buf = new StringBuilder(parentFull.length() + regionName.length() + 1);
            buf.append(parentFull);
        }
        buf.append("/").append(regionName);
        return buf.toString();
    }

    protected LocalRegion(String regionName, RegionAttributes attrs, LocalRegion parentRegion, InternalCache cache, InternalRegionArguments internalRegionArgs) throws DiskAccessException {
        super(cache, attrs, regionName, internalRegionArgs);
        this.EXPIRY_UNITS_MS = parentRegion != null ? parentRegion.EXPIRY_UNITS_MS : Boolean.getBoolean(EXPIRY_MS_PROPERTY);
        Assert.assertTrue(regionName != null, "regionName must not be null");
        this.sharedDataView = this.buildDataView();
        this.regionName = regionName;
        this.parentRegion = parentRegion;
        this.fullPath = LocalRegion.calcFullPath(regionName, parentRegion);
        String myName = this.getFullPath();
        if (internalRegionArgs.getPartitionedRegion() != null) {
            myName = internalRegionArgs.getPartitionedRegion().getFullPath();
        }
        boolean bl = this.offHeap = attrs.getOffHeap() || Boolean.getBoolean(myName + ":OFF_HEAP");
        if (this.getOffHeap() && cache.getOffHeapStore() == null) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_THE_REGION_0_WAS_CONFIGURED_TO_USE_OFF_HEAP_MEMORY_BUT_OFF_HEAP_NOT_CONFIGURED.toLocalizedString(myName));
        }
        this.initializationLatchBeforeGetInitialImage = new StoppableCountDownLatch(this.stopper, 1);
        this.initializationLatchAfterGetInitialImage = new StoppableCountDownLatch(this.stopper, 1);
        this.afterRegionCreateEventLatch = new StoppableCountDownLatch(this.stopper, 1);
        if (internalRegionArgs.getUserAttribute() != null) {
            this.setUserAttribute(internalRegionArgs.getUserAttribute());
        }
        initializingRegion.set(this);
        if (internalRegionArgs.getCachePerfStatsHolder() != null) {
            this.hasOwnStats = false;
            this.cachePerfStats = internalRegionArgs.getCachePerfStatsHolder().getCachePerfStats();
        } else if (attrs.getPartitionAttributes() != null || this.isInternalRegion() || internalRegionArgs.isUsedForMetaRegion()) {
            this.hasOwnStats = false;
            this.cachePerfStats = cache.getCachePerfStats();
        } else {
            this.hasOwnStats = true;
            this.cachePerfStats = new RegionPerfStats(cache, cache.getCachePerfStats(), regionName);
        }
        this.diskStoreImpl = this.findDiskStore(attrs, internalRegionArgs);
        this.diskRegion = this.createDiskRegion(internalRegionArgs);
        this.entries = this.createRegionMap(internalRegionArgs);
        this.entriesInitialized = true;
        this.subregions = new ConcurrentHashMap();
        if (parentRegion == null) {
            this.initRoot();
        }
        this.loaderHelperFactory = internalRegionArgs.getLoaderHelperFactory() != null ? internalRegionArgs.getLoaderHelperFactory() : this;
        this.isUsedForPartitionedRegionAdmin = internalRegionArgs.isUsedForPartitionedRegionAdmin();
        this.isUsedForPartitionedRegionBucket = internalRegionArgs.isUsedForPartitionedRegionBucket();
        this.isUsedForMetaRegion = internalRegionArgs.isUsedForMetaRegion();
        this.isMetaRegionWithTransactions = internalRegionArgs.isMetaRegionWithTransactions();
        this.isUsedForSerialGatewaySenderQueue = internalRegionArgs.isUsedForSerialGatewaySenderQueue();
        this.isUsedForParallelGatewaySenderQueue = internalRegionArgs.isUsedForParallelGatewaySenderQueue();
        this.serialGatewaySender = internalRegionArgs.getSerialGatewaySender();
        if (internalRegionArgs.getCacheServiceProfiles() != null) {
            this.cacheServiceProfiles.putAll(internalRegionArgs.getCacheServiceProfiles());
        }
        if (!(this.isUsedForMetaRegion || this.isUsedForPartitionedRegionAdmin || this.isUsedForPartitionedRegionBucket || this.isUsedForSerialGatewaySenderQueue || this.isUsedForParallelGatewaySenderQueue)) {
            this.filterProfile = new FilterProfile(this);
        }
        this.serverRegionProxy = this.getPoolName() != null ? new ServerRegionProxy(this) : null;
        this.imageState = new UnsharedImageState(this.serverRegionProxy != null, this.getDataPolicy().withReplication() || this.getDataPolicy().isPreloaded(), this.getAttributes().getDataPolicy().withPersistence(), this.stopper);
        this.supportsTX = !this.isSecret() && !this.isUsedForPartitionedRegionAdmin() && !this.isUsedForMetaRegion() || this.isMetaRegionWithTransactions();
        this.testCallable = internalRegionArgs.getTestCallable();
        this.eventTracker = this.createEventTracker();
        this.versionVector = this.createRegionVersionVector();
    }

    protected EventTracker createEventTracker() {
        return NonDistributedEventTracker.getInstance();
    }

    private RegionMap createRegionMap(InternalRegionArguments internalRegionArgs) {
        RegionMap result = null;
        if (this.diskRegion != null) {
            result = this.diskRegion.useExistingRegionMap(this);
        }
        if (result == null) {
            RegionMap.Attributes ma = new RegionMap.Attributes();
            ma.statisticsEnabled = this.statisticsEnabled;
            ma.loadFactor = this.loadFactor;
            ma.initialCapacity = this.initialCapacity;
            ma.concurrencyLevel = this.concurrencyLevel;
            result = RegionMapFactory.createVM(this, ma, internalRegionArgs);
        }
        return result;
    }

    protected InternalDataView buildDataView() {
        return new LocalRegionDataView();
    }

    public EventTracker getEventTracker() {
        return this.eventTracker;
    }

    @Override
    public RegionVersionVector getVersionVector() {
        return this.versionVector;
    }

    Object getSizeGuard() {
        if (!this.getConcurrencyChecksEnabled()) {
            return new Object();
        }
        return this.fullPath;
    }

    protected RegionVersionVector createRegionVersionVector() {
        if (this.getConcurrencyChecksEnabled()) {
            return this.createVersionVector();
        }
        return null;
    }

    private RegionVersionVector createVersionVector() {
        RegionVersionVector<?> regionVersionVector = RegionVersionVector.create(this.getVersionMember(), this);
        if (this.getDataPolicy().withPersistence()) {
            RegionVersionVector diskVector = this.diskRegion.getRegionVersionVector();
            regionVersionVector.recordVersions(diskVector.getCloneForTransmission());
        } else if (!this.getDataPolicy().withStorage()) {
            regionVersionVector.turnOffRecordingForEmptyRegion();
        }
        if (this.serverRegionProxy != null) {
            regionVersionVector.setIsClientVector();
        }
        this.cache.getDistributionManager().addMembershipListener(regionVersionVector);
        return regionVersionVector;
    }

    @Override
    protected void updateEntryExpiryPossible() {
        super.updateEntryExpiryPossible();
        if (!this.isEntryExpiryPossible()) {
            this.cancelAllEntryExpiryTasks();
        }
    }

    boolean isCacheClosing() {
        return this.cache.isClosed();
    }

    @Override
    public RegionEntry getRegionEntry(Object key) {
        return this.entries.getEntry(key);
    }

    public VersionTag getVersionTag(Object key) {
        Region.Entry entry = this.getEntry(key, true);
        VersionTag tag = null;
        if (entry != null && entry instanceof EntrySnapshot) {
            tag = ((EntrySnapshot)entry).getVersionTag();
        } else if (entry != null && entry instanceof NonTXEntry) {
            tag = ((NonTXEntry)entry).getRegionEntry().getVersionStamp().asVersionTag();
        }
        return tag;
    }

    private void destroyEntriesAndClearDestroyedKeysSet() {
        ImageState is = this.getImageState();
        Iterator iter = is.getDestroyedEntries();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.entries.removeIfDestroyed(key);
        }
    }

    @Override
    public ServerRegionProxy getServerProxy() {
        return this.serverRegionProxy;
    }

    @Override
    public boolean hasServerProxy() {
        return this.serverRegionProxy != null;
    }

    protected boolean isExpirationAllowed(ExpiryTask expiry) {
        return true;
    }

    void performExpiryTimeout(ExpiryTask expiryTask) throws CacheException {
        if (expiryTask != null) {
            expiryTask.basicPerformTimeout(false);
        }
    }

    private void initRoot() {
        this.destroyLock = new Semaphore(1);
    }

    public void handleMarker() {
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.MARKER, null, false, (DistributedMember)this.getMyId(), false);
        this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_LIVE, event);
    }

    public AttributesMutator getAttributesMutator() {
        this.checkReadiness();
        return this;
    }

    public Region createSubregion(String subregionName, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        try {
            return this.createSubregion(subregionName, aRegionAttributes, new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_EXCEPTION.toLocalizedString(), e);
        }
    }

    @Override
    public InternalDistributedMember getMyId() {
        return this.cache.getInternalDistributedSystem().getDistributedMember();
    }

    @Override
    public VersionSource getVersionMember() {
        if (this.getDataPolicy().withPersistence()) {
            return this.getDiskStore().getDiskStoreID();
        }
        return this.cache.getInternalDistributedSystem().getDistributedMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region createSubregion(String subregionName, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        this.checkReadiness();
        RegionAttributes regionAttributes = attrs;
        attrs = this.cache.invokeRegionBefore(this, subregionName, attrs, internalRegionArgs);
        InputStream snapshotInputStream = internalRegionArgs.getSnapshotInputStream();
        boolean getDestroyLock = internalRegionArgs.getDestroyLockFlag();
        InternalDistributedMember imageTarget = internalRegionArgs.getImageTarget();
        LocalRegion newRegion = null;
        try {
            if (getDestroyLock) {
                this.acquireDestroyLock();
            }
            LocalRegion existing = null;
            try {
                if (this.isDestroyed()) {
                    if (this.reinitialized_old) {
                        throw new RegionReinitializedException(this.toString(), this.getFullPath());
                    }
                    throw new RegionDestroyedException(this.toString(), this.getFullPath());
                }
                LocalRegion.validateRegionName(subregionName, internalRegionArgs);
                this.validateSubregionAttributes(regionAttributes);
                Object object = this.subregionsLock;
                synchronized (object) {
                    existing = (LocalRegion)this.subregions.get(subregionName);
                    if (existing == null) {
                        if (regionAttributes.getScope().isDistributed() && internalRegionArgs.isUsedForPartitionedRegionBucket()) {
                            PartitionedRegion pr = internalRegionArgs.getPartitionedRegion();
                            internalRegionArgs.setUserAttribute(pr.getUserAttribute());
                            newRegion = pr.isShadowPR() ? new BucketRegionQueue(subregionName, regionAttributes, this, this.cache, internalRegionArgs) : new BucketRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs);
                        } else {
                            boolean local;
                            newRegion = regionAttributes.getPartitionAttributes() != null ? new PartitionedRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs) : ((local = regionAttributes.getScope().isLocal()) ? new LocalRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs) : new DistributedRegion(subregionName, regionAttributes, this, this.cache, internalRegionArgs));
                        }
                        LocalRegion previousValue = this.subregions.putIfAbsent(subregionName, newRegion);
                        Assert.assertTrue(previousValue == null);
                        Assert.assertTrue(!newRegion.isInitialized());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Subregion created: {}", (Object)newRegion.getFullPath());
                        }
                        if (snapshotInputStream != null || imageTarget != null || internalRegionArgs.getRecreateFlag()) {
                            this.cache.regionReinitialized(newRegion);
                        }
                    }
                }
            }
            finally {
                if (getDestroyLock) {
                    this.releaseDestroyLock();
                }
            }
            if (existing != null) {
                existing.waitOnInitialization();
                throw new RegionExistsException(existing);
            }
            boolean success = false;
            try {
                newRegion.checkReadiness();
                this.cache.setRegionByPath(newRegion.getFullPath(), newRegion);
                if (regionAttributes instanceof UserSpecifiedRegionAttributes) {
                    internalRegionArgs.setIndexes(((UserSpecifiedRegionAttributes)regionAttributes).getIndexes());
                }
                newRegion.initialize(snapshotInputStream, imageTarget, internalRegionArgs);
                if (!newRegion.isInternalRegion() && !newRegion.isDestroyed) {
                    this.cache.getInternalResourceManager().addResourceListener(InternalResourceManager.ResourceType.MEMORY, newRegion);
                    if (!newRegion.getOffHeap()) {
                        newRegion.initialCriticalMembers(this.cache.getInternalResourceManager().getHeapMonitor().getState().isCritical(), this.cache.getResourceAdvisor().adviseCritialMembers());
                    } else {
                        newRegion.initialCriticalMembers(this.cache.getInternalResourceManager().getHeapMonitor().getState().isCritical() || this.cache.getInternalResourceManager().getOffHeapMonitor().getState().isCritical(), this.cache.getResourceAdvisor().adviseCritialMembers());
                    }
                    InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
                    system.handleResourceEvent(ResourceEvent.REGION_CREATE, newRegion);
                }
                success = true;
            }
            catch (CancelException | RegionDestroyedException | RedundancyAlreadyMetException e) {
                throw e;
            }
            catch (RuntimeException validationException) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_INITIALIZATION_FAILED_FOR_REGION_0, this.getFullPath()), (Throwable)validationException);
                throw validationException;
            }
            finally {
                if (!success) {
                    this.cache.setRegionByPath(newRegion.getFullPath(), null);
                    this.initializationFailed(newRegion);
                    this.cache.getInternalResourceManager(false).removeResourceListener(newRegion);
                }
            }
            newRegion.postCreateRegion();
        }
        finally {
            if (newRegion != null && !newRegion.isInitialized() && logger.isDebugEnabled()) {
                logger.debug("Region initialize latch is closed, Error must have occurred");
            }
        }
        this.cache.invokeRegionAfter(newRegion);
        return newRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Object key, Object value, Object aCallbackArgument) throws TimeoutException, EntryExistsException, CacheWriterException {
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = this.newCreateEntryEvent(key, value, aCallbackArgument);
        try {
            this.validatedCreate(event, startPut);
        }
        finally {
            event.release();
        }
    }

    private void validatedCreate(EntryEventImpl event, long startPut) throws TimeoutException, EntryExistsException, CacheWriterException {
        if (event.getEventId() == null && this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        if (this.getDataPolicy() == DataPolicy.NORMAL) {
            event.setLocalInvalid(true);
        }
        this.discoverJTA();
        if (!this.basicPut(event, true, false, null, true)) {
            throw new EntryExistsException(event.getKey().toString(), event.getOldValue());
        }
        if (!this.getDataView().isDeferredStats()) {
            this.getCachePerfStats().endPut(startPut, false);
        }
    }

    private EntryEventImpl newCreateEntryEvent(Object key, Object value, Object aCallbackArgument) {
        this.validateArguments(key, value, aCallbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        return EntryEventImpl.create(this, Operation.CREATE, key, value, aCallbackArgument, false, this.getMyId()).setCreate(true);
    }

    @Override
    public boolean generateEventID() {
        return !this.isUsedForPartitionedRegionAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object destroy(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        EntryEventImpl event = this.newDestroyEntryEvent(key, aCallbackArgument);
        try {
            Object object = this.validatedDestroy(key, event);
            return object;
        }
        finally {
            event.release();
        }
    }

    public Object validatedDestroy(Object key, EntryEventImpl event) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        if (event.getEventId() == null && this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        this.basicDestroy(event, true, null);
        if (event.isOldValueOffHeap()) {
            return null;
        }
        return LocalRegion.handleNotAvailable(event.getOldValue());
    }

    EntryEventImpl newDestroyEntryEvent(Object key, Object aCallbackArgument) {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        return EntryEventImpl.create(this, Operation.DESTROY, key, null, aCallbackArgument, false, this.getMyId());
    }

    @Override
    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        this.cache.invokeBeforeDestroyed(this);
        this.getDataView().checkSupportsRegionDestroy();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_DESTROY, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicDestroyRegion(event, true);
    }

    public InternalDataView getDataView() {
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            return this.sharedDataView;
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDeserializedValue(RegionEntry regionEntry, KeyInfo keyInfo, boolean updateStats, boolean disableCopyOnRead, boolean preferCachedDeserializable, EntryEventImpl clientEvent, boolean returnTombstones, boolean retainResult) {
        if (this.diskRegion != null) {
            this.diskRegion.setClearCountReference();
        }
        try {
            Object value;
            block21: {
                if (regionEntry == null) {
                    regionEntry = this.entries.getEntry(keyInfo.getKey());
                }
                if (regionEntry == null) {
                    Object var9_9 = null;
                    return var9_9;
                }
                if (clientEvent != null && regionEntry.getVersionStamp() != null) {
                    boolean disabled = this.entries.disableLruUpdateCallback();
                    try {
                        RegionEntry regionEntry2 = regionEntry;
                        synchronized (regionEntry2) {
                            clientEvent.setVersionTag(regionEntry.getVersionStamp().asVersionTag());
                            value = this.getDeserialized(regionEntry, updateStats, disableCopyOnRead, preferCachedDeserializable, retainResult);
                            break block21;
                        }
                    }
                    finally {
                        if (disabled) {
                            this.entries.enableLruUpdateCallback();
                        }
                        try {
                            this.entries.lruUpdateCallback();
                        }
                        catch (DiskAccessException dae) {
                            this.handleDiskAccessException(dae);
                            throw dae;
                        }
                    }
                }
                value = this.getDeserialized(regionEntry, updateStats, disableCopyOnRead, preferCachedDeserializable, retainResult);
            }
            if (logger.isTraceEnabled() && !(this instanceof HARegion)) {
                logger.trace("getDeserializedValue for {} returning version: {} returnTombstones: {} value: {}", keyInfo.getKey(), regionEntry.getVersionStamp() == null ? "null" : regionEntry.getVersionStamp().asVersionTag(), (Object)returnTombstones, value);
            }
            Object object = value;
            return object;
        }
        finally {
            if (this.diskRegion != null) {
                this.diskRegion.removeClearCountReference();
            }
        }
    }

    Object getDeserialized(RegionEntry regionEntry, boolean updateStats, boolean disableCopyOnRead, boolean preferCachedDeserializable, boolean retainResult) {
        assert (!retainResult || preferCachedDeserializable);
        boolean disabledLRUCallback = this.entries.disableLruUpdateCallback();
        try {
            Object value;
            try {
                value = retainResult ? regionEntry.getValueRetain(this) : regionEntry.getValue(this);
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                throw dae;
            }
            if (value == null) {
                Object var8_10 = null;
                return var8_10;
            }
            if (value instanceof CachedDeserializable) {
                if (!preferCachedDeserializable) {
                    value = this.isCopyOnRead() ? (disableCopyOnRead ? ((CachedDeserializable)value).getDeserializedForReading() : ((CachedDeserializable)value).getDeserializedWritableCopy(this, regionEntry)) : ((CachedDeserializable)value).getDeserializedValue(this, regionEntry);
                }
            } else if (!disableCopyOnRead) {
                value = this.conditionalCopy(value);
            }
            if (updateStats) {
                this.updateStatsForGet(regionEntry, value != null && !Token.isInvalid(value));
            }
            Object object = value;
            return object;
        }
        catch (IllegalArgumentException i) {
            throw new IllegalArgumentException(LocalizedStrings.DONT_RELEASE.toLocalizedString("Error while deserializing value for key=" + regionEntry.getKey()), i);
        }
        finally {
            if (disabledLRUCallback) {
                this.entries.enableLruUpdateCallback();
                this.entries.lruUpdateCallback();
            }
        }
    }

    @Override
    public Object get(Object key, Object aCallbackArgument, boolean generateCallbacks, EntryEventImpl clientEvent) throws TimeoutException, CacheLoaderException {
        Object result = this.get(key, aCallbackArgument, generateCallbacks, false, false, null, clientEvent, false);
        if (Token.isInvalid(result)) {
            result = null;
        }
        return result;
    }

    public Object get(Object key, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws TimeoutException, CacheLoaderException {
        return this.get(key, aCallbackArgument, generateCallbacks, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones, false, false);
    }

    public Object getRetained(Object key, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws TimeoutException, CacheLoaderException {
        return this.getRetained(key, aCallbackArgument, generateCallbacks, disableCopyOnRead, requestingClient, clientEvent, returnTombstones, false);
    }

    private Object getRetained(Object key, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean opScopeIsLocal) throws TimeoutException, CacheLoaderException {
        return this.get(key, aCallbackArgument, generateCallbacks, disableCopyOnRead, true, requestingClient, clientEvent, returnTombstones, opScopeIsLocal, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, Object aCallbackArgument, boolean generateCallbacks, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones, boolean opScopeIsLocal, boolean retainResult) throws TimeoutException, CacheLoaderException {
        assert (!retainResult || preferCD);
        this.validateKey(key);
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        CachePerfStats stats = this.getCachePerfStats();
        long start = stats.startGet();
        boolean isMiss = true;
        try {
            KeyInfo keyInfo = this.getKeyInfo(key, aCallbackArgument);
            Object value = this.getDataView().getDeserializedValue(keyInfo, this, true, disableCopyOnRead, preferCD, clientEvent, returnTombstones, retainResult);
            boolean isCreate = value == null;
            boolean bl = isMiss = value == null || Token.isInvalid(value) || !returnTombstones && value == Token.TOMBSTONE;
            if (isMiss) {
                if (!opScopeIsLocal && (this.getScope().isDistributed() || this.hasServerProxy() || this.basicGetLoader() != null)) {
                    value = this.getDataView().findObject(keyInfo, this, isCreate, generateCallbacks, value, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
                    if (!returnTombstones && value == Token.TOMBSTONE) {
                        value = null;
                    }
                } else {
                    if (isCreate) {
                        this.recordMiss(null, key);
                    }
                    value = null;
                }
            }
            Object object = value;
            return object;
        }
        finally {
            stats.endGet(start, isMiss);
        }
    }

    public void recordMiss(RegionEntry re, Object key) {
        if (!this.statisticsEnabled) {
            return;
        }
        RegionEntry e = re == null && !this.isTX() ? this.basicGetEntry(key) : re;
        this.updateStatsForGet(e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Object nonTxnFindObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws TimeoutException, CacheLoaderException {
        block22: {
            block19: {
                block21: {
                    block17: {
                        block20: {
                            block18: {
                                result = null;
                                thisFuture = new FutureResult(this.stopper);
                                otherFuture = this.getFutures.putIfAbsent(keyInfo.getKey(), thisFuture);
                                if (otherFuture != null) {
                                    try {
                                        valueAndVersion = (Object[])otherFuture.get();
                                        if (valueAndVersion != null) {
                                            result = valueAndVersion[0];
                                            if (clientEvent != null) {
                                                clientEvent.setVersionTag((VersionTag)valueAndVersion[1]);
                                            }
                                            if (!preferCD && result instanceof CachedDeserializable) {
                                                cd = (CachedDeserializable)result;
                                                result = !disableCopyOnRead && this.isCopyOnRead() ? cd.getDeserializedWritableCopy(null, null) : cd.getDeserializedForReading();
                                            } else if (!disableCopyOnRead) {
                                                result = this.conditionalCopy(result);
                                            }
                                            if (isCreate) {
                                                regionEntry = this.basicGetEntry(keyInfo.getKey());
                                                this.updateStatsForGet(regionEntry, true);
                                            }
                                            return result;
                                        }
                                    }
                                    catch (InterruptedException ignore) {
                                        Thread.currentThread().interrupt();
                                        return null;
                                    }
                                    catch (ExecutionException e) {
                                        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_EXCEPTION.toLocalizedString(), e);
                                    }
                                }
                                try {
                                    partitioned = this.getDataPolicy().withPartitioning();
                                    if (partitioned) ** GOTO lbl57
                                    localValue = this.getDeserializedValue(null, keyInfo, isCreate, disableCopyOnRead, preferCD, clientEvent, false, false);
                                    if (localValue == null || Token.isInvalid(localValue)) break block17;
                                    var14_19 = result = localValue;
                                    if (result == null) break block18;
                                    tag = clientEvent == null ? null : clientEvent.getVersionTag();
                                }
                                catch (Throwable var16_21) {
                                    if (result != null) {
                                        tag = clientEvent == null ? null : clientEvent.getVersionTag();
                                        thisFuture.set(new Object[]{result, tag});
                                    } else {
                                        thisFuture.set(null);
                                    }
                                    this.getFutures.remove(keyInfo.getKey());
                                    throw var16_21;
                                }
                                thisFuture.set(new Object[]{result, tag});
                                break block20;
                            }
                            thisFuture.set(null);
                        }
                        this.getFutures.remove(keyInfo.getKey());
                        return var14_19;
                    }
                    isCreate = localValue == null;
                    result = this.findObjectInSystem(keyInfo, isCreate, null, generateCallbacks, localValue, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
                    break block21;
lbl57:
                    // 1 sources

                    result = this.getSharedDataView().findObject(keyInfo, this, isCreate, generateCallbacks, localValue, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
                }
                if (result == null && localValue != null && (localValue != Token.TOMBSTONE || returnTombstones)) {
                    result = localValue;
                }
                if (result == null) break block19;
                tag = clientEvent == null ? null : clientEvent.getVersionTag();
                thisFuture.set(new Object[]{result, tag});
                break block22;
            }
            thisFuture.set(null);
        }
        this.getFutures.remove(keyInfo.getKey());
        if (!disableCopyOnRead) {
            result = this.conditionalCopy(result);
        }
        return result;
    }

    protected boolean isCopyOnRead() {
        return this.compressor == null && this.cache.isCopyOnRead() && !this.isUsedForPartitionedRegionAdmin && !this.isUsedForMetaRegion && !this.getOffHeap() && !this.isSecret();
    }

    Object conditionalCopy(Object o) {
        if (this.isCopyOnRead() && !Token.isInvalid(o)) {
            return CopyHelper.copy(o);
        }
        return o;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public Region getParentRegion() {
        return this.parentRegion;
    }

    public Region getSubregion(String path) {
        this.checkReadiness();
        return this.getSubregion(path, false);
    }

    @Override
    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        this.getDataView().checkSupportsRegionInvalidate();
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_INVALIDATE, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.basicInvalidateRegion(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value, Object aCallbackArgument) throws TimeoutException, CacheWriterException {
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = this.newUpdateEntryEvent(key, value, aCallbackArgument);
        try {
            Object object = this.validatedPut(event, startPut);
            return object;
        }
        finally {
            event.release();
        }
    }

    Object validatedPut(EntryEventImpl event, long startPut) throws TimeoutException, CacheWriterException {
        if (event.getEventId() == null && this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        Object oldValue = null;
        if (this.basicPut(event, false, false, null, false)) {
            if (!event.isOldValueOffHeap()) {
                oldValue = event.getOldValue();
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
        }
        return LocalRegion.handleNotAvailable(oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntryEventImpl newUpdateEntryEvent(Object key, Object value, Object aCallbackArgument) {
        this.validateArguments(key, value, aCallbackArgument);
        if (value == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.UPDATE, key, value, aCallbackArgument, false, this.getMyId());
        boolean eventReturned = false;
        try {
            this.extractDeltaIntoEvent(value, event);
            eventReturned = true;
            EntryEventImpl entryEventImpl = event;
            return entryEventImpl;
        }
        finally {
            if (!eventReturned) {
                event.release();
            }
        }
    }

    private void extractDeltaIntoEvent(Object value, EntryEventImpl event) {
        block13: {
            try {
                if (!this.getSystem().getConfig().getDeltaPropagation() || !(value instanceof Delta)) break block13;
                boolean extractDelta = false;
                if (!this.hasServerProxy()) {
                    if (this instanceof PartitionedRegion) {
                        InternalDistributedMember ids;
                        extractDelta = ((PartitionedRegion)this).getRedundantCopies() > 0 ? true : ((ids = (InternalDistributedMember)PartitionRegionHelper.getPrimaryMemberForKey(this, event.getKey())) != null ? !this.getSystem().getMemberId().equals(ids.getId()) || this.hasAdjunctRecipientsNeedingDelta(event) : true);
                    } else if (this instanceof DistributedRegion && !((DistributedRegion)this).scope.isDistributedNoAck() && !((CacheDistributionAdvisee)((Object)this)).getCacheDistributionAdvisor().adviseCacheOp().isEmpty()) {
                        extractDelta = true;
                    }
                    if (!extractDelta && ClientHealthMonitor.getInstance() != null) {
                        extractDelta = ClientHealthMonitor.getInstance().hasDeltaClients();
                    }
                } else if (this.getSystem().isDeltaEnabledOnServer()) {
                    extractDelta = true;
                }
                if (!extractDelta || !((Delta)value).hasDelta()) break block13;
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                long start = DistributionStats.getStatTime();
                try {
                    ((Delta)value).toDelta(hdos);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new DeltaSerializationException(LocalizedStrings.DistributionManager_CAUGHT_EXCEPTION_WHILE_SENDING_DELTA.toLocalizedString(), e);
                }
                event.setDeltaBytes(hdos.toByteArray());
                this.getCachePerfStats().endDeltaPrepared(start);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new InternalGemFireException(e);
            }
        }
    }

    private boolean hasAdjunctRecipientsNeedingDelta(EntryEventImpl event) {
        BucketRegion bucketRegion;
        PartitionedRegion partitionedRegion = (PartitionedRegion)this;
        int bId = event.getKeyInfo().getBucketId();
        try {
            bucketRegion = partitionedRegion.dataStore.getInitializedBucketForId(event.getKey(), bId);
        }
        catch (ForceReattemptException ignore) {
            return true;
        }
        Set recipients = bucketRegion.getCacheDistributionAdvisor().adviseUpdate(event);
        Set twoMessages = bucketRegion.getBucketAdvisor().adviseRequiresTwoMessages();
        CacheDistributionAdvisor cda = partitionedRegion.getCacheDistributionAdvisor();
        FilterRoutingInfo filterRouting = cda.adviseFilterRouting(event, recipients);
        Set adjunctRecipients = bucketRegion.getAdjunctReceivers(event, recipients, twoMessages, filterRouting);
        Set cacheServerMembers = cda.adviseCacheServers();
        return !Collections.disjoint(adjunctRecipients, cacheServerMembers);
    }

    public Region.Entry getEntry(Object key) {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        return this.getDataView().getEntry(this.getKeyInfo(key), this, false);
    }

    public Region.Entry getEntry(Object key, boolean allowTombstones) {
        return this.getDataView().getEntry(this.getKeyInfo(key), this, allowTombstones);
    }

    public Region.Entry accessEntry(Object key, boolean updateStats) {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForNoAccess();
        if (updateStats) {
            return this.getDataView().accessEntry(this.getKeyInfo(key), this);
        }
        return this.getDataView().getEntry(this.getKeyInfo(key), this, false);
    }

    public long getEstimatedLocalSize() {
        if (!this.isDestroyed) {
            long size;
            RegionMap regionMap;
            if (!this.initialized && this.diskRegion != null && (regionMap = this.diskRegion.getRecoveredEntryMap()) != null && (size = (long)regionMap.size()) > 0L) {
                return size;
            }
            regionMap = this.getRegionMap();
            if (regionMap != null) {
                return regionMap.size();
            }
        }
        return 0L;
    }

    protected Region.Entry nonTXGetEntry(KeyInfo keyInfo, boolean access, boolean allowTombstones) {
        boolean miss;
        Object key = keyInfo.getKey();
        RegionEntry re = this.entries.getEntry(key);
        boolean bl = miss = re == null || re.isDestroyedOrRemoved();
        if (access) {
            this.updateStatsForGet(re, !miss);
        }
        if (re == null) {
            return null;
        }
        if (re.isTombstone() ? !allowTombstones : miss) {
            return null;
        }
        return new NonTXEntry(re);
    }

    protected boolean isClosed() {
        return this.cache.isClosed();
    }

    @Override
    public boolean isThisRegionBeingClosedOrDestroyed() {
        return this.isDestroyed;
    }

    @Override
    public boolean isDestroyed() {
        if (this.isClosed()) {
            return true;
        }
        boolean isTraceEnabled = logger.isTraceEnabled();
        if (this.isDestroyed) {
            if (isTraceEnabled) {
                logger.trace("isDestroyed: true, this.isDestroyed: {}", (Object)this.getFullPath());
            }
            return true;
        }
        if (isTraceEnabled) {
            logger.trace("isDestroyed: false : {}", (Object)this.getFullPath());
        }
        return false;
    }

    @Override
    public Set basicSubregions(boolean recursive) {
        return new SubregionsSet(recursive);
    }

    public Set subregions(boolean recursive) {
        this.checkReadiness();
        return new SubregionsSet(recursive);
    }

    public Set entrySet(boolean recursive) {
        this.checkReadiness();
        this.checkForNoAccess();
        if (!this.restoreSetOperationTransactionBehavior) {
            this.discoverJTA();
        }
        return this.basicEntries(recursive);
    }

    public Set basicEntries(boolean recursive) {
        return new EntriesSet(this, recursive, IteratorType.ENTRIES, false);
    }

    public Set testHookKeys() {
        this.checkReadiness();
        this.checkForNoAccess();
        return new EntriesSet(this, false, IteratorType.KEYS, false);
    }

    public Set keys() {
        this.checkReadiness();
        this.checkForNoAccess();
        if (!this.restoreSetOperationTransactionBehavior) {
            this.discoverJTA();
        }
        return new EntriesSet(this, false, IteratorType.KEYS, false);
    }

    public Set keySet(boolean allowTombstones) {
        this.checkReadiness();
        this.checkForNoAccess();
        return new EntriesSet(this, false, IteratorType.KEYS, allowTombstones);
    }

    @Override
    public Collection values() {
        this.checkReadiness();
        this.checkForNoAccess();
        if (!this.restoreSetOperationTransactionBehavior) {
            this.discoverJTA();
        }
        return new EntriesSet(this, false, IteratorType.VALUES, false);
    }

    @Override
    public Object getUserAttribute() {
        return this.regionUserAttribute;
    }

    @Override
    public void setUserAttribute(Object value) {
        this.checkReadiness();
        this.regionUserAttribute = value;
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkReadiness();
        this.checkForNoAccess();
        return this.getDataView().containsKey(this.getKeyInfo(key), this);
    }

    public boolean containsTombstone(Object key) {
        this.checkReadiness();
        this.checkForNoAccess();
        if (!this.getConcurrencyChecksEnabled()) {
            return false;
        }
        try {
            Region.Entry entry = this.getDataView().getEntry(this.getKeyInfo(key), this, true);
            return entry != null && entry.getValue() == Token.TOMBSTONE;
        }
        catch (EntryDestroyedException ignore) {
            return true;
        }
    }

    protected boolean nonTXContainsKey(KeyInfo keyInfo) {
        RegionEntry regionEntry;
        boolean contains = this.getRegionMap().containsKey(keyInfo.getKey());
        if (contains && this.imageState.isClient() && ((regionEntry = this.entries.getEntry(keyInfo.getKey())) == null || regionEntry.isDestroyedOrRemoved())) {
            contains = false;
        }
        return contains;
    }

    @Override
    public boolean containsValueForKey(Object key) {
        this.discoverJTA();
        return this.getDataView().containsValueForKey(this.getKeyInfo(key), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean nonTXContainsValueForKey(KeyInfo keyInfo) {
        this.checkReadiness();
        this.checkForNoAccess();
        if (this.diskRegion != null) {
            this.diskRegion.setClearCountReference();
        }
        try {
            boolean result;
            RegionEntry entry = this.entries.getEntry(keyInfo.getKey());
            boolean bl = result = entry != null;
            if (result) {
                ReferenceCountHelper.skipRefCountTracking();
                Object val = entry.getTransformedValue();
                if (val instanceof StoredObject) {
                    OffHeapHelper.release(val);
                    ReferenceCountHelper.unskipRefCountTracking();
                    boolean bl2 = true;
                    return bl2;
                }
                ReferenceCountHelper.unskipRefCountTracking();
                result = !Token.isInvalidOrRemoved(val);
            }
            boolean bl3 = result;
            return bl3;
        }
        finally {
            if (this.diskRegion != null) {
                this.diskRegion.removeClearCountReference();
            }
        }
    }

    public RegionAttributes getAttributes() {
        return this;
    }

    @Override
    public String getName() {
        return this.regionName;
    }

    public String getDisplayName() {
        if (this.isUsedForPartitionedRegionBucket()) {
            return this.getPartitionedRegion().getName();
        }
        return this.regionName;
    }

    public int entryCount() {
        return this.getDataView().entryCount(this);
    }

    public int entryCount(Set<Integer> buckets) {
        return this.entryCount(buckets, false);
    }

    protected int entryCount(Set<Integer> buckets, boolean estimate) {
        assert (buckets == null) : "unexpected buckets " + buckets + " for region " + this.toString();
        return this.getDataView().entryCount(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRegionSize() {
        Object object = this.getSizeGuard();
        synchronized (object) {
            int result = this.getRegionMap().size();
            if (this.imageState.isClient() && !this.getConcurrencyChecksEnabled()) {
                return result - this.imageState.getDestroyedEntriesCount();
            }
            return result - this.tombstoneCount.get();
        }
    }

    @Override
    public DiskRegion getDiskRegion() {
        return this.diskRegion;
    }

    @Override
    public DiskRegionView getDiskRegionView() {
        return this.getDiskRegion();
    }

    public void evictValue(Object key) {
        if (this.getDiskRegion() != null) {
            this.entries.evictValue(key);
        }
    }

    private boolean isOverflowEnabled() {
        EvictionAttributes ea = this.getAttributes().getEvictionAttributes();
        return ea != null && ea.getAction().isOverflowToDisk();
    }

    @Override
    public void writeToDisk() {
        if (this.diskRegion == null) {
            DataPolicy dp = this.getDataPolicy();
            if (dp.isEmpty()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_CANNOT_WRITE_A_REGION_WITH_DATAPOLICY_0_TO_DISK.toLocalizedString(dp));
            }
            if (!dp.withPersistence() && !this.isOverflowEnabled()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_CANNOT_WRITE_A_REGION_THAT_IS_NOT_CONFIGURED_TO_ACCESS_DISKS.toLocalizedString());
            }
        } else {
            this.diskRegion.asynchForceFlush();
        }
    }

    public void forceFlush() {
        if (this.diskRegion != null) {
            this.diskRegion.flushForTesting();
        }
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        Scope theScope = this.getAttributes().getScope();
        Assert.assertTrue(theScope == Scope.LOCAL);
        throw new IllegalStateException(LocalizedStrings.LocalRegion_ONLY_SUPPORTED_FOR_GLOBAL_SCOPE_NOT_LOCAL.toLocalizedString());
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        Scope theScope = this.getAttributes().getScope();
        Assert.assertTrue(theScope == Scope.LOCAL);
        throw new IllegalStateException(LocalizedStrings.LocalRegion_ONLY_SUPPORTED_FOR_GLOBAL_SCOPE_NOT_LOCAL.toLocalizedString());
    }

    @Override
    public void invalidate(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.validatedInvalidate(key, aCallbackArgument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validatedInvalidate(Object key, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        EntryEventImpl event = EntryEventImpl.create(this, Operation.INVALIDATE, key, null, aCallbackArgument, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.basicInvalidate(event);
        }
        finally {
            event.release();
        }
    }

    @Override
    public void localDestroy(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForNoAccess();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.LOCAL_DESTROY, key, null, aCallbackArgument, false, this.getMyId());
        if (this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        try {
            this.basicDestroy(event, false, null);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHE_WRITER_SHOULD_NOT_HAVE_BEEN_CALLED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_NO_DISTRIBUTED_LOCK_SHOULD_HAVE_BEEN_ATTEMPTED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        finally {
            event.release();
        }
    }

    @Override
    public void localDestroyRegion(Object aCallbackArgument) {
        this.getDataView().checkSupportsRegionDestroy();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_DESTROY, aCallbackArgument, false, (DistributedMember)this.getMyId(), this.generateEventID());
        try {
            this.basicDestroyRegion(event, false);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
    }

    @Override
    public void close() {
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        try {
            this.basicDestroyRegion(event, false, true, true);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localInvalidate(Object key, Object aCallbackArgument) throws EntryNotFoundException {
        this.validateKey(key);
        this.checkReadiness();
        this.checkForNoAccess();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.LOCAL_INVALIDATE, key, null, aCallbackArgument, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            event.setLocalInvalid(true);
            this.basicInvalidate(event);
        }
        finally {
            event.release();
        }
    }

    @Override
    public void localInvalidateRegion(Object aCallbackArgument) {
        this.getDataView().checkSupportsRegionInvalidate();
        this.checkReadiness();
        this.checkForNoAccess();
        RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_LOCAL_INVALIDATE, aCallbackArgument, false, this.getMyId());
        this.basicInvalidateRegion(event);
    }

    @Override
    public void initialize(InputStream snapshotInputStream, InternalDistributedMember imageTarget, InternalRegionArguments internalRegionArgs) throws TimeoutException, IOException, ClassNotFoundException {
        if (!this.isInternalRegion() && !this.isDestroyed) {
            this.cache.getInternalResourceManager().addResourceListener(InternalResourceManager.ResourceType.MEMORY, this);
        }
        if (this.scope.isLocal()) {
            this.createOQLIndexes(internalRegionArgs);
            if (this.diskRegion != null) {
                try {
                    this.diskRegion.initializeOwner(this);
                    this.diskRegion.finishInitializeOwner(this, InitialImageOperation.GIIStatus.NO_GII);
                    PersistentMemberID oldId = this.diskRegion.getMyInitializingID();
                    if (oldId == null) {
                        oldId = this.diskRegion.getMyPersistentID();
                    }
                    if (oldId == null) {
                        PersistentMemberID newId = this.diskRegion.generatePersistentID();
                        this.diskRegion.setInitializing(newId);
                        this.diskRegion.setInitialized();
                    }
                }
                catch (DiskAccessException dae) {
                    this.releaseAfterRegionCreateEventLatch();
                    this.handleDiskAccessException(dae, true);
                    throw dae;
                }
            }
        }
        this.releaseBeforeGetInitialImageLatch();
        if (snapshotInputStream != null && this.scope.isLocal()) {
            try {
                this.loadSnapshotDuringInitialization(snapshotInputStream);
            }
            catch (DiskAccessException dae) {
                this.releaseAfterRegionCreateEventLatch();
                this.handleDiskAccessException(dae);
                throw dae;
            }
        }
        this.releaseAfterGetInitialImageLatch();
        if (logger.isDebugEnabled()) {
            logger.debug("Calling addExpiryTasks for {}", (Object)this);
        }
        try {
            this.addIdleExpiryTask();
            this.addTTLExpiryTask();
            if (this.isEntryExpiryPossible()) {
                this.rescheduleEntryExpiryTasks();
            }
            this.initialized();
        }
        catch (RegionDestroyedException ignore) {
            Assert.assertTrue(this.isDestroyed());
        }
    }

    void createOQLIndexes(InternalRegionArguments internalRegionArgs) {
        this.createOQLIndexes(internalRegionArgs, false);
    }

    /*
     * Exception decompiling
     */
    void createOQLIndexes(InternalRegionArguments internalRegionArgs, boolean recoverFromDisk) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void populateOQLIndexes(Set<Index> indexes) {
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_INDEX_LOADING));
        try {
            this.indexManager.populateIndexes(indexes);
        }
        catch (MultiIndexCreationException ex) {
            logger.info("Failed to update index on region {}: {}", (Object)this.getFullPath(), (Object)ex.getMessage());
        }
    }

    protected void initialized() {
    }

    protected void releaseLatches() {
        this.releaseBeforeGetInitialImageLatch();
        this.releaseAfterGetInitialImageLatch();
        this.releaseAfterRegionCreateEventLatch();
    }

    void releaseBeforeGetInitialImageLatch() {
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing Initialization Latch (before initial image) for {}", (Object)this.getFullPath());
        }
        LocalRegion.releaseLatch(this.initializationLatchBeforeGetInitialImage);
    }

    void releaseAfterGetInitialImageLatch() {
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing Initialization Latch (after initial image) for {}", (Object)this.getFullPath());
        }
        LocalRegion.releaseLatch(this.initializationLatchAfterGetInitialImage);
    }

    private void releaseAfterRegionCreateEventLatch() {
        LocalRegion.releaseLatch(this.afterRegionCreateEventLatch);
    }

    private void waitForRegionCreateEvent() {
        StoppableCountDownLatch latch = this.afterRegionCreateEventLatch;
        if (latch != null && latch.getCount() == 0L) {
            return;
        }
        this.waitOnInitialization(latch);
    }

    private static void releaseLatch(StoppableCountDownLatch latch) {
        if (latch == null) {
            return;
        }
        latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveDestroyRegion(Set eventSet, RegionEventImpl regionEvent, boolean cacheWrite) throws CacheWriterException, TimeoutException {
        boolean isClose;
        block45: {
            isClose = regionEvent.getOperation().isClose();
            if (eventSet != null && cacheWrite) {
                try {
                    this.cacheWriteBeforeRegionDestroy(regionEvent);
                }
                catch (CancelException e) {
                    if (this.cache.forcedDisconnect()) break block45;
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_PROBLEM_IN_CACHEWRITEBEFOREREGIONDESTROY), (Throwable)e);
                }
            }
        }
        this.getEventTracker().stop();
        if (logger.isTraceEnabled(LogMarker.RVV_VERBOSE) && this.getVersionVector() != null) {
            logger.trace(LogMarker.RVV_VERBOSE, "version vector for {} is {}", (Object)this.getName(), (Object)this.getVersionVector().fullToString());
        }
        this.cancelTTLExpiryTask();
        this.cancelIdleExpiryTask();
        this.cancelAllEntryExpiryTasks();
        if (!this.isInternalRegion()) {
            this.getCachePerfStats().incRegions(-1);
        }
        this.cache.getInternalResourceManager(false).removeResourceListener(this);
        if (this.getMembershipAttributes().hasRequiredRoles() && !this.isInternalRegion()) {
            this.getCachePerfStats().incReliableRegions(-1);
        }
        if (eventSet != null) {
            eventSet.add(regionEvent);
        }
        try {
            block48: {
                Collection values = this.subregions.values();
                Iterator itr = values.iterator();
                while (itr.hasNext()) {
                    block47: {
                        LocalRegion region;
                        Object element = itr.next();
                        try {
                            LocalRegion.setThreadInitLevelRequirement(1);
                            try {
                                region = this.toRegion(element);
                            }
                            finally {
                                LocalRegion.setThreadInitLevelRequirement(0);
                            }
                        }
                        catch (CancelException ignore) {
                            region = (LocalRegion)element;
                        }
                        catch (RegionDestroyedException ignore) {
                            continue;
                        }
                        if (region.isDestroyed) continue;
                        if (eventSet != null) {
                            regionEvent = (RegionEventImpl)regionEvent.clone();
                            regionEvent.region = region;
                        }
                        try {
                            region.recursiveDestroyRegion(eventSet, regionEvent, cacheWrite);
                            if (!region.isInternalRegion()) {
                                InternalDistributedSystem system = region.cache.getInternalDistributedSystem();
                                system.handleResourceEvent(ResourceEvent.REGION_REMOVE, region);
                            }
                        }
                        catch (CancelException e) {
                            if (this.cache.forcedDisconnect()) break block47;
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_RECURSION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, region.getFullPath()), (Throwable)e);
                        }
                    }
                    itr.remove();
                }
                try {
                    if (this.indexManager == null) break block48;
                    try {
                        if (this instanceof BucketRegion) {
                            this.indexManager.removeBucketIndexes(this.getPartitionedRegion());
                        }
                        this.indexManager.destroy();
                    }
                    catch (QueryException e) {
                        throw new IndexMaintenanceException(e);
                    }
                }
                catch (CancelException e) {
                    if (this.cache.forcedDisconnect()) break block48;
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_BASICDESTROYREGION_INDEX_REMOVAL_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
                }
            }
            if (regionEvent.isReinitializing()) {
                this.reinitialized_old = true;
            }
            this.cache.setRegionByPath(this.getFullPath(), null);
            this.getEventTracker().stop();
            if (this.diskRegion != null) {
                this.diskRegion.prepareForClose(this);
            }
            this.isDestroyed = true;
            this.cache.getInternalResourceManager(false).removeResourceListener(this);
            this.closeEntries();
        }
        catch (Throwable throwable) {
            if (regionEvent.isReinitializing()) {
                this.reinitialized_old = true;
            }
            this.cache.setRegionByPath(this.getFullPath(), null);
            this.getEventTracker().stop();
            if (this.diskRegion != null) {
                this.diskRegion.prepareForClose(this);
            }
            this.isDestroyed = true;
            this.cache.getInternalResourceManager(false).removeResourceListener(this);
            this.closeEntries();
            if (logger.isDebugEnabled()) {
                logger.debug("recursiveDestroyRegion: Region Destroyed: {}", (Object)this.getFullPath());
            }
            try {
                this.postDestroyRegion(!isClose, regionEvent);
            }
            catch (CancelException e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_POSTDESTROYREGION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
            }
            if (this.getServerProxy() == null) {
                this.closeCqs();
            }
            this.detachPool();
            if (eventSet != null) {
                this.closeCallbacksExceptListener();
            } else {
                this.closeAllCallbacks();
            }
            if (this.getConcurrencyChecksEnabled() && this.getDataPolicy().withReplication() && !this.cache.isClosed()) {
                this.cache.getTombstoneService().unscheduleTombstones(this);
            }
            if (this.hasOwnStats) {
                this.cachePerfStats.close();
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("recursiveDestroyRegion: Region Destroyed: {}", (Object)this.getFullPath());
        }
        try {
            this.postDestroyRegion(!isClose, regionEvent);
        }
        catch (CancelException e) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_POSTDESTROYREGION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
        }
        if (this.getServerProxy() == null) {
            this.closeCqs();
        }
        this.detachPool();
        if (eventSet != null) {
            this.closeCallbacksExceptListener();
        } else {
            this.closeAllCallbacks();
        }
        if (this.getConcurrencyChecksEnabled() && this.getDataPolicy().withReplication() && !this.cache.isClosed()) {
            this.cache.getTombstoneService().unscheduleTombstones(this);
        }
        if (this.hasOwnStats) {
            this.cachePerfStats.close();
        }
    }

    public void closeEntries() {
        this.entries.close(null);
    }

    public Set<VersionSource> clearEntries(RegionVersionVector rvv) {
        return this.entries.clear(rvv, null);
    }

    @Override
    public void checkReadiness() {
        this.checkRegionDestroyed(true);
    }

    @Override
    public void checkEntryNotFound(Object entryKey) {
        this.checkReadiness();
        throw new EntryNotFoundException(LocalizedStrings.PartitionedRegion_ENTRY_NOT_FOUND_FOR_KEY_0.toLocalizedString(entryKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object findObjectInSystem(KeyInfo keyInfo, boolean isCreate, TXStateInterface tx, boolean generateCallbacks, Object localValue, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws CacheLoaderException, TimeoutException {
        RegionEntry re;
        Object value;
        Object key;
        block26: {
            CacheLoader loader;
            key = keyInfo.getKey();
            Object aCallbackArgument = keyInfo.getCallbackArg();
            value = null;
            boolean fromServer = false;
            VersionTagHolder holder = null;
            ServerRegionProxy mySRP = this.getServerProxy();
            if (mySRP != null) {
                holder = new VersionTagHolder();
                value = mySRP.get(key, aCallbackArgument, holder);
                boolean bl = fromServer = value != null;
            }
            if (!(fromServer && value != Token.TOMBSTONE || (loader = this.basicGetLoader()) == null)) {
                fromServer = false;
                CachePerfStats stats = this.getCachePerfStats();
                long statStart = stats.startLoad();
                try {
                    value = this.callCacheLoader(loader, key, aCallbackArgument, preferCD);
                }
                finally {
                    stats.endLoad(statStart);
                }
            }
            if (fromServer && value == Token.TOMBSTONE && !this.getConcurrencyChecksEnabled()) {
                value = null;
            }
            re = null;
            if (value != null && !this.isMemoryThresholdReachedForLoad()) {
                long startPut = CachePerfStats.getStatTime();
                this.validateKey(key);
                Operation op = isCreate ? Operation.LOCAL_LOAD_CREATE : Operation.LOCAL_LOAD_UPDATE;
                EntryEventImpl event = EntryEventImpl.create(this, op, key, value, aCallbackArgument, false, this.getMyId(), generateCallbacks);
                try {
                    if (fromServer) {
                        if (this.alreadyInvalid(key, event)) {
                            Object var22_24 = null;
                            return var22_24;
                        }
                        event.setFromServer(fromServer);
                        event.setVersionTag(holder.getVersionTag());
                        if (clientEvent != null) {
                            clientEvent.setVersionTag(holder.getVersionTag());
                        }
                    }
                    if (!fromServer) {
                        event.setNewEventId(this.cache.getDistributedSystem());
                    }
                    try {
                        re = this.basicPutEntry(event, 0L);
                        if (!fromServer && clientEvent != null) {
                            clientEvent.setVersionTag(event.getVersionTag());
                            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
                        }
                        if (fromServer && event.getRawNewValue() == Token.TOMBSTONE) {
                            Object var22_25 = null;
                            return var22_25;
                        }
                    }
                    catch (ConcurrentCacheModificationException ignore) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("caught concurrent modification attempt when applying {}", (Object)event);
                        }
                        this.notifyBridgeClients(event);
                    }
                    catch (CacheWriterException cwe) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("findObjectInSystem: writer exception putting entry {}", (Object)event, (Object)cwe);
                        }
                        break block26;
                    }
                    if (!this.getDataView().isDeferredStats()) {
                        this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
                    }
                }
                finally {
                    event.release();
                }
            }
        }
        if (!isCreate) return value;
        this.recordMiss(re, key);
        return value;
    }

    protected Object callCacheLoader(CacheLoader loader, Object key, Object aCallbackArgument, boolean preferCD) {
        LoaderHelper loaderHelper = this.loaderHelperFactory.createLoaderHelper(key, aCallbackArgument, false, true, null);
        Object result = loader.load(loaderHelper);
        result = this.getCache().convertPdxInstanceIfNeeded(result, preferCD);
        return result;
    }

    protected boolean isMemoryThresholdReachedForLoad() {
        return this.memoryThresholdReached.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyInvalid(Object key, EntryEventImpl event) {
        RegionEntry entry;
        Object newValue = event.getRawNewValue();
        if ((newValue == null || Token.isInvalid(newValue)) && (entry = this.entries.getEntry(key)) != null) {
            RegionEntry regionEntry = entry;
            synchronized (regionEntry) {
                if (entry.isInvalid()) {
                    VersionStamp stamp = entry.getVersionStamp();
                    if (stamp == null || event.getVersionTag() == null) {
                        return true;
                    }
                    if (stamp.getEntryVersion() >= event.getVersionTag().getEntryVersion()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cacheWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean result = false;
        CacheWriter writer = this.basicGetWriter();
        if (writer != null && event.getOperation() != Operation.REMOVE && !event.inhibitAllNotifications()) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            event.setReadOldValueFromDisk(true);
            try {
                writer.beforeDestroy(event);
            }
            finally {
                event.setReadOldValueFromDisk(false);
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            result = true;
        }
        this.serverDestroy(event, expectedOldValue);
        return result;
    }

    @Override
    public boolean bridgeWriteBeforeDestroy(EntryEventImpl event, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        if (this.hasServerProxy()) {
            this.serverDestroy(event, expectedOldValue);
            return true;
        }
        return false;
    }

    void serverRegionDestroy(RegionEventImpl regionEvent) {
        ServerRegionProxy mySRP;
        if (regionEvent.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            EventID eventId = regionEvent.getEventId();
            Object callbackArg = regionEvent.getRawCallbackArgument();
            mySRP.destroyRegion(eventId, callbackArg);
        }
    }

    private void serverRegionClear(RegionEventImpl regionEvent) {
        ServerRegionProxy mySRP;
        if (regionEvent.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            EventID eventId = regionEvent.getEventId();
            Object callbackArg = regionEvent.getRawCallbackArgument();
            mySRP.clear(eventId, callbackArg);
        }
    }

    void serverInvalidate(EntryEventImpl event) {
        ServerRegionProxy mySRP;
        if (event.getOperation().isDistributed() && !event.isOriginRemote() && (mySRP = this.getServerProxy()) != null) {
            mySRP.invalidate(event);
        }
    }

    void serverPut(EntryEventImpl event, boolean requireOldValue, Object expectedOldValue) {
        ServerRegionProxy mySRP;
        if (event.getOperation().isDistributed() && !event.isFromServer() && (mySRP = this.getServerProxy()) != null) {
            if (event.isBulkOpInProgress()) {
                return;
            }
            Operation op = event.getOperation();
            Object key = event.getKey();
            Object value = event.getRawNewValue();
            Object callbackArg = event.getRawCallbackArgument();
            boolean isCreate = event.isCreate();
            Object result = mySRP.put(key, value, event.getDeltaBytes(), event, op, requireOldValue, expectedOldValue, callbackArg, isCreate);
            this.getCancelCriterion().checkCancelInProgress(null);
            if (op.guaranteesOldValue()) {
                if (op != Operation.REPLACE || requireOldValue) {
                    event.setConcurrentMapOldValue(result);
                }
                if (op == Operation.PUT_IF_ABSENT) {
                    if (result != null) {
                        throw new EntryNotFoundException("entry existed for putIfAbsent");
                    }
                } else if (op == Operation.REPLACE) {
                    if (requireOldValue && result == null) {
                        throw new EntryNotFoundException("entry not found for replace");
                    }
                    if (!requireOldValue && !((Boolean)result).booleanValue()) {
                        throw new EntryNotFoundException("entry found with wrong value");
                    }
                }
            }
        }
    }

    void serverDestroy(EntryEventImpl event, Object expectedOldValue) {
        ServerRegionProxy mySRP;
        if (event.getOperation().isDistributed() && (mySRP = this.getServerProxy()) != null) {
            Object key = event.getKey();
            Object callbackArg = event.getRawCallbackArgument();
            Object result = mySRP.destroy(key, expectedOldValue, event.getOperation(), event, callbackArg);
            if (result instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cacheWriteBeforeRegionDestroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean result = false;
        CacheWriter writer = this.basicGetWriter();
        if (writer != null) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                writer.beforeRegionDestroy(event);
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
            result = true;
        }
        this.serverRegionDestroy(event);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheWriteBeforeRegionClear(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        CacheWriter writer = this.basicGetWriter();
        if (writer != null) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            try {
                writer.beforeRegionClear(event);
            }
            finally {
                this.getCachePerfStats().endCacheWriterCall(start);
            }
        }
        this.serverRegionClear(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheWriteBeforePut(EntryEventImpl event, Set netWriteRecipients, CacheWriter localWriter, boolean requireOldValue, Object expectedOldValue) throws CacheWriterException, TimeoutException {
        boolean isPutIfAbsentOrReplace;
        Assert.assertTrue(netWriteRecipients == null);
        Operation operation = event.getOperation();
        boolean bl = isPutIfAbsentOrReplace = operation == Operation.PUT_IF_ABSENT || operation == Operation.REPLACE;
        if (!isPutIfAbsentOrReplace && localWriter != null && !event.inhibitAllNotifications()) {
            long start = this.getCachePerfStats().startCacheWriterCall();
            boolean newEntry = event.getOperation().isCreate();
            event.setReadOldValueFromDisk(true);
            try {
                if (!newEntry) {
                    localWriter.beforeUpdate(event);
                } else {
                    localWriter.beforeCreate(event);
                }
            }
            finally {
                event.setReadOldValueFromDisk(false);
                this.getCachePerfStats().endCacheWriterCall(start);
            }
        }
        this.serverPut(event, requireOldValue, expectedOldValue);
    }

    protected void validateArguments(Object key, Object value, Object aCallbackArgument) {
        this.validateKey(key);
        this.validateValue(value);
    }

    void validateKey(Object key) {
        if (key == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_KEY_CANNOT_BE_NULL.toLocalizedString());
        }
        if (this.keyConstraint != null && !this.keyConstraint.isInstance(key)) {
            throw new ClassCastException(LocalizedStrings.LocalRegion_KEY_0_DOES_NOT_SATISFY_KEYCONSTRAINT_1.toLocalizedString(key.getClass().getName(), this.keyConstraint.getName()));
        }
    }

    private void validateValue(Object value) {
        if (this.valueConstraint != null && value != null) {
            if (value instanceof CachedDeserializable) {
                if (this.doExpensiveValidations) {
                    value = ((CachedDeserializable)value).getDeserializedValue(null, null);
                } else {
                    return;
                }
            }
            if (!this.valueConstraint.isInstance(value)) {
                String valueClassName = value.getClass().getName();
                if (value instanceof PdxInstance) {
                    PdxInstance pdx = (PdxInstance)value;
                    if (pdx.getClassName().equals("__GEMFIRE_JSON")) {
                        Object type = pdx.getField("@type");
                        if (type != null && type instanceof String) {
                            valueClassName = (String)type;
                        } else {
                            return;
                        }
                    }
                    if (valueClassName.equals(this.valueConstraint.getName())) {
                        return;
                    }
                }
                throw new ClassCastException(LocalizedStrings.LocalRegion_VALUE_0_DOES_NOT_SATISFY_VALUECONSTRAINT_1.toLocalizedString(valueClassName, this.valueConstraint.getName()));
            }
        }
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    public CachePerfStats getRegionPerfStats() {
        return this.cachePerfStats;
    }

    public void incTombstoneCount(int delta) {
        this.tombstoneCount.addAndGet(delta);
        this.cachePerfStats.incTombstoneCount(delta);
        this.cachePerfStats.incEntryCount(-delta);
    }

    public int getTombstoneCount() {
        return this.tombstoneCount.get();
    }

    @Override
    public void scheduleTombstone(RegionEntry entry, VersionTag destroyedVersion) {
        this.scheduleTombstone(entry, destroyedVersion, false);
    }

    private void scheduleTombstone(RegionEntry entry, VersionTag destroyedVersion, boolean reschedule) {
        if (destroyedVersion == null) {
            throw new NullPointerException("destroyed version tag cannot be null");
        }
        if (!reschedule) {
            this.incTombstoneCount(1);
        }
        if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT_VERBOSE)) {
            logger.trace(LogMarker.TOMBSTONE_COUNT_VERBOSE, "{} tombstone for {} version={} count is {} entryMap size is {}", (Object)(reschedule ? "rescheduling" : "scheduling"), entry.getKey(), entry.getVersionStamp().asVersionTag(), (Object)this.tombstoneCount.get(), (Object)this.entries.size());
        }
        this.getGemFireCache().getTombstoneService().scheduleTombstone(this, entry, destroyedVersion);
    }

    @Override
    public void rescheduleTombstone(RegionEntry entry, VersionTag version) {
        this.scheduleTombstone(entry, version, true);
    }

    @Override
    public void unscheduleTombstone(RegionEntry entry) {
        this.unscheduleTombstone(entry, true);
    }

    private void unscheduleTombstone(RegionEntry entry, boolean validate) {
        this.incTombstoneCount(-1);
        if (logger.isTraceEnabled(LogMarker.TOMBSTONE_VERBOSE)) {
            logger.trace(LogMarker.TOMBSTONE_VERBOSE, "unscheduling tombstone for {} count is {} entryMap size is {}", entry.getKey(), (Object)this.tombstoneCount.get(), (Object)this.entries.size());
        }
        if (logger.isTraceEnabled(LogMarker.TOMBSTONE_COUNT_VERBOSE) && validate && this.entries instanceof AbstractRegionMap) {
            ((AbstractRegionMap)this.entries).verifyTombstoneCount(this.tombstoneCount);
        }
    }

    public void expireTombstones(Map<VersionSource, Long> regionGCVersions, EventID eventID, FilterRoutingInfo.FilterInfo clientRouting) {
        if (!this.getConcurrencyChecksEnabled()) {
            return;
        }
        Set<Object> keys = null;
        if (!this.versionVector.containsTombstoneGCVersions(regionGCVersions) && (keys = this.cache.getTombstoneService().gcTombstones(this, regionGCVersions, this.needsTombstoneGCKeysForClients(eventID, clientRouting))) == null) {
            return;
        }
        if (eventID != null) {
            this.notifyClientsOfTombstoneGC(regionGCVersions, keys, eventID, clientRouting);
        }
    }

    public void expireTombstoneKeys(Set<Object> tombstoneKeys) {
        if (this.getConcurrencyChecksEnabled()) {
            this.cache.getTombstoneService().gcTombstoneKeys(this, tombstoneKeys);
        }
    }

    protected boolean needsTombstoneGCKeysForClients(EventID eventID, FilterRoutingInfo.FilterInfo clientRouting) {
        return false;
    }

    protected void notifyClientsOfTombstoneGC(Map<VersionSource, Long> regionGCVersions, Set<Object> keysRemoved, EventID eventID, FilterRoutingInfo.FilterInfo routing) {
        FilterProfile fp;
        if (CacheClientNotifier.getInstance() != null && ((fp = this.getFilterProfile()) != null || routing != null)) {
            RegionEventImpl regionEvent = new RegionEventImpl(this, Operation.REGION_DESTROY, null, true, this.getMyId());
            regionEvent.setEventID(eventID);
            FilterRoutingInfo.FilterInfo clientRouting = routing;
            if (clientRouting == null) {
                clientRouting = fp.getLocalFilterRouting(regionEvent);
            }
            regionEvent.setLocalFilterInfo(clientRouting);
            ClientTombstoneMessage clientMessage = ClientTombstoneMessage.gc(this, regionGCVersions, eventID);
            CacheClientNotifier.notifyClients(regionEvent, clientMessage);
        }
    }

    protected boolean shouldGenerateVersionTag(RegionEntry entry, EntryEventImpl event) {
        if (this.getDataPolicy().withPersistence()) {
            return true;
        }
        return this.getConcurrencyChecksEnabled() && (entry.getVersionStamp().hasValidVersion() || this.getDataPolicy().withReplication());
    }

    protected void enableConcurrencyChecks() {
        this.setConcurrencyChecksEnabled(true);
        if (this.getDataPolicy().withStorage()) {
            RegionEntryFactory versionedEntryFactory = this.entries.getEntryFactory().makeVersioned();
            Assert.assertTrue(this.entries.isEmpty(), "RegionMap should be empty but was of size:" + this.entries.size());
            this.entries.setEntryFactory(versionedEntryFactory);
        }
    }

    protected boolean getEnableConcurrencyChecks() {
        return this.getConcurrencyChecksEnabled();
    }

    private void validateSubregionAttributes(RegionAttributes attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_REGION_ATTRIBUTES_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (this.scope == Scope.LOCAL && attrs.getScope() != Scope.LOCAL) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_A_REGION_WITH_SCOPELOCAL_CAN_ONLY_HAVE_SUBREGIONS_WITH_SCOPELOCAL.toLocalizedString());
        }
    }

    @Override
    public Object getValueInVM(Object key) throws EntryNotFoundException {
        return this.basicGetValueInVM(key, true);
    }

    public Object getValueInVM(EntryEventImpl event) throws EntryNotFoundException {
        return this.basicGetValueInVM(event.getKey(), true);
    }

    private Object basicGetValueInVM(Object key, boolean rememberRead) throws EntryNotFoundException {
        return this.getDataView().getValueInVM(this.getKeyInfo(key), this, rememberRead);
    }

    Object nonTXbasicGetValueInVM(KeyInfo keyInfo) {
        Object value;
        RegionEntry regionEntry = this.entries.getEntry(keyInfo.getKey());
        if (regionEntry == null) {
            this.checkEntryNotFound(keyInfo.getKey());
        }
        if (Token.isRemoved(value = regionEntry.getValueInVM(this))) {
            this.checkEntryNotFound(keyInfo.getKey());
        }
        if (value == Token.NOT_AVAILABLE) {
            return null;
        }
        return value;
    }

    public Set testHookTXKeys() {
        if (!this.isTX()) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_TX_NOT_IN_PROGRESS.toLocalizedString());
        }
        TXStateProxyImpl tx = (TXStateProxyImpl)this.getTXState();
        if (!tx.isRealDealLocal()) {
            return Collections.emptySet();
        }
        TXRegionState txr = this.txReadRegion();
        if (txr == null) {
            return Collections.emptySet();
        }
        return txr.getEntryKeys();
    }

    @Override
    public Object getValueOnDisk(Object key) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key);
        if (re == null) {
            throw new EntryNotFoundException(key.toString());
        }
        return re.getValueOnDisk(this);
    }

    public Object getValueInVMOrDiskWithoutFaultIn(Object key) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key);
        if (re == null) {
            throw new EntryNotFoundException(key.toString());
        }
        return re.getValueInVMOrDiskWithoutFaultIn(this);
    }

    public Object getValueOnDiskOrBuffer(Object key) throws EntryNotFoundException {
        RegionEntry re = this.entries.getEntry(key);
        if (re == null) {
            throw new EntryNotFoundException(key.toString());
        }
        return re.getValueOnDiskOrBuffer(this);
    }

    Object getNoLRU(Object key, boolean adamant, boolean allowTombstone, boolean serializedFormOkay) {
        Object value = null;
        try {
            value = this.getValueInVM(key);
            if (value == null) {
                value = this.getValueOnDiskOrBuffer(key);
                if (value == null) {
                    value = this.getValueInVM(key);
                    if (value == null) {
                        if (adamant) {
                            value = this.get(key);
                        }
                    } else if (!serializedFormOkay && value instanceof CachedDeserializable) {
                        value = ((CachedDeserializable)value).getDeserializedValue(this, this.getRegionEntry(key));
                    }
                }
            } else if (!serializedFormOkay && value instanceof CachedDeserializable) {
                value = ((CachedDeserializable)value).getDeserializedValue(this, this.getRegionEntry(key));
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        if (value == Token.TOMBSTONE && !allowTombstone) {
            value = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        if (this.isProxy()) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_REGIONS_WITH_DATAPOLICY_0_DO_NOT_SUPPORT_SAVESNAPSHOT.toLocalizedString(this.getDataPolicy()));
        }
        this.checkForNoAccess();
        try (DataOutputStream out = new DataOutputStream(outputStream);){
            out.writeByte(1);
            for (Object entryObject : this.entrySet(false)) {
                Region.Entry entry = (Region.Entry)entryObject;
                try {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value == Token.TOMBSTONE) continue;
                    DataSerializer.writeObject(key, out);
                    if (value == null) {
                        NonTXEntry lre = (NonTXEntry)entry;
                        RegionEntry re = lre.getRegionEntry();
                        value = re.getValue(this);
                        if (value == Token.INVALID) {
                            out.writeByte(24);
                            continue;
                        }
                        if (value == Token.LOCAL_INVALID) {
                            out.writeByte(25);
                            continue;
                        }
                        out.writeByte(23);
                        DataSerializer.writeObject(value, out);
                        continue;
                    }
                    out.writeByte(23);
                    DataSerializer.writeObject(value, out);
                }
                catch (EntryDestroyedException entryDestroyedException) {}
            }
            DataSerializer.writeObject(null, out);
        }
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws CacheWriterException, TimeoutException, ClassNotFoundException, IOException {
        if (this.isProxy()) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_REGIONS_WITH_DATAPOLICY_0_DO_NOT_SUPPORT_LOADSNAPSHOT.toLocalizedString(this.getDataPolicy()));
        }
        if (inputStream == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_INPUTSTREAM_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOAD_SNAPSHOT, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        this.reinitialize(inputStream, event);
    }

    public void registerInterest(Object key) {
        this.registerInterest(key, false);
    }

    public void registerInterest(Object key, boolean isDurable) {
        this.registerInterest(key, isDurable, true);
    }

    public void registerInterest(Object key, boolean isDurable, boolean receiveValues) {
        this.registerInterest(key, InterestResultPolicy.DEFAULT, isDurable, receiveValues);
    }

    public void startRegisterInterest() {
        this.getImageState().writeLockRI();
        try {
            this.cache.registerInterestStarted();
            ++this.riCnt;
        }
        finally {
            this.getImageState().writeUnlockRI();
        }
    }

    public void finishRegisterInterest() {
        if (Boolean.getBoolean("gemfire.testing.slow-interest-recovery")) {
            if (logger.isDebugEnabled()) {
                logger.debug("slowing interest recovery...");
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("done slowing interest recovery");
            }
        }
        boolean gotLock = false;
        try {
            this.getImageState().writeLockRI();
            gotLock = true;
            --this.riCnt;
            Assert.assertTrue(this.riCnt >= 0, "register interest count can not be < 0 ");
            if (this.riCnt == 0) {
                this.destroyEntriesAndClearDestroyedKeysSet();
            }
        }
        finally {
            this.cache.registerInterestCompleted();
            if (gotLock) {
                this.getImageState().writeUnlockRI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleInterest(Object key, int interestType2, InterestResultPolicy interestResultPolicy, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        block38: {
            ServerRegionProxy proxy = this.getServerProxy();
            if (proxy == null) {
                throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_REGISTRATION_REQUIRES_A_POOL.toLocalizedString());
            }
            if (isDurable && !proxy.getPool().isDurableClient()) {
                throw new IllegalStateException(LocalizedStrings.LocalRegion_DURABLE_FLAG_ONLY_APPLICABLE_FOR_DURABLE_CLIENTS.toLocalizedString());
            }
            if (!proxy.getPool().getSubscriptionEnabled()) {
                String msg = "Interest registration requires a pool whose queue is enabled.";
                throw new SubscriptionNotEnabledException(msg);
            }
            if (this.getAttributes().getDataPolicy().withReplication() && !this.getAttributes().getScope().isLocal()) {
                throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_REGISTRATION_NOT_SUPPORTED_ON_REPLICATED_REGIONS.toLocalizedString());
            }
            if (key == null) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_INTEREST_KEY_MUST_NOT_BE_NULL.toLocalizedString());
            }
            this.startRegisterInterest();
            try {
                List serverKeys;
                this.clearKeysOfInterest(key, interestType2, interestResultPolicy);
                if (PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG) {
                    ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                    bo.beforeInterestRegistration();
                }
                byte regionDataPolicy = this.getAttributes().getDataPolicy().ordinal;
                switch (interestType2) {
                    case 2: {
                        serverKeys = proxy.registerInterest(key, interestType2, interestResultPolicy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    case 0: {
                        if (key instanceof String && key.equals("ALL_KEYS")) {
                            logger.warn("Usage of registerInterest('ALL_KEYS') has been deprecated.  Please use registerInterestForAllKeys()");
                            serverKeys = proxy.registerInterest(".*", 1, interestResultPolicy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                            break;
                        }
                        if (key instanceof List) {
                            logger.warn("Usage of registerInterest(List) has been deprecated. Please use registerInterestForKeys(Iterable)");
                            serverKeys = proxy.registerInterestList((List)key, interestResultPolicy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                            break;
                        }
                        serverKeys = proxy.registerInterest(key, 0, interestResultPolicy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    case 3: {
                        serverKeys = proxy.registerInterest(key, 3, interestResultPolicy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    case 1: {
                        String regex = (String)key;
                        Pattern.compile(regex);
                        serverKeys = proxy.registerInterest(regex, 1, interestResultPolicy, isDurable, receiveUpdatesAsInvalidates, regionDataPolicy);
                        break;
                    }
                    default: {
                        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                    }
                }
                boolean finishedRefresh = false;
                try {
                    this.refreshEntriesFromServerKeys(null, serverKeys, interestResultPolicy);
                    finishedRefresh = true;
                    if (finishedRefresh) break block38;
                }
                catch (Throwable throwable) {
                    if (!finishedRefresh) {
                        switch (interestType2) {
                            case 2: {
                                proxy.unregisterInterest(key, interestType2, false, false);
                                break;
                            }
                            case 0: {
                                if (key instanceof String && key.equals("ALL_KEYS")) {
                                    proxy.unregisterInterest(".*", 1, false, false);
                                    break;
                                }
                                if (key instanceof List) {
                                    proxy.unregisterInterestList((List)key, false, false);
                                    break;
                                }
                                proxy.unregisterInterest(key, 0, false, false);
                                break;
                            }
                            case 3: {
                                proxy.unregisterInterest(key, 3, false, false);
                                break;
                            }
                            case 1: {
                                proxy.unregisterInterest(key, 1, false, false);
                                break;
                            }
                            default: {
                                throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                            }
                        }
                    }
                    throw throwable;
                }
                switch (interestType2) {
                    case 2: {
                        proxy.unregisterInterest(key, interestType2, false, false);
                        break;
                    }
                    case 0: {
                        if (key instanceof String && key.equals("ALL_KEYS")) {
                            proxy.unregisterInterest(".*", 1, false, false);
                        } else if (key instanceof List) {
                            proxy.unregisterInterestList((List)key, false, false);
                        } else {
                            proxy.unregisterInterest(key, 0, false, false);
                        }
                        break;
                    }
                    case 3: {
                        proxy.unregisterInterest(key, 3, false, false);
                        break;
                    }
                    case 1: {
                        proxy.unregisterInterest(key, 1, false, false);
                        break;
                    }
                    default: {
                        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
                    }
                }
            }
            finally {
                this.finishRegisterInterest();
            }
        }
    }

    public void registerInterest(Object key, InterestResultPolicy policy) {
        this.registerInterest(key, policy, false);
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable) {
        this.registerInterest(key, policy, isDurable, true);
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(key, 0, policy, isDurable, !receiveValues);
    }

    @Override
    public void registerInterestRegex(String regex) {
        this.registerInterestRegex(regex, false);
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) {
        this.registerInterestRegex(regex, InterestResultPolicy.DEFAULT, isDurable, true);
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) {
        this.registerInterestRegex(regex, InterestResultPolicy.DEFAULT, isDurable, receiveValues);
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) {
        this.registerInterestRegex(regex, policy, false);
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) {
        this.registerInterestRegex(regex, policy, isDurable, true);
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(regex, 1, policy, isDurable, !receiveValues);
    }

    private void registerInterestFilter(String className, boolean isDurable) {
        this.registerInterestFilter(className, isDurable, true);
    }

    private void registerInterestFilter(String className, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(className, 2, InterestResultPolicy.DEFAULT, isDurable, !receiveValues);
    }

    private void registerInterestOQL(String query, boolean isDurable) {
        this.registerInterestOQL(query, isDurable, true);
    }

    private void registerInterestOQL(String query, boolean isDurable, boolean receiveValues) {
        this.processSingleInterest(query, 3, InterestResultPolicy.DEFAULT, isDurable, !receiveValues);
    }

    public void unregisterInterest(Object key) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            if (key instanceof String && key.equals("ALL_KEYS")) {
                proxy.unregisterInterest(".*", 1, false, false);
            } else if (key instanceof List) {
                proxy.unregisterInterestList((List)key, false, false);
            } else {
                proxy.unregisterInterest(key, 0, false, false);
            }
        } else {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
    }

    @Override
    public void unregisterInterestRegex(String regex) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy == null) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
        proxy.unregisterInterest(regex, 1, false, false);
    }

    public void unregisterInterestFilter(String className) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy == null) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
        proxy.unregisterInterest(className, 2, false, false);
    }

    public void unregisterInterestOQL(String query) {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy == null) {
            throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
        }
        proxy.unregisterInterest(query, 3, false, false);
    }

    public List getInterestList() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.getInterestList(0);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_UNREGISTRATION_REQUIRES_A_POOL.toLocalizedString());
    }

    public Set getKeysWithInterest(int interestType2, Object interestArg, boolean allowTombstones) {
        HashSet<Object> ret;
        if (interestType2 == 1) {
            if (interestArg == null || ".*".equals(interestArg)) {
                ret = new HashSet<Object>(this.keySet(allowTombstones));
            } else {
                ret = new HashSet();
                if (!(interestArg instanceof String)) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_REGULAR_EXPRESSION_ARGUMENT_WAS_NOT_A_STRING.toLocalizedString());
                }
                Pattern keyPattern = Pattern.compile((String)interestArg);
                for (Object entryKey : this.keySet(allowTombstones)) {
                    if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                    ret.add(entryKey);
                }
            }
        } else if (interestType2 == 0) {
            if (interestArg instanceof List) {
                ret = new HashSet();
                List keyList = (List)interestArg;
                for (Object entryKey : keyList) {
                    if (!this.containsKey(entryKey) && (!allowTombstones || !this.containsTombstone(entryKey))) continue;
                    ret.add(entryKey);
                }
            } else {
                ret = new HashSet();
                if (this.containsKey(interestArg) || allowTombstones && this.containsTombstone(interestArg)) {
                    ret.add(interestArg);
                }
            }
        } else {
            if (interestType2 == 2) {
                throw new UnsupportedOperationException(LocalizedStrings.AbstractRegion_INTERESTTYPEFILTER_CLASS_NOT_YET_SUPPORTED.toLocalizedString());
            }
            if (interestType2 == 3) {
                throw new UnsupportedOperationException(LocalizedStrings.AbstractRegion_INTERESTTYPEOQL_QUERY_NOT_YET_SUPPORTED.toLocalizedString());
            }
            throw new IllegalArgumentException(LocalizedStrings.AbstractRegion_UNSUPPORTED_INTEREST_TYPE_0.toLocalizedString(interestType2));
        }
        return ret;
    }

    @Override
    public List<String> getInterestListRegex() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.getInterestList(1);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_INTEREST_LIST_RETRIEVAL_REQUIRES_A_POOL.toLocalizedString());
    }

    public Set keySetOnServer() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.keySet();
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_SERVER_KEYSET_REQUIRES_A_POOL.toLocalizedString());
    }

    @Override
    public boolean containsKeyOnServer(Object key) {
        this.checkReadiness();
        this.checkForNoAccess();
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.containsKey(key);
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_SERVER_KEYSET_REQUIRES_A_POOL.toLocalizedString());
    }

    @Override
    public int sizeOnServer() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.size();
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_SERVER_SIZE_REQUIRES_A_POOL.toLocalizedString());
    }

    @Override
    public boolean isEmptyOnServer() {
        ServerRegionProxy proxy = this.getServerProxy();
        if (proxy != null) {
            return proxy.size() == 0;
        }
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_SERVER_ISEMPTY_REQUIRES_A_POOL.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localDestroyNoCallbacks(Object key) {
        if (logger.isDebugEnabled()) {
            logger.debug("localDestroyNoCallbacks key={}", key);
        }
        this.checkReadiness();
        this.validateKey(key);
        EntryEventImpl event = EntryEventImpl.create(this, Operation.LOCAL_DESTROY, key, false, this.getMyId(), false, true);
        try {
            this.basicDestroy(event, false, null);
        }
        catch (CacheWriterException e) {
            throw new Error(LocalizedStrings.LocalRegion_CACHE_WRITER_SHOULD_NOT_HAVE_BEEN_CALLED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        catch (TimeoutException e) {
            throw new Error(LocalizedStrings.LocalRegion_NO_DISTRIBUTED_LOCK_SHOULD_HAVE_BEEN_ATTEMPTED_FOR_LOCALDESTROY.toLocalizedString(), e);
        }
        catch (EntryNotFoundException entryNotFoundException) {
        }
        finally {
            event.release();
        }
    }

    private void clearViaList(List keys) {
        for (Object entryObject : this.entrySet(false)) {
            Region.Entry entry = (Region.Entry)entryObject;
            try {
                Object entryKey = entry.getKey();
                boolean match = false;
                for (Object key : keys) {
                    if (!entryKey.equals(key)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                this.localDestroyNoCallbacks(entryKey);
            }
            catch (EntryDestroyedException entryDestroyedException) {}
        }
    }

    private void clearViaRegEx(String key) {
        Pattern keyPattern = Pattern.compile(key);
        for (Region.Entry entry : this.entrySet(false)) {
            try {
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof String) || !keyPattern.matcher((String)entryKey).matches()) continue;
                this.localDestroyNoCallbacks(entryKey);
            }
            catch (EntryDestroyedException entryDestroyedException) {}
        }
    }

    private void clearViaFilterClass(String key) {
        InterestFilter filter;
        try {
            Class filterClass = ClassLoadUtil.classFromName(key);
            filter = (InterestFilter)filterClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(LocalizedStrings.LocalRegion_CLASS_0_NOT_FOUND_IN_CLASSPATH.toLocalizedString(key), cnfe);
        }
        catch (Exception e) {
            throw new RuntimeException(LocalizedStrings.LocalRegion_CLASS_0_COULD_NOT_BE_INSTANTIATED.toLocalizedString(key), e);
        }
        for (Object entryObject : this.entrySet(false)) {
            Region.Entry entry = (Region.Entry)entryObject;
            try {
                InterestEvent e;
                Object entryKey = entry.getKey();
                if (!(entryKey instanceof String) || !filter.notifyOnRegister(e = new InterestEvent(entryKey, entry.getValue(), true))) continue;
                this.localDestroyNoCallbacks(entryKey);
            }
            catch (EntryDestroyedException entryDestroyedException) {}
        }
    }

    private void clearViaQuery(String query) {
        throw new InternalGemFireError(LocalizedStrings.LocalRegion_NOT_YET_SUPPORTED.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshEntriesFromServerKeys(Connection con, List serverKeys, InterestResultPolicy interestResultPolicy) {
        if (serverKeys == null) {
            return;
        }
        ServerRegionProxy proxy = this.getServerProxy();
        if (logger.isDebugEnabled()) {
            this.logKeys(serverKeys, interestResultPolicy);
        }
        if (interestResultPolicy == InterestResultPolicy.NONE) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("refreshEntries region={}", (Object)this.getFullPath());
        }
        for (Object serverKey : serverKeys) {
            Endpoint endpoint;
            ArrayList keysList = (ArrayList)serverKey;
            if (keysList == null) continue;
            if (EntryLogger.isEnabled() && con != null && (endpoint = con.getEndpoint()) != null) {
                EntryLogger.setSource(endpoint.getMemberId(), "RIGII");
            }
            try {
                ArrayList list = new ArrayList(keysList);
                if (interestResultPolicy != InterestResultPolicy.KEYS_VALUES) {
                    for (Object currentKey : keysList) {
                        if (currentKey != null && !this.getImageState().hasDestroyedEntry(currentKey)) continue;
                        list.remove(currentKey);
                    }
                }
                if (interestResultPolicy == InterestResultPolicy.KEYS) {
                    if (this.isProxy()) continue;
                    for (Object currentKey : list) {
                        this.entries.initialImagePut(currentKey, 0L, Token.LOCAL_INVALID, false, false, null, null, false);
                    }
                    continue;
                }
                if (list.isEmpty()) continue;
                Assert.assertTrue(interestResultPolicy == InterestResultPolicy.KEYS_VALUES);
                VersionedObjectList values = (VersionedObjectList)list.get(0);
                if (logger.isDebugEnabled()) {
                    logger.debug("processing interest response: {}", (Object)values.size());
                }
                VersionedObjectList.Iterator listIt = values.iterator();
                while (listIt.hasNext()) {
                    VersionedObjectList.Entry entry = listIt.next();
                    Object currentKey = entry.getKey();
                    if (currentKey == null || this.getImageState().hasDestroyedEntry(currentKey)) continue;
                    Object val = entry.getObject();
                    boolean isBytes = entry.isBytes();
                    boolean isKeyOnServer = !entry.isKeyNotOnServer();
                    boolean isTombstone = this.getConcurrencyChecksEnabled() && entry.isKeyNotOnServer() && entry.getVersionTag() != null;
                    VersionTag tag = entry.getVersionTag();
                    if (val instanceof Throwable) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_CAUGHT_THE_FOLLOWING_EXCEPTION_FOR_KEY_0_WHILE_PERFORMING_A_REMOTE_GETALL, currentKey), (Throwable)val);
                        this.localDestroyNoCallbacks(currentKey);
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("refreshEntries key={} value={} version={}", currentKey, (Object)entry, (Object)tag);
                    }
                    if (tag == null) {
                        this.localDestroyNoCallbacks(currentKey);
                    }
                    if (val instanceof byte[] && !isBytes) {
                        val = CachedDeserializableFactory.create((byte[])val, this.getCache());
                    }
                    if (isTombstone) {
                        assert (val == null) : "server returned a value for a destroyed entry";
                        val = Token.TOMBSTONE;
                    }
                    if (val != null || isTombstone) {
                        if (this.isProxy()) continue;
                        this.entries.initialImagePut(currentKey, 0L, val, false, false, tag, null, false);
                        continue;
                    }
                    RegionEntry regionEntry = this.entries.getEntry(currentKey);
                    if (!this.isProxy() && isKeyOnServer) {
                        this.entries.initialImagePut(currentKey, 0L, Token.LOCAL_INVALID, false, false, tag, null, false);
                        continue;
                    }
                    if (regionEntry == null) continue;
                    RegionEntry regionEntry2 = regionEntry;
                    synchronized (regionEntry2) {
                        if (regionEntry.isDestroyedOrRemovedButNotTombstone()) {
                            this.entries.removeEntry(currentKey, regionEntry, false);
                        }
                    }
                }
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                throw dae;
            }
            finally {
                EntryLogger.clearSource();
            }
        }
    }

    private void logKeys(List serverKeys, InterestResultPolicy pol) {
        int totalKeys = 0;
        StringBuffer buffer = new StringBuffer();
        for (Object serverKey : serverKeys) {
            List keysList = (List)serverKey;
            if (keysList == null) continue;
            int numThisChunk = keysList.size();
            totalKeys += numThisChunk;
            for (Object key : keysList) {
                if (key == null) continue;
                if (key instanceof VersionedObjectList) {
                    Set keys = ((VersionedObjectList)key).keySet();
                    for (Object k : keys) {
                        buffer.append("  ").append(k).append(SystemUtils.getLineSeparator());
                    }
                    continue;
                }
                buffer.append("  ").append(key).append(SystemUtils.getLineSeparator());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} refreshEntriesFromServerKeys count={} policy={}{}{}", (Object)this, (Object)totalKeys, (Object)pol, (Object)SystemUtils.getLineSeparator(), (Object)buffer);
        }
    }

    public void clearKeysOfInterest(Object key, int interestType2, InterestResultPolicy interestResultPolicy) {
        switch (interestType2) {
            case 2: {
                this.clearViaFilterClass((String)key);
                break;
            }
            case 0: {
                if (key instanceof String && key.equals("ALL_KEYS")) {
                    this.clearViaRegEx(".*");
                    break;
                }
                if (key instanceof List) {
                    this.clearViaList((List)key);
                    break;
                }
                this.localDestroyNoCallbacks(key);
                break;
            }
            case 3: {
                this.clearViaQuery((String)key);
                break;
            }
            case 1: {
                this.clearViaRegEx((String)key);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNKNOWN_INTEREST_TYPE.toLocalizedString());
            }
        }
    }

    void reinitialize(InputStream inputStream, RegionEventImpl event) throws TimeoutException, IOException, ClassNotFoundException {
        this.acquireDestroyLock();
        try {
            this.reinitialize_destroy(event);
            this.recreate(inputStream, null);
        }
        finally {
            this.releaseDestroyLock();
        }
    }

    void reinitializeFromImageTarget(InternalDistributedMember imageTarget) throws TimeoutException, IOException, ClassNotFoundException {
        Assert.assertTrue(imageTarget != null);
        this.recreate(null, imageTarget);
    }

    boolean reinitialized_new() {
        return this.reinitialized_new;
    }

    void reinitialize_destroy(RegionEventImpl event) throws CacheWriterException, TimeoutException {
        boolean cacheWrite = !event.originRemote;
        this.cache.regionReinitializing(this.getFullPath());
        this.basicDestroyRegion(event, cacheWrite, false, true);
    }

    private void recreate(InputStream inputStream, InternalDistributedMember imageTarget) throws TimeoutException, IOException, ClassNotFoundException {
        String thePath = this.getFullPath();
        Region newRegion = null;
        try {
            LocalRegion parent = this.parentRegion;
            if (this.diskStoreImpl != null && this.diskStoreImpl.getName().equals("DEFAULT") && this.diskStoreName == null && !this.useDefaultDiskStore()) {
                this.diskStoreName = this.diskStoreImpl.getName();
            }
            LocalRegion attrs = this;
            boolean getDestroyLock = false;
            InternalRegionArguments internalRegionArguments = new InternalRegionArguments().setDestroyLockFlag(getDestroyLock).setSnapshotInputStream(inputStream).setImageTarget(imageTarget).setRecreateFlag(true);
            if (this instanceof BucketRegion) {
                BucketRegion me = (BucketRegion)this;
                internalRegionArguments.setPartitionedRegionBucketRedundancy(me.getRedundancyLevel());
            }
            newRegion = parent == null ? this.cache.createVMRegion(this.regionName, attrs, internalRegionArguments) : parent.createSubregion(this.regionName, attrs, internalRegionArguments);
        }
        catch (RegionExistsException e) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_GOT_REGIONEXISTSEXCEPTION_IN_REINITIALIZE_WHEN_HOLDING_DESTROY_LOCK.toLocalizedString(), e);
        }
        finally {
            if (newRegion == null) {
                this.cache.unregisterReinitializingRegion(thePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSnapshotDuringInitialization(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (DataInputStream in = new DataInputStream(inputStream);){
            Object key;
            RegionMap map = this.getRegionMap();
            byte snapshotVersion = in.readByte();
            if (snapshotVersion != 1) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_UNSUPPORTED_SNAPSHOT_VERSION_0_ONLY_VERSION_1_IS_SUPPORTED.toLocalizedString(snapshotVersion, (byte)1));
            }
            while ((key = DataSerializer.readObject(in)) != null) {
                Object value;
                byte aByte = in.readByte();
                if (aByte == 23) {
                    value = DataSerializer.readObject(in);
                } else if (aByte == 24 || aByte == 25) {
                    value = Token.LOCAL_INVALID;
                } else {
                    throw new IllegalArgumentException(LocalizedStrings.LocalRegion_UNEXPECTED_SNAPSHOT_CODE_0_THIS_SNAPSHOT_WAS_PROBABLY_WRITTEN_BY_AN_EARLIER_INCOMPATIBLE_RELEASE.toLocalizedString(aByte));
                }
                VersionTag tag = null;
                if (this.getConcurrencyChecksEnabled()) {
                    tag = VersionTag.create(this.getVersionMember());
                }
                map.initialImagePut(key, this.cacheTimeMillis(), value, false, false, tag, null, false);
            }
        }
        this.reinitialized_new = true;
    }

    @Override
    public Region getSubregion(String path, boolean destroyedRegionOk) {
        if (destroyedRegionOk) {
            this.checkCacheClosed();
        } else if (this.isDestroyed()) {
            return null;
        }
        if (path == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_PATH_SHOULD_NOT_BE_NULL.toLocalizedString());
        }
        if (path.isEmpty()) {
            this.waitOnInitialization();
            return this;
        }
        if (path.charAt(0) == '/') {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_PATH_SHOULD_NOT_START_WITH_A_SLASH.toLocalizedString());
        }
        LocalRegion region = this;
        String name = path;
        while (!name.isEmpty()) {
            int separatorIndex = name.indexOf(47);
            boolean last = separatorIndex < 0;
            String next = last ? name : name.substring(0, separatorIndex);
            if ((region = region.basicGetSubregion(next)) == null) {
                return null;
            }
            if (region.isDestroyed() && !destroyedRegionOk) {
                return null;
            }
            if (!last) {
                name = name.substring(separatorIndex + 1);
            }
            if (!last) continue;
        }
        region.waitOnInitialization();
        if (region.isDestroyed()) {
            if (!destroyedRegionOk) {
                return null;
            }
            return region;
        }
        return region;
    }

    public static int setThreadInitLevelRequirement(int level) {
        int oldLevel = LocalRegion.threadInitLevelRequirement();
        if (level == 0) {
            initializationThread.remove();
        } else {
            initializationThread.set(level);
        }
        return oldLevel;
    }

    public static int threadInitLevelRequirement() {
        Integer initLevel = initializationThread.get();
        if (initLevel == null) {
            return 0;
        }
        return initLevel;
    }

    @Override
    public boolean checkForInitialization() {
        if (this.initialized) {
            return true;
        }
        switch (LocalRegion.threadInitLevelRequirement()) {
            case 0: {
                return this.checkForInitialization(this.initializationLatchAfterGetInitialImage);
            }
            case 1: {
                return this.checkForInitialization(this.initializationLatchBeforeGetInitialImage);
            }
            case 2: {
                return true;
            }
        }
        throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_THREADINITLEVELREQUIREMENT.toLocalizedString());
    }

    private boolean checkForInitialization(StoppableCountDownLatch latch) {
        return latch.getCount() == 0L;
    }

    @Override
    public void waitOnInitialization() {
        if (this.initialized) {
            return;
        }
        switch (LocalRegion.threadInitLevelRequirement()) {
            case 0: {
                this.waitOnInitialization(this.initializationLatchAfterGetInitialImage);
                break;
            }
            case 1: {
                this.waitOnInitialization(this.initializationLatchBeforeGetInitialImage);
                break;
            }
            case 2: {
                return;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.LocalRegion_UNEXPECTED_THREADINITLEVELREQUIREMENT.toLocalizedString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitOnInitialization(StoppableCountDownLatch latch) {
        if (latch == null) {
            return;
        }
        while (true) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.cache.getCancelCriterion().checkCancelInProgress(e);
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void waitForData() {
        if (this.initialized) {
            return;
        }
        this.waitOnInitialization(this.initializationLatchAfterGetInitialImage);
    }

    @Override
    public RegionEntry basicGetEntry(Object key) {
        RegionEntry regionEntry = this.entries.getEntry(key);
        if (regionEntry != null && regionEntry.isRemoved()) {
            regionEntry = null;
        }
        return regionEntry;
    }

    public void basicInvalidate(EntryEventImpl event) throws EntryNotFoundException {
        this.basicInvalidate(event, this.isInitialized());
    }

    @Override
    public DiskEntry initializeRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        Assert.assertTrue(this.diskRegion != null);
        RegionEntry regionEntry = this.entries.initRecoveredEntry(key, re);
        if (regionEntry == null) {
            throw new InternalGemFireError(LocalizedStrings.LocalRegion_ENTRY_ALREADY_EXISTED_0.toLocalizedString(key));
        }
        return (DiskEntry)regionEntry;
    }

    @Override
    public DiskEntry updateRecoveredEntry(Object key, DiskEntry.RecoveredEntry re) {
        Assert.assertTrue(this.diskRegion != null);
        RegionEntry regionEntry = this.entries.updateRecoveredEntry(key, re);
        return (DiskEntry)regionEntry;
    }

    @Override
    public void copyRecoveredEntries(RegionMap rm) {
        this.entries.copyRecoveredEntries(rm);
    }

    @Override
    public void recordRecoveredGCVersion(VersionSource member, long gcVersion) {
        this.versionVector.recordGCVersion(member, gcVersion);
        DiskRegion region = this.getDiskRegion();
        if (region != null) {
            region.recordRecoveredGCVersion(member, gcVersion);
        }
    }

    @Override
    public void recordRecoveredVersonHolder(VersionSource member, RegionVersionHolder versionHolder, boolean latestOplog) {
        if (this.getConcurrencyChecksEnabled()) {
            this.versionVector.initRecoveredVersion(member, versionHolder, latestOplog);
            DiskRegion region = this.getDiskRegion();
            if (region != null) {
                region.recordRecoveredVersonHolder(member, versionHolder, latestOplog);
            }
        }
    }

    @Override
    public void recordRecoveredVersionTag(VersionTag tag) {
        if (this.getConcurrencyChecksEnabled()) {
            this.versionVector.recordVersion(tag.getMemberID(), tag.getRegionVersion());
            DiskRegion region = this.getDiskRegion();
            if (region != null) {
                region.recordRecoveredVersionTag(tag);
            }
        }
    }

    @Override
    public void setRVVTrusted(boolean rvvTrusted) {
        DiskRegion region;
        if (this.getConcurrencyChecksEnabled() && (region = this.getDiskRegion()) != null) {
            region.setRVVTrusted(rvvTrusted);
        }
    }

    public Iterator<RegionEntry> getBestIterator(boolean includeValues) {
        if (this instanceof DistributedRegion) {
            return ((DistributedRegion)this).getBestIterator(includeValues);
        }
        return this.entries.regionEntries().iterator();
    }

    void repairRVV() {
        RegionVersionVector rvv = this.getVersionVector();
        if (rvv == null) {
            return;
        }
        Iterator<RegionEntry> it = this.getBestIterator(false);
        VersionSource myId = this.getVersionMember();
        while (it.hasNext()) {
            RegionEntry mapEntry = it.next();
            VersionStamp stamp = mapEntry.getVersionStamp();
            Object id = stamp.getMemberID();
            if (id == null) {
                id = myId;
            }
            rvv.recordVersion(id, stamp.getRegionVersion());
        }
    }

    private void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks) throws EntryNotFoundException {
        this.basicInvalidate(event, invokeCallbacks, false);
    }

    void basicInvalidate(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws EntryNotFoundException {
        if (!event.isOriginRemote() && !event.isDistributed() && this.getScope().isDistributed() && this.getDataPolicy().withReplication() && invokeCallbacks) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_CANNOT_DO_A_LOCAL_INVALIDATE_ON_A_REPLICATED_REGION.toLocalizedString());
        }
        if (this.hasSeenEvent(event)) {
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "LR.basicInvalidate: this cache has already seen this event {}", (Object)event);
            }
            if (this.getConcurrencyChecksEnabled() && event.getVersionTag() != null && !event.getVersionTag().isRecorded()) {
                this.getVersionVector().recordVersion((InternalDistributedMember)event.getDistributedMember(), event.getVersionTag());
            }
            return;
        }
        this.discoverJTA();
        this.getDataView().invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    void basicInvalidatePart2(RegionEntry regionEntry, EntryEventImpl event, boolean conflictWithClear, boolean invokeCallbacks) {
        this.updateStatsForInvalidate();
        if (invokeCallbacks) {
            try {
                regionEntry.dispatchListenerEvents(event);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                this.stopper.checkCancelInProgress(null);
            }
        } else {
            event.callbacksInvoked(true);
        }
    }

    private void updateStatsForInvalidate() {
        this.getCachePerfStats().incInvalidates();
    }

    void basicInvalidatePart3(RegionEntry re, EntryEventImpl event, boolean invokeCallbacks) {
    }

    @Override
    public void invokeInvalidateCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        if (callDispatchListenerEvent) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    void txApplyInvalidate(Object key, Object newValue, boolean didDestroy, TransactionId transactionId, TXRmtEvent event, boolean localOp, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        this.entries.txApplyInvalidate(key, newValue, didDestroy, transactionId, event, localOp, eventId, aCallbackArgument, pendingCallbacks, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
    }

    void txApplyInvalidatePart2(RegionEntry regionEntry, Object key, boolean didDestroy, boolean didInvalidate) {
        if (this.testCallable != null) {
            this.testCallable.call(this, Operation.INVALIDATE, regionEntry);
        }
        if (didInvalidate) {
            this.updateStatsForInvalidate();
        }
        if (didDestroy && this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(key);
        }
    }

    public boolean basicPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) throws TimeoutException, CacheWriterException {
        return this.getDataView().putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, 0L, false);
    }

    void txApplyPut(Operation putOp, Object key, Object newValue, boolean didDestroy, TransactionId transactionId, TXRmtEvent event, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        long startPut = CachePerfStats.getStatTime();
        this.entries.txApplyPut(putOp, key, newValue, didDestroy, transactionId, event, eventId, aCallbackArgument, pendingCallbacks, filterRoutingInfo, bridgeContext, txEntryState, versionTag, tailKey);
        this.updateStatsForPut(startPut);
        this.checkReadiness();
    }

    private void updateStatsForPut(long startPut) {
        this.getCachePerfStats().endPut(startPut, false);
    }

    void txApplyPutPart2(RegionEntry regionEntry, Object key, long lastModified, boolean isCreate, boolean didDestroy, boolean clearConflict) {
        if (this.testCallable != null) {
            Operation op = isCreate ? Operation.CREATE : Operation.UPDATE;
            this.testCallable.call(this, op, regionEntry);
        }
        if (isCreate) {
            this.updateStatsForCreate();
        }
        if (!this.isProxy() && !clearConflict && this.indexManager != null) {
            try {
                this.indexManager.updateIndexes(regionEntry, isCreate ? 1 : 2, isCreate ? 0 : 2);
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
        }
        if (didDestroy && this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(key);
        }
        if (this.statisticsEnabled && !clearConflict) {
            this.addExpiryTaskIfAbsent(regionEntry);
        }
        this.setLastModifiedTime(lastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean basicBridgeCreate(Object key, byte[] value, boolean isObject, Object callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent, boolean throwEntryExists) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        Object theCallbackArg = callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient && this.isGatewaySenderEnabled()) {
            theCallbackArg = new GatewaySenderEventCallbackArgument(theCallbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.CREATE, key, (Object)value, theCallbackArg, false, client.getDistributedMember(), true, eventId);
        try {
            event.setContext(client);
            event.setVersionTag(clientEvent.getVersionTag());
            event.setPossibleDuplicate(clientEvent.isPossibleDuplicate());
            if (this.getDataPolicy() == DataPolicy.NORMAL) {
                event.setLocalInvalid(true);
            }
            if (value != null) {
                if (isObject) {
                    event.setSerializedNewValue(value);
                } else {
                    event.setNewValue(value);
                }
            }
            boolean ifNew = true;
            boolean ifOld = false;
            long lastModified = 0L;
            boolean overwriteDestroyed = false;
            boolean success = this.basicUpdate(event, ifNew, ifOld, lastModified, overwriteDestroyed);
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            if (success) {
                clientEvent.setVersionTag(event.getVersionTag());
                this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
            } else {
                this.stopper.checkCancelInProgress(null);
                if (throwEntryExists) {
                    throw new EntryExistsException("" + key, event.getOldValue());
                }
            }
            boolean bl = success;
            return bl;
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean basicBridgePut(Object key, Object value, byte[] deltaBytes, boolean isObject, Object callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, CacheWriterException {
        EventID eventID = clientEvent.getEventId();
        Object theCallbackArg = callbackArg;
        long startPut = CachePerfStats.getStatTime();
        if (fromClient && this.isGatewaySenderEnabled()) {
            theCallbackArg = new GatewaySenderEventCallbackArgument(theCallbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.UPDATE, key, null, theCallbackArg, false, memberId.getDistributedMember(), true, eventID);
        try {
            event.setContext(memberId);
            event.setDeltaBytes(deltaBytes);
            event.setVersionTag(clientEvent.getVersionTag());
            event.setPossibleDuplicate(clientEvent.isPossibleDuplicate());
            if (isObject && value instanceof byte[]) {
                event.setSerializedNewValue((byte[])value);
            } else {
                event.setNewValue(value);
            }
            boolean success = false;
            try {
                boolean ifNew = false;
                boolean ifOld = false;
                long lastModified = 0L;
                boolean overwriteDestroyed = false;
                success = this.basicUpdate(event, ifNew, ifOld, lastModified, overwriteDestroyed);
            }
            catch (ConcurrentCacheModificationException ignore) {
                event.isConcurrencyConflict(true);
            }
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            if (success) {
                clientEvent.setVersionTag(event.getVersionTag());
                this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
            } else {
                this.stopper.checkCancelInProgress(null);
            }
            boolean bl = success;
            return bl;
        }
        finally {
            event.release();
        }
    }

    private void concurrencyConfigurationCheck(VersionTag tag) {
        if (!this.concurrencyMessageIssued && tag == null && this.getConcurrencyChecksEnabled()) {
            this.concurrencyMessageIssued = true;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_SERVER_HAS_CONCURRENCY_CHECKS_ENABLED_0_BUT_CLIENT_HAS_1_FOR_REGION_2, new Object[]{!this.getConcurrencyChecksEnabled(), this.getConcurrencyChecksEnabled(), this}));
        }
    }

    public void basicBridgeClientUpdate(DistributedMember serverId, Object key, Object value, byte[] deltaBytes, boolean isObject, Object callbackArgument, boolean isCreate, boolean processedMarker, EntryEventImpl event, EventID eventID) throws TimeoutException, CacheWriterException {
        if (this.isCacheContentProxy()) {
            return;
        }
        this.concurrencyConfigurationCheck(event.getVersionTag());
        long startPut = CachePerfStats.getStatTime();
        if (this.generateEventID() && !this.cache.getCacheServers().isEmpty()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        } else {
            event.setEventId(eventID);
        }
        event.setDeltaBytes(deltaBytes);
        if (value != null) {
            if (isObject && value instanceof byte[]) {
                event.setSerializedNewValue((byte[])value);
            } else {
                event.setNewValue(value);
            }
        }
        if (processedMarker) {
            boolean ifNew = false;
            boolean ifOld = false;
            long lastModified = 0L;
            boolean overwriteDestroyed = true;
            if (this.basicUpdate(event, ifNew, ifOld, lastModified, overwriteDestroyed)) {
                this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
            }
        } else if (this.isInitialized()) {
            this.invokePutCallbacks(isCreate ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE, event, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeClientInvalidate(DistributedMember serverId, Object key, Object callbackArgument, boolean processedMarker, EventID eventID, VersionTag versionTag) throws EntryNotFoundException {
        if (!this.isCacheContentProxy()) {
            this.concurrencyConfigurationCheck(versionTag);
            EntryEventImpl event = EntryEventImpl.create(this, Operation.INVALIDATE, key, null, callbackArgument, true, serverId);
            try {
                event.setVersionTag(versionTag);
                event.setFromServer(true);
                if (this.generateEventID() && !this.cache.getCacheServers().isEmpty()) {
                    event.setNewEventId(this.cache.getDistributedSystem());
                } else {
                    event.setEventId(eventID);
                }
                if (processedMarker) {
                    boolean forceNewEntry = this.getConcurrencyChecksEnabled();
                    this.basicInvalidate(event, true, forceNewEntry);
                    if (event.isConcurrencyConflict()) {
                        throw new ConcurrentCacheModificationException();
                    }
                } else if (this.isInitialized()) {
                    this.invokeInvalidateCallbacks(EnumListenerEvent.AFTER_INVALIDATE, event, true);
                }
            }
            finally {
                event.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeClientDestroy(DistributedMember serverId, Object key, Object callbackArgument, boolean processedMarker, EventID eventID, VersionTag versionTag) throws EntryNotFoundException {
        if (!this.isCacheContentProxy()) {
            this.concurrencyConfigurationCheck(versionTag);
            EntryEventImpl event = EntryEventImpl.create(this, Operation.DESTROY, key, null, callbackArgument, true, serverId);
            try {
                event.setFromServer(true);
                event.setVersionTag(versionTag);
                if (this.generateEventID() && !this.cache.getCacheServers().isEmpty()) {
                    event.setNewEventId(this.cache.getDistributedSystem());
                } else {
                    event.setEventId(eventID);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("basicBridgeClientDestroy(processedMarker={})", (Object)processedMarker);
                }
                if (processedMarker) {
                    this.basicDestroy(event, false, null);
                    if (event.isConcurrencyConflict()) {
                        throw new ConcurrentCacheModificationException();
                    }
                } else if (this.isInitialized()) {
                    this.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, event, true, true);
                }
            }
            finally {
                event.release();
            }
        }
    }

    public void basicBridgeClientClear(Object callbackArgument, boolean processedMarker) {
        this.checkReadiness();
        this.checkForNoAccess();
        RegionEventImpl event = new RegionEventImpl((Region)this, Operation.REGION_LOCAL_CLEAR, callbackArgument, true, (DistributedMember)this.getMyId(), this.generateEventID());
        if (processedMarker) {
            this.basicLocalClear(event);
        } else if (this.isInitialized()) {
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_CLEAR, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeDestroy(Object key, Object callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Object theCallbackArg = callbackArg;
        if (fromClient && this.isGatewaySenderEnabled()) {
            theCallbackArg = new GatewaySenderEventCallbackArgument(theCallbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.DESTROY, key, null, theCallbackArg, false, memberId.getDistributedMember(), true, clientEvent.getEventId());
        try {
            event.setContext(memberId);
            event.setVersionTag(clientEvent.getVersionTag());
            try {
                this.basicDestroy(event, true, null);
            }
            catch (ConcurrentCacheModificationException ignore) {
                event.isConcurrencyConflict(true);
            }
            finally {
                clientEvent.setVersionTag(event.getVersionTag());
                clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
                clientEvent.setIsRedestroyedEntry(event.getIsRedestroyedEntry());
            }
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeInvalidate(Object key, Object callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        Object theCallbackArg = callbackArg;
        if (fromClient && this.isGatewaySenderEnabled()) {
            theCallbackArg = new GatewaySenderEventCallbackArgument(theCallbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.INVALIDATE, key, null, theCallbackArg, false, memberId.getDistributedMember(), true, clientEvent.getEventId());
        try {
            event.setContext(memberId);
            event.setVersionTag(clientEvent.getVersionTag());
            try {
                this.basicInvalidate(event);
            }
            finally {
                clientEvent.setVersionTag(event.getVersionTag());
                clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            }
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeUpdateVersionStamp(Object key, Object callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) {
        EntryEventImpl event = EntryEventImpl.create(this, Operation.UPDATE_VERSION_STAMP, key, null, null, false, memberId.getDistributedMember(), false, clientEvent.getEventId());
        event.setContext(memberId);
        event.setVersionTag(clientEvent.getVersionTag());
        try {
            this.basicUpdateEntryVersion(event);
        }
        finally {
            clientEvent.setVersionTag(event.getVersionTag());
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            event.release();
        }
    }

    void basicUpdateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        if (this.hasSeenEvent(event)) {
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "LR.basicDestroy: this cache has already seen this event {}", (Object)event);
            }
            if (this.getConcurrencyChecksEnabled() && event.getVersionTag() != null && !event.getVersionTag().isRecorded()) {
                this.getVersionVector().recordVersion((InternalDistributedMember)event.getDistributedMember(), event.getVersionTag());
            }
            return;
        }
        this.getDataView().updateEntryVersion(event);
    }

    boolean basicUpdate(EntryEventImpl event, boolean ifNew, boolean ifOld, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        if (this.keyConstraint != null && !this.keyConstraint.isInstance(event.getKey())) {
            throw new ClassCastException(LocalizedStrings.LocalRegion_KEY_0_DOES_NOT_SATISFY_KEYCONSTRAINT_1.toLocalizedString(event.getKey().getClass().getName(), this.keyConstraint.getName()));
        }
        this.validateValue(event.basicGetNewValue());
        return this.getDataView().putEntry(event, ifNew, ifOld, null, false, lastModified, overwriteDestroyed);
    }

    boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        RegionEntry oldEntry;
        if (!MemoryThresholds.isLowMemoryExceptionDisabled()) {
            this.checkIfAboveThreshold(event);
        }
        Operation originalOp = event.getOperation();
        try {
            oldEntry = this.entries.basicPut(event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue, overwriteDestroyed);
        }
        catch (ConcurrentCacheModificationException ignore) {
            if (logger.isDebugEnabled()) {
                logger.debug("caught concurrent modification attempt when applying {}", (Object)event);
            }
            this.notifyBridgeClients(event);
            this.notifyGatewaySender(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
            return false;
        }
        ServerRegionProxy mySRP = this.getServerProxy();
        if (mySRP != null && this.getDataPolicy() == DataPolicy.EMPTY) {
            if (originalOp == Operation.PUT_IF_ABSENT) {
                return !event.hasOldValue();
            }
            if (originalOp == Operation.REPLACE && !requireOldValue) {
                return true;
            }
        }
        return oldEntry != null;
    }

    public void checkIfAboveThreshold(EntryEventImpl entryEvent) throws LowMemoryException {
        boolean alreadyCheckedThreshold;
        if (entryEvent == null) {
            this.checkIfAboveThreshold("UNKNOWN");
            return;
        }
        boolean bl = alreadyCheckedThreshold = this.hasServerProxy() && entryEvent.getOperation().isPutAll();
        if (!alreadyCheckedThreshold && !entryEvent.isOriginRemote()) {
            this.checkIfAboveThreshold(entryEvent.getKey());
        }
    }

    private void checkIfAboveThreshold(Object key) throws LowMemoryException {
        if (this.memoryThresholdReached.get()) {
            Set<DistributedMember> membersThatReachedThreshold = this.getMemoryThresholdReachedMembers();
            InternalResourceManager.getInternalResourceManager(this.cache).getHeapMonitor().updateStateAndSendEvent();
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_IN_0_FOR_PUT_1_MEMBER_2.toLocalizedString(this.getFullPath(), key, membersThatReachedThreshold), membersThatReachedThreshold);
        }
    }

    protected RegionEntry basicPutEntry(EntryEventImpl event, long lastModified) throws TimeoutException, CacheWriterException {
        this.discoverJTA();
        TXStateProxy tx = this.getTXState();
        boolean ifNew = false;
        if (this.isTX()) {
            tx.txPutEntry(event, false, false, false, null);
            return null;
        }
        if (DistTXState.internalBeforeNonTXBasicPut != null) {
            DistTXState.internalBeforeNonTXBasicPut.run();
        }
        return this.entries.basicPut(event, lastModified, false, false, null, false, false);
    }

    protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        boolean invokeCallbacks;
        boolean isNewKey = event.getOperation().isCreate();
        boolean bl = invokeCallbacks = event.basicGetNewValue() != Token.TOMBSTONE;
        if (isNewKey) {
            this.updateStatsForCreate();
        }
        boolean lruRecentUse = event.isNetSearch() || event.isLoad();
        long lastModifiedTime = event.getEventTime(lastModified);
        this.updateStatsForPut(entry, lastModifiedTime, lruRecentUse);
        if (!this.isProxy() && !clearConflict && this.indexManager != null) {
            try {
                if (!entry.isInvalid()) {
                    this.indexManager.updateIndexes(entry, isNewKey ? 1 : 2, isNewKey ? 0 : 2);
                }
            }
            catch (QueryException e) {
                throw new IndexMaintenanceException(e);
            }
            finally {
                IndexManager.setIndexBufferTime(lastModifiedTime, this.cacheTimeMillis());
            }
        }
        if (invokeCallbacks) {
            boolean doCallback = false;
            if (isInitialized) {
                if (event.isGenerateCallbacks()) {
                    doCallback = true;
                }
            } else if (this.isUsedForPartitionedRegionBucket) {
                doCallback = true;
            }
            if (doCallback) {
                if (event.isBulkOpInProgress() && this.isUsedForPartitionedRegionBucket) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("For bulk operation on bucket region, not to notify gateway sender earlier.");
                    }
                } else {
                    this.notifyGatewaySender(event.getOperation().isUpdate() ? EnumListenerEvent.AFTER_UPDATE : EnumListenerEvent.AFTER_CREATE, event);
                }
                if (!event.isBulkOpInProgress()) {
                    try {
                        entry.dispatchListenerEvents(event);
                    }
                    catch (InterruptedException ignore) {
                        Thread.currentThread().interrupt();
                        this.stopper.checkCancelInProgress(null);
                    }
                }
            }
        }
        return lastModifiedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateLocalFilterRouting(InternalCacheEvent event) {
        boolean isEntryEvent = event.getOperation().isEntry();
        EntryEventImpl entryEvent = isEntryEvent ? (EntryEventImpl)event : null;
        FilterProfile filterProfile = this.getFilterProfile();
        FilterRoutingInfo.FilterInfo routing = event.getLocalFilterInfo();
        if (filterProfile != null && routing == null) {
            boolean lockForCQ = false;
            RegionEntry regionEntryObject = null;
            if (isEntryEvent && entryEvent.getRegionEntry() != null) {
                regionEntryObject = entryEvent.getRegionEntry();
                if (!entryEvent.isConcurrencyConflict()) {
                    Assert.assertTrue(regionEntryObject != null);
                    lockForCQ = true;
                }
            }
            if (isEntryEvent && logger.isDebugEnabled()) {
                logger.debug("getting local client routing.");
            }
            if (lockForCQ) {
                RegionEntry regionEntry = regionEntryObject;
                synchronized (regionEntry) {
                    routing = filterProfile.getLocalFilterRouting(event);
                }
            } else {
                routing = filterProfile.getLocalFilterRouting(event);
            }
            event.setLocalFilterInfo(routing);
        }
        if (routing != null && event.getOperation().isEntry() && ((EntryEventImpl)event).isConcurrencyConflict()) {
            if (logger.isDebugEnabled()) {
                logger.debug("clearing CQ routing for event that's in conflict");
            }
            routing.clearCQRouting();
        }
    }

    @Override
    public void notifyTimestampsToGateways(EntryEventImpl event) {
        VersionTagHolder updateTimeStampEvent = new VersionTagHolder(event.getVersionTag());
        updateTimeStampEvent.setOperation(Operation.UPDATE_VERSION_STAMP);
        updateTimeStampEvent.setKeyInfo(event.getKeyInfo());
        updateTimeStampEvent.setGenerateCallbacks(false);
        updateTimeStampEvent.distributedMember = event.getDistributedMember();
        updateTimeStampEvent.setNewEventId(this.getSystem());
        if (event.getRegion() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)event.getRegion();
            PartitionedRegion partitionedRegion = bucketRegion.getPartitionedRegion();
            updateTimeStampEvent.setRegion(partitionedRegion);
            if (partitionedRegion.isParallelWanEnabled()) {
                bucketRegion.handleWANEvent(updateTimeStampEvent);
            }
            if (partitionedRegion.isInitialized()) {
                partitionedRegion.notifyGatewaySender(EnumListenerEvent.TIMESTAMP_UPDATE, updateTimeStampEvent);
            }
        } else {
            updateTimeStampEvent.setRegion(event.getRegion());
            this.notifyGatewaySender(EnumListenerEvent.TIMESTAMP_UPDATE, updateTimeStampEvent);
        }
    }

    private void updateStatsForCreate() {
        this.getCachePerfStats().incCreates();
    }

    public void basicPutPart3(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean invokeCallbacks, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) {
        if (invokeCallbacks && event.isBulkOpInProgress()) {
            event.getPutAllOperation().addEntry(event);
        }
    }

    @Override
    public void invokePutCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (!event.isGenerateCallbacks()) {
            return;
        }
        Operation op = event.getOperation();
        if (op == Operation.PUT_IF_ABSENT) {
            event.setOperation(Operation.CREATE);
        } else if (op == Operation.REPLACE) {
            event.setOperation(Operation.UPDATE);
        }
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        if (notifyGateways) {
            this.notifyGatewaySender(eventType, event);
        }
        if (callDispatchListenerEvent) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    public Map<? extends DataSerializable, ? extends DataSerializable> getEventState() {
        return this.getEventTracker().getState();
    }

    protected void recordEventState(InternalDistributedMember provider, Map state) {
        this.getEventTracker().recordState(provider, state);
    }

    @Override
    public void generateAndSetVersionTag(InternalCacheEvent event, RegionEntry entry) {
        EntryEventImpl entryEvent;
        if (entry != null && event.getOperation().isEntry() && !(entryEvent = (EntryEventImpl)event).isOriginRemote() && this.shouldGenerateVersionTag(entry, entryEvent)) {
            boolean eventHasDelta = this.getSystem().getConfig().getDeltaPropagation() && !this.scope.isDistributedNoAck() && entryEvent.getDeltaBytes() != null;
            VersionTag v = entry.generateVersionTag(null, eventHasDelta, this, entryEvent);
            if (logger.isDebugEnabled() && v != null) {
                logger.debug("generated version tag {} for {}", (Object)v, entryEvent.getKey());
            }
        }
    }

    @Override
    public void recordEvent(InternalCacheEvent event) {
        this.getEventTracker().recordEvent(event);
    }

    public boolean hasSeenEvent(EntryEventImpl event) {
        return this.getEventTracker().hasSeenEvent(event);
    }

    public VersionTag findVersionTagForEvent(EventID eventId) {
        return this.getEventTracker().findVersionTagForSequence(eventId);
    }

    public VersionTag findVersionTagForClientBulkOp(EventID eventId) {
        return this.getEventTracker().findVersionTagForBulkOp(eventId);
    }

    public boolean hasSeenEvent(EventID eventID) {
        return this.getEventTracker().hasSeenEvent(eventID);
    }

    public void syncBulkOp(Runnable task, EventID eventId) {
        this.getEventTracker().syncBulkOp(task, eventId, this.isTX());
    }

    public void recordBulkOpStart(ThreadIdentifier membershipID, EventID eventID) {
        if (!this.isTX()) {
            this.getEventTracker().recordBulkOpStart(eventID, membershipID);
        }
    }

    protected void notifyBridgeClients(CacheEvent event) {
        int numBS = this.getCache().getCacheServers().size();
        if (event.getOperation().isLocal() || numBS == 0) {
            return;
        }
        if (event instanceof EntryEventImpl && ((EntryEventImpl)event).inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", (Object)event);
            }
            return;
        }
        if (this.shouldNotifyBridgeClients()) {
            EntryEventImpl e;
            if (numBS > 0 && logger.isDebugEnabled()) {
                logger.debug("{}: notifying {} bridge servers of event: {}", (Object)this.getName(), (Object)numBS, (Object)event);
            }
            Operation op = event.getOperation();
            if (event.getOperation().isEntry() && (e = (EntryEventImpl)event).getEventType() == null) {
                if (op.isCreate()) {
                    e.setEventType(EnumListenerEvent.AFTER_CREATE);
                } else if (op.isUpdate()) {
                    e.setEventType(EnumListenerEvent.AFTER_UPDATE);
                } else if (op.isDestroy()) {
                    e.setEventType(EnumListenerEvent.AFTER_DESTROY);
                } else if (op.isInvalidate()) {
                    e.setEventType(EnumListenerEvent.AFTER_INVALIDATE);
                } else {
                    throw new IllegalStateException("event is missing client notification eventType: " + e);
                }
            }
            InternalCacheEvent ice = (InternalCacheEvent)event;
            if (!this.isUsedForPartitionedRegionBucket()) {
                this.generateLocalFilterRouting(ice);
            }
            CacheClientNotifier.notifyClients((InternalCacheEvent)event);
        }
    }

    public boolean notifiesMultipleSerialGateways() {
        List<Integer> allRemoteDSIds;
        if (this.isPdxTypesRegion()) {
            return false;
        }
        Set<String> allGatewaySenderIds = this.getAllGatewaySenderIds();
        if (!allGatewaySenderIds.isEmpty() && (allRemoteDSIds = this.getRemoteDsIds(allGatewaySenderIds)) != null) {
            int serialGatewayCount = 0;
            for (GatewaySender sender : this.getCache().getAllGatewaySenders()) {
                if (!allGatewaySenderIds.contains(sender.getId()) || sender.isParallel() || ++serialGatewayCount <= 1) continue;
                return true;
            }
        }
        return false;
    }

    protected void notifyGatewaySender(EnumListenerEvent operation, EntryEventImpl event) {
        if (this.isPdxTypesRegion()) {
            return;
        }
        if (event.inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", (Object)event);
            }
            return;
        }
        this.checkSameSenderIdsAvailableOnAllNodes();
        Set<String> allGatewaySenderIds = event.getOperation() == Operation.UPDATE_VERSION_STAMP ? this.getGatewaySenderIds() : this.getAllGatewaySenderIds();
        List<Integer> allRemoteDSIds = this.getRemoteDsIds(allGatewaySenderIds);
        if (allRemoteDSIds != null) {
            for (GatewaySender sender : this.getCache().getAllGatewaySenders()) {
                if (!allGatewaySenderIds.contains(sender.getId())) continue;
                if (!this.getDataPolicy().withStorage() && sender.isParallel()) {
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Notifying the GatewaySender : {}", (Object)sender.getId());
                }
                ((AbstractGatewaySender)sender).distribute(operation, event, allRemoteDSIds);
            }
        }
    }

    public void checkSameSenderIdsAvailableOnAllNodes() {
    }

    void basicDestroyRegion(RegionEventImpl event, boolean cacheWrite) throws CacheWriterException, TimeoutException {
        this.basicDestroyRegion(event, cacheWrite, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicDestroyRegion(RegionEventImpl event, boolean cacheWrite, boolean lock, boolean callbackEvents) throws CacheWriterException, TimeoutException {
        block35: {
            this.preDestroyChecks();
            TXStateProxy tx = this.cache.getTXMgr().pauseTransaction();
            try {
                boolean acquiredLock;
                block34: {
                    acquiredLock = false;
                    if (lock) {
                        try {
                            this.acquireDestroyLock();
                            acquiredLock = true;
                        }
                        catch (CancelException ignore) {
                            if (!logger.isDebugEnabled()) break block34;
                            logger.debug("basicDestroyRegion: acquireDestroyLock failed due to cache closure, region = {}", (Object)this.getFullPath());
                        }
                    }
                }
                try {
                    this.checkRegionDestroyed(false);
                    boolean cancelledByCacheWriterException = false;
                    HashSet eventSet = null;
                    try {
                        if (this instanceof PartitionedRegion && !((PartitionedRegion)this).getParallelGatewaySenderIds().isEmpty()) {
                            ((PartitionedRegion)this).destroyParallelGatewaySenderRegion(event.getOperation(), cacheWrite, lock, callbackEvents);
                        }
                        if (this.parentRegion != null) {
                            this.parentRegion.updateStats();
                        }
                        try {
                            eventSet = callbackEvents ? new HashSet() : null;
                            this.destroyedSubregionSerialNumbers = this.collectSubregionSerialNumbers();
                            this.recursiveDestroyRegion(eventSet, event, cacheWrite);
                        }
                        catch (CancelException e) {
                            if (!this.cache.forcedDisconnect()) {
                                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_RECURSIVEDESTROYREGION_RECURSION_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
                            }
                        }
                        catch (CacheWriterException cwe) {
                            cancelledByCacheWriterException = true;
                            throw cwe;
                        }
                        Assert.assertTrue(this.isDestroyed);
                        if (!this.isInternalRegion()) {
                            InternalDistributedSystem system = this.cache.getInternalDistributedSystem();
                            system.handleResourceEvent(ResourceEvent.REGION_REMOVE, this);
                        }
                        try {
                            LocalRegion parent = this.parentRegion;
                            if (parent == null) {
                                this.cache.removeRoot(this);
                                break block35;
                            }
                            parent.subregions.remove(this.regionName, this);
                        }
                        catch (CancelException e) {
                            if (!this.cache.forcedDisconnect()) {
                                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_BASICDESTROYREGION_PARENT_REMOVAL_FAILED_DUE_TO_CACHE_CLOSURE_REGION_0, this.getFullPath()), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (!cancelledByCacheWriterException) {
                            event.setEventType(EnumListenerEvent.AFTER_REGION_DESTROY);
                            this.notifyBridgeClients(event);
                        }
                        if (eventSet != null && callbackEvents) {
                            try {
                                this.sendPendingRegionDestroyEvents(eventSet);
                            }
                            catch (CancelException cancelException) {}
                        }
                    }
                }
                finally {
                    if (acquiredLock) {
                        try {
                            this.releaseDestroyLock();
                        }
                        catch (CancelException cancelException) {}
                    }
                }
            }
            finally {
                this.cache.getTXMgr().unpauseTransaction(tx);
            }
        }
    }

    protected void preDestroyChecks() {
    }

    protected void distributeDestroyRegion(RegionEventImpl event, boolean notifyOfRegionDeparture) {
    }

    @Override
    public void postCreateRegion() {
        if (this.getEvictionAttributes().getAlgorithm().isLRUHeap()) {
            LogWriter logWriter = this.cache.getLogger();
            float evictionPercentage = 80.0f;
            InternalResourceManager rm = this.cache.getInternalResourceManager();
            if (!this.getOffHeap()) {
                if (!rm.getHeapMonitor().hasEvictionThreshold()) {
                    float criticalPercentage = rm.getCriticalHeapPercentage();
                    if (criticalPercentage > 0.0f) {
                        evictionPercentage = criticalPercentage >= 10.0f ? criticalPercentage - 5.0f : criticalPercentage;
                    }
                    rm.setEvictionHeapPercentage(evictionPercentage);
                    if (logWriter.fineEnabled()) {
                        logWriter.fine("Enabled heap eviction at " + evictionPercentage + " percent for LRU region");
                    }
                }
            } else if (!rm.getOffHeapMonitor().hasEvictionThreshold()) {
                float criticalPercentage = rm.getCriticalOffHeapPercentage();
                if (criticalPercentage > 0.0f) {
                    evictionPercentage = criticalPercentage >= 10.0f ? criticalPercentage - 5.0f : criticalPercentage;
                }
                rm.setEvictionOffHeapPercentage(evictionPercentage);
                if (logWriter.fineEnabled()) {
                    logWriter.fine("Enabled off-heap eviction at " + evictionPercentage + " percent for LRU region");
                }
            }
        }
        if (!this.isInternalRegion()) {
            this.getCachePerfStats().incRegions(1);
            if (this.getMembershipAttributes().hasRequiredRoles()) {
                this.getCachePerfStats().incReliableRegions(1);
            }
        }
        if (this.hasListener()) {
            RegionEventImpl event = new RegionEventImpl(this, Operation.REGION_CREATE, null, false, this.getMyId());
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_CREATE, event);
        }
        this.releaseAfterRegionCreateEventLatch();
        SystemMemberCacheEventProcessor.send(this.getCache(), this, Operation.REGION_CREATE);
        initializingRegion.remove();
    }

    protected void postDestroyRegion(boolean destroyDiskRegion, RegionEventImpl event) {
        if (this.diskRegion != null) {
            if (destroyDiskRegion) {
                this.diskRegion.endDestroy(this);
            } else {
                this.diskRegion.close(this);
            }
        }
        if (this.versionVector != null) {
            try {
                this.cache.getDistributionManager().removeMembershipListener(this.versionVector);
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        if (!event.isOriginRemote()) {
            this.checkIfReplicatedAndLocalDestroy(event);
        }
        if (this.hasSeenEvent(event)) {
            assert (this.getJTAEnlistedTX() == null);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "LR.basicDestroy: this cache has already seen this event {}", (Object)event);
            }
            if (this.getConcurrencyChecksEnabled() && event.getVersionTag() != null && !event.getVersionTag().isRecorded()) {
                this.getVersionVector().recordVersion((InternalDistributedMember)event.getDistributedMember(), event.getVersionTag());
            }
            this.notifyGatewaySender(EnumListenerEvent.AFTER_DESTROY, event);
            return;
        }
        this.discoverJTA();
        this.getDataView().destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    void discoverJTA() {
        if (!(this.isSecret() || this.isUsedForPartitionedRegionAdmin() || this.isUsedForMetaRegion())) {
            this.getJTAEnlistedTX();
        }
    }

    private boolean isTransactionPaused() {
        TXManagerImpl txMgr = (TXManagerImpl)this.getCache().getCacheTransactionManager();
        return txMgr.isTransactionPaused();
    }

    private boolean isJTAPaused() {
        TXManagerImpl txMgr = (TXManagerImpl)this.getCache().getCacheTransactionManager();
        return txMgr.isJTAPaused();
    }

    public boolean isTX() {
        return this.getTXState() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mapDestroy(EntryEventImpl event, boolean cacheWrite, boolean isEviction, Object expectedOldValue) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        boolean inGII = this.lockGII();
        try {
            boolean bl = this.mapDestroy(event, cacheWrite, isEviction, expectedOldValue, inGII, false);
            return bl;
        }
        finally {
            if (inGII) {
                this.unlockGII();
            }
        }
    }

    private boolean mapDestroy(EntryEventImpl event, boolean cacheWrite, boolean isEviction, Object expectedOldValue, boolean needTokensForGII, boolean removeRecoveredEntry) {
        boolean inRI = !needTokensForGII && !event.isFromRILocalDestroy() && this.lockRIReadLock();
        try {
            boolean needRIDestroyToken = inRI && this.riCnt > 0;
            boolean inTokenMode = needTokensForGII || needRIDestroyToken;
            boolean bl = this.entries.destroy(event, inTokenMode, needRIDestroyToken, cacheWrite, isEviction, expectedOldValue, removeRecoveredEntry);
            return bl;
        }
        catch (ConcurrentCacheModificationException ignore) {
            if (logger.isDebugEnabled()) {
                logger.debug("caught concurrent modification attempt when applying {}", (Object)event);
            }
            if (event.getVersionTag() != null && !event.getVersionTag().isGatewayTag()) {
                this.notifyBridgeClients(event);
                this.notifyGatewaySender(EnumListenerEvent.AFTER_DESTROY, event);
            }
            boolean bl = true;
            return bl;
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
        finally {
            if (inRI) {
                this.unlockRIReadLock();
            }
        }
    }

    static boolean causedByRDE(DiskAccessException diskAccessException) {
        boolean result = false;
        if (diskAccessException != null) {
            for (Throwable cause = diskAccessException.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof RegionDestroyedException)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public void handleDiskAccessException(DiskAccessException dae) {
        this.handleDiskAccessException(dae, false);
    }

    public void handleDiskAccessException(DiskAccessException dae, boolean duringInitialization) {
        if (duringInitialization && !(dae instanceof ConflictingPersistentDataException)) {
            return;
        }
        if (LocalRegion.causedByRDE(dae)) {
            return;
        }
        StringId sid = LocalizedStrings.LocalRegion_A_DISKACCESSEXCEPTION_HAS_OCCURRED_WHILE_WRITING_TO_THE_DISK_FOR_REGION_0_THE_CACHE_WILL_BE_CLOSED;
        logger.error((Message)LocalizedMessage.create(sid, this.fullPath), (Throwable)dae);
        this.getDiskStore().handleDiskAccessException(dae);
    }

    void expireDestroy(EntryEventImpl event, boolean cacheWrite) {
        this.basicDestroy(event, cacheWrite, null);
    }

    void expireInvalidate(EntryEventImpl event) {
        this.basicInvalidate(event);
    }

    protected EntryEventImpl generateEvictDestroyEvent(Object key) {
        EntryEventImpl event = EntryEventImpl.create(this, Operation.EVICT_DESTROY, key, null, null, false, this.getMyId());
        if (this.generateEventID()) {
            event.setNewEventId(this.cache.getDistributedSystem());
        }
        return event;
    }

    boolean evictDestroy(EvictableEntry entry) {
        this.checkReadiness();
        EntryEventImpl event = this.generateEvictDestroyEvent(entry.getKey());
        try {
            boolean bl = this.mapDestroy(event, false, true, null);
            return bl;
        }
        catch (CacheWriterException error) {
            throw new Error(LocalizedStrings.LocalRegion_CACHE_WRITER_SHOULD_NOT_HAVE_BEEN_CALLED_FOR_EVICTDESTROY.toLocalizedString(), error);
        }
        catch (TimeoutException anotherError) {
            throw new Error(LocalizedStrings.LocalRegion_NO_DISTRIBUTED_LOCK_SHOULD_HAVE_BEEN_ATTEMPTED_FOR_EVICTDESTROY.toLocalizedString(), anotherError);
        }
        catch (EntryNotFoundException yetAnotherError) {
            throw new Error(LocalizedStrings.LocalRegion_ENTRYNOTFOUNDEXCEPTION_SHOULD_BE_MASKED_FOR_EVICTDESTROY.toLocalizedString(), yetAnotherError);
        }
        finally {
            event.release();
        }
    }

    @Override
    public void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
    }

    @Override
    public void basicDestroyPart2(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean conflictWithClear, boolean duringRI, boolean invokeCallbacks) {
        if (!(this instanceof HARegion) && logger.isTraceEnabled()) {
            logger.trace("basicDestroyPart2(inTokenMode={},conflictWithClear={},duringRI={}) event={}", (Object)inTokenMode, (Object)conflictWithClear, (Object)duringRI, (Object)event);
        }
        VersionTag v = event.getVersionTag();
        if (inTokenMode && !this.getConcurrencyChecksEnabled() && !event.isFromRILocalDestroy()) {
            if (re.isDestroyed()) {
                this.getImageState().addDestroyedEntry(event.getKey());
                if (!(this instanceof HARegion) && logger.isTraceEnabled()) {
                    logger.trace("basicDestroy: {}--> Token.DESTROYED", event.getKey());
                }
            }
        } else if (this.getConcurrencyChecksEnabled() && !(this instanceof HARegion) && logger.isDebugEnabled()) {
            logger.debug("basicDestroyPart2: {}, version={}", event.getKey(), (Object)v);
        }
        if (event.isBulkOpInProgress() && this.isUsedForPartitionedRegionBucket) {
            if (logger.isDebugEnabled()) {
                logger.debug("For bulk operation on bucket region, not to notify gateway sender earlier.");
            }
        } else {
            this.notifyGatewaySender(EnumListenerEvent.AFTER_DESTROY, event);
        }
        if (invokeCallbacks && !event.isBulkOpInProgress()) {
            if (this.isInitialized() && (!inTokenMode || duringRI) || this.isUsedForPartitionedRegionBucket) {
                try {
                    re.dispatchListenerEvents(event);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    this.stopper.checkCancelInProgress(null);
                }
            } else {
                event.callbacksInvoked(true);
            }
        }
    }

    @Override
    public void basicDestroyPart3(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean duringRI, boolean invokeCallbacks, Object expectedOldValue) {
        if (invokeCallbacks && event.isBulkOpInProgress()) {
            event.getRemoveAllOperation().addEntry(event);
        }
        if (!inTokenMode || duringRI) {
            this.updateStatsForDestroy();
        }
        if (this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(event.getKey());
        }
    }

    private void updateStatsForDestroy() {
        this.getCachePerfStats().incDestroys();
    }

    void txClearRegion() {
        TXStateInterface tx = this.getJTAEnlistedTX();
        if (tx != null) {
            tx.rmRegion(this);
        }
    }

    @Override
    public void invokeDestroyCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent, boolean notifyGateways) {
        if (event.getOperation() == Operation.REMOVE) {
            event.setOperation(Operation.DESTROY);
        }
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        if (notifyGateways) {
            this.notifyGatewaySender(eventType, event);
        }
        if (callDispatchListenerEvent && !event.getIsRedestroyedEntry()) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    public void invokeTXCallbacks(EnumListenerEvent eventType, EntryEventImpl event, boolean callDispatchListenerEvent) {
        Operation operation = event.getOperation();
        if (logger.isDebugEnabled()) {
            logger.debug("invokeTXCallbacks for event {}", (Object)event);
        }
        if (operation == Operation.REMOVE) {
            event.setOperation(Operation.DESTROY);
        } else if (operation == Operation.PUT_IF_ABSENT) {
            event.setOperation(Operation.CREATE);
        } else if (operation == Operation.REPLACE) {
            event.setOperation(Operation.UPDATE);
        }
        event.setEventType(eventType);
        this.notifyBridgeClients(event);
        this.notifyGatewaySender(eventType, event);
        if (callDispatchListenerEvent && (event.getInvokePRCallbacks() || !(event.getRegion() instanceof PartitionedRegion) && !event.getRegion().isUsedForPartitionedRegionBucket())) {
            this.dispatchListenerEvent(eventType, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void txApplyDestroy(Object key, TransactionId rmtOrigin, TXRmtEvent event, boolean needTokensForGII, Operation op, EventID eventId, Object aCallbackArgument, List<EntryEventImpl> pendingCallbacks, FilterRoutingInfo filterRoutingInfo, ClientProxyMembershipID bridgeContext, boolean isOriginRemote, TXEntryState txEntryState, VersionTag versionTag, long tailKey) {
        boolean inRI = !needTokensForGII && this.lockRIReadLock();
        boolean needRIDestroyToken = inRI && this.riCnt > 0;
        try {
            boolean inTokenMode = needTokensForGII || needRIDestroyToken;
            this.entries.txApplyDestroy(key, rmtOrigin, event, inTokenMode, needRIDestroyToken, op, eventId, aCallbackArgument, pendingCallbacks, filterRoutingInfo, bridgeContext, isOriginRemote, txEntryState, versionTag, tailKey);
        }
        finally {
            if (inRI) {
                this.unlockRIReadLock();
            }
        }
    }

    void txApplyDestroyPart2(RegionEntry re, Object key, boolean inTokenMode, boolean clearConflict) {
        if (this.testCallable != null) {
            this.testCallable.call(this, Operation.DESTROY, re);
        }
        if (inTokenMode) {
            this.getImageState().addDestroyedEntry(key);
        } else {
            this.updateStatsForDestroy();
        }
        if (this.entryUserAttributes != null) {
            this.entryUserAttributes.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicInvalidateRegion(RegionEventImpl event) {
        TXStateProxy tx = this.cache.getTXMgr().pauseTransaction();
        try {
            this.regionInvalid = true;
            this.getImageState().setRegionInvalidated(true);
            this.invalidateAllEntries(event);
            Set allSubregions = this.subregions(true);
            for (Object allSubregion : allSubregions) {
                LocalRegion region = (LocalRegion)allSubregion;
                region.regionInvalid = true;
                try {
                    region.getImageState().setRegionInvalidated(true);
                    region.invalidateAllEntries(event);
                    if (!region.isInitialized() || !region.hasListener()) continue;
                    RegionEventImpl event2 = (RegionEventImpl)event.clone();
                    event2.region = region;
                    region.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_INVALIDATE, event2);
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
            if (!this.isInitialized()) {
                return;
            }
            event.setEventType(EnumListenerEvent.AFTER_REGION_INVALIDATE);
            this.notifyBridgeClients(event);
            boolean hasListener = this.hasListener();
            if (logger.isDebugEnabled()) {
                logger.debug("basicInvalidateRegion: hasListener = {}", (Object)hasListener);
            }
            if (hasListener) {
                this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_INVALIDATE, event);
            }
        }
        finally {
            this.cache.getTXMgr().unpauseTransaction(tx);
        }
    }

    boolean isExpiredWithRegardTo(Object key, int ttl, int idleTime) {
        long expTime;
        if (!this.getAttributes().getStatisticsEnabled()) {
            return false;
        }
        try {
            expTime = new NetSearchExpirationCalculator(this, key, ttl, idleTime).getExpirationTime();
        }
        catch (EntryNotFoundException ignore) {
            return true;
        }
        return expTime != 0L && expTime <= this.cacheTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchListenerEvent(EnumListenerEvent op, InternalCacheEvent event) {
        boolean isEntryEvent = event instanceof EntryEventImpl;
        if (isEntryEvent && ((EntryEventImpl)event).inhibitAllNotifications()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Notification inhibited for key {}", (Object)event);
            }
            return;
        }
        if (this.shouldDispatchListenerEvent()) {
            RegionEntry regionEntry;
            if (logger.isTraceEnabled()) {
                logger.trace("dispatchListenerEvent event={}", (Object)event);
            }
            long start = this.getCachePerfStats().startCacheListenerCall();
            boolean isOriginRemote = false;
            boolean isOriginRemoteSetOnEvent = false;
            try {
                if (isEntryEvent) {
                    if (((EntryEventImpl)event).isSingleHop()) {
                        isOriginRemote = event.isOriginRemote();
                        ((EntryEventImpl)event).setOriginRemote(true);
                        isOriginRemoteSetOnEvent = true;
                    }
                    if ((regionEntry = ((EntryEventImpl)event).getRegionEntry()) != null) {
                        ((EntryEventImpl)event).getRegionEntry().setCacheListenerInvocationInProgress(true);
                    }
                }
                if (this.cache.getEventThreadPool() == null) {
                    LocalRegion.dispatchEvent(this, event, op);
                } else {
                    EventDispatcher eventDispatcher = new EventDispatcher(event, op);
                    try {
                        this.cache.getEventThreadPool().execute(eventDispatcher);
                    }
                    catch (RejectedExecutionException ignore) {
                        eventDispatcher.release();
                        LocalRegion.dispatchEvent(this, event, op);
                    }
                }
            }
            finally {
                this.getCachePerfStats().endCacheListenerCall(start);
                if (isOriginRemoteSetOnEvent) {
                    ((EntryEventImpl)event).setOriginRemote(isOriginRemote);
                }
                if (isEntryEvent && (regionEntry = ((EntryEventImpl)event).getRegionEntry()) != null) {
                    regionEntry.setCacheListenerInvocationInProgress(false);
                }
            }
        }
    }

    @Override
    public boolean isInitialized() {
        if (this.initialized) {
            return true;
        }
        StoppableCountDownLatch latch = this.initializationLatchAfterGetInitialImage;
        if (latch == null) {
            return true;
        }
        long count = latch.getCount();
        if (count == 0L) {
            this.initialized = true;
            return true;
        }
        return false;
    }

    boolean isEventTrackerInitialized() {
        return this.getEventTracker().isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDestroyLock() {
        LocalRegion root = this.getRoot();
        boolean acquired = false;
        do {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                root.destroyLock.acquire();
                acquired = true;
            }
            catch (InterruptedException ie) {
                interrupted = true;
                this.cache.getCancelCriterion().checkCancelInProgress(ie);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (!acquired);
        if (logger.isDebugEnabled()) {
            logger.debug("Acquired Destroy Lock: {}", (Object)root);
        }
    }

    public void releaseDestroyLock() {
        LocalRegion root = this.getRoot();
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing Destroy Lock: {}", (Object)root.getName());
        }
        root.destroyLock.release();
    }

    @Override
    public void cleanupFailedInitialization() {
        this.isDestroyed = true;
        this.cache.getInternalResourceManager(false).removeResourceListener(this);
        this.closeEntries();
        this.destroyedSubregionSerialNumbers = this.collectSubregionSerialNumbers();
        try {
            this.getEventTracker().stop();
            if (this.diskRegion != null) {
                try {
                    this.diskRegion.cleanupFailedInitialization(this);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            this.cache.invokeCleanupFailedInitialization(this);
        }
        finally {
            this.releaseLatches();
        }
    }

    LocalRegion getRoot() {
        LocalRegion region = this;
        while (region.parentRegion != null) {
            region = region.parentRegion;
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializationFailed(LocalRegion subregion) {
        Object object = this.subregionsLock;
        synchronized (object) {
            this.subregions.remove(subregion.getName());
        }
        subregion.cleanupFailedInitialization();
    }

    @Override
    public long updateStatsForPut(RegionEntry entry, long lastModified, boolean lruRecentUse) {
        long lastAccessed = this.cacheTimeMillis();
        if (lruRecentUse) {
            entry.setRecentlyUsed(this);
        }
        if (lastModified == 0L) {
            lastModified = lastAccessed;
        }
        entry.updateStatsForPut(lastModified, lastAccessed);
        if (this.statisticsEnabled && !this.isProxy()) {
            this.addExpiryTaskIfAbsent(entry);
        }
        this.setLastModifiedTime(lastModified);
        return lastModified;
    }

    private LocalRegion basicGetSubregion(String name) {
        LocalRegion region = this.toRegion(this.subregions.get(name));
        if (region == null && LocalRegion.threadInitLevelRequirement() != 2) {
            String thePath = this.getFullPath() + "/" + name;
            if (logger.isDebugEnabled()) {
                logger.debug("Trying reinitializing region, fullPath={}", (Object)thePath);
            }
            region = (LocalRegion)this.cache.getReinitializingRegion(thePath);
            if (logger.isDebugEnabled()) {
                logger.debug("Reinitialized region is {}", (Object)region);
            }
        }
        return region;
    }

    private LocalRegion toRegion(Object element) {
        LocalRegion region = (LocalRegion)element;
        if (region != null) {
            region.waitOnInitialization();
        }
        return region;
    }

    public void updateStatsForGet(RegionEntry regionEntry, boolean hit) {
        if (!this.statisticsEnabled) {
            return;
        }
        long now = this.cacheTimeMillis();
        if (regionEntry != null) {
            regionEntry.updateStatsForGet(hit, now);
            if (this.isEntryIdleExpiryPossible()) {
                this.addExpiryTaskIfAbsent(regionEntry);
            }
        }
        this.setLastAccessedTime(now, hit);
    }

    private void sendPendingRegionDestroyEvents(Set regionEvents) {
        for (Object regionEvent : regionEvents) {
            RegionEventImpl regionEventImpl = (RegionEventImpl)regionEvent;
            regionEventImpl.region.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_DESTROY, regionEventImpl);
            if (this.cache.forcedDisconnect()) continue;
            SystemMemberCacheEventProcessor.send(this.getCache(), regionEventImpl.getRegion(), regionEventImpl.getOperation());
        }
    }

    protected void closeCallbacksExceptListener() {
        this.closeCacheCallback(this.getCacheLoader());
        this.closeCacheCallback(this.getCacheWriter());
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null) {
            evictionController.close();
        }
    }

    private void closeAllCallbacks() {
        this.closeCallbacksExceptListener();
        CacheListener[] listeners = this.fetchCacheListenersField();
        if (listeners != null) {
            for (CacheListener listener : listeners) {
                this.closeCacheCallback(listener);
            }
        }
    }

    private void detachPool() {
        ServerRegionProxy serverRegionProxy = this.getServerProxy();
        if (serverRegionProxy != null) {
            InternalCache internalCache = this.getCache();
            String poolName = this.getPoolName();
            PoolImpl pool = (PoolImpl)PoolManager.find(this.getPoolName());
            if (poolName != null && pool != null) {
                serverRegionProxy.detach(internalCache.keepDurableSubscriptionsAlive() || pool.getKeepAlive());
            } else {
                serverRegionProxy.detach(internalCache.keepDurableSubscriptionsAlive());
            }
        }
    }

    private void closeCqs() {
        CqService cqService = this.getCache().getCqService();
        if (cqService != null) {
            try {
                cqService.closeCqs(this.getFullPath());
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_WHILE_CLOSING_CQS_ON_REGION_DESTORY), t);
            }
        }
    }

    @Override
    public void handleCacheClose(Operation operation) {
        block7: {
            RegionEventImpl event = new RegionEventImpl((Region)this, operation, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
            if (!this.isDestroyed) {
                try {
                    this.basicDestroyRegion(event, false, true, true);
                }
                catch (CancelException ignore) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("handleCacheClose: Encountered cache closure while closing region {}", (Object)this.getFullPath());
                    }
                }
                catch (RegionDestroyedException ignore) {
                }
                catch (CacheWriterException e) {
                    throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_HERE.toLocalizedString(), e);
                }
                catch (TimeoutException e) {
                    InternalDistributedSystem ids = this.getCache().getInternalDistributedSystem();
                    if (ids.isDisconnecting()) break block7;
                    throw new InternalGemFireError(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_HERE.toLocalizedString(), e);
                }
            }
        }
    }

    void cleanUpOnIncompleteOp(EntryEventImpl event, RegionEntry regionEntry) {
        this.entries.removeEntry(event.getKey(), regionEntry, false);
    }

    public static void validateRegionName(String name, InternalRegionArguments internalRegionArgs) {
        if (name == null) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_NULL.toLocalizedString());
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_BE_EMPTY.toLocalizedString());
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException(LocalizedStrings.LocalRegion_NAME_CANNOT_CONTAIN_THE_SEPARATOR_0.toLocalizedString("/"));
        }
        if (internalRegionArgs.isInternalRegion()) {
            return;
        }
        if (internalRegionArgs.isUsedForMetaRegion()) {
            return;
        }
        if (internalRegionArgs.isUsedForPartitionedRegionAdmin()) {
            return;
        }
        if (internalRegionArgs.isUsedForPartitionedRegionBucket()) {
            return;
        }
        if (name.startsWith("__")) {
            throw new IllegalArgumentException("Region names may not begin with a double-underscore: " + name);
        }
        Pattern NAME_PATTERN = Pattern.compile("[aA-zZ0-9-_.]+");
        Matcher matcher = NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Region names may only be alphanumeric and may contain hyphens or underscores: " + name);
        }
    }

    private void checkCacheClosed() {
        if (this.cache.isClosed()) {
            throw this.cache.getCacheClosedException(null, null);
        }
    }

    private void checkRegionDestroyed(boolean checkCancel) {
        if (checkCancel) {
            this.cache.getCancelCriterion().checkCancelInProgress(null);
        }
        if (this.isDestroyed) {
            RegionDestroyedException regionDestroyedException;
            if (this.reinitialized_old) {
                regionDestroyedException = new RegionReinitializedException(this.toString(), this.getFullPath());
            } else {
                if (this.cache.isCacheAtShutdownAll()) {
                    throw this.cache.getCacheClosedException("Cache is being closed by ShutdownAll");
                }
                regionDestroyedException = new RegionDestroyedException(this.toString(), this.getFullPath());
            }
            if (checkCancel) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
            }
            throw regionDestroyedException;
        }
        if (this.isDestroyedForParallelWAN) {
            throw new RegionDestroyedException(LocalizedStrings.LocalRegion_REGION_IS_BEING_DESTROYED_WAITING_FOR_PARALLEL_QUEUE_TO_DRAIN.toLocalizedString(), this.getFullPath());
        }
    }

    @Override
    public void foreachRegionEntry(RegionEntryCallback callback) {
        for (RegionEntry regionEntry : this.entries.regionEntriesInVM()) {
            callback.handleRegionEntry(regionEntry);
        }
    }

    protected void checkIfReplicatedAndLocalDestroy(EntryEventImpl event) {
        if (this.getScope().isDistributed() && this.getDataPolicy().withReplication() && !event.isDistributed() && !this.isUsedForSerialGatewaySenderQueue()) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_NOT_ALLOWED_TO_DO_A_LOCAL_DESTROY_ON_A_REPLICATED_REGION.toLocalizedString());
        }
    }

    private int allSubregionsSize() {
        int size = 1;
        for (Object regionObject : this.subregions.values()) {
            LocalRegion region = (LocalRegion)regionObject;
            if (region == null || !region.isInitialized() || region.isDestroyed()) continue;
            size += region.allSubregionsSize();
        }
        return size;
    }

    int allEntriesSize() {
        int size = this.entryCount();
        for (Object regionObject : this.subregions.values()) {
            LocalRegion region = this.toRegion(regionObject);
            if (region == null || region.isDestroyed()) continue;
            size += region.allEntriesSize();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateAllEntries(RegionEvent rgnEvent) {
        Operation operation = Operation.LOCAL_INVALIDATE;
        if (rgnEvent.getOperation().isDistributed()) {
            operation = Operation.INVALIDATE;
        }
        for (Object keyObject : this.keySet()) {
            try {
                EntryEventImpl event = EntryEventImpl.create(this, operation, keyObject, null, null, rgnEvent.isOriginRemote(), rgnEvent.getDistributedMember());
                try {
                    event.setLocalInvalid(!rgnEvent.getOperation().isDistributed());
                    this.basicInvalidate(event, false);
                }
                finally {
                    event.release();
                }
            }
            catch (EntryNotFoundException entryNotFoundException) {}
        }
    }

    boolean hasListener() {
        CacheListener[] listeners = this.fetchCacheListenersField();
        return listeners != null && listeners.length > 0;
    }

    @Override
    public DiskStoreImpl getDiskStore() {
        return this.diskStoreImpl;
    }

    private boolean useDefaultDiskStore() {
        assert (this.getDiskStoreName() == null);
        if (!Arrays.equals(this.getDiskDirs(), DefaultDiskDirs.getDefaultDiskDirs())) {
            return false;
        }
        if (!Arrays.equals(this.getDiskDirSizes(), DiskStoreFactory.DEFAULT_DISK_DIR_SIZES)) {
            return false;
        }
        DiskWriteAttributesFactory attributesFactory = new DiskWriteAttributesFactory();
        attributesFactory.setSynchronous(false);
        if (attributesFactory.create().equals(this.getDiskWriteAttributes())) {
            return true;
        }
        attributesFactory.setSynchronous(true);
        return attributesFactory.create().equals(this.getDiskWriteAttributes());
    }

    protected boolean usesDiskStore(RegionAttributes regionAttributes) {
        return !this.isProxy() && (this.getAttributes().getDataPolicy().withPersistence() || this.isOverflowEnabled());
    }

    protected DiskStoreImpl findDiskStore(RegionAttributes regionAttributes, InternalRegionArguments internalRegionArgs) {
        if (this.getAttributes().getDataPolicy().withPersistence()) {
            this.getCache().getPdxRegistry().creatingPersistentRegion();
        }
        if (this.usesDiskStore(regionAttributes)) {
            if (this.getDiskStoreName() != null) {
                DiskStoreImpl diskStore = (DiskStoreImpl)this.getGemFireCache().findDiskStore(this.getDiskStoreName());
                if (diskStore == null) {
                    throw new IllegalStateException(LocalizedStrings.CacheCreation_DISKSTORE_NOTFOUND_0.toLocalizedString(this.getDiskStoreName()));
                }
                return diskStore;
            }
            if (this.useDefaultDiskStore()) {
                return this.getGemFireCache().getOrCreateDefaultDiskStore();
            }
            DiskStoreFactory diskStoreFactory = this.getGemFireCache().createDiskStoreFactory();
            diskStoreFactory.setDiskDirsAndSizes(this.getDiskDirs(), this.getDiskDirSizes());
            DiskWriteAttributes dwa = this.getDiskWriteAttributes();
            diskStoreFactory.setAutoCompact(dwa.isRollOplogs());
            diskStoreFactory.setMaxOplogSize(dwa.getMaxOplogSize());
            diskStoreFactory.setTimeInterval(dwa.getTimeInterval());
            if (dwa.getBytesThreshold() > 0L) {
                diskStoreFactory.setQueueSize(1);
            } else {
                diskStoreFactory.setQueueSize(0);
            }
            DiskStoreFactoryImpl diskStoreFactoryImpl = (DiskStoreFactoryImpl)diskStoreFactory;
            return diskStoreFactoryImpl.createOwnedByRegion(this.getFullPath().replace('/', '_'), this instanceof PartitionedRegion, internalRegionArgs);
        }
        return null;
    }

    protected DiskRegion createDiskRegion(InternalRegionArguments internalRegionArgs) throws DiskAccessException {
        if (internalRegionArgs.getDiskRegion() != null) {
            DiskRegion region = internalRegionArgs.getDiskRegion();
            region.createDataStorage();
            return region;
        }
        if (this.diskStoreImpl == null) {
            return null;
        }
        DiskRegionStats stats = this instanceof BucketRegion ? internalRegionArgs.getPartitionedRegion().getDiskRegionStats() : new DiskRegionStats(this.getCache().getDistributedSystem(), this.getFullPath());
        EnumSet<DiskInitFile.DiskRegionFlag> diskFlags = EnumSet.noneOf(DiskInitFile.DiskRegionFlag.class);
        if (this.getAttributes().getConcurrencyChecksEnabled()) {
            diskFlags.add(DiskInitFile.DiskRegionFlag.IS_WITH_VERSIONING);
        }
        return DiskRegion.create(this.diskStoreImpl, this.getFullPath(), false, this.getDataPolicy().withPersistence(), this.isOverflowEnabled(), this.isDiskSynchronous(), stats, this.getCancelCriterion(), this, this.getAttributes(), diskFlags, "NO_PARTITITON", -1, this.getCompressor(), this.getOffHeap());
    }

    public ObjectSizer getObjectSizer() {
        ObjectSizer result = null;
        EvictionAttributes ea = this.getEvictionAttributes();
        if (ea != null) {
            result = ea.getObjectSizer();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTTLExpiryTask() {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            RegionTTLExpiryTask task = this.regionTTLExpiryTask;
            if (task != null) {
                task.cancel();
            }
            if (this.regionTimeToLive > 0) {
                this.regionTTLExpiryTask = (RegionTTLExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(new RegionTTLExpiryTask(this));
                if (this.regionTTLExpiryTask != null && logger.isDebugEnabled()) {
                    logger.debug("Initialized Region TTL Expiry Task {}", (Object)this.regionTTLExpiryTask);
                }
            } else {
                this.regionTTLExpiryTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTTLExpiryTask(RegionTTLExpiryTask callingTask) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (this.regionTTLExpiryTask != null && this.regionTTLExpiryTask != callingTask) {
                return;
            }
            if (this.regionTimeToLive <= 0) {
                this.regionTTLExpiryTask = null;
                return;
            }
            RegionTTLExpiryTask task = new RegionTTLExpiryTask(this);
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling Region TTL Expiry Task {} which replaces {}", (Object)task, (Object)this.regionTTLExpiryTask);
            }
            this.regionTTLExpiryTask = (RegionTTLExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleExpiryTask() {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            RegionIdleExpiryTask task = this.regionIdleExpiryTask;
            if (task != null) {
                task.cancel();
            }
            if (this.regionIdleTimeout > 0) {
                this.regionIdleExpiryTask = (RegionIdleExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(new RegionIdleExpiryTask(this));
                if (this.regionIdleExpiryTask != null && logger.isDebugEnabled()) {
                    logger.debug("Initialized Region Idle Expiry Task {}", (Object)this.regionIdleExpiryTask);
                }
            } else {
                this.regionIdleExpiryTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleExpiryTask(RegionIdleExpiryTask callingTask) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (this.regionIdleExpiryTask != null && this.regionIdleExpiryTask != callingTask) {
                return;
            }
            if (this.regionIdleTimeout <= 0) {
                this.regionIdleExpiryTask = null;
                return;
            }
            RegionIdleExpiryTask task = new RegionIdleExpiryTask(this);
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduling Region Idle Expiry Task {} which replaces {}", (Object)task, (Object)this.regionIdleExpiryTask);
            }
            this.regionIdleExpiryTask = (RegionIdleExpiryTask)this.cache.getExpirationScheduler().addExpiryTask(task);
        }
    }

    protected boolean isEntryIdleExpiryPossible() {
        return this.entryIdleTimeout > 0 || this.customEntryIdleTimeout != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTTLExpiryTask() {
        RegionTTLExpiryTask task;
        Object object = this.regionExpiryLock;
        synchronized (object) {
            task = this.regionTTLExpiryTask;
            if (task != null) {
                this.regionTTLExpiryTask = null;
            }
        }
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIdleExpiryTask() {
        RegionIdleExpiryTask task;
        Object object = this.regionExpiryLock;
        synchronized (object) {
            task = this.regionIdleExpiryTask;
            if (task != null) {
                this.regionIdleExpiryTask = null;
            }
        }
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    protected void regionTimeToLiveChanged(ExpirationAttributes oldTimeToLive) {
        this.addTTLExpiryTask();
    }

    @Override
    protected void regionIdleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
        this.addIdleExpiryTask();
    }

    @Override
    protected void timeToLiveChanged(ExpirationAttributes oldTimeToLive) {
        int oldTimeout = oldTimeToLive.getTimeout();
        if (this.customEntryTimeToLive != null) {
            this.rescheduleEntryExpiryTasks();
        }
        if (this.entryTimeToLive > 0 && (oldTimeout == 0 || this.entryTimeToLive < oldTimeout)) {
            this.rescheduleEntryExpiryTasks();
        }
    }

    @Override
    protected void idleTimeoutChanged(ExpirationAttributes oldIdleTimeout) {
        int oldTimeout = oldIdleTimeout.getTimeout();
        if (this.customEntryIdleTimeout != null) {
            this.rescheduleEntryExpiryTasks();
        }
        if (this.entryIdleTimeout > 0 && (oldTimeout == 0 || this.entryIdleTimeout < oldTimeout)) {
            this.rescheduleEntryExpiryTasks();
        }
    }

    void rescheduleEntryExpiryTasks() {
        if (this.isProxy()) {
            return;
        }
        if (!this.isInitialized()) {
            return;
        }
        if (!this.isEntryExpiryPossible()) {
            return;
        }
        Iterator<RegionEntry> it = this.entries.regionEntries().iterator();
        if (it.hasNext()) {
            ExpiryTask.doWithNowSet(this, () -> {
                while (it.hasNext()) {
                    this.addExpiryTask((RegionEntry)it.next());
                }
            });
        }
    }

    @Override
    public void addExpiryTaskIfAbsent(RegionEntry entry) {
        this.addExpiryTask(entry, true);
    }

    void addExpiryTask(RegionEntry re) {
        this.addExpiryTask(re, false);
    }

    private EntryExpiryTask createExpiryTask(RegionEntry regionEntry) {
        if (regionEntry == null || regionEntry.isDestroyedOrRemoved()) {
            return null;
        }
        if (this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null) {
            boolean idleDisabled;
            CustomExpiry customIdle;
            ExpiryRegionEntry expiryRegionEntry = new ExpiryRegionEntry(this, regionEntry);
            ExpirationAttributes ttlAttributes = null;
            ExpirationAttributes idleAttributes = null;
            RegionAttributes regionAttributes = this.getAttributes();
            CustomExpiry customTTL = regionAttributes.getCustomEntryTimeToLive();
            if (customTTL != null) {
                try {
                    ttlAttributes = customTTL.getExpiry(expiryRegionEntry);
                    if (ttlAttributes != null) {
                        this.checkEntryTimeoutAction("timeToLive", ttlAttributes.getAction());
                    }
                }
                catch (RegionDestroyedException regionDestroyedException) {
                }
                catch (EntryNotFoundException entryNotFoundException) {
                }
                catch (EntryDestroyedException entryDestroyedException) {
                }
                catch (Exception e) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.EntryExpiryTask_ERROR_CALCULATING_EXPIRATION_0, e.getMessage()), (Throwable)e);
                }
            }
            if (ttlAttributes == null) {
                ttlAttributes = regionAttributes.getEntryTimeToLive();
            }
            if ((customIdle = regionAttributes.getCustomEntryIdleTimeout()) != null) {
                try {
                    idleAttributes = customIdle.getExpiry(expiryRegionEntry);
                    if (idleAttributes != null) {
                        this.checkEntryTimeoutAction("idleTimeout", idleAttributes.getAction());
                    }
                }
                catch (RegionDestroyedException regionDestroyedException) {
                }
                catch (EntryNotFoundException entryNotFoundException) {
                }
                catch (EntryDestroyedException entryDestroyedException) {
                }
                catch (Exception e) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.EntryExpiryTask_ERROR_CALCULATING_EXPIRATION_0, e.getMessage()), (Throwable)e);
                }
            }
            if (idleAttributes == null) {
                idleAttributes = regionAttributes.getEntryIdleTimeout();
            }
            boolean ttlDisabled = ttlAttributes == null || ttlAttributes.getTimeout() == 0;
            boolean bl = idleDisabled = idleAttributes == null || idleAttributes.getTimeout() == 0;
            if (ttlDisabled && idleDisabled) {
                return null;
            }
            if ((ttlDisabled || ttlAttributes.equals(regionAttributes.getEntryTimeToLive())) && (idleDisabled || idleAttributes.equals(regionAttributes.getEntryIdleTimeout()))) {
                return new EntryExpiryTask(this, regionEntry);
            }
            return new CustomEntryExpiryTask(this, regionEntry, ttlAttributes, idleAttributes);
        }
        if (this.isEntryExpiryPossible()) {
            return new EntryExpiryTask(this, regionEntry);
        }
        return null;
    }

    @Override
    public EntryExpiryTask getEntryExpiryTask(Object key) {
        RegionEntry re = this.getRegionEntry(key);
        if (re == null) {
            throw new EntryNotFoundException("Entry for key " + key + " does not exist.");
        }
        return this.entryExpiryTasks.get(re);
    }

    public RegionIdleExpiryTask getRegionIdleExpiryTask() {
        return this.regionIdleExpiryTask;
    }

    public RegionTTLExpiryTask getRegionTTLExpiryTask() {
        return this.regionTTLExpiryTask;
    }

    private void addExpiryTask(RegionEntry regionEntry, boolean ifAbsent) {
        if (this.isProxy()) {
            return;
        }
        if (!this.isInitialized()) {
            return;
        }
        if (this.isEntryExpiryPossible()) {
            EntryExpiryTask oldTask;
            EntryExpiryTask newTask = null;
            if (ifAbsent && (oldTask = this.entryExpiryTasks.get(regionEntry)) != null) {
                boolean keepOldTask = true;
                if (this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null) {
                    newTask = this.createExpiryTask(regionEntry);
                    if (newTask == null) {
                        return;
                    }
                    long newTaskTime = newTask.getExpirationTime();
                    try {
                        if (newTaskTime != 0L && newTaskTime < oldTask.getExpirationTime()) {
                            keepOldTask = false;
                        }
                    }
                    catch (EntryNotFoundException ignore) {
                        keepOldTask = false;
                    }
                }
                if (keepOldTask) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Expiry Task not added because one already present. Key={}", regionEntry.getKey());
                    }
                    return;
                }
            }
            if (newTask == null && (newTask = this.createExpiryTask(regionEntry)) == null) {
                return;
            }
            oldTask = this.entryExpiryTasks.put(regionEntry, newTask);
            ExpirationScheduler scheduler = this.cache.getExpirationScheduler();
            if (oldTask != null && oldTask.cancel()) {
                scheduler.incCancels();
            }
            if (!scheduler.addEntryExpiryTask(newTask)) {
                this.entryExpiryTasks.remove(regionEntry);
            } else if (ExpiryTask.expiryTaskListener != null) {
                ExpiryTask.expiryTaskListener.afterSchedule(newTask);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("addExpiryTask(key) ignored");
        }
    }

    @Override
    public void cancelExpiryTask(RegionEntry regionEntry) {
        this.cancelExpiryTask(regionEntry, null);
    }

    void cancelExpiryTask(RegionEntry regionEntry, ExpiryTask expiryTask) {
        if (expiryTask != null) {
            this.entryExpiryTasks.remove(regionEntry, expiryTask);
            if (expiryTask.cancel()) {
                this.cache.getExpirationScheduler().incCancels();
            }
        } else {
            EntryExpiryTask oldTask = this.entryExpiryTasks.remove(regionEntry);
            if (oldTask != null && oldTask.cancel()) {
                this.cache.getExpirationScheduler().incCancels();
            }
        }
    }

    private void cancelAllEntryExpiryTasks() {
        if (this.entryExpiryTasks == null) {
            return;
        }
        if (this.entryExpiryTasks.isEmpty()) {
            return;
        }
        boolean doPurge = false;
        for (EntryExpiryTask task : this.entryExpiryTasks.values()) {
            task.cancel();
            doPurge = true;
        }
        if (doPurge) {
            this.cache.getExpirationScheduler().forcePurge();
        }
    }

    @Override
    public ImageState getImageState() {
        return this.imageState;
    }

    boolean lockGII() {
        ImageState imageState = this.getImageState();
        if (imageState.isReplicate() && !this.isInitialized()) {
            imageState.lockGII();
            if (this.isInitialized()) {
                imageState.unlockGII();
            } else {
                return true;
            }
        }
        return false;
    }

    void unlockGII() {
        ImageState imageState = this.getImageState();
        assert (imageState.isReplicate());
        imageState.unlockGII();
    }

    private boolean lockRIReadLock() {
        if (this.getImageState().isClient()) {
            this.getImageState().readLockRI();
            return true;
        }
        return false;
    }

    private void unlockRIReadLock() {
        assert (this.getImageState().isClient());
        this.getImageState().readUnlockRI();
    }

    LocalRegion basicGetParentRegion() {
        return this.parentRegion;
    }

    Object basicGetEntryUserAttribute(Object entryKey) {
        Map userAttr = this.entryUserAttributes;
        if (userAttr == null) {
            return null;
        }
        return userAttr.get(entryKey);
    }

    public TXStateProxy getTXState() {
        if (this.supportsTX) {
            return TXManagerImpl.getCurrentTXState();
        }
        return null;
    }

    TXId getTXId() {
        TXStateProxy tx = this.getTXState();
        if (tx == null) {
            return null;
        }
        return (TXId)tx.getTransactionId();
    }

    private TXRegionState txReadRegion() {
        TXStateProxy txState = this.getTXState();
        if (txState != null) {
            return txState.txReadRegion(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TXEntryState createReadEntry(TXRegionState txRegionState, KeyInfo keyInfo, boolean createIfAbsent) {
        TXEntryState result = null;
        RegionEntry regionEntry = this.basicGetTXEntry(keyInfo);
        if (regionEntry != null) {
            boolean needsLRUCleanup = false;
            try {
                RegionEntry regionEntry2 = regionEntry;
                synchronized (regionEntry2) {
                    if (!regionEntry.isRemoved()) {
                        EvictableEntry le;
                        if (regionEntry instanceof DiskEntry && regionEntry instanceof EvictableEntry && (le = (EvictableEntry)regionEntry).isEvicted()) {
                            this.txLRUStart();
                            needsLRUCleanup = true;
                            regionEntry.getValue(this);
                        }
                        Object value = regionEntry.getValueInVM(this);
                        Object id = regionEntry.getTransformedValue();
                        result = txRegionState.createReadEntry(this, keyInfo.getKey(), regionEntry, id, value);
                    }
                }
            }
            catch (DiskAccessException dae) {
                this.handleDiskAccessException(dae);
                needsLRUCleanup = false;
                throw dae;
            }
            finally {
                if (needsLRUCleanup) {
                    this.txLRUEnd();
                }
            }
        }
        if (result == null && createIfAbsent) {
            result = txRegionState.createReadEntry(this, keyInfo.getKey(), null, null, null);
        }
        return result;
    }

    private TXStateInterface getJTAEnlistedTX() {
        if (this.ignoreJTA) {
            return null;
        }
        TXStateProxy txState = this.getTXState();
        if (txState != null) {
            return txState;
        }
        try {
            if (!this.ignoreJTA && this.cache.getJTATransactionManager() != null) {
                Transaction jtaTransaction = this.cache.getJTATransactionManager().getTransaction();
                if (jtaTransaction == null || jtaTransaction.getStatus() == 6) {
                    return null;
                }
                if (this.isTransactionPaused() || this.isJTAPaused()) {
                    return null;
                }
                txState = this.cache.getTXMgr().beginJTA();
                jtaTransaction.registerSynchronization((Synchronization)txState);
                return txState;
            }
            return null;
        }
        catch (SystemException se) {
            this.stopper.checkCancelInProgress(se);
            this.jtaEnlistmentFailureCleanup(txState, (Exception)((Object)se));
            return null;
        }
        catch (IllegalStateException | RollbackException re) {
            this.jtaEnlistmentFailureCleanup(txState, (Exception)re);
            return null;
        }
    }

    private void jtaEnlistmentFailureCleanup(TXStateInterface txState, Exception reason) {
        if (this.cache == null) {
            return;
        }
        this.cache.getTXMgr().setTXState(null);
        if (txState != null) {
            txState.rollback();
        }
        String jtaTransName = null;
        try {
            jtaTransName = this.cache.getJTATransactionManager().getTransaction().toString();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ignore) {
            SystemFailure.checkFailure();
        }
        throw new FailedSynchronizationException(LocalizedStrings.LocalRegion_FAILED_ENLISTEMENT_WITH_TRANSACTION_0.toLocalizedString(jtaTransName), reason);
    }

    void txLRUStart() {
        this.entries.disableLruUpdateCallback();
    }

    void txLRUEnd() {
        this.entries.enableLruUpdateCallback();
        try {
            this.entries.lruUpdateCallback();
        }
        catch (DiskAccessException dae) {
            this.handleDiskAccessException(dae);
            throw dae;
        }
    }

    void txDecRefCount(RegionEntry regionEntry) {
        this.entries.decTxRefCount(regionEntry);
    }

    List debugGetSubregionNames() {
        ArrayList names = new ArrayList();
        names.addAll(this.subregions.keySet());
        return names;
    }

    @Override
    public void incRecentlyUsed() {
        this.entries.incRecentlyUsed();
    }

    static void dispatchEvent(LocalRegion region, InternalCacheEvent event, EnumListenerEvent operation) {
        Object[] listeners;
        block11: {
            listeners = region.fetchCacheListenersField();
            if (event.getOperation().isCreate() && logger.isDebugEnabled()) {
                logger.debug("invoking listeners: {}", (Object)Arrays.toString(listeners));
            }
            if (listeners == null || listeners.length == 0) {
                return;
            }
            if (operation != EnumListenerEvent.AFTER_REGION_CREATE) {
                try {
                    region.waitForRegionCreateEvent();
                }
                catch (CancelException ignore) {
                    if (!logger.isTraceEnabled()) break block11;
                    logger.trace("Dispatching events after cache closure for region {}", (Object)region.getFullPath());
                }
            }
        }
        if (!event.isGenerateCallbacks()) {
            return;
        }
        for (Object listener : listeners) {
            if (listener == null) continue;
            try {
                operation.dispatchEvent(event, (CacheListener)listener);
            }
            catch (CancelException cancelException) {
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_IN_CACHELISTENER), t);
            }
        }
    }

    @Override
    public RegionMap getRegionMap() {
        return this.entries;
    }

    @Override
    public int size() {
        this.checkReadiness();
        this.checkForNoAccess();
        this.discoverJTA();
        boolean isClient = this.imageState.isClient();
        if (isClient) {
            this.lockRIReadLock();
        }
        try {
            int n = this.entryCount();
            return n;
        }
        finally {
            if (isClient) {
                this.unlockRIReadLock();
            }
        }
    }

    public int sizeEstimate() {
        boolean isClient = this.imageState.isClient();
        if (isClient) {
            throw new UnsupportedOperationException("Method not supported on a client");
        }
        return this.entryCount(null, true);
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_FOR_CONTAINSVALUEVALUE_CANNOT_BE_NULL.toLocalizedString());
        }
        this.checkReadiness();
        this.checkForNoAccess();
        boolean result = false;
        for (Object entry : new EntriesSet(this, false, IteratorType.VALUES, false)) {
            if (entry == null || !value.equals(entry)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Set entrySet() {
        return this.entrySet(false);
    }

    @Override
    public Set keySet() {
        return this.keys();
    }

    @Override
    public Object remove(Object key) {
        Object value = null;
        try {
            value = this.destroy(key);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        return value;
    }

    public void basicBridgeDestroyRegion(Object callbackArg, ClientProxyMembershipID client, boolean fromClient, EventID eventId) throws TimeoutException, EntryExistsException, CacheWriterException {
        if (fromClient && this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        ClientRegionEventImpl event = new ClientRegionEventImpl(this, Operation.REGION_DESTROY, callbackArg, false, client.getDistributedMember(), client, eventId);
        this.basicDestroyRegion(event, true);
    }

    public void basicBridgeClear(Object callbackArg, ClientProxyMembershipID client, boolean fromClient, EventID eventId) throws TimeoutException, EntryExistsException, CacheWriterException {
        if (fromClient && this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        ClientRegionEventImpl event = new ClientRegionEventImpl(this, Operation.REGION_CLEAR, callbackArg, false, client.getDistributedMember(), client, eventId);
        this.basicClear(event, true);
    }

    @Override
    void basicClear(RegionEventImpl regionEvent) {
        this.getDataView().checkSupportsRegionClear();
        this.basicClear(regionEvent, true);
    }

    void basicClear(RegionEventImpl regionEvent, boolean cacheWrite) {
        this.cmnClearRegion(regionEvent, cacheWrite, true);
    }

    void cmnClearRegion(RegionEventImpl regionEvent, boolean cacheWrite, boolean useRVV) {
        RegionVersionVector rvv = null;
        if (useRVV && this.getDataPolicy().withReplication() && this.getConcurrencyChecksEnabled()) {
            rvv = this.versionVector.getCloneForTransmission();
        }
        this.clearRegionLocally(regionEvent, cacheWrite, rvv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRegionLocally(RegionEventImpl regionEvent, boolean cacheWrite, RegionVersionVector vector) {
        RegionVersionVector myVector;
        boolean isGIIinProgress;
        boolean isRvvDebugEnabled = logger.isTraceEnabled(LogMarker.RVV_VERBOSE);
        RegionVersionVector rvv = vector;
        if (this.serverRegionProxy != null) {
            rvv = null;
        }
        if (rvv != null && this.getDataPolicy().withStorage()) {
            boolean result;
            if (isRvvDebugEnabled) {
                logger.trace(LogMarker.RVV_VERBOSE, "waiting for my version vector to dominate{}mine={}{} other={}", (Object)SystemUtils.getLineSeparator(), (Object)SystemUtils.getLineSeparator(), (Object)this.versionVector.fullToString(), (Object)rvv);
            }
            if (!(result = this.versionVector.waitToDominate(rvv, this))) {
                if (isRvvDebugEnabled) {
                    logger.trace(LogMarker.RVV_VERBOSE, "incrementing clearTimeouts for {} rvv={}", (Object)this.getName(), (Object)this.versionVector.fullToString());
                }
                this.getCachePerfStats().incClearTimeouts();
            }
        }
        if (isGIIinProgress = this.lockGII()) {
            try {
                this.getImageState().setClearRegionFlag(true, rvv);
            }
            finally {
                this.unlockGII();
            }
        }
        if (cacheWrite && !isGIIinProgress) {
            this.cacheWriteBeforeRegionClear(regionEvent);
        }
        if ((myVector = this.getVersionVector()) != null) {
            VersionTag tag;
            if (isRvvDebugEnabled) {
                logger.trace(LogMarker.RVV_VERBOSE, "processing version information for {}", (Object)regionEvent);
            }
            if (!regionEvent.isOriginRemote() && !regionEvent.getOperation().isLocal()) {
                tag = VersionTag.create(this.getVersionMember());
                tag.setVersionTimeStamp(this.cacheTimeMillis());
                tag.setRegionVersion(myVector.getNextVersionWhileLocked());
                if (isRvvDebugEnabled) {
                    logger.trace(LogMarker.RVV_VERBOSE, "generated version tag for clear: {}", (Object)tag);
                }
                regionEvent.setVersionTag(tag);
            } else {
                tag = regionEvent.getVersionTag();
                if (tag != null) {
                    if (isRvvDebugEnabled) {
                        logger.trace(LogMarker.RVV_VERBOSE, "recording version tag for clear: {}", (Object)tag);
                    }
                    myVector.recordVersion(tag.getMemberID(), tag);
                }
            }
        }
        this.cancelAllEntryExpiryTasks();
        if (this.entryUserAttributes != null) {
            this.entryUserAttributes.clear();
        }
        if (rvv == null && myVector != null) {
            myVector.removeOldVersions();
        }
        if (this.diskRegion != null) {
            if (this.getDataPolicy().withPersistence()) {
                if (isRvvDebugEnabled) {
                    logger.trace(LogMarker.RVV_VERBOSE, "Clear: Saved current rvv: {}", (Object)this.diskRegion.getRegionVersionVector());
                }
                this.diskRegion.writeRVV(this, null);
                this.diskRegion.writeRVVGC(this);
            }
            this.diskRegion.clear(this, rvv);
        } else {
            this.txClearRegion();
            Set remainingIDs = this.clearEntries(rvv);
            if (!this.getDataPolicy().withPersistence() && myVector != null) {
                myVector.removeOldMembers(remainingIDs);
            }
        }
        if (!this.isProxy() && this.indexManager != null) {
            try {
                this.indexManager.rerunIndexCreationQuery();
            }
            catch (QueryException qe) {
                throw new CacheRuntimeException(LocalizedStrings.LocalRegion_EXCEPTION_OCCURRED_WHILE_RE_CREATING_INDEX_DATA_ON_CLEARED_REGION.toLocalizedString(), qe){
                    private static final long serialVersionUID = 0L;
                };
            }
        }
        if (ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().afterRegionClear(regionEvent);
        }
        if (isGIIinProgress) {
            return;
        }
        regionEvent.setEventType(EnumListenerEvent.AFTER_REGION_CLEAR);
        boolean hasListener = this.hasListener();
        if (hasListener) {
            this.dispatchListenerEvent(EnumListenerEvent.AFTER_REGION_CLEAR, regionEvent);
        }
    }

    @Override
    void basicLocalClear(RegionEventImpl rEvent) {
        this.getDataView().checkSupportsRegionClear();
        this.cmnClearRegion(rEvent, false, false);
    }

    public void handleInterestEvent(InterestRegistrationEvent event) {
        throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_REGION_INTEREST_REGISTRATION_IS_ONLY_SUPPORTED_FOR_PARTITIONEDREGIONS.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Map basicGetAll(Collection keys, Object callback) {
        HashMap<Object, Object> allResults;
        block24: {
            block23: {
                boolean isDebugEnabled = logger.isDebugEnabled();
                boolean isTraceEnabled = logger.isTraceEnabled();
                if (isDebugEnabled) {
                    logger.debug("Processing getAll request for: {}", (Object)keys);
                }
                this.discoverJTA();
                allResults = new HashMap<Object, Object>();
                if (!this.hasServerProxy()) break block23;
                ArrayList keysList = keys instanceof List ? (ArrayList)keys : new ArrayList(keys);
                if (this.getTXState() == null && this.hasStorage()) {
                    if (keysList == keys) {
                        keysList = new ArrayList(keys);
                    }
                    Iterator iterator = keysList.iterator();
                    while (iterator.hasNext()) {
                        Object value;
                        Object key = iterator.next();
                        Region.Entry entry = this.accessEntry(key, true);
                        if (entry == null || (value = entry.getValue()) == null) continue;
                        allResults.put(key, value);
                        iterator.remove();
                    }
                    if (isDebugEnabled) {
                        logger.debug("Added local results for getAll request: {}", allResults);
                    }
                }
                if (keysList.isEmpty()) break block24;
                VersionedObjectList remoteResults = this.getServerProxy().getAll(keysList, callback);
                if (isDebugEnabled) {
                    logger.debug("remote getAll results are {}", (Object)remoteResults);
                }
                VersionedObjectList.Iterator it = remoteResults.iterator();
                while (it.hasNext()) {
                    Object value;
                    VersionedObjectList.Entry entry = it.next();
                    Object key = entry.getKey();
                    boolean notOnServer = entry.isKeyNotOnServer();
                    boolean createTombstone = false;
                    if (notOnServer) {
                        createTombstone = entry.getVersionTag() != null && this.getConcurrencyChecksEnabled();
                        allResults.put(key, null);
                        if (isDebugEnabled) {
                            logger.debug("Added remote result for missing key: {}", key);
                        }
                        if (!createTombstone) continue;
                    }
                    if ((value = createTombstone ? Token.TOMBSTONE : entry.getObject()) instanceof Throwable) continue;
                    long startPut = CachePerfStats.getStatTime();
                    this.validateKey(key);
                    EntryEventImpl event = EntryEventImpl.create(this, Operation.LOCAL_LOAD_CREATE, key, value, callback, false, this.getMyId(), true);
                    try {
                        event.setFromServer(true);
                        event.setVersionTag(entry.getVersionTag());
                        if (!this.alreadyInvalid(key, event)) {
                            TXStateProxy txState = this.cache.getTXMgr().pauseTransaction();
                            try {
                                this.basicPutEntry(event, 0L);
                            }
                            catch (ConcurrentCacheModificationException e) {
                                if (isDebugEnabled) {
                                    logger.debug("getAll result for {} not stored in cache due to concurrent modification", key, (Object)e);
                                }
                            }
                            finally {
                                this.cache.getTXMgr().unpauseTransaction(txState);
                            }
                            this.getCachePerfStats().endPut(startPut, event.isOriginRemote());
                        }
                        if (createTombstone) continue;
                        allResults.put(key, value);
                        if (!isTraceEnabled) continue;
                        logger.trace("Added remote result for getAll request: {}, {}", key, value);
                    }
                    finally {
                        event.release();
                    }
                }
                break block24;
            }
            for (Object key : keys) {
                try {
                    allResults.put(key, this.get(key, callback));
                }
                catch (Exception e) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_THE_FOLLOWING_EXCEPTION_OCCURRED_ATTEMPTING_TO_GET_KEY_0, key), (Throwable)e);
                }
            }
        }
        return allResults;
    }

    protected boolean hasStorage() {
        return this.getDataPolicy().withStorage();
    }

    private void verifyPutAllMap(Map map) {
        Set theEntries = map.entrySet();
        for (Object e : theEntries) {
            Map.Entry mapEntry = (Map.Entry)e;
            Object key = mapEntry.getKey();
            if (mapEntry.getValue() == null || key == null) {
                throw new NullPointerException("Any key or value in putAll should not be null");
            }
            if (MemoryThresholds.isLowMemoryExceptionDisabled()) continue;
            this.checkIfAboveThreshold(key);
        }
    }

    private void verifyRemoveAllKeys(Collection<Object> keys) {
        for (Object key : keys) {
            if (key != null) continue;
            throw new NullPointerException("Any key in removeAll must not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedObjectList basicBridgePutAll(Map map, Map<Object, VersionTag> retryVersions, ClientProxyMembershipID memberId, EventID eventId, boolean skipCallbacks, Object callbackArg) throws TimeoutException, CacheWriterException {
        long startPut = CachePerfStats.getStatTime();
        if (this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.PUTALL_CREATE, null, null, callbackArg, false, memberId.getDistributedMember(), !skipCallbacks, eventId);
        try {
            event.setContext(memberId);
            DistributedPutAllOperation putAllOp = new DistributedPutAllOperation(event, map.size(), true);
            try {
                VersionedObjectList result = this.basicPutAll(map, putAllOp, retryVersions);
                this.getCachePerfStats().endPutAll(startPut);
                VersionedObjectList versionedObjectList = result;
                putAllOp.freeOffHeapResources();
                return versionedObjectList;
            }
            catch (Throwable throwable) {
                putAllOp.freeOffHeapResources();
                throw throwable;
            }
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedObjectList basicBridgeRemoveAll(List<Object> keys, ArrayList<VersionTag> retryVersions, ClientProxyMembershipID memberId, EventID eventId, Object callbackArg) throws TimeoutException, CacheWriterException {
        long startOp = CachePerfStats.getStatTime();
        if (this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REMOVEALL_DESTROY, null, null, callbackArg, false, memberId.getDistributedMember(), true, eventId);
        try {
            event.setContext(memberId);
            DistributedRemoveAllOperation removeAllOp = new DistributedRemoveAllOperation(event, keys.size(), true);
            try {
                VersionedObjectList result = this.basicRemoveAll(keys, removeAllOp, retryVersions);
                this.getCachePerfStats().endRemoveAll(startOp);
                VersionedObjectList versionedObjectList = result;
                removeAllOp.freeOffHeapResources();
                return versionedObjectList;
            }
            catch (Throwable throwable) {
                removeAllOp.freeOffHeapResources();
                throw throwable;
            }
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedObjectList basicImportPutAll(Map map, boolean skipCallbacks) {
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.PUTALL_CREATE, null, null, null, true, this.getMyId(), !skipCallbacks);
        try {
            DistributedPutAllOperation putAllOp = new DistributedPutAllOperation(event, map.size(), false);
            try {
                VersionedObjectList result = this.basicPutAll(map, putAllOp, null);
                this.getCachePerfStats().endPutAll(startPut);
                VersionedObjectList versionedObjectList = result;
                putAllOp.freeOffHeapResources();
                return versionedObjectList;
            }
            catch (Throwable throwable) {
                putAllOp.freeOffHeapResources();
                throw throwable;
            }
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map, Object aCallbackArgument) {
        long startPut = CachePerfStats.getStatTime();
        DistributedPutAllOperation putAllOp = this.newPutAllOperation(map, aCallbackArgument);
        if (putAllOp != null) {
            try {
                this.basicPutAll(map, putAllOp, null);
            }
            finally {
                putAllOp.getBaseEvent().release();
                putAllOp.freeOffHeapResources();
            }
        }
        this.getCachePerfStats().endPutAll(startPut);
    }

    @Override
    public void putAll(Map map) {
        this.putAll(map, (Object)null);
    }

    public void removeAll(Collection keys) {
        this.removeAll(keys, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection keys, Object aCallbackArgument) {
        long startOp = CachePerfStats.getStatTime();
        DistributedRemoveAllOperation operation = this.newRemoveAllOperation(keys, aCallbackArgument);
        if (operation != null) {
            try {
                this.basicRemoveAll(keys, operation, null);
            }
            finally {
                operation.getBaseEvent().release();
                operation.freeOffHeapResources();
            }
        }
        this.getCachePerfStats().endRemoveAll(startOp);
    }

    public boolean requiresOneHopForMissingEntry(EntryEventImpl event) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedObjectList basicPutAll(final Map<?, ?> map, final DistributedPutAllOperation putAllOp, final Map<Object, VersionTag> retryVersions) {
        boolean serverIsVersioned;
        RuntimeException runtimeException;
        boolean partialResult;
        VersionedObjectList proxyResult;
        EventID eventId;
        EntryEventImpl event;
        boolean isDebugEnabled;
        block30: {
            isDebugEnabled = logger.isDebugEnabled();
            event = putAllOp.getBaseEvent();
            eventId = event.getEventId();
            if (eventId == null && this.generateEventID()) {
                event.reserveNewEventId(this.cache.getDistributedSystem(), map.size());
                eventId = event.getEventId();
            }
            this.verifyPutAllMap(map);
            proxyResult = null;
            partialResult = false;
            runtimeException = null;
            if (this.hasServerProxy()) {
                if (this.isTX()) {
                    TXStateProxyImpl txState = (TXStateProxyImpl)this.cache.getTxManager().getTXState();
                    txState.getRealDeal(null, this);
                }
                try {
                    proxyResult = this.getServerProxy().putAll(map, eventId, !event.isGenerateCallbacks(), event.getCallbackArgument());
                    if (isDebugEnabled) {
                        logger.debug("PutAll received response from server: {}", (Object)proxyResult);
                    }
                }
                catch (PutAllPartialResultException e) {
                    proxyResult = e.getSucceededKeysAndVersions();
                    partialResult = true;
                    if (isDebugEnabled) {
                        logger.debug("putAll in client encountered a PutAllPartialResultException:{}{}. Adjusted keys are: {}", (Object)e.getMessage(), (Object)SystemUtils.getLineSeparator(), proxyResult.getKeys());
                    }
                    for (Throwable txException = e.getFailure(); txException != null; txException = txException.getCause()) {
                        if (!(txException instanceof TransactionException)) continue;
                        runtimeException = (RuntimeException)txException;
                        break;
                    }
                    if (runtimeException != null || (runtimeException = this.getCancelCriterion().generateCancelledException(e.getFailure())) != null) break block30;
                    runtimeException = new ServerOperationException(LocalizedStrings.Region_PutAll_Applied_PartialKeys_At_Server_0.toLocalizedString(this.getFullPath()), e.getFailure());
                }
            }
        }
        final VersionedObjectList succeeded = new VersionedObjectList(map.size(), true, this.getConcurrencyChecksEnabled());
        boolean bl = serverIsVersioned = proxyResult != null && proxyResult.regionIsVersioned() && !this.isTX() && this.getDataPolicy() != DataPolicy.EMPTY;
        if (!serverIsVersioned && !partialResult) {
            proxyResult = null;
        }
        this.lockRVVForBulkOp();
        try {
            block31: {
                try {
                    boolean isVersionedResults;
                    Iterator iterator;
                    int size;
                    int n = size = proxyResult == null ? map.size() : proxyResult.size();
                    if (isDebugEnabled) {
                        logger.debug("size of put result is {} maps is {} proxyResult is {}", (Object)size, map, (Object)proxyResult);
                    }
                    final PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(size);
                    if (proxyResult != null) {
                        iterator = proxyResult.iterator();
                        isVersionedResults = true;
                    } else {
                        iterator = map.entrySet().iterator();
                        isVersionedResults = false;
                    }
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            int offset = 0;
                            VersionTagHolder tagHolder = new VersionTagHolder();
                            while (iterator.hasNext()) {
                                Object value;
                                LocalRegion.this.stopper.checkCancelInProgress(null);
                                Map.Entry mapEntry = (Map.Entry)iterator.next();
                                Object key = mapEntry.getKey();
                                VersionTag versionTag = null;
                                tagHolder.setVersionTag(null);
                                boolean overwritten = false;
                                if (isVersionedResults) {
                                    versionTag = ((VersionedObjectList.Entry)mapEntry).getVersionTag();
                                    value = map.get(key);
                                    if (isDebugEnabled) {
                                        logger.debug("putAll key {} -> {} version={}", key, value, (Object)versionTag);
                                    }
                                    if (versionTag == null && serverIsVersioned && LocalRegion.this.getConcurrencyChecksEnabled() && LocalRegion.this.getDataPolicy().withStorage()) {
                                        if (isDebugEnabled) {
                                            logger.debug("server returned no version information for {}", key);
                                        }
                                        LocalRegion.this.localDestroyNoCallbacks(key);
                                        LocalRegion.this.get(key, event.getCallbackArgument(), false, null);
                                        overwritten = true;
                                    }
                                } else {
                                    value = mapEntry.getValue();
                                    if (isDebugEnabled) {
                                        logger.debug("putAll {} -> {}", key, value);
                                    }
                                }
                                try {
                                    if (serverIsVersioned) {
                                        if (isDebugEnabled) {
                                            logger.debug("associating version tag with {} version={}", key, (Object)versionTag);
                                        }
                                        tagHolder.setVersionTag(versionTag);
                                        tagHolder.setFromServer(true);
                                    } else if (retryVersions != null && retryVersions.containsKey(key)) {
                                        tagHolder.setVersionTag((VersionTag)retryVersions.get(key));
                                    }
                                    if (!overwritten) {
                                        LocalRegion.this.basicEntryPutAll(key, value, putAllOp, offset, tagHolder);
                                    }
                                    LocalRegion.this.stopper.checkCancelInProgress(null);
                                    succeeded.addKeyAndVersion(key, tagHolder.getVersionTag());
                                }
                                catch (Exception ex) {
                                    if (isDebugEnabled) {
                                        logger.debug("PutAll operation encountered exception for key {}", key, (Object)ex);
                                    }
                                    partialKeys.saveFailedKey(key, ex);
                                }
                                ++offset;
                            }
                        }
                    };
                    this.syncBulkOp(task, eventId);
                    if (!partialKeys.hasFailure()) break block31;
                    partialKeys.setSucceededKeysAndVersions(succeeded);
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.Region_PutAll_Applied_PartialKeys_0_1, new Object[]{this.getFullPath(), partialKeys}));
                    if (isDebugEnabled) {
                        logger.debug(partialKeys.detailString());
                    }
                    if (runtimeException != null) break block31;
                    if (putAllOp.isBridgeOperation()) {
                        if (partialKeys.getFailure() instanceof CancelException) {
                            runtimeException = (RuntimeException)partialKeys.getFailure();
                        } else {
                            if (partialKeys.getFailure() instanceof LowMemoryException) {
                                throw partialKeys.getFailure();
                            }
                            runtimeException = new PutAllPartialResultException(partialKeys);
                            if (isDebugEnabled) {
                                logger.debug("basicPutAll:" + partialKeys.detailString());
                            }
                        }
                        break block31;
                    }
                    throw partialKeys.getFailure();
                }
                catch (LowMemoryException lme) {
                    throw lme;
                }
                catch (RuntimeException ex) {
                    runtimeException = ex;
                }
                catch (Exception ex) {
                    runtimeException = new RuntimeException(ex);
                }
                finally {
                    putAllOp.getBaseEvent().release();
                    putAllOp.freeOffHeapResources();
                }
            }
            this.getDataView().postPutAll(putAllOp, succeeded, this);
        }
        finally {
            this.unlockRVVForBulkOp();
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersionedObjectList basicRemoveAll(Collection<Object> keys, final DistributedRemoveAllOperation removeAllOp, final List<VersionTag> retryVersions) {
        boolean serverIsVersioned;
        RuntimeException runtimeException;
        boolean partialResult;
        VersionedObjectList proxyResult;
        EventID eventId;
        boolean isTraceEnabled;
        boolean isDebugEnabled;
        block35: {
            isDebugEnabled = logger.isDebugEnabled();
            isTraceEnabled = logger.isTraceEnabled();
            EntryEventImpl event = removeAllOp.getBaseEvent();
            eventId = event.getEventId();
            if (eventId == null && this.generateEventID()) {
                event.reserveNewEventId(this.cache.getDistributedSystem(), keys.size());
                eventId = event.getEventId();
            }
            this.verifyRemoveAllKeys(keys);
            proxyResult = null;
            partialResult = false;
            runtimeException = null;
            if (this.hasServerProxy()) {
                if (this.isTX()) {
                    TXStateProxyImpl txState = (TXStateProxyImpl)this.cache.getTxManager().getTXState();
                    txState.getRealDeal(null, this);
                }
                try {
                    proxyResult = this.getServerProxy().removeAll(keys, eventId, event.getCallbackArgument());
                    if (isDebugEnabled) {
                        logger.debug("removeAll received response from server: {}", (Object)proxyResult);
                    }
                }
                catch (PutAllPartialResultException e) {
                    proxyResult = e.getSucceededKeysAndVersions();
                    partialResult = true;
                    if (isDebugEnabled) {
                        logger.debug("removeAll in client encountered a BulkOpPartialResultException: {}{}. Adjusted keys are: {}", (Object)e.getMessage(), (Object)SystemUtils.getLineSeparator(), proxyResult.getKeys());
                    }
                    for (Throwable txException = e.getFailure(); txException != null; txException = txException.getCause()) {
                        if (!(txException instanceof TransactionException)) continue;
                        runtimeException = (RuntimeException)txException;
                        break;
                    }
                    if (runtimeException != null) break block35;
                    runtimeException = new ServerOperationException(LocalizedStrings.Region_RemoveAll_Applied_PartialKeys_At_Server_0.toLocalizedString(this.getFullPath()), e.getFailure());
                }
            }
        }
        final VersionedObjectList succeeded = new VersionedObjectList(keys.size(), true, this.getConcurrencyChecksEnabled());
        boolean bl = serverIsVersioned = proxyResult != null && proxyResult.regionIsVersioned() && !this.isTX() && this.getDataPolicy().withStorage();
        if (!serverIsVersioned && !partialResult) {
            proxyResult = null;
        }
        this.lockRVVForBulkOp();
        try {
            block36: {
                try {
                    boolean isVersionedResults;
                    Iterator iterator;
                    int size;
                    int n = size = proxyResult == null ? keys.size() : proxyResult.size();
                    if (this.isInternalRegion()) {
                        if (isTraceEnabled) {
                            logger.trace("size of removeAll result is {} keys are {} proxyResult is {}", (Object)size, keys, (Object)proxyResult);
                        } else if (isTraceEnabled) {
                            logger.trace("size of removeAll result is {} keys are {} proxyResult is {}", (Object)size, keys, (Object)proxyResult);
                        }
                    } else if (isTraceEnabled) {
                        logger.trace("size of removeAll result is {} keys are {} proxyResult is {}", (Object)size, keys, (Object)proxyResult);
                    }
                    final PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(size);
                    if (proxyResult != null) {
                        iterator = proxyResult.iterator();
                        isVersionedResults = true;
                    } else {
                        iterator = keys.iterator();
                        isVersionedResults = false;
                    }
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            int offset = 0;
                            VersionTagHolder tagHolder = new VersionTagHolder();
                            while (iterator.hasNext()) {
                                Object key;
                                LocalRegion.this.stopper.checkCancelInProgress(null);
                                tagHolder.setVersionTag(null);
                                VersionTag versionTag = null;
                                if (isVersionedResults) {
                                    Map.Entry mapEntry = (Map.Entry)iterator.next();
                                    key = mapEntry.getKey();
                                    versionTag = ((VersionedObjectList.Entry)mapEntry).getVersionTag();
                                    if (isDebugEnabled) {
                                        logger.debug("removeAll key {} version={}", key, (Object)versionTag);
                                    }
                                    if (versionTag == null) {
                                        if (isDebugEnabled) {
                                            logger.debug("removeAll found invalid version tag, which means the entry is not found at server for key={}.", key);
                                        }
                                        succeeded.addKeyAndVersion(key, null);
                                        continue;
                                    }
                                } else {
                                    key = iterator.next();
                                    if (isTraceEnabled) {
                                        logger.trace("removeAll {}", key);
                                    }
                                }
                                try {
                                    VersionTag versionTag1;
                                    if (serverIsVersioned) {
                                        if (isDebugEnabled) {
                                            logger.debug("associating version tag with {} version={}", key, (Object)versionTag);
                                        }
                                        tagHolder.setVersionTag(versionTag);
                                        tagHolder.setFromServer(true);
                                    } else if (retryVersions != null && (versionTag1 = (VersionTag)retryVersions.get(offset)) != null) {
                                        tagHolder.setVersionTag(versionTag1);
                                    }
                                    LocalRegion.this.basicEntryRemoveAll(key, removeAllOp, offset, tagHolder);
                                    LocalRegion.this.stopper.checkCancelInProgress(null);
                                    succeeded.addKeyAndVersion(key, tagHolder.getVersionTag());
                                }
                                catch (Exception ex) {
                                    partialKeys.saveFailedKey(key, ex);
                                }
                                ++offset;
                            }
                        }
                    };
                    this.syncBulkOp(task, eventId);
                    if (!partialKeys.hasFailure()) break block36;
                    partialKeys.setSucceededKeysAndVersions(succeeded);
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.Region_RemoveAll_Applied_PartialKeys_0_1, new Object[]{this.getFullPath(), partialKeys}));
                    if (isDebugEnabled) {
                        logger.debug(partialKeys.detailString());
                    }
                    if (runtimeException != null) break block36;
                    if (removeAllOp.isBridgeOperation()) {
                        if (partialKeys.getFailure() instanceof CancelException) {
                            runtimeException = (RuntimeException)partialKeys.getFailure();
                        } else {
                            if (partialKeys.getFailure() instanceof LowMemoryException) {
                                throw partialKeys.getFailure();
                            }
                            runtimeException = new PutAllPartialResultException(partialKeys);
                            if (isDebugEnabled) {
                                logger.debug("basicRemoveAll: {}", (Object)partialKeys.detailString());
                            }
                        }
                        break block36;
                    }
                    throw partialKeys.getFailure();
                }
                catch (LowMemoryException lme) {
                    throw lme;
                }
                catch (RuntimeException ex) {
                    runtimeException = ex;
                }
                catch (Exception ex) {
                    runtimeException = new RuntimeException(ex);
                }
                finally {
                    removeAllOp.getBaseEvent().release();
                    removeAllOp.freeOffHeapResources();
                }
            }
            this.getDataView().postRemoveAll(removeAllOp, succeeded, this);
        }
        finally {
            this.unlockRVVForBulkOp();
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        return succeeded;
    }

    private void lockRVVForBulkOp() {
        AbstractRegionMap.ARMLockTestHook testHook = this.getRegionMap().getARMLockTestHook();
        if (testHook != null) {
            testHook.beforeBulkLock(this);
        }
        if (this.versionVector != null && this.getDataPolicy().withReplication()) {
            this.versionVector.lockForCacheModification(this);
        }
        if (testHook != null) {
            testHook.afterBulkLock(this);
        }
    }

    private void unlockRVVForBulkOp() {
        AbstractRegionMap.ARMLockTestHook testHook = this.getRegionMap().getARMLockTestHook();
        if (testHook != null) {
            testHook.beforeBulkRelease(this);
        }
        if (this.versionVector != null && this.getDataPolicy().withReplication()) {
            this.versionVector.releaseCacheModificationLock(this);
        }
        if (testHook != null) {
            testHook.afterBulkRelease(this);
        }
    }

    public DistributedPutAllOperation newPutAllOperation(Map<?, ?> map, Object callbackArg) {
        if (map == null) {
            throw new NullPointerException(LocalizedStrings.AbstractRegion_MAP_CANNOT_BE_NULL.toLocalizedString());
        }
        if (map.isEmpty()) {
            return null;
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.PUTALL_CREATE, null, null, callbackArg, true, this.getMyId());
        event.disallowOffHeapValues();
        return new DistributedPutAllOperation(event, map.size(), false);
    }

    private DistributedRemoveAllOperation newRemoveAllOperation(Collection<?> keys, Object callbackArg) {
        if (keys == null) {
            throw new NullPointerException("The keys Collection passed to removeAll was null.");
        }
        if (keys.isEmpty()) {
            return null;
        }
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REMOVEALL_DESTROY, null, null, callbackArg, false, this.getMyId());
        event.disallowOffHeapValues();
        return new DistributedRemoveAllOperation(event, keys.size(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicEntryPutAll(Object key, Object value, DistributedPutAllOperation putallOp, int offset, EntryEventImpl tagHolder) throws TimeoutException, CacheWriterException {
        assert (putallOp != null);
        this.checkReadiness();
        if (value == null) {
            throw new NullPointerException(LocalizedStrings.LocalRegion_VALUE_CANNOT_BE_NULL.toLocalizedString());
        }
        this.validateArguments(key, value, null);
        EntryEventImpl event = EntryEventImpl.createPutAllEvent(putallOp, this, Operation.PUTALL_CREATE, key, value);
        try {
            if (tagHolder != null) {
                event.setVersionTag(tagHolder.getVersionTag());
                event.setFromServer(tagHolder.isFromServer());
            }
            if (this.generateEventID()) {
                event.setEventId(new EventID(putallOp.getBaseEvent().getEventId(), offset));
            }
            this.discoverJTA();
            this.performPutAllEntry(event);
            if (tagHolder != null) {
                tagHolder.setVersionTag(event.getVersionTag());
                tagHolder.isConcurrencyConflict(event.isConcurrencyConflict());
            }
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicEntryRemoveAll(Object key, DistributedRemoveAllOperation op, int offset, EntryEventImpl tagHolder) throws TimeoutException, CacheWriterException {
        assert (op != null);
        this.checkReadiness();
        this.validateKey(key);
        EntryEventImpl event = EntryEventImpl.createRemoveAllEvent(op, this, key);
        try {
            block9: {
                if (tagHolder != null) {
                    event.setVersionTag(tagHolder.getVersionTag());
                    event.setFromServer(tagHolder.isFromServer());
                }
                if (this.generateEventID()) {
                    event.setEventId(new EventID(op.getBaseEvent().getEventId(), offset));
                }
                this.discoverJTA();
                try {
                    this.performRemoveAllEntry(event);
                }
                catch (EntryNotFoundException ignore) {
                    if (event.getVersionTag() != null || !logger.isDebugEnabled()) break block9;
                    logger.debug("RemoveAll encoutered EntryNotFoundException: event={}", (Object)event);
                }
            }
            if (tagHolder != null) {
                tagHolder.setVersionTag(event.getVersionTag());
                tagHolder.isConcurrencyConflict(event.isConcurrencyConflict());
            }
        }
        finally {
            event.release();
        }
    }

    public void performPutAllEntry(EntryEventImpl event) {
        this.getDataView().putEntry(event, false, false, null, false, 0L, false);
    }

    public void performRemoveAllEntry(EntryEventImpl event) {
        this.basicDestroy(event, true, null);
    }

    public void postPutAllFireEvents(DistributedPutAllOperation putAllOp, VersionedObjectList successfulPuts) {
        if (!this.getDataPolicy().withStorage() && this.getConcurrencyChecksEnabled() && putAllOp.getBaseEvent().isBridgeEvent()) {
            successfulPuts.clear();
            putAllOp.fillVersionedObjectList(successfulPuts);
        }
        HashSet<Object> successfulKeys = new HashSet<Object>(successfulPuts.size());
        for (Object key : successfulPuts.getKeys()) {
            successfulKeys.add(key);
        }
        Iterator it = putAllOp.eventIterator();
        while (it.hasNext()) {
            EntryEventImpl event = (EntryEventImpl)it.next();
            if (!successfulKeys.contains(event.getKey())) continue;
            EnumListenerEvent op = event.getOperation().isCreate() ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE;
            this.invokePutCallbacks(op, event, !event.callbacksInvoked() && !event.isPossibleDuplicate(), this.isUsedForPartitionedRegionBucket);
        }
    }

    public void postRemoveAllFireEvents(DistributedRemoveAllOperation removeAllOp, VersionedObjectList successfulOps) {
        if (!this.getDataPolicy().withStorage() && this.getConcurrencyChecksEnabled() && removeAllOp.getBaseEvent().isBridgeEvent()) {
            successfulOps.clear();
            removeAllOp.fillVersionedObjectList(successfulOps);
        }
        HashSet<Object> successfulKeys = new HashSet<Object>(successfulOps.size());
        for (Object key : successfulOps.getKeys()) {
            successfulKeys.add(key);
        }
        Iterator it = removeAllOp.eventIterator();
        while (it.hasNext()) {
            EntryEventImpl event = (EntryEventImpl)it.next();
            if (!successfulKeys.contains(event.getKey())) continue;
            this.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, event, !event.callbacksInvoked() && !event.isPossibleDuplicate(), this.isUsedForPartitionedRegionBucket);
        }
    }

    public long postPutAllSend(DistributedPutAllOperation putAllOp, VersionedObjectList successfulPuts) {
        return -1L;
    }

    public long postRemoveAllSend(DistributedRemoveAllOperation op, VersionedObjectList successfulOps) {
        return -1L;
    }

    @Override
    protected boolean isCurrentlyLockGrantor() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRemoteLocalRegionDestroyOrClose(InternalDistributedMember sender, int topSerial, Map subregionSerialNumbers, boolean regionDestroyed) {
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            this.basicHandleRemoteLocalRegionDestroyOrClose(sender, topSerial, subregionSerialNumbers, false, regionDestroyed);
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    private void basicHandleRemoteLocalRegionDestroyOrClose(InternalDistributedMember sender, int topSerial, Map subregionSerialNumbers, boolean subregion, boolean regionDestroyed) {
        int serialForThisRegion = topSerial;
        if (subregion) {
            Integer serialNumber = (Integer)subregionSerialNumbers.get(this.getFullPath());
            if (serialNumber == null) {
                return;
            }
            serialForThisRegion = serialNumber;
        }
        this.removeSenderFromAdvisor(sender, serialForThisRegion, regionDestroyed);
        for (Object regionObject : this.subregions.values()) {
            LocalRegion region = this.toRegion(regionObject);
            if (region == null || region.isDestroyed()) continue;
            region.basicHandleRemoteLocalRegionDestroyOrClose(sender, topSerial, subregionSerialNumbers, true, regionDestroyed);
        }
    }

    protected void removeSenderFromAdvisor(InternalDistributedMember sender, int serial, boolean regionDestroyed) {
    }

    @Override
    public boolean isUsedForPartitionedRegionAdmin() {
        return this.isUsedForPartitionedRegionAdmin;
    }

    public boolean shouldSyncForCrashedMember(InternalDistributedMember id) {
        return this.getConcurrencyChecksEnabled() && this.getDataPolicy().withReplication() && !this.isUsedForPartitionedRegionAdmin && !this.isUsedForMetaRegion && !this.isUsedForSerialGatewaySenderQueue;
    }

    @Override
    public void forceRolling() throws DiskAccessException {
        if (this.diskRegion != null) {
            this.diskRegion.forceRolling();
        }
    }

    @Deprecated
    public boolean notifyToRoll() {
        return this.forceCompaction();
    }

    @Override
    public boolean forceCompaction() {
        DiskRegion region = this.getDiskRegion();
        if (region != null) {
            if (region.isCompactionPossible()) {
                return region.forceCompaction();
            }
            throw new IllegalStateException("To call notifyToCompact you must configure the region with <disk-write-attributes allow-force-compaction=true/>");
        }
        return false;
    }

    @Override
    public File[] getDiskDirs() {
        if (this.getDiskStore() != null) {
            return this.getDiskStore().getDiskDirs();
        }
        return this.diskDirs;
    }

    @Override
    public int[] getDiskDirSizes() {
        if (this.getDiskStore() != null) {
            return this.getDiskStore().getDiskDirSizes();
        }
        return this.diskSizes;
    }

    @Override
    public boolean isUsedForPartitionedRegionBucket() {
        return this.isUsedForPartitionedRegionBucket;
    }

    public boolean isUsedForSerialGatewaySenderQueue() {
        return this.isUsedForSerialGatewaySenderQueue;
    }

    public boolean isUsedForParallelGatewaySenderQueue() {
        return this.isUsedForParallelGatewaySenderQueue;
    }

    public AbstractGatewaySender getSerialGatewaySender() {
        return this.serialGatewaySender;
    }

    boolean isParallelWanEnabled() {
        Set<String> regionGatewaySenderIds = this.getAllGatewaySenderIds();
        if (regionGatewaySenderIds.isEmpty()) {
            return false;
        }
        Set<GatewaySender> cacheGatewaySenders = this.getCache().getAllGatewaySenders();
        for (GatewaySender sender : cacheGatewaySenders) {
            if (!regionGatewaySenderIds.contains(sender.getId()) || !sender.isParallel()) continue;
            return true;
        }
        return false;
    }

    public PartitionedRegion getPartitionedRegion() {
        if (!this.isUsedForPartitionedRegionBucket) {
            throw new IllegalArgumentException();
        }
        return ((Bucket)((Object)this)).getPartitionedRegion();
    }

    @Override
    public boolean isUsedForMetaRegion() {
        return this.isUsedForMetaRegion;
    }

    boolean isMetaRegionWithTransactions() {
        return this.isMetaRegionWithTransactions;
    }

    @Override
    public boolean isInternalRegion() {
        return this.isSecret() || this.isUsedForMetaRegion() || this.isUsedForPartitionedRegionAdmin() || this.isUsedForPartitionedRegionBucket();
    }

    Map<String, CacheServiceProfile> getCacheServiceProfiles() {
        return this.cacheServiceProfiles.getSnapshot();
    }

    @Override
    public void addCacheServiceProfile(CacheServiceProfile profile) {
        this.cacheServiceProfiles.put(profile.getId(), profile);
    }

    @Override
    public LoaderHelper createLoaderHelper(Object key, Object callbackArgument, boolean netSearchAllowed, boolean netLoadAllowed, SearchLoadAndWriteProcessor searcher) {
        return new LoaderHelperImpl(this, key, callbackArgument, netSearchAllowed, netLoadAllowed, searcher);
    }

    boolean hasNetLoader(CacheDistributionAdvisor distAdvisor) {
        return !distAdvisor.accept(netLoaderVisitor, null);
    }

    @Override
    public boolean isSecret() {
        return false;
    }

    @Override
    public boolean supportsConcurrencyChecks() {
        return !this.isSecret() || this.getDataPolicy().withPersistence();
    }

    protected boolean shouldNotifyBridgeClients() {
        return !this.cache.getCacheServers().isEmpty() && !this.isUsedForPartitionedRegionAdmin && !this.isUsedForPartitionedRegionBucket && !this.isUsedForMetaRegion;
    }

    boolean shouldDispatchListenerEvent() {
        return this.hasListener();
    }

    @Override
    public void cleanupForClient(CacheClientNotifier clientNotifier, ClientProxyMembershipID client) {
        if (this.cache.isClosed() || this.isDestroyed) {
            return;
        }
        this.filterProfile.cleanupForClient(clientNotifier, client);
        for (Object regionObject : new SubregionsSet(false)) {
            LocalRegion region = (LocalRegion)regionObject;
            region.cleanupForClient(clientNotifier, client);
        }
    }

    @Override
    public FilterProfile getFilterProfile() {
        return this.filterProfile;
    }

    protected HashMap getDestroyedSubregionSerialNumbers() {
        if (!this.isDestroyed) {
            throw new IllegalStateException(LocalizedStrings.LocalRegion_REGION_0_MUST_BE_DESTROYED_BEFORE_CALLING_GETDESTROYEDSUBREGIONSERIALNUMBERS.toLocalizedString(this.getFullPath()));
        }
        return this.destroyedSubregionSerialNumbers;
    }

    private HashMap collectSubregionSerialNumbers() {
        HashMap map = new HashMap();
        this.addSubregionSerialNumbers(map);
        return map;
    }

    private void addSubregionSerialNumbers(Map map) {
        Iterator iterator = this.subregions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            LocalRegion subregion = (LocalRegion)entry.getValue();
            map.put(subregion.getFullPath(), subregion.getSerialNumber());
            subregion.addSubregionSerialNumbers(map);
        }
    }

    public SelectResults query(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults results;
        if (predicate == null) {
            throw new IllegalArgumentException("The input query predicate is null. A null predicate is not allowed.");
        }
        predicate = predicate.trim();
        if (this.hasServerProxy()) {
            String queryString = this.constructRegionQueryString(predicate.trim());
            try {
                results = this.getServerProxy().query(queryString, null);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new QueryInvocationTargetException(e.getMessage(), cause);
            }
        } else {
            String queryStr;
            Object[] params = new Object[]{};
            QueryService qs = this.getGemFireCache().getLocalQueryService();
            DefaultQuery query = (DefaultQuery)qs.newQuery(queryStr = this.constructRegionQueryString(predicate.trim()));
            if (query.getRegionsInQuery(params).size() != 1) {
                throw new QueryInvalidException("Prevent multiple region query from being executed through region.query()");
            }
            results = (SelectResults)query.execute(params);
        }
        return results;
    }

    private String constructRegionQueryString(String predicate) throws QueryInvalidException {
        boolean matches = false;
        for (Pattern queryPattern : QUERY_PATTERNS) {
            if (!queryPattern.matcher(predicate).matches()) continue;
            if (!predicate.contains(this.getName())) {
                throw new QueryInvalidException("Should not execute region.query with a different region in the from clause: " + this.getName() + " was not present in:" + predicate);
            }
            matches = true;
            break;
        }
        String queryString = matches ? predicate : "select * from " + this.getFullPath() + " this where " + predicate;
        return queryString;
    }

    public ResultCollector executeFunction(DistributedRegionFunctionExecutor execution, Function function, Object args, ResultCollector rc, Set filter, ServerToClientFunctionResultSender sender) {
        if (function.optimizeForWrite() && this.memoryThresholdReached.get() && !MemoryThresholds.isLowMemoryExceptionDisabled()) {
            Set<DistributedMember> members = this.getMemoryThresholdReachedMembers();
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(function.getId(), members), members);
        }
        LocalResultCollector<?, ?> resultCollector = execution.getLocalResultCollector(function, rc);
        DistributionManager dm = this.getDistributionManager();
        execution.setExecutionNodes(Collections.singleton(this.getMyId()));
        DistributedRegionFunctionResultSender resultSender = new DistributedRegionFunctionResultSender(dm, resultCollector, function, sender);
        RegionFunctionContextImpl context = new RegionFunctionContextImpl(this.cache, function.getId(), this, args, filter, null, null, resultSender, execution.isReExecute());
        execution.executeFunctionOnLocalNode(function, context, resultSender, dm, this.isTX());
        return resultCollector;
    }

    public Set<DistributedMember> getMemoryThresholdReachedMembers() {
        return Collections.singleton(this.cache.getMyId());
    }

    @Override
    public void onEvent(MemoryEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Region:{} received a Memory event.{}", (Object)this, (Object)event);
        }
        this.setMemoryThresholdFlag(event);
    }

    protected void setMemoryThresholdFlag(MemoryEvent event) {
        assert (this.getScope().isLocal());
        if (event.isLocal()) {
            if (event.getState().isCritical() && !event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
                this.memoryThresholdReached.set(true);
            } else if (!event.getState().isCritical() && event.getPreviousState().isCritical() && (event.getType() == InternalResourceManager.ResourceType.HEAP_MEMORY || event.getType() == InternalResourceManager.ResourceType.OFFHEAP_MEMORY && this.getOffHeap())) {
                this.memoryThresholdReached.set(false);
            }
        }
    }

    void updateSizeOnClearRegion(int sizeBeforeClear) {
    }

    @Override
    public int calculateValueSize(Object value) {
        return 0;
    }

    @Override
    public int calculateRegionEntryValueSize(RegionEntry regionEntry) {
        return 0;
    }

    void updateSizeOnPut(Object key, int oldSize, int newSize) {
    }

    void updateSizeOnCreate(Object key, int newSize) {
    }

    @Override
    public void updateSizeOnRemove(Object key, int oldSize) {
    }

    @Override
    public int updateSizeOnEvict(Object key, int oldSize) {
        return 0;
    }

    @Override
    public void updateSizeOnFaultIn(Object key, int newSize, int bytesOnDisk) {
    }

    @Override
    public void initializeStats(long numEntriesInVM, long numOverflowOnDisk, long numOverflowBytesOnDisk) {
        this.getDiskRegion().getStats().incNumEntriesInVM(numEntriesInVM);
        this.getDiskRegion().getStats().incNumOverflowOnDisk(numOverflowOnDisk);
    }

    public void removeMemberFromCriticalList(DistributedMember member) {
        Assert.assertTrue(false);
    }

    public void initialCriticalMembers(boolean localMemoryIsCritical, Set<InternalDistributedMember> criticalMembers) {
        assert (this.getScope().isLocal());
        if (localMemoryIsCritical) {
            this.memoryThresholdReached.set(true);
        }
    }

    @Override
    public void destroyRecoveredEntry(Object key) {
        EntryEventImpl event = EntryEventImpl.create(this, Operation.LOCAL_DESTROY, key, null, null, false, this.getMyId(), false);
        try {
            event.inhibitCacheListenerNotification(true);
            this.mapDestroy(event, true, false, null, false, true);
        }
        finally {
            event.release();
        }
    }

    @Override
    public boolean lruLimitExceeded() {
        return this.entries.lruLimitExceeded(this.getDiskRegionView());
    }

    @Override
    public DiskEntry getDiskEntry(Object key) {
        RegionEntry regionEntry = this.entries.getEntry(key);
        if (regionEntry != null && regionEntry.isRemoved() && !regionEntry.isTombstone()) {
            regionEntry = null;
        }
        return (DiskEntry)regionEntry;
    }

    public LocalRegion getDataRegionForRead(KeyInfo entryKey) {
        return this;
    }

    public LocalRegion getDataRegionForWrite(KeyInfo entryKey) {
        return this;
    }

    Set getRegionKeysForIteration() {
        return this.getRegionMap().keySet();
    }

    public InternalDataView getSharedDataView() {
        return this.sharedDataView;
    }

    public DistributedMember getOwnerForKey(KeyInfo key) {
        return this.getMyId();
    }

    @Override
    public KeyInfo getKeyInfo(Object key) {
        return new KeyInfo(key, null, null);
    }

    public KeyInfo getKeyInfo(Object key, Object callbackArg) {
        return this.getKeyInfo(key, null, callbackArg);
    }

    public KeyInfo getKeyInfo(Object key, Object value, Object callbackArg) {
        return new KeyInfo(key, null, callbackArg);
    }

    protected RegionEntry basicGetTXEntry(KeyInfo keyInfo) {
        return this.basicGetEntry(keyInfo.getKey());
    }

    @Override
    public void senderCreated() {
        this.distributeUpdatedProfileOnSenderCreation();
    }

    void distributeUpdatedProfileOnSenderCreation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBackingMap() {
        RegionMap regionMap = this.entries;
        synchronized (regionMap) {
            if (this.entries instanceof AbstractRegionMap) {
                ((AbstractRegionMap)this.entries).verifyTombstoneCount(this.tombstoneCount);
            }
            logger.debug("Dumping region of size {} tombstones: {}: {}", (Object)this.size(), (Object)this.getTombstoneCount(), (Object)this.toString());
            if (this.entries instanceof AbstractRegionMap) {
                ((AbstractRegionMap)this.entries).dumpMap();
            }
        }
    }

    private void checkIfConcurrentMapOpsAllowed() {
        if (this.serverRegionProxy == null && (this.getDataPolicy() == DataPolicy.NORMAL && this.scope.isDistributed() || this.getDataPolicy() == DataPolicy.EMPTY)) {
            throw new UnsupportedOperationException();
        }
    }

    public boolean canStoreDataLocally() {
        return this.getDataPolicy().withStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Object key, Object value, Object callbackArgument) {
        long startPut = CachePerfStats.getStatTime();
        this.checkIfConcurrentMapOpsAllowed();
        this.validateArguments(key, value, callbackArgument);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        this.discoverJTA();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.PUT_IF_ABSENT, key, value, callbackArgument, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            Object oldValue = null;
            boolean ifNew = true;
            boolean ifOld = false;
            boolean requireOldValue = true;
            if (!this.basicPut(event, true, false, oldValue, true)) {
                Object object = event.getOldValue();
                return object;
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
            Object var11_13 = null;
            return var11_13;
        }
        catch (EntryNotFoundException ignore) {
            Object object = event.getOldValue();
            return object;
        }
        finally {
            event.release();
        }
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.putIfAbsent(key, value, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, value, null);
    }

    public boolean remove(Object key, Object value, Object callbackArg) {
        this.checkIfConcurrentMapOpsAllowed();
        this.validateKey(key);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        if (value == null) {
            value = Token.INVALID;
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REMOVE, key, null, callbackArg, false, this.getMyId());
        try {
            if (this.generateEventID() && event.getEventId() == null) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            this.getDataView().destroyExistingEntry(event, true, value);
        }
        catch (EntryNotFoundException ignore) {
            boolean bl = false;
            return bl;
        }
        catch (RegionDestroyedException rde) {
            if (!rde.getRegionFullPath().equals(this.getFullPath())) {
                throw new RegionDestroyedException(this.toString(), this.getFullPath(), rde);
            }
            throw rde;
        }
        finally {
            event.release();
        }
        return true;
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.replace(key, oldValue, newValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Object key, Object expectedOldValue, Object newValue, Object callbackArg) {
        this.checkIfConcurrentMapOpsAllowed();
        if (newValue == null) {
            throw new NullPointerException();
        }
        long startPut = CachePerfStats.getStatTime();
        this.validateArguments(key, newValue, callbackArg);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REPLACE, key, newValue, callbackArg, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            if (expectedOldValue == null) {
                expectedOldValue = Token.INVALID;
            }
            if (!this.basicPut(event, false, true, expectedOldValue, false)) {
                boolean bl = false;
                return bl;
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
            boolean bl = true;
            return bl;
        }
        catch (EntryNotFoundException ignore) {
            boolean bl = false;
            return bl;
        }
        finally {
            event.release();
        }
    }

    @Override
    public Object replace(Object key, Object value) {
        return this.replaceWithCallbackArgument(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object replaceWithCallbackArgument(Object key, Object value, Object callbackArg) {
        long startPut = CachePerfStats.getStatTime();
        this.checkIfConcurrentMapOpsAllowed();
        if (value == null) {
            throw new NullPointerException();
        }
        this.validateArguments(key, value, callbackArg);
        this.checkReadiness();
        this.checkForLimitedOrNoAccess();
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REPLACE, key, value, callbackArg, false, this.getMyId());
        try {
            if (this.generateEventID()) {
                event.setNewEventId(this.cache.getDistributedSystem());
            }
            this.discoverJTA();
            if (!this.basicPut(event, false, true, null, true)) {
                Object var7_6 = null;
                return var7_6;
            }
            if (!this.getDataView().isDeferredStats()) {
                this.getCachePerfStats().endPut(startPut, false);
            }
            Object object = event.getOldValue();
            return object;
        }
        catch (EntryNotFoundException ignore) {
            Object var8_9 = null;
            return var8_9;
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object basicBridgePutIfAbsent(Object key, Object value, boolean isObject, Object callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        long startPut = CachePerfStats.getStatTime();
        if (fromClient && this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.PUT_IF_ABSENT, key, null, callbackArg, false, client.getDistributedMember(), true, eventId);
        try {
            event.setContext(client);
            event.setVersionTag(clientEvent.getVersionTag());
            if (value != null) {
                if (isObject) {
                    event.setSerializedNewValue((byte[])value);
                } else {
                    event.setNewValue(value);
                }
            }
            this.validateArguments(key, event.basicGetNewValue(), callbackArg);
            boolean ifNew = true;
            boolean ifOld = false;
            boolean requireOldValue = true;
            boolean basicPut = this.basicPut(event, ifNew, ifOld, null, requireOldValue);
            this.getCachePerfStats().endPut(startPut, false);
            this.stopper.checkCancelInProgress(null);
            Object oldValue = event.getRawOldValueAsHeapObject();
            if (oldValue == Token.NOT_AVAILABLE) {
                oldValue = AbstractRegion.handleNotAvailable(oldValue);
            }
            if (basicPut) {
                clientEvent.setVersionTag(event.getVersionTag());
                clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            } else if (oldValue == null) {
                Token.Invalid invalid = Token.INVALID;
                return invalid;
            }
            Object object = oldValue;
            return object;
        }
        finally {
            event.release();
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean basicBridgeReplace(Object key, Object expectedOldValue, Object value, boolean isObject, Object callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        long startPut = CachePerfStats.getStatTime();
        if (fromClient && this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REPLACE, key, null, callbackArg, false, client.getDistributedMember(), true, eventId);
        try {
            event.setContext(client);
            if (value != null) {
                if (isObject) {
                    event.setSerializedNewValue((byte[])value);
                } else {
                    event.setNewValue(value);
                }
            }
            this.validateArguments(key, event.basicGetNewValue(), callbackArg);
            boolean ifNew = false;
            boolean ifOld = true;
            boolean requireOldValue = false;
            boolean success = this.basicPut(event, ifNew, ifOld, expectedOldValue, requireOldValue);
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            if (success) {
                clientEvent.setVersionTag(event.getVersionTag());
            }
            this.getCachePerfStats().endPut(startPut, false);
            this.stopper.checkCancelInProgress(null);
            boolean bl = success;
            return bl;
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object basicBridgeReplace(Object key, Object value, boolean isObject, Object callbackArg, ClientProxyMembershipID client, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryExistsException, CacheWriterException {
        EventID eventId = clientEvent.getEventId();
        long startPut = CachePerfStats.getStatTime();
        if (fromClient && this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REPLACE, key, null, callbackArg, false, client.getDistributedMember(), true, eventId);
        try {
            event.setContext(client);
            if (value != null) {
                if (isObject) {
                    event.setSerializedNewValue((byte[])value);
                } else {
                    event.setNewValue(value);
                }
            }
            this.validateArguments(key, event.basicGetNewValue(), callbackArg);
            boolean ifNew = false;
            boolean ifOld = true;
            boolean requireOldValue = true;
            boolean succeeded = this.basicPut(event, ifNew, ifOld, null, requireOldValue);
            this.getCachePerfStats().endPut(startPut, false);
            this.stopper.checkCancelInProgress(null);
            clientEvent.isConcurrencyConflict(event.isConcurrencyConflict());
            if (succeeded) {
                clientEvent.setVersionTag(event.getVersionTag());
                Object oldValue = event.getRawOldValueAsHeapObject();
                if (oldValue == Token.NOT_AVAILABLE) {
                    oldValue = AbstractRegion.handleNotAvailable(oldValue);
                }
                if (oldValue == null) {
                    oldValue = Token.INVALID;
                }
                Object object = oldValue;
                return object;
            }
            Object var16_16 = null;
            return var16_16;
        }
        finally {
            event.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicBridgeRemove(Object key, Object expectedOldValue, Object callbackArg, ClientProxyMembershipID memberId, boolean fromClient, EntryEventImpl clientEvent) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        if (fromClient && this.isGatewaySenderEnabled()) {
            callbackArg = new GatewaySenderEventCallbackArgument(callbackArg);
        }
        EntryEventImpl event = EntryEventImpl.create(this, Operation.REMOVE, key, null, callbackArg, false, memberId.getDistributedMember(), true, clientEvent.getEventId());
        try {
            event.setContext(memberId);
            try {
                this.basicDestroy(event, true, expectedOldValue);
            }
            finally {
                clientEvent.setVersionTag(event.getVersionTag());
                clientEvent.setIsRedestroyedEntry(event.getIsRedestroyedEntry());
            }
        }
        finally {
            event.release();
        }
    }

    @Override
    public long getVersionForMember(VersionSource member) {
        throw new IllegalStateException("Operation only implemented for disk region");
    }

    public IndexMap getIndexMap(String indexName, String indexedExpression, String fromClause) {
        return new IndexMapImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInUseByTransaction(boolean value) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (value) {
                ++this.txRefCount;
            } else {
                --this.txRefCount;
                assert (this.txRefCount >= 0);
                if (this.txRefCount == 0) {
                    if (this.regionTTLExpiryTask == null && this.regionTimeToLive > 0) {
                        this.addTTLExpiryTask();
                    }
                    if (this.regionIdleExpiryTask == null && this.regionIdleTimeout > 0) {
                        this.addIdleExpiryTask();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean expireRegion(RegionExpiryTask regionExpiryTask, boolean distributed, boolean destroy) {
        Object object = this.regionExpiryLock;
        synchronized (object) {
            if (regionExpiryTask instanceof RegionTTLExpiryTask) {
                if (regionExpiryTask != this.regionTTLExpiryTask) {
                    return false;
                }
                this.regionTTLExpiryTask = null;
            } else {
                if (regionExpiryTask != this.regionIdleExpiryTask) {
                    return false;
                }
                this.regionIdleExpiryTask = null;
            }
            if (this.txRefCount > 0) {
                return false;
            }
        }
        Operation op = destroy ? (distributed ? Operation.REGION_EXPIRE_DESTROY : Operation.REGION_EXPIRE_LOCAL_DESTROY) : (distributed ? Operation.REGION_EXPIRE_INVALIDATE : Operation.REGION_EXPIRE_LOCAL_INVALIDATE);
        RegionEventImpl event = new RegionEventImpl((Region)this, op, null, false, (DistributedMember)this.getMyId(), this.generateEventID());
        if (destroy) {
            this.basicDestroyRegion(event, distributed);
        } else {
            this.basicInvalidateRegion(event);
        }
        return true;
    }

    public int testHookGetValuesInVM() {
        int result = 0;
        for (RegionEntry re : this.getRegionMap().regionEntries()) {
            if (re.getValueAsToken() != Token.NOT_A_TOKEN) continue;
            ++result;
        }
        return result;
    }

    public int testHookGetValuesOnDisk() {
        int result = 0;
        for (RegionEntry re : this.getRegionMap().regionEntries()) {
            if (re.getValueAsToken() != null) continue;
            ++result;
        }
        return result;
    }

    public long getLatestLastAccessTimeFromOthers(Object key) {
        return 0L;
    }

    @Override
    public long getTotalEvictions() {
        return this.entries.getEvictions();
    }

    public void incBucketEvictions() {
    }

    @Override
    public long getEvictionCounter() {
        EvictionCounters es;
        long result = 0L;
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null && (es = evictionController.getCounters()) != null) {
            result = es.getCounter();
        }
        return result;
    }

    public long getEvictionLimit() {
        EvictionCounters es;
        long result = 0L;
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null && (es = evictionController.getCounters()) != null) {
            result = es.getLimit();
        }
        return result;
    }

    public long getEvictionDestroys() {
        EvictionCounters es;
        long result = 0L;
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null && (es = evictionController.getCounters()) != null) {
            result = es.getDestroys();
        }
        return result;
    }

    public EvictionController getEvictionController() {
        return this.getRegionMap().getEvictionController();
    }

    @Override
    public void setEvictionMaximum(int maximum) {
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null) {
            evictionController.setLimit(maximum);
        }
    }

    @Override
    public Statistics getEvictionStatistics() {
        EvictionCounters es;
        Statistics result = null;
        EvictionController evictionController = this.getEvictionController();
        if (evictionController != null && (es = evictionController.getCounters()) != null) {
            result = es.getStatistics();
        }
        return result;
    }

    @Override
    public EvictionController getExistingController(InternalRegionArguments internalArgs) {
        return null;
    }

    @Override
    public String getNameForStats() {
        return this.getFullPath();
    }

    @Override
    public Lock getClientMetaDataLock() {
        return this.clientMetaDataLock;
    }

    static class RegionPerfStats
    extends CachePerfStats {
        CachePerfStats cachePerfStats;

        RegionPerfStats(InternalCache cache, CachePerfStats superStats, String regionName) {
            super(cache.getDistributedSystem(), regionName);
            this.cachePerfStats = superStats;
        }

        @Override
        public void incReliableQueuedOps(int inc) {
            this.stats.incInt(reliableQueuedOpsId, inc);
            this.cachePerfStats.incReliableQueuedOps(inc);
        }

        @Override
        public void incReliableQueueSize(int inc) {
            this.stats.incInt(reliableQueueSizeId, inc);
            this.cachePerfStats.incReliableQueueSize(inc);
        }

        @Override
        public void incReliableQueueMax(int inc) {
            this.stats.incInt(reliableQueueMaxId, inc);
            this.cachePerfStats.incReliableQueueMax(inc);
        }

        @Override
        public void incReliableRegions(int inc) {
            this.stats.incInt(reliableRegionsId, inc);
            this.cachePerfStats.incReliableRegions(inc);
        }

        @Override
        public void incReliableRegionsMissing(int inc) {
            this.stats.incInt(reliableRegionsMissingId, inc);
            this.cachePerfStats.incReliableRegionsMissing(inc);
        }

        @Override
        public void incReliableRegionsQueuing(int inc) {
            this.stats.incInt(reliableRegionsQueuingId, inc);
            this.cachePerfStats.incReliableRegionsQueuing(inc);
        }

        @Override
        public void incReliableRegionsMissingFullAccess(int inc) {
            this.stats.incInt(reliableRegionsMissingFullAccessId, inc);
            this.cachePerfStats.incReliableRegionsMissingFullAccess(inc);
        }

        @Override
        public void incReliableRegionsMissingLimitedAccess(int inc) {
            this.stats.incInt(reliableRegionsMissingLimitedAccessId, inc);
            this.cachePerfStats.incReliableRegionsMissingLimitedAccess(inc);
        }

        @Override
        public void incReliableRegionsMissingNoAccess(int inc) {
            this.stats.incInt(reliableRegionsMissingNoAccessId, inc);
            this.cachePerfStats.incReliableRegionsMissingNoAccess(inc);
        }

        @Override
        public void incQueuedEvents(int inc) {
            this.stats.incLong(eventsQueuedId, (long)inc);
            this.cachePerfStats.incQueuedEvents(inc);
        }

        @Override
        public long startLoad() {
            this.stats.incInt(loadsInProgressId, 1);
            return this.cachePerfStats.startLoad();
        }

        @Override
        public void endLoad(long start) {
            long ts = NanoTimer.getTime();
            this.stats.incLong(loadTimeId, ts - start);
            this.stats.incInt(loadsInProgressId, -1);
            this.stats.incInt(loadsCompletedId, 1);
            this.cachePerfStats.endLoad(start);
        }

        @Override
        public long startNetload() {
            this.stats.incInt(netloadsInProgressId, 1);
            this.cachePerfStats.startNetload();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endNetload(long start) {
            if (enableClockStats) {
                this.stats.incLong(netloadTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(netloadsInProgressId, -1);
            this.stats.incInt(netloadsCompletedId, 1);
            this.cachePerfStats.endNetload(start);
        }

        @Override
        public long startNetsearch() {
            this.stats.incInt(netsearchesInProgressId, 1);
            return this.cachePerfStats.startNetsearch();
        }

        @Override
        public void endNetsearch(long start) {
            long ts = NanoTimer.getTime();
            this.stats.incLong(netsearchTimeId, ts - start);
            this.stats.incInt(netsearchesInProgressId, -1);
            this.stats.incInt(netsearchesCompletedId, 1);
            this.cachePerfStats.endNetsearch(start);
        }

        @Override
        public long startCacheWriterCall() {
            this.stats.incInt(cacheWriterCallsInProgressId, 1);
            this.cachePerfStats.startCacheWriterCall();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endCacheWriterCall(long start) {
            if (enableClockStats) {
                this.stats.incLong(cacheWriterCallTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(cacheWriterCallsInProgressId, -1);
            this.stats.incInt(cacheWriterCallsCompletedId, 1);
            this.cachePerfStats.endCacheWriterCall(start);
        }

        @Override
        public long startCacheListenerCall() {
            this.stats.incInt(cacheListenerCallsInProgressId, 1);
            this.cachePerfStats.startCacheListenerCall();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endCacheListenerCall(long start) {
            if (enableClockStats) {
                this.stats.incLong(cacheListenerCallTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(cacheListenerCallsInProgressId, -1);
            this.stats.incInt(cacheListenerCallsCompletedId, 1);
            this.cachePerfStats.endCacheListenerCall(start);
        }

        @Override
        public long startGetInitialImage() {
            this.stats.incInt(getInitialImagesInProgressId, 1);
            this.cachePerfStats.startGetInitialImage();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endGetInitialImage(long start) {
            if (enableClockStats) {
                this.stats.incLong(getInitialImageTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(getInitialImagesInProgressId, -1);
            this.stats.incInt(getInitialImagesCompletedId, 1);
            this.cachePerfStats.endGetInitialImage(start);
        }

        @Override
        public void endNoGIIDone(long start) {
            if (enableClockStats) {
                this.stats.incLong(getInitialImageTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(getInitialImagesInProgressId, -1);
            this.cachePerfStats.endNoGIIDone(start);
        }

        @Override
        public void incGetInitialImageKeysReceived() {
            this.stats.incInt(getInitialImageKeysReceivedId, 1);
            this.cachePerfStats.incGetInitialImageKeysReceived();
        }

        @Override
        public long startIndexUpdate() {
            this.stats.incInt(indexUpdateInProgressId, 1);
            this.cachePerfStats.startIndexUpdate();
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endIndexUpdate(long start) {
            long ts = RegionPerfStats.getStatTime();
            this.stats.incLong(indexUpdateTimeId, ts - start);
            this.stats.incInt(indexUpdateInProgressId, -1);
            this.stats.incInt(indexUpdateCompletedId, 1);
            this.cachePerfStats.endIndexUpdate(start);
        }

        @Override
        public void incRegions(int inc) {
            this.stats.incInt(regionsId, inc);
            this.cachePerfStats.incRegions(inc);
        }

        @Override
        public void incPartitionedRegions(int inc) {
            this.stats.incInt(partitionedRegionsId, inc);
            this.cachePerfStats.incPartitionedRegions(inc);
        }

        @Override
        public void incDestroys() {
            this.stats.incInt(destroysId, 1);
            this.cachePerfStats.incDestroys();
        }

        @Override
        public void incCreates() {
            this.stats.incInt(createsId, 1);
            this.cachePerfStats.incCreates();
        }

        @Override
        public void incInvalidates() {
            this.stats.incInt(invalidatesId, 1);
            this.cachePerfStats.incInvalidates();
        }

        @Override
        public void incTombstoneCount(int amount) {
            this.stats.incInt(tombstoneCountId, amount);
            this.cachePerfStats.incTombstoneCount(amount);
        }

        @Override
        public void incTombstoneGCCount() {
            this.stats.incInt(tombstoneGCCountId, 1);
            this.cachePerfStats.incTombstoneGCCount();
        }

        @Override
        public void incClearTimeouts() {
            this.stats.incInt(clearTimeoutsId, 1);
            this.cachePerfStats.incClearTimeouts();
        }

        @Override
        public void incConflatedEventsCount() {
            this.stats.incLong(conflatedEventsId, 1L);
            this.cachePerfStats.incConflatedEventsCount();
        }

        @Override
        public void endGet(long start, boolean miss) {
            if (enableClockStats) {
                this.stats.incLong(getTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.stats.incInt(getsId, 1);
            if (miss) {
                this.stats.incInt(missesId, 1);
            }
            this.cachePerfStats.endGet(start, miss);
        }

        @Override
        public long endPut(long start, boolean isUpdate) {
            long total = 0L;
            if (isUpdate) {
                this.stats.incInt(updatesId, 1);
                if (enableClockStats) {
                    total = RegionPerfStats.getStatTime() - start;
                    this.stats.incLong(updateTimeId, total);
                }
            } else {
                this.stats.incInt(putsId, 1);
                if (enableClockStats) {
                    total = RegionPerfStats.getStatTime() - start;
                    this.stats.incLong(putTimeId, total);
                }
            }
            this.cachePerfStats.endPut(start, isUpdate);
            return total;
        }

        @Override
        public void endPutAll(long start) {
            this.stats.incInt(putallsId, 1);
            if (enableClockStats) {
                this.stats.incLong(putallTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endPutAll(start);
        }

        @Override
        public void endQueryExecution(long executionTime) {
            this.stats.incInt(queryExecutionsId, 1);
            if (enableClockStats) {
                this.stats.incLong(queryExecutionTimeId, executionTime);
            }
            this.cachePerfStats.endQueryExecution(executionTime);
        }

        @Override
        public void endQueryResultsHashCollisionProbe(long start) {
            if (enableClockStats) {
                this.stats.incLong(queryResultsHashCollisionProbeTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endQueryResultsHashCollisionProbe(start);
        }

        @Override
        public void incQueryResultsHashCollisions() {
            this.stats.incInt(queryResultsHashCollisionsId, 1);
            this.cachePerfStats.incQueryResultsHashCollisions();
        }

        @Override
        public void incTxConflictCheckTime(long delta) {
            this.stats.incLong(txConflictCheckTimeId, delta);
            this.cachePerfStats.incTxConflictCheckTime(delta);
        }

        @Override
        public void txSuccess(long opTime, long txLifeTime, int txChanges) {
            this.stats.incInt(txCommitsId, 1);
            this.stats.incInt(txCommitChangesId, txChanges);
            this.stats.incLong(txCommitTimeId, opTime);
            this.stats.incLong(txSuccessLifeTimeId, txLifeTime);
            this.cachePerfStats.txSuccess(opTime, txLifeTime, txChanges);
        }

        @Override
        public void txFailure(long opTime, long txLifeTime, int txChanges) {
            this.stats.incInt(txFailuresId, 1);
            this.stats.incInt(txFailureChangesId, txChanges);
            this.stats.incLong(txFailureTimeId, opTime);
            this.stats.incLong(txFailedLifeTimeId, txLifeTime);
            this.cachePerfStats.txFailure(opTime, txLifeTime, txChanges);
        }

        @Override
        public void txRollback(long opTime, long txLifeTime, int txChanges) {
            this.stats.incInt(txRollbacksId, 1);
            this.stats.incInt(txRollbackChangesId, txChanges);
            this.stats.incLong(txRollbackTimeId, opTime);
            this.stats.incLong(txRollbackLifeTimeId, txLifeTime);
            this.cachePerfStats.txRollback(opTime, txLifeTime, txChanges);
        }

        @Override
        public void incEventQueueSize(int items) {
            this.stats.incInt(eventQueueSizeId, items);
            this.cachePerfStats.incEventQueueSize(items);
        }

        @Override
        public void incEventQueueThrottleCount(int items) {
            this.stats.incInt(eventQueueThrottleCountId, items);
            this.cachePerfStats.incEventQueueThrottleCount(items);
        }

        @Override
        protected void incEventQueueThrottleTime(long nanos) {
            this.stats.incLong(eventQueueThrottleTimeId, nanos);
            this.cachePerfStats.incEventQueueThrottleTime(nanos);
        }

        @Override
        protected void incEventThreads(int items) {
            this.stats.incInt(eventThreadsId, items);
            this.cachePerfStats.incEventThreads(items);
        }

        @Override
        public void incEntryCount(int delta) {
            this.stats.incLong(entryCountId, (long)delta);
            this.cachePerfStats.incEntryCount(delta);
        }

        @Override
        public void incRetries() {
            this.stats.incInt(retriesId, 1);
            this.cachePerfStats.incRetries();
        }

        @Override
        public void incDiskTasksWaiting() {
            this.stats.incInt(diskTasksWaitingId, 1);
            this.cachePerfStats.incDiskTasksWaiting();
        }

        @Override
        public void decDiskTasksWaiting() {
            this.stats.incInt(diskTasksWaitingId, -1);
            this.cachePerfStats.decDiskTasksWaiting();
        }

        @Override
        public void decDiskTasksWaiting(int count) {
            this.stats.incInt(diskTasksWaitingId, -count);
            this.cachePerfStats.decDiskTasksWaiting(count);
        }

        @Override
        public void incEvictorJobsStarted() {
            this.stats.incInt(evictorJobsStartedId, 1);
            this.cachePerfStats.incEvictorJobsStarted();
        }

        @Override
        public void incEvictorJobsCompleted() {
            this.stats.incInt(evictorJobsCompletedId, 1);
            this.cachePerfStats.incEvictorJobsCompleted();
        }

        @Override
        public void incEvictorQueueSize(int delta) {
            this.stats.incInt(evictorQueueSizeId, delta);
            this.cachePerfStats.incEvictorQueueSize(delta);
        }

        @Override
        public void incEvictWorkTime(long delta) {
            this.stats.incLong(evictWorkTimeId, delta);
            this.cachePerfStats.incEvictWorkTime(delta);
        }

        @Override
        public void incClearCount() {
            this.stats.incInt(clearsId, 1);
            this.cachePerfStats.incClearCount();
        }

        @Override
        public void incPRQueryRetries() {
            this.stats.incLong(partitionedRegionQueryRetriesId, 1L);
            this.cachePerfStats.incPRQueryRetries();
        }

        @Override
        public void incMetaDataRefreshCount() {
            this.stats.incLong(metaDataRefreshCountId, 1L);
            this.cachePerfStats.incMetaDataRefreshCount();
        }

        @Override
        public void endImport(long entryCount, long start) {
            this.stats.incLong(importedEntriesCountId, entryCount);
            if (enableClockStats) {
                this.stats.incLong(importTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endImport(entryCount, start);
        }

        @Override
        public void endExport(long entryCount, long start) {
            this.stats.incLong(exportedEntriesCountId, entryCount);
            if (enableClockStats) {
                this.stats.incLong(exportTimeId, RegionPerfStats.getStatTime() - start);
            }
            this.cachePerfStats.endExport(entryCount, start);
        }

        @Override
        public long startCompression() {
            this.stats.incLong(compressionCompressionsId, 1L);
            this.cachePerfStats.stats.incLong(compressionCompressionsId, 1L);
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endCompression(long startTime, long startSize, long endSize) {
            if (enableClockStats) {
                long time = RegionPerfStats.getStatTime() - startTime;
                this.stats.incLong(compressionCompressTimeId, time);
                this.cachePerfStats.stats.incLong(compressionCompressTimeId, time);
            }
            this.stats.incLong(compressionPreCompressedBytesId, startSize);
            this.stats.incLong(compressionPostCompressedBytesId, endSize);
            this.cachePerfStats.stats.incLong(compressionPreCompressedBytesId, startSize);
            this.cachePerfStats.stats.incLong(compressionPostCompressedBytesId, endSize);
        }

        @Override
        public long startDecompression() {
            this.stats.incLong(compressionDecompressionsId, 1L);
            this.cachePerfStats.stats.incLong(compressionDecompressionsId, 1L);
            return RegionPerfStats.getStatTime();
        }

        @Override
        public void endDecompression(long startTime) {
            if (enableClockStats) {
                long time = RegionPerfStats.getStatTime() - startTime;
                this.stats.incLong(compressionDecompressTimeId, time);
                this.cachePerfStats.stats.incLong(compressionDecompressTimeId, time);
            }
        }
    }

    public class NonTXEntry
    implements Region.Entry {
        private final Object key;
        private boolean entryIsDestroyed = false;

        @Override
        public boolean isLocal() {
            return true;
        }

        public NonTXEntry(RegionEntry regionEntry) {
            if (regionEntry == null) {
                throw new IllegalArgumentException(LocalizedStrings.LocalRegion_REGIONENTRY_SHOULD_NOT_BE_NULL.toLocalizedString());
            }
            this.key = regionEntry.getKey();
        }

        public RegionEntry getRegionEntry() {
            RegionEntry regionEntry = LocalRegion.this.getRegionMap().getEntry(this.key);
            if (regionEntry == null) {
                throw new EntryDestroyedException(this.key.toString());
            }
            return regionEntry;
        }

        private RegionEntry basicGetEntry() {
            RegionEntry re = LocalRegion.this.basicGetEntry(this.key);
            if (re == null) {
                throw new EntryDestroyedException(this.key.toString());
            }
            return re;
        }

        @Override
        public boolean isDestroyed() {
            if (this.entryIsDestroyed) {
                return true;
            }
            if (LocalRegion.this.isDestroyed || LocalRegion.this.basicGetEntry(this.key) == null) {
                this.entryIsDestroyed = true;
            }
            return this.entryIsDestroyed;
        }

        @Override
        public Object getKey() {
            return this.basicGetEntry().getKey();
        }

        @Override
        public Object getValue() {
            return this.getValue(false);
        }

        public Object getValue(boolean ignoreCopyOnRead) {
            Object value = LocalRegion.this.getDeserialized(this.basicGetEntry(), false, ignoreCopyOnRead, false, false);
            if (value == null) {
                throw new EntryDestroyedException(this.getKey().toString());
            }
            if (Token.isInvalid(value)) {
                return null;
            }
            return value;
        }

        public Object getRawValue() {
            Object value = this.basicGetEntry().getValue((RegionEntryContext)((Object)this.getRegion()));
            if (value == null) {
                throw new EntryDestroyedException(this.getRegionEntry().getKey().toString());
            }
            if (Token.isInvalid(value)) {
                return null;
            }
            return value;
        }

        public Region getRegion() {
            this.basicGetEntry();
            return LocalRegion.this;
        }

        @Override
        public CacheStatistics getStatistics() {
            this.basicGetEntry();
            if (!LocalRegion.this.statisticsEnabled) {
                throw new StatisticsDisabledException(LocalizedStrings.LocalRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(LocalRegion.this.getFullPath()));
            }
            return new CacheStatisticsImpl(this.basicGetEntry(), LocalRegion.this);
        }

        @Override
        public Object getUserAttribute() {
            this.basicGetEntry();
            Map userAttributes = LocalRegion.this.entryUserAttributes;
            if (userAttributes == null) {
                return null;
            }
            return userAttributes.get(this.basicGetEntry().getKey());
        }

        @Override
        public Object setUserAttribute(Object userAttribute) {
            if (LocalRegion.this.entryUserAttributes == null) {
                LocalRegion.this.entryUserAttributes = new ConcurrentHashMap();
            }
            return LocalRegion.this.entryUserAttributes.put(this.basicGetEntry().getKey(), userAttribute);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof NonTXEntry)) {
                return false;
            }
            NonTXEntry entry = (NonTXEntry)obj;
            return this.basicGetEntry().equals(entry.getRegionEntry()) && this.getRegion() == entry.getRegion();
        }

        @Override
        public int hashCode() {
            return this.basicGetEntry().hashCode() ^ this.getRegion().hashCode();
        }

        public String toString() {
            return "NonTXEntry@" + Integer.toHexString(System.identityHashCode(this)) + ' ' + this.getRegionEntry();
        }

        @Override
        public Object setValue(Object value) {
            return LocalRegion.this.put(this.getKey(), value);
        }
    }

    private class SubregionsSet
    extends AbstractSet {
        final boolean recursive;

        SubregionsSet(boolean recursive) {
            this.recursive = recursive;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator currentIterator;
                List queue;
                Object nextElement;
                {
                    this.currentIterator = LocalRegion.this.subregions.values().iterator();
                    this.nextElement = null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException(LocalizedStrings.LocalRegion_THIS_ITERATOR_DOES_NOT_SUPPORT_MODIFICATION.toLocalizedString());
                }

                @Override
                public boolean hasNext() {
                    if (this.nextElement != null) {
                        return true;
                    }
                    Object element = this.next(true);
                    if (element != null) {
                        this.nextElement = element;
                        return true;
                    }
                    return false;
                }

                private boolean doHasNext() {
                    return this.currentIterator != null && this.currentIterator.hasNext();
                }

                public Object next() {
                    return this.next(false);
                }

                private Object next(boolean nullOK) {
                    Iterator nextIterator;
                    LocalRegion region;
                    if (this.nextElement != null) {
                        Object next = this.nextElement;
                        this.nextElement = null;
                        return next;
                    }
                    do {
                        region = null;
                        if (!this.doHasNext()) {
                            if (this.queue == null || this.queue.isEmpty()) {
                                if (nullOK) {
                                    return null;
                                }
                                throw new NoSuchElementException();
                            }
                            this.currentIterator = (Iterator)this.queue.remove(0);
                            continue;
                        }
                        region = (LocalRegion)this.currentIterator.next();
                    } while (region == null || !region.isInitialized() || region.isDestroyed());
                    if (SubregionsSet.this.recursive && (nextIterator = region.subregions.values().iterator()).hasNext()) {
                        if (this.queue == null) {
                            this.queue = new ArrayList();
                        }
                        this.queue.add(nextIterator);
                    }
                    if (!this.doHasNext()) {
                        this.currentIterator = this.queue == null || this.queue.isEmpty() ? null : (Iterator)this.queue.remove(0);
                    }
                    return region;
                }
            };
        }

        @Override
        public int size() {
            if (this.recursive) {
                return LocalRegion.this.allSubregionsSize() - 1;
            }
            return LocalRegion.this.subregions.size();
        }

        @Override
        public Object[] toArray() {
            ArrayList temp = new ArrayList(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                temp.add(iter.next());
            }
            return temp.toArray();
        }

        @Override
        public Object[] toArray(Object[] array) {
            ArrayList temp = new ArrayList(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                temp.add(iter.next());
            }
            return temp.toArray(array);
        }
    }

    class EventDispatcher
    implements Runnable {
        InternalCacheEvent event;
        EnumListenerEvent op;

        EventDispatcher(InternalCacheEvent event, EnumListenerEvent op) {
            if (LocalRegion.this.offHeap && event instanceof EntryEventImpl) {
                event = new EntryEventImpl((EntryEventImpl)event);
            }
            this.event = event;
            this.op = op;
        }

        @Override
        public void run() {
            try {
                LocalRegion.dispatchEvent(LocalRegion.this, this.event, this.op);
            }
            finally {
                this.release();
            }
        }

        public void release() {
            if (LocalRegion.this.offHeap && this.event instanceof EntryEventImpl) {
                ((Releasable)((Object)this.event)).release();
            }
        }
    }

    private static class ExpiryRegionEntry
    implements Region.Entry {
        private final LocalRegion region;
        private final RegionEntry regionEntry;

        ExpiryRegionEntry(LocalRegion region, RegionEntry regionEntry) {
            this.region = region;
            this.regionEntry = regionEntry;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.regionEntry == null ? 0 : this.regionEntry.hashCode());
            result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpiryRegionEntry other = (ExpiryRegionEntry)obj;
            if (this.regionEntry == null ? other.regionEntry != null : !this.regionEntry.equals(other.regionEntry)) {
                return false;
            }
            return !(this.region == null ? other.region != null : !this.region.equals(other.region));
        }

        public String toString() {
            return "region=" + this.region.getFullPath() + ", key=" + this.getKey() + " value=" + this.getValue();
        }

        public Region getRegion() {
            return this.region;
        }

        private RegionEntry getCheckedRegionEntry() throws EntryNotFoundException {
            if (this.regionEntry.isDestroyedOrRemoved()) {
                throw new EntryNotFoundException("Entry for key " + this.regionEntry.getKey() + " no longer exists");
            }
            return this.regionEntry;
        }

        @Override
        public Object getValue() {
            Object value = this.region.getDeserialized(this.getCheckedRegionEntry(), false, false, false, false);
            if (value == null) {
                throw new EntryDestroyedException(this.getKey().toString());
            }
            if (Token.isInvalid(value)) {
                return null;
            }
            return value;
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public CacheStatistics getStatistics() {
            LocalRegion lr = this.region;
            if (!lr.statisticsEnabled) {
                throw new StatisticsDisabledException(LocalizedStrings.LocalRegion_STATISTICS_DISABLED_FOR_REGION_0.toLocalizedString(lr.getFullPath()));
            }
            return new CacheStatisticsImpl(this.getCheckedRegionEntry(), lr);
        }

        @Override
        public Object getUserAttribute() {
            Map userAttr = this.region.entryUserAttributes;
            if (userAttr == null) {
                return null;
            }
            return userAttr.get(this.getKey());
        }

        @Override
        public Object setUserAttribute(Object userAttribute) {
            LocalRegion lr = this.region;
            if (lr.entryUserAttributes == null) {
                lr.entryUserAttributes = new ConcurrentHashMap();
            }
            return lr.entryUserAttributes.put(this.getKey(), userAttribute);
        }

        @Override
        public boolean isDestroyed() {
            return this.regionEntry.isDestroyedOrRemoved();
        }

        @Override
        public Object setValue(Object value) {
            return this.region.put(this.getKey(), value);
        }

        @Override
        public Object getKey() {
            return this.regionEntry.getKey();
        }
    }

    public static interface RegionEntryCallback {
        public void handleRegionEntry(RegionEntry var1);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            InternalCache cache = LocalRegion.this.getCache();
            if (cache == null) {
                return LocalizedStrings.LocalRegion_THE_CACHE_IS_NOT_AVAILABLE.toLocalizedString();
            }
            return cache.getCancelCriterion().cancelInProgress();
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            this.checkFailure();
            InternalCache cache = LocalRegion.this.getCache();
            if (cache == null) {
                return new CacheClosedException("No cache", e);
            }
            return cache.getCancelCriterion().generateCancelledException(e);
        }
    }

    public static enum IteratorType {
        KEYS,
        VALUES,
        ENTRIES;

    }

    public static interface TestCallable {
        public void call(LocalRegion var1, Operation var2, RegionEntry var3);
    }
}

