/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.InternalDistributedRegion;
import org.apache.geode.internal.cache.LatestLastAccessTimeMessage;
import org.apache.geode.internal.cache.LatestLastAccessTimeReplyProcessor;

public class LatestLastAccessTimeOperation<K> {
    private final InternalDistributedRegion region;
    private final K key;

    public LatestLastAccessTimeOperation(InternalDistributedRegion region, K key) {
        this.region = region;
        this.key = key;
    }

    public long getLatestLastAccessTime() {
        Set recipients = this.region.getCacheDistributionAdvisor().adviseNetSearch();
        DistributionManager dm = this.region.getDistributionManager();
        dm.retainMembersWithSameOrNewerVersion(recipients, Version.GEODE_140);
        LatestLastAccessTimeReplyProcessor replyProcessor = new LatestLastAccessTimeReplyProcessor(dm, recipients);
        dm.putOutgoing(new LatestLastAccessTimeMessage<K>(replyProcessor, recipients, this.region, this.key));
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            dm.getCancelCriterion().checkCancelInProgress(e);
            Thread.currentThread().interrupt();
        }
        return replyProcessor.getLatestLastAccessTime();
    }
}

